/*
 * Decompiled with CFR 0.152.
 */
package catalystchart;

import catalystchart.DemoPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYDataImageAnnotation;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.panel.CrosshairOverlay;
import org.jfree.chart.panel.Overlay;
import org.jfree.chart.plot.Crosshair;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.GrayPaintScale;
import org.jfree.chart.renderer.PaintScale;
import org.jfree.data.Range;
import org.jfree.data.general.DefaultHeatMapDataset;
import org.jfree.data.general.HeatMapDataset;
import org.jfree.data.general.HeatMapUtilities;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RefineryUtilities;

public class CrossSectionDemo1
extends ApplicationFrame {
    public CrossSectionDemo1(String object) {
        super((String)object);
        object = CrossSectionDemo1.createDemoPanel();
        this.setContentPane((Container)object);
    }

    public static JPanel createDemoPanel() {
        return new MyDemoPanel();
    }

    public static void main(String[] object) {
        object = new CrossSectionDemo1("JFreeChart: CrossSectionDemo1");
        object.pack();
        RefineryUtilities.centerFrameOnScreen((Window)object);
        object.setVisible(true);
    }

    static /* synthetic */ HeatMapDataset access$000() {
        DefaultHeatMapDataset defaultHeatMapDataset = new DefaultHeatMapDataset(501, 501, -250.0, 250.0, -250.0, 250.0);
        for (int i2 = 0; i2 < 501; ++i2) {
            for (int i3 = 0; i3 < 501; ++i3) {
                defaultHeatMapDataset.setZValue(i2, i3, Math.sin(Math.sqrt(i2 * i3) / 10.0));
            }
        }
        return defaultHeatMapDataset;
    }

    static class MyDemoPanel
    extends DemoPanel
    implements ChangeListener,
    ChartChangeListener {
        private HeatMapDataset dataset;
        private JFreeChart mainChart;
        private JFreeChart subchart1;
        private JFreeChart subchart2;
        private JSlider slider1;
        private JSlider slider2;
        private Crosshair crosshair1;
        private Crosshair crosshair2;
        private Range lastXRange;
        private Range lastYRange;

        public MyDemoPanel() {
            super(new BorderLayout());
            Object object = (ChartPanel)this.createMainPanel();
            object.setPreferredSize(new Dimension(500, 270));
            Object object2 = new CrosshairOverlay();
            this.crosshair1 = new Crosshair(0.0);
            this.crosshair1.setPaint((Paint)Color.red);
            this.crosshair2 = new Crosshair(0.0);
            this.crosshair2.setPaint((Paint)Color.blue);
            object2.addDomainCrosshair(this.crosshair1);
            object2.addRangeCrosshair(this.crosshair2);
            object.addOverlay((Overlay)object2);
            this.crosshair1.setLabelVisible(true);
            this.crosshair1.setLabelAnchor(RectangleAnchor.BOTTOM_RIGHT);
            this.crosshair1.setLabelBackgroundPaint((Paint)new Color(255, 255, 0, 100));
            this.crosshair2.setLabelVisible(true);
            this.crosshair2.setLabelBackgroundPaint((Paint)new Color(255, 255, 0, 100));
            this.add((Component)object);
            object = new JPanel(new BorderLayout());
            object2 = new XYSeriesCollection();
            this.subchart1 = ChartFactory.createXYLineChart((String)"Cross-section A", (String)"Y", (String)"Z", (XYDataset)object2, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)false, (boolean)false);
            object2 = (XYPlot)this.subchart1.getPlot();
            object2.getDomainAxis().setLowerMargin(0.0);
            object2.getDomainAxis().setUpperMargin(0.0);
            object2.setDomainAxisLocation(AxisLocation.BOTTOM_OR_RIGHT);
            object2 = new ChartPanel(this.subchart1);
            object2.setMinimumDrawWidth(0);
            object2.setMinimumDrawHeight(0);
            object2.setPreferredSize(new Dimension(200, 150));
            this.slider1 = new JSlider(-250, 250, 0);
            this.slider1.addChangeListener(this);
            this.slider1.setOrientation(1);
            ((Container)object).add((Component)object2);
            ((Container)object).add((Component)this.slider1, "West");
            object2 = new JPanel(new BorderLayout());
            XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
            this.subchart2 = ChartFactory.createXYLineChart((String)"Cross-section B", (String)"X", (String)"Z", (XYDataset)xYSeriesCollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
            xYSeriesCollection = (XYPlot)this.subchart2.getPlot();
            xYSeriesCollection.getDomainAxis().setLowerMargin(0.0);
            xYSeriesCollection.getDomainAxis().setUpperMargin(0.0);
            xYSeriesCollection.getRenderer().setSeriesPaint(0, (Paint)Color.blue);
            xYSeriesCollection = new ChartPanel(this.subchart2);
            xYSeriesCollection.setMinimumDrawWidth(0);
            xYSeriesCollection.setMinimumDrawHeight(0);
            xYSeriesCollection.setPreferredSize(new Dimension(200, 150));
            JPanel jPanel = new JPanel();
            jPanel.setPreferredSize(new Dimension(200, 10));
            ((Container)object2).add((Component)jPanel, "East");
            this.slider2 = new JSlider(-250, 250, 0);
            this.slider2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 200));
            this.slider2.addChangeListener(this);
            ((Container)object2).add((Component)xYSeriesCollection);
            ((Container)object2).add((Component)this.slider2, "North");
            this.add((Component)object, "East");
            this.add((Component)object2, "South");
            this.mainChart.setNotify(true);
        }

        public JPanel createMainPanel() {
            XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
            Object object = this;
            xYSeriesCollection = ChartFactory.createScatterPlot((String)"CrossSectionDemo1", (String)"X", (String)"Y", (XYDataset)xYSeriesCollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            ((MyDemoPanel)object).dataset = CrossSectionDemo1.access$000();
            GrayPaintScale grayPaintScale = new GrayPaintScale(-1.0, 1.0, 128);
            object = HeatMapUtilities.createHeatMapImage((HeatMapDataset)((MyDemoPanel)object).dataset, (PaintScale)grayPaintScale);
            object = new XYDataImageAnnotation((Image)object, -250.5, -250.5, 501.0, 501.0, true);
            grayPaintScale = (XYPlot)xYSeriesCollection.getPlot();
            grayPaintScale.setDomainPannable(true);
            grayPaintScale.setRangePannable(true);
            grayPaintScale.getRenderer().addAnnotation((XYAnnotation)object, Layer.BACKGROUND);
            object = (NumberAxis)grayPaintScale.getDomainAxis();
            object.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            object.setLowerMargin(0.0);
            object.setUpperMargin(0.0);
            object = (NumberAxis)grayPaintScale.getRangeAxis();
            object.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            object.setLowerMargin(0.0);
            object.setUpperMargin(0.0);
            this.mainChart = xYSeriesCollection;
            this.mainChart.addChangeListener((ChartChangeListener)this);
            object = new ChartPanel(this.mainChart);
            object.setFillZoomRectangle(true);
            object.setMouseWheelEnabled(true);
            return object;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == this.slider1) {
                this.crosshair2.setValue((double)this.slider1.getValue());
                int n2 = this.slider1.getValue() - this.slider1.getMinimum();
                XYDataset xYDataset = HeatMapUtilities.extractColumnFromHeatMapDataset((HeatMapDataset)this.dataset, (int)n2, (Comparable)((Object)"Y1"));
                this.subchart2.getXYPlot().setDataset(xYDataset);
                return;
            }
            if (changeEvent.getSource() == this.slider2) {
                this.crosshair1.setValue((double)this.slider2.getValue());
                int n3 = this.slider2.getValue() - this.slider2.getMinimum();
                XYDataset xYDataset = HeatMapUtilities.extractRowFromHeatMapDataset((HeatMapDataset)this.dataset, (int)n3, (Comparable)((Object)"Y2"));
                this.subchart1.getXYPlot().setDataset(xYDataset);
            }
        }

        public void chartChanged(ChartChangeEvent chartChangeEvent) {
        }
    }
}

