/*
 * Decompiled with CFR 0.152.
 */
package catalystchart;

import catalystchart.ChartActionEvent;
import catalystchart.OptionPanel;
import chart.data.ChartData;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import jfree.custom.CustomChartPanel;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.ui.ApplicationFrame;

public abstract class IntradayChart
extends ApplicationFrame
implements ChartMouseListener,
ChartChangeListener {
    CombinedDomainXYPlot localCombinedDomainXYPlot;
    private OptionPanel optionpanel = null;
    JFreeChart localJFreeChart;
    XYPlot localXYPlot;
    ChartPanel chartPanel;
    JPopupMenu popup;
    double upperBound = 0.0;
    double lowerBound = 0.0;
    final Color PLOTBGCOLOR = Color.BLACK;
    final Color CHARTBGCOLOR = Color.BLACK;
    DecimalFormat localDecimalFormat = new DecimalFormat("###,###.##");
    NumberFormat localNumberFormat = new DecimalFormat("###,###");
    protected String waterMarkText = "";
    double rangeLowerBound = 10000.0;
    double ltrdPrice = 0.0;
    double ask = 0.0;

    public IntradayChart() {
        super("");
        this.localDecimalFormat.setMinimumFractionDigits(2);
        this.localDecimalFormat.setMaximumFractionDigits(2);
    }

    public abstract JFreeChart createChart();

    public abstract void createDataset();

    public abstract void InitializeCrosshair();

    public JPanel createDemoPanel() {
        this.localJFreeChart = this.createChart();
        this.chartPanel = new CustomChartPanel(this.localJFreeChart);
        this.chartPanel.setFocusable(true);
        this.chartPanel.requestFocus();
        this.InitializeCrosshair();
        this.chartPanel.addChartMouseListener((ChartMouseListener)this);
        this.chartPanel.setRangeZoomable(false);
        this.localJFreeChart.setNotify(true);
        this.localJFreeChart.addChangeListener((ChartChangeListener)this);
        this.localXYPlot.setBackgroundPaint((Paint)this.PLOTBGCOLOR);
        this.localXYPlot.setOutlinePaint((Paint)Color.WHITE);
        this.localJFreeChart.setBackgroundPaint((Paint)this.CHARTBGCOLOR);
        return this.chartPanel;
    }

    public static void main(String[] stringArray) {
    }

    public void setWaterMarkText(String string) {
        this.waterMarkText = string;
    }

    public void ZoomIn(ChartActionEvent object) {
        object = this.chartPanel.getChartRenderingInfo();
        object = object.getPlotInfo().getDataArea();
        this.chartPanel.zoomInDomain(((RectangularShape)object).getCenterX(), ((RectangularShape)object).getCenterY());
    }

    public void ZoomOut(ChartActionEvent object) {
        object = this.chartPanel.getChartRenderingInfo();
        object = object.getPlotInfo().getDataArea();
        Object object2 = (DateAxis)this.localXYPlot.getDomainAxis();
        try {
            Cloneable cloneable = new SimpleDateFormat("HH:mm:ss");
            cloneable = cloneable.parse("08:00:00");
            object2 = new Date((long)object2.getLowerBound());
            if (object2.compareTo((Date)cloneable) <= 0) {
                return;
            }
        }
        catch (Exception exception) {}
        this.chartPanel.zoomOutDomain(((RectangularShape)object).getCenterX(), ((RectangularShape)object).getCenterY());
    }

    public void ResetZoom(ChartActionEvent chartActionEvent) {
        this.chartPanel.restoreAutoBounds();
    }

    public void setInterval(ChartActionEvent chartActionEvent) {
        DateAxis dateAxis = (DateAxis)this.localXYPlot.getDomainAxis();
        Cloneable cloneable = new SimpleDateFormat("HH:mm:ss");
        try {
            cloneable = ((DateFormat)cloneable).parse("09:00:00");
            Millisecond millisecond = new Millisecond((Date)cloneable);
            dateAxis.setLowerBound((double)millisecond.getFirstMillisecond());
            ((Date)cloneable).setHours(9 + chartActionEvent.getInterval());
            millisecond = new Millisecond((Date)cloneable);
            dateAxis.setUpperBound((double)millisecond.getFirstMillisecond());
            return;
        }
        catch (ParseException parseException) {
            return;
        }
    }

    public void chartMouseClicked(ChartMouseEvent chartMouseEvent) {
    }

    public Point2D getDotDatavalue(Point2D point2D, TimeSeries timeSeries) {
        Object object;
        ValueAxis valueAxis;
        Rectangle2D rectangle2D = this.chartPanel.getScreenDataArea();
        Object object2 = this.localXYPlot;
        if (this.localJFreeChart.getPlot() instanceof CombinedDomainXYPlot) {
            valueAxis = (CombinedDomainXYPlot)this.localJFreeChart.getPlot();
            object = valueAxis.getSubplots();
            object2 = (XYPlot)object.get(0);
            rectangle2D = this.chartPanel.getChartRenderingInfo().getPlotInfo().getSubplotInfo(0).getDataArea();
        }
        valueAxis = object2.getDomainAxis();
        object = object2.getDomainAxisEdge();
        object2.getRangeAxis();
        object2.getRangeAxisEdge();
        double d2 = valueAxis.java2DToValue(point2D.getX(), rectangle2D, object);
        int n2 = 0;
        int n3 = timeSeries.getItemCount() - 1;
        object2 = new Date((long)d2);
        long l2 = object2.getTime();
        long l3 = Long.MAX_VALUE;
        int n4 = 0;
        while (n2 <= n3) {
            long l4;
            int n5 = n2 + n3 >>> 1;
            TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataItem(n5);
            RegularTimePeriod regularTimePeriod = timeSeriesDataItem.getPeriod();
            long l5 = regularTimePeriod.getFirstMillisecond();
            long l6 = l5 - l2;
            if (l6 < 0L) {
                n2 = n5 + 1;
            } else if (l6 > 0L) {
                n3 = n5 - 1;
            } else {
                n4 = n5;
                break;
            }
            if ((l4 = Math.abs(l6)) >= l3) continue;
            l3 = l4;
            n4 = n5;
        }
        TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataItem(n4);
        double d3 = timeSeriesDataItem.getPeriod().getFirstMillisecond();
        double d4 = timeSeriesDataItem.getValue().doubleValue();
        return new Point2D.Double(d3, d4);
    }

    public void setUpperLowerBound(double d2, double d3) {
        this.upperBound = d2;
        this.lowerBound = d3;
    }

    public abstract void chartMouseMoved(ChartMouseEvent var1);

    public abstract void chartChanged(ChartChangeEvent var1);

    public abstract void RunDemo();

    public abstract void AddIndicator(ChartActionEvent var1);

    public List<ChartData> getChartDatas() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public XYPlot getPlot() {
        JFreeChart jFreeChart = this.chartPanel.getChart();
        jFreeChart = (CombinedDomainXYPlot)jFreeChart.getPlot();
        jFreeChart = (XYPlot)jFreeChart.getSubplots().get(0);
        return jFreeChart;
    }

    public int getPlotSize() {
        JFreeChart jFreeChart = this.chartPanel.getChart();
        jFreeChart = (CombinedDomainXYPlot)jFreeChart.getPlot();
        return jFreeChart.getSubplots().size();
    }

    public XYPlot getPlot(int n2) {
        JFreeChart jFreeChart = this.chartPanel.getChart();
        jFreeChart = (CombinedDomainXYPlot)jFreeChart.getPlot();
        XYPlot xYPlot = (XYPlot)jFreeChart.getSubplots().get(n2);
        return xYPlot;
    }
}

