/*
 * Decompiled with CFR 0.152.
 */
package catalystchart;

import CATALYST.Control.MarketFeed;
import catalystchart.BidAskChart;
import catalystchart.ChartActionEvent;
import catalystchart.ChartScrollBar;
import catalystchart.ChartType;
import catalystchart.IndexVolumeCombinedChart;
import catalystchart.IntradayChart;
import catalystchart.PriceVolumeCombinedChart;
import java.awt.Color;
import java.awt.Dimension;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JPanel;

public class PnlIntraday
extends JPanel {
    IntradayChart intraday;
    public ChartScrollBar scrollBar;
    public ChartScrollBar scrollBarVertical;
    JPanel pnlChart;
    private String Symbol = "";
    public static ChartType lastChartType = ChartType.PRICEVOLUME;
    private String waterMarkText = "";
    private JPanel hScrollpnl;
    private JPanel jPanel1;
    private JPanel vScrollpnl;

    public PnlIntraday() {
        PnlIntraday pnlIntraday = this;
        this.vScrollpnl = new JPanel();
        pnlIntraday.jPanel1 = new JPanel();
        pnlIntraday.hScrollpnl = new JPanel();
        pnlIntraday.setMinimumSize(new Dimension(400, 200));
        pnlIntraday.setPreferredSize(new Dimension(400, 200));
        pnlIntraday.vScrollpnl.setBackground(new Color(0, 0, 0));
        pnlIntraday.vScrollpnl.setLayout(new BoxLayout(pnlIntraday.vScrollpnl, 2));
        pnlIntraday.jPanel1.setBackground(new Color(0, 0, 0));
        pnlIntraday.jPanel1.setMaximumSize(new Dimension(2000, 2000));
        pnlIntraday.jPanel1.setLayout(new BoxLayout(pnlIntraday.jPanel1, 1));
        pnlIntraday.hScrollpnl.setBackground(new Color(0, 0, 0));
        pnlIntraday.hScrollpnl.setLayout(new BoxLayout(pnlIntraday.hScrollpnl, 0));
        GroupLayout groupLayout = new GroupLayout(pnlIntraday);
        pnlIntraday.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(pnlIntraday.hScrollpnl, -1, 400, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(pnlIntraday.jPanel1, -1, 383, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(pnlIntraday.vScrollpnl, -2, 17, -2)))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(pnlIntraday.vScrollpnl, -1, 183, Short.MAX_VALUE).addComponent(pnlIntraday.jPanel1, -1, 183, Short.MAX_VALUE)).addGap(0, 0, 0).addComponent(pnlIntraday.hScrollpnl, -2, 17, -2)));
        System.err.println("CATALYST Chart 3.2.0");
    }

    public synchronized void initializeChart(String string, String string2, ChartType chartType) {
        if (this.pnlChart != null) {
            this.jPanel1.remove(this.pnlChart);
        }
        if (this.scrollBar != null) {
            this.hScrollpnl.remove(this.scrollBar);
        }
        if (this.scrollBarVertical != null) {
            this.vScrollpnl.remove(this.scrollBarVertical);
        }
        this.intraday = null;
        this.pnlChart = null;
        this.scrollBar = null;
        this.scrollBarVertical = null;
        this.jPanel1.validate();
        this.vScrollpnl.validate();
        this.hScrollpnl.validate();
        if (chartType == ChartType.BUYSELL) {
            lastChartType = chartType;
            this.intraday = new BidAskChart(string, string2);
        } else if (chartType == ChartType.PRICEVOLUME) {
            lastChartType = chartType;
            this.intraday = new PriceVolumeCombinedChart();
        } else if (chartType == ChartType.PRICEVOLUME) {
            lastChartType = chartType;
            this.intraday = new PriceVolumeCombinedChart();
        } else if (chartType == ChartType.INDEXVOLUME) {
            lastChartType = chartType;
            this.intraday = new IndexVolumeCombinedChart();
        }
        this.intraday.setWaterMarkText(this.waterMarkText);
    }

    public void showChart() {
        this.pnlChart = this.intraday.createDemoPanel();
        this.scrollBar = new ChartScrollBar(0, this.intraday.localJFreeChart, this.intraday.localXYPlot);
        this.scrollBarVertical = new ChartScrollBar(1, this.intraday.localJFreeChart, this.intraday.localXYPlot);
        this.jPanel1.add(this.pnlChart);
        this.jPanel1.validate();
        this.hScrollpnl.add(this.scrollBar);
        this.hScrollpnl.validate();
        this.vScrollpnl.add(this.scrollBarVertical);
        this.vScrollpnl.validate();
        this.validate();
    }

    public String getSymbol() {
        return this.Symbol;
    }

    public void setSymbol(String string) {
        this.Symbol = string;
    }

    public void setWaterMarkText(String string) {
        this.waterMarkText = string;
        if (this.intraday != null) {
            this.intraday.setWaterMarkText(string);
        }
    }

    public void ZoomIn(ChartActionEvent chartActionEvent) {
        this.intraday.ZoomIn(chartActionEvent);
    }

    public void ZoomOut(ChartActionEvent chartActionEvent) {
        this.intraday.ZoomOut(chartActionEvent);
    }

    public void ResetZoom(ChartActionEvent chartActionEvent) {
        this.intraday.ResetZoom(chartActionEvent);
    }

    public void setInterval(ChartActionEvent chartActionEvent) {
        this.intraday.setInterval(chartActionEvent);
    }

    public void AddIndicator(ChartActionEvent chartActionEvent) {
        this.intraday.AddIndicator(chartActionEvent);
    }

    public void addTick(MarketFeed marketFeed) {
        try {
            if (this.intraday instanceof BidAskChart) {
                this.addBuySellTick(new SimpleDateFormat().parse(marketFeed.lTrdTime), Double.parseDouble(marketFeed.buy), Double.parseDouble(marketFeed.sell));
            }
        }
        catch (Exception exception) {}
        try {
            if (this.intraday instanceof PriceVolumeCombinedChart) {
                this.addPriceVolumeTick(new SimpleDateFormat().parse(marketFeed.lTrdTime), Double.parseDouble(marketFeed.buy), Double.parseDouble(marketFeed.sell));
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void addPriceVolumeTick(Date date, double d2, double d3) {
        if (this.intraday instanceof PriceVolumeCombinedChart) {
            ((PriceVolumeCombinedChart)this.intraday).addPriceVolumeTick(date, d2, d3);
        }
    }

    public void addIndexVolumeTick(Date date, double d2, double d3) {
        if (this.intraday instanceof IndexVolumeCombinedChart) {
            ((IndexVolumeCombinedChart)this.intraday).addPriceVolumeTick(date, d2, d3);
        }
    }

    public void addBuySellTick(Date date, double d2, double d3) {
        if (this.intraday instanceof BidAskChart) {
            ((BidAskChart)this.intraday).addBuySellTick(date, d2, d3);
        }
    }

    public void setInitialDataForbuySellChart(List<Date> list, List<Double> list2, List<Double> list3) {
        if (this.intraday instanceof BidAskChart) {
            ((BidAskChart)this.intraday).setInitialDataForbuySellChart(list, list2, list3);
            return;
        }
        throw new UnsupportedOperationException("Chart is not instance of buy sell chart");
    }

    public void setInitialDataForPriceVolumeChart(List<Date> list, List<Double> list2, List<Double> list3) {
        if (this.intraday instanceof PriceVolumeCombinedChart) {
            ((PriceVolumeCombinedChart)this.intraday).setInitialDataForPriceVolumeChart(list, list2, list3);
            return;
        }
        throw new UnsupportedOperationException("Chart is not instance of buy sell chart");
    }

    public void setInitialDataForIndexVolumeChart(List<Date> list, List<Double> list2, List<Double> list3) {
        if (this.intraday instanceof IndexVolumeCombinedChart) {
            ((IndexVolumeCombinedChart)this.intraday).setInitialDataForPriceVolumeChart(list, list2, list3);
            return;
        }
        throw new UnsupportedOperationException("Chart is not instance of buy sell chart");
    }

    public void setUpperLowerBound(double d2, double d3) {
        this.intraday.setUpperLowerBound(d2, d3);
    }
}

