/*
 * Decompiled with CFR 0.152.
 */
package catalystchart;

import catalystchart.ChartActionEvent;
import catalystchart.IntradayChart;
import catalystchart.JFreeChartDataProvider;
import catalystchart.o;
import chart.data.CSVReader;
import chart.data.IDataContainer;
import chart.data.XYDataContainer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import jfree.custom.CustomCrosshairOverlay;
import jfree.custom.InfoBoxCrosshair;
import jfree.custom.InfoBoxCrosshairOverlay;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.panel.AbstractOverlay;
import org.jfree.chart.panel.Overlay;
import org.jfree.chart.plot.Crosshair;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.XYBarDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleAnchor;

public class PriceVolumeChart
extends IntradayChart {
    private Crosshair crosshair1;
    private InfoBoxCrosshair infoboxcrosshair1;
    private InfoBoxCrosshair infoboxcrosshair2;
    private TimeSeries series;
    private TimeSeries series2;
    private TimeSeriesCollection localXYDataset;
    private TimeSeriesCollection localXYDataset2;
    IDataContainer dataContainer;
    IDataContainer dataContainer2;
    final Color VolumeColor = Color.RED;
    final Color LtrdPriceColor = new Color(0, 136, 0);

    @Override
    public void InitializeCrosshair() {
        AbstractOverlay abstractOverlay = new CustomCrosshairOverlay();
        this.crosshair1 = new Crosshair(0.0);
        this.crosshair1.setPaint((Paint)this.LtrdPriceColor);
        this.crosshair1.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
        this.crosshair1.setLabelVisible(true);
        this.crosshair1.setLabelBackgroundPaint((Paint)this.LtrdPriceColor);
        abstractOverlay.addRangeCrosshair(this.crosshair1);
        this.chartPanel.addOverlay((Overlay)abstractOverlay);
        abstractOverlay = new InfoBoxCrosshairOverlay();
        this.infoboxcrosshair1 = new InfoBoxCrosshair(0.0, 0.0);
        this.infoboxcrosshair1.setPaint(this.LtrdPriceColor);
        this.infoboxcrosshair1.showInfoBox(false);
        this.infoboxcrosshair2 = new InfoBoxCrosshair(0.0, 0.0);
        this.infoboxcrosshair2.setPaint(this.VolumeColor);
        this.infoboxcrosshair2.showInfoBox(true);
        abstractOverlay.addInfoCrosshair(this.infoboxcrosshair1);
        abstractOverlay.addInfoCrosshair(this.infoboxcrosshair2);
        this.chartPanel.addOverlay((Overlay)abstractOverlay);
        this.infoboxcrosshair1.setLabelVisible(true);
        this.infoboxcrosshair1.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
        this.infoboxcrosshair1.setLabelBackgroundPaint(new Color(255, 255, 0, 100));
    }

    @Override
    public void createDataset() {
        JFreeChartDataProvider jFreeChartDataProvider = new JFreeChartDataProvider();
        CSVReader cSVReader = new CSVReader();
        this.series = new TimeSeries((Comparable)((Object)"Series1"));
        this.dataContainer = new XYDataContainer();
        this.series2 = new TimeSeries((Comparable)((Object)"Series1"));
        this.dataContainer2 = new XYDataContainer();
        cSVReader.ReadLastTradePrice(this.dataContainer);
        cSVReader.ReadVolumeData(this.dataContainer2);
        this.localXYDataset = jFreeChartDataProvider.getXYdataset(this.dataContainer, this.series);
        this.localXYDataset2 = jFreeChartDataProvider.getXYdataset(this.dataContainer2, this.series2);
    }

    @Override
    public JFreeChart createChart() {
        this.createDataset();
        JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart((String)"", (String)"", (String)"", (XYDataset)this.localXYDataset, (boolean)false, (boolean)false, (boolean)false);
        this.localXYPlot = (XYPlot)jFreeChart.getPlot();
        this.localXYPlot.setDomainPannable(false);
        this.localXYPlot.setDataset(1, (XYDataset)new XYBarDataset((XYDataset)this.localXYDataset2, 0.2));
        NumberAxis numberAxis = (NumberAxis)this.localXYPlot.getRangeAxis();
        numberAxis.setLowerMargin(0.4);
        DecimalFormat decimalFormat = new DecimalFormat("00.00");
        numberAxis.setNumberFormatOverride((NumberFormat)decimalFormat);
        this.localXYPlot.setRangeAxisLocation(0, AxisLocation.TOP_OR_RIGHT);
        numberAxis = new NumberAxis();
        numberAxis.setAutoRangeIncludesZero(false);
        numberAxis.setTickLabelPaint((Paint)Color.gray);
        numberAxis.setUpperMargin(1.0);
        this.localXYPlot.setRangeAxis(1, (ValueAxis)numberAxis);
        this.localXYPlot.setRangeAxisLocation(1, AxisLocation.TOP_OR_LEFT);
        this.localXYPlot.mapDatasetToRangeAxis(1, 1);
        numberAxis = new XYBarRenderer(0.1);
        numberAxis.setBaseOutlineStroke((Stroke)new BasicStroke(3.0f, 2, 2, 3.0f, new float[]{2.0f}, 0.0f));
        numberAxis.setBaseOutlinePaint((Paint)Color.RED);
        numberAxis.setDrawBarOutline(true);
        numberAxis.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{0}: ({1}, {2})", (DateFormat)new SimpleDateFormat("d-MMM-yyyy"), (NumberFormat)new DecimalFormat("0,000.00")));
        this.localXYPlot.setRenderer(1, (XYItemRenderer)numberAxis);
        decimalFormat = new StandardXYBarPainter();
        numberAxis.setBarPainter((XYBarPainter)decimalFormat);
        numberAxis.setShadowVisible(false);
        this.localXYPlot.getRenderer(0).setSeriesPaint(0, (Paint)this.LtrdPriceColor);
        return jFreeChart;
    }

    @Override
    public void chartMouseMoved(ChartMouseEvent chartMouseEvent) {
        double d2 = (double)chartMouseEvent.getTrigger().getX() - this.chartPanel.getScreenDataArea().getX();
        double d3 = (double)(this.chartPanel.getHeight() - chartMouseEvent.getTrigger().getY()) - ((double)this.chartPanel.getHeight() - this.chartPanel.getScreenDataArea().getY() - this.chartPanel.getScreenDataArea().getHeight());
        Point2D point2D = this.getDotDatavalue(new Point2D.Double(d2, d3), this.series);
        this.infoboxcrosshair1.setX(point2D.getX());
        this.infoboxcrosshair1.setY(point2D.getY());
        Point2D point2D2 = this.getDotDatavalue(new Point2D.Double(d2, d3), this.series2);
        this.infoboxcrosshair2.setX(point2D2.getX());
        this.infoboxcrosshair2.setY(point2D2.getY());
        chartMouseEvent.getTrigger().getX();
        this.chartPanel.getScreenDataArea().getX();
        double d4 = this.chartPanel.getScreenDataArea().getWidth();
        chartMouseEvent = this.localXYPlot.getDomainAxis();
        point2D2 = chartMouseEvent.getRange();
        double d5 = chartMouseEvent.getLowerBound() + d2 / d4 * point2D2.getLength();
        long l2 = (long)d5;
        int n2 = this.series.getIndex((RegularTimePeriod)new Millisecond(new Date(l2)));
        if (-n2 < this.series.getItemCount()) {
            TimeSeriesDataItem timeSeriesDataItem = this.series.getDataItem(-n2);
            timeSeriesDataItem.getValue().doubleValue();
            TimeSeriesDataItem timeSeriesDataItem2 = this.series2.getDataItem(-n2);
            timeSeriesDataItem2.getValue().doubleValue();
        }
        new SimpleDateFormat("HH:mm:ss");
        Date date = new Date(l2);
        this.infoboxcrosshair2.setTime(date);
    }

    @Override
    public void chartChanged(ChartChangeEvent chartChangeEvent) {
        if (this.crosshair1 != null) {
            this.crosshair1.setValue(this.ltrdPrice);
        }
    }

    @Override
    public void RunDemo() {
        new Thread((Runnable)new o(this), "PriceVolumeChart Run Demo").start();
    }

    @Override
    public void AddIndicator(ChartActionEvent chartActionEvent) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addPriceVolumeTick(Date date, double d2, double d3) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static /* synthetic */ TimeSeries access$000(PriceVolumeChart priceVolumeChart) {
        return priceVolumeChart.series;
    }

    static /* synthetic */ TimeSeries access$100(PriceVolumeChart priceVolumeChart) {
        return priceVolumeChart.series2;
    }
}

