/*
 * Decompiled with CFR 0.152.
 */
package jfree.custom;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jfree.custom.CustomCrosshairOverlay;
import jfree.custom.TrendLineCrosshair;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.panel.AbstractOverlay;
import org.jfree.chart.panel.Overlay;
import org.jfree.chart.plot.Crosshair;
import org.jfree.chart.plot.XYPlot;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class TrendLineCrosshairOverlay
extends AbstractOverlay
implements PropertyChangeListener,
Serializable,
Cloneable,
Overlay,
PublicCloneable {
    private List tCrosshairs = new ArrayList();

    public void addTrendLineCrosshair(Crosshair crosshair) {
        if (crosshair == null) {
            throw new IllegalArgumentException("Null 'crosshair' argument.");
        }
        this.tCrosshairs.add(crosshair);
        crosshair.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void removeTrendLineCrosshair(Crosshair crosshair) {
        if (crosshair == null) {
            throw new IllegalArgumentException("Null 'crosshair' argument.");
        }
        if (this.tCrosshairs.remove(crosshair)) {
            crosshair.removePropertyChangeListener((PropertyChangeListener)this);
            this.fireOverlayChanged();
        }
    }

    public void clearTrendLineCrosshairs() {
        if (this.tCrosshairs.isEmpty()) {
            return;
        }
        List list = this.getTrendLineCrosshairs();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Crosshair crosshair = (Crosshair)list.get(i2);
            this.tCrosshairs.remove(crosshair);
            crosshair.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.fireOverlayChanged();
    }

    public List getTrendLineCrosshairs() {
        return new ArrayList(this.tCrosshairs);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.fireOverlayChanged();
    }

    public void paintOverlay(Graphics2D graphics2D, ChartPanel chartPanel) {
        Shape shape = graphics2D.getClip();
        Rectangle2D rectangle2D = chartPanel.getScreenDataArea();
        graphics2D.clip(rectangle2D);
        chartPanel = chartPanel.getChart();
        chartPanel = (XYPlot)chartPanel.getPlot();
        ValueAxis valueAxis = chartPanel.getDomainAxis();
        RectangleEdge rectangleEdge = chartPanel.getDomainAxisEdge();
        ValueAxis valueAxis2 = chartPanel.getRangeAxis();
        chartPanel = chartPanel.getRangeAxisEdge();
        for (TrendLineCrosshair trendLineCrosshair : this.tCrosshairs) {
            if (trendLineCrosshair.getFirstPoint() == null || trendLineCrosshair.getSecondPoint() == null) continue;
            Point2D point2D = trendLineCrosshair.getFirstPoint();
            Point2D point2D2 = trendLineCrosshair.getSecondPoint();
            System.out.println("1.  FX:" + point2D.getX() + " FY:" + point2D.getY() + " SX:" + point2D2.getX() + " SY:" + point2D2.getY());
            point2D = new Point2D.Double(valueAxis.valueToJava2D(point2D.getX(), rectangle2D, rectangleEdge), valueAxis2.valueToJava2D(point2D.getY(), rectangle2D, (RectangleEdge)chartPanel));
            point2D2 = new Point2D.Double(valueAxis.valueToJava2D(point2D2.getX(), rectangle2D, rectangleEdge), valueAxis2.valueToJava2D(point2D2.getY(), rectangle2D, (RectangleEdge)chartPanel));
            this.drawTrendLineCrosshair(graphics2D, rectangle2D, point2D, point2D2, trendLineCrosshair);
        }
        graphics2D.setClip(shape);
    }

    protected void drawTrendLineCrosshair(Graphics2D graphics2D, Rectangle2D shape, Point2D object, Point2D object2, TrendLineCrosshair trendLineCrosshair) {
        if (((Point2D)object).getX() >= shape.getMinX() && ((Point2D)object).getX() <= shape.getMaxX() && ((Point2D)object).getY() >= shape.getMinY() && ((Point2D)object).getY() <= shape.getMaxY() && ((Point2D)object2).getX() >= shape.getMinX() && ((Point2D)object2).getX() <= shape.getMaxX() && ((Point2D)object2).getY() >= shape.getMinY() && ((Point2D)object2).getY() <= shape.getMaxY()) {
            shape = new Line2D.Double((Point2D)object, (Point2D)object2);
            object = graphics2D.getPaint();
            object2 = graphics2D.getStroke();
            graphics2D.setPaint(trendLineCrosshair.getPaint());
            graphics2D.setStroke(trendLineCrosshair.getStroke());
            graphics2D.draw(shape);
            graphics2D.setPaint((Paint)object);
            graphics2D.setStroke((Stroke)object2);
            return;
        }
        System.out.println("FX:" + ((Point2D)object).getX() + " FY:" + ((Point2D)object).getY() + " SX:" + ((Point2D)object2).getX() + " SY:" + ((Point2D)object2).getY());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CustomCrosshairOverlay)) {
            return false;
        }
        object = (TrendLineCrosshairOverlay)object;
        return ((Object)this.tCrosshairs).equals(((TrendLineCrosshairOverlay)object).tCrosshairs);
    }

    public Object clone() {
        TrendLineCrosshairOverlay trendLineCrosshairOverlay = (TrendLineCrosshairOverlay)super.clone();
        ((TrendLineCrosshairOverlay)super.clone()).tCrosshairs = (List)ObjectUtilities.deepClone((Collection)this.tCrosshairs);
        return trendLineCrosshairOverlay;
    }
}

