/*
 * Decompiled with CFR 0.152.
 */
package common.gui.component;

import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

public class ArrowIcon
implements Icon,
SwingConstants {
    private static final float DB = -0.06f;
    private int direction;
    private int size;
    private Color color;
    private BufferedImage arrowImage;

    public ArrowIcon(int direction) {
        this(direction, 10, null);
    }

    public ArrowIcon(int direction, Color color) {
        this(direction, 10, color);
    }

    public ArrowIcon(int direction, int size, Color color) {
        this.size = size;
        this.direction = direction;
        this.color = color;
    }

    @Override
    public int getIconHeight() {
        return this.size;
    }

    @Override
    public int getIconWidth() {
        return this.size;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.drawImage(this.getArrowImage(), x, y, c);
    }

    protected Image getArrowImage() {
        if (this.arrowImage == null) {
            this.arrowImage = Util.createTranslucentImage(this.size, this.size);
            AffineTransform atx = this.direction != 5 ? new AffineTransform() : null;
            switch (this.direction) {
                case 1: {
                    atx.setToRotation(Math.PI, this.size / 2, this.size / 2);
                    break;
                }
                case 3: {
                    atx.setToRotation(-1.5707963267948966, this.size / 2, this.size / 2);
                    break;
                }
                case 7: {
                    atx.setToRotation(1.5707963267948966, this.size / 2, this.size / 2);
                }
            }
            Graphics2D ig = (Graphics2D)this.arrowImage.getGraphics();
            if (atx != null) {
                ig.setTransform(atx);
            }
            int width = this.size;
            int height = this.size / 2 + 1;
            int xx = (this.size - width) / 2;
            int yy = (this.size - height + 1) / 2;
            Color base = this.color != null ? this.color : UIManager.getColor("controlDkShadow").darker();
            this.paintArrow(ig, base, xx, yy);
            this.paintArrowBevel(ig, base, xx, yy);
            this.paintArrowBevel(ig, Util.deriveColorHSB(base, 0.0f, 0.0f, 0.2f), xx, yy + 1);
        }
        return this.arrowImage;
    }

    protected void paintArrow(Graphics2D g, Color base, int x, int y) {
        g.setColor(base);
        int xx = x;
        int yy = y - 1;
        for (int len = this.size - 2; len >= 2; len -= 2) {
            g.fillRect(++xx, ++yy, len, 1);
        }
    }

    protected void paintArrowBevel(Graphics g, Color base, int x, int y) {
        int len = this.size;
        int xx = x;
        int yy = y;
        Color c2 = Util.deriveColorHSB(base, 0.0f, 0.0f, 0.06f * (float)(this.size / 2));
        while (len >= 2) {
            c2 = Util.deriveColorHSB(c2, 0.0f, 0.0f, -0.06f);
            g.setColor(c2);
            g.fillRect(xx, yy, 1, 1);
            g.fillRect(xx + len - 1, yy, 1, 1);
            len -= 2;
            ++xx;
            ++yy;
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        JPanel panel = new JPanel();
        frame.add(panel);
        panel.add(new JLabel("north", new ArrowIcon(1), 0));
        panel.add(new JLabel("west", new ArrowIcon(7), 0));
        panel.add(new JLabel("south", new ArrowIcon(5), 0));
        panel.add(new JLabel("east", new ArrowIcon(3), 0));
        panel.add(new JLabel("east-20", new ArrowIcon(3, 20, Color.blue), 0));
        frame.pack();
        frame.setVisible(true);
    }
}

