/*
 * Decompiled with CFR 0.152.
 */
package common.gui.component;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.GroupLayout;
import javax.swing.JPanel;

public class BarPanel
extends JPanel {
    private Color start = Color.BLUE;
    private Color end = Color.PINK;
    ArrayList<Double> list = new ArrayList(10);
    RenderingHints qualityHints;
    double max = 0.0;

    public BarPanel(ArrayList<Double> list) {
        int i;
        this.initComponents();
        this.list = list;
        this.qualityHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.qualityHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Random red = new Random();
        for (i = 0; i < 26; ++i) {
            list.add(Math.abs(red.nextDouble()));
            list.add(Double.valueOf(i));
        }
        for (i = 0; i < 26; ++i) {
            if (!(this.max < list.get(i))) continue;
            this.max = list.get(i);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHints(this.qualityHints);
        int space = 1;
        int frameHeigth = this.getSize().height;
        int frameWidth = this.getSize().width;
        int barWidth = (frameWidth + this.list.size() * space) / this.list.size() - 2;
        for (int i = 0; i < this.list.size(); ++i) {
            double value = this.list.get(i);
            Color bgColor = Color.white;
            g2d.setColor(bgColor);
            double slice = new Double(value) / new Double(this.max);
            int barHeight = (int)(slice * (double)frameHeigth);
            int startY = frameHeigth - barHeight;
            int stattX = i * (barWidth + space);
            Paint oldPaint = g2d.getPaint();
            GradientPaint paint = new GradientPaint(0.0f, barHeight, this.start, 0.0f, 0.0f, this.end, false);
            g2d.setPaint(paint);
            g2d.fillRect(stattX, startY, barWidth, barHeight);
            g2d.setPaint(oldPaint);
        }
    }

    private void initComponents() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                BarPanel.this.formMousePressed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    private void formMousePressed(MouseEvent evt) {
        System.out.println(evt);
    }
}

