/*
 * Decompiled with CFR 0.152.
 */
package common.gui.component;

import common.gui.util.ColorUtility;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.jdesktop.swingx.JXCollapsiblePane;

public class BlurLabelArrow
extends JLabel {
    BufferedImage img2;
    private final Color start = Color.BLACK;
    Color end = ColorUtility.ScrollerMouseExit;
    private JXCollapsiblePane.Direction dir;

    public BlurLabelArrow() {
        this.setOpaque(false);
        try {
            this.img2 = ImageIO.read(this.getClass().getResource("/common/gui/images/up.png"));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setDirection(JXCollapsiblePane.Direction dir) {
        this.dir = dir;
        if (dir == JXCollapsiblePane.Direction.UP) {
            try {
                this.img2 = ImageIO.read(this.getClass().getResource("/common/gui/images/up.png"));
                ImageIcon i = new ImageIcon(this.img2);
                this.setIcon(i);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else if (dir == JXCollapsiblePane.Direction.DOWN) {
            try {
                this.img2 = ImageIO.read(this.getClass().getResource("/common/gui/images/down.png"));
                ImageIcon i = new ImageIcon(this.img2);
                this.setIcon(i);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else if (dir == JXCollapsiblePane.Direction.LEFT) {
            try {
                this.img2 = ImageIO.read(this.getClass().getResource("/common/gui/images/leftdisable.png"));
                ImageIcon i = new ImageIcon(this.img2);
                this.setIcon(i);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else if (dir == JXCollapsiblePane.Direction.RIGHT) {
            try {
                this.img2 = ImageIO.read(this.getClass().getResource("/common/gui/images/rightdisable.png"));
                ImageIcon i = new ImageIcon(this.img2);
                this.setIcon(i);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.end = bg;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int he = this.getSize().height;
        int wi = this.getSize().width;
        if (this.dir == JXCollapsiblePane.Direction.UP) {
            GradientPaint paint = new GradientPaint(0.0f, he, this.start, 0.0f, 0.0f, this.end, false);
            g2d.setPaint(paint);
            int[] xPoints = new int[]{wi / 2, 100, wi - 100};
            int[] yPoints = new int[]{3, he - 2, he - 2};
            g2d.fillPolygon(xPoints, yPoints, 3);
        } else if (this.dir == JXCollapsiblePane.Direction.DOWN) {
            GradientPaint paint = new GradientPaint(0.0f, he, this.end, 0.0f, 0.0f, this.start, false);
            g2d.setPaint(paint);
            int[] xPoints = new int[]{wi / 2, 100, wi - 100};
            int[] yPoints = new int[]{he - 2, 3, 3};
            g2d.fillPolygon(xPoints, yPoints, 3);
        } else {
            super.paintComponent(g);
        }
    }
}

