/*
 * Decompiled with CFR 0.152.
 */
package common.gui.component;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.SwingConstants;

public class DualIcon
implements Icon,
SwingConstants {
    Icon icon1;
    Icon icon2;
    private int width;
    private int height;
    private int icon1HOffset;
    private int icon1VOffset;
    private int icon2HOffset;
    private int icon2VOffset;
    private int iconIconGap;

    public DualIcon(Icon icon1, Icon icon2) {
        this(icon1, icon2, 4, 0, 4);
    }

    public DualIcon(Icon icon1, Icon icon2, int horizontalPosition, int verticalPosition, int iconIconGap) {
        if (icon1 == null || icon2 == null) {
            throw new NullPointerException("Icons cannot be null");
        }
        horizontalPosition = this.checkHorizontalKey(horizontalPosition, "horizontalPosition");
        verticalPosition = this.checkVerticalKey(verticalPosition, "verticalPosition");
        this.icon1 = icon1;
        this.icon2 = icon2;
        this.iconIconGap = iconIconGap;
        this.width = horizontalPosition == 0 ? Math.max(icon1.getIconWidth(), icon2.getIconWidth()) : icon1.getIconWidth() + iconIconGap + icon2.getIconWidth();
        this.height = verticalPosition == 0 || horizontalPosition != 0 ? Math.max(icon1.getIconHeight(), icon2.getIconHeight()) : icon1.getIconHeight() + iconIconGap + icon2.getIconHeight();
        switch (horizontalPosition) {
            case 2: {
                this.icon1HOffset = 0;
                this.icon2HOffset = icon1.getIconWidth() + iconIconGap;
                break;
            }
            case 0: {
                this.icon1HOffset = (this.width - icon1.getIconWidth()) / 2;
                this.icon2HOffset = (this.width - icon2.getIconWidth()) / 2;
                break;
            }
            case 4: {
                this.icon1HOffset = icon2.getIconWidth() + iconIconGap;
                this.icon2HOffset = 0;
            }
        }
        if (verticalPosition == 0) {
            this.icon1VOffset = (this.height - icon1.getIconHeight()) / 2;
            this.icon2VOffset = (this.height - icon2.getIconHeight()) / 2;
        } else if (horizontalPosition == 0) {
            this.icon1VOffset = verticalPosition == 1 ? 0 : icon2.getIconHeight() + iconIconGap;
            this.icon2VOffset = verticalPosition == 1 ? icon1.getIconHeight() + iconIconGap : 0;
        } else {
            this.icon1VOffset = verticalPosition == 1 ? 0 : this.height - icon1.getIconHeight();
            this.icon2VOffset = verticalPosition == 1 ? 0 : this.height - icon2.getIconHeight();
        }
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.icon1.paintIcon(c, g, x + this.icon1HOffset, y + this.icon1VOffset);
        this.icon2.paintIcon(c, g, x + 85, y + this.icon2VOffset);
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    private int checkHorizontalKey(int key, String exception) {
        if (key == 2 || key == 0 || key == 4) {
            return key;
        }
        throw new IllegalArgumentException(exception);
    }

    private int checkVerticalKey(int key, String exception) {
        if (key == 1 || key == 0 || key == 3) {
            return key;
        }
        throw new IllegalArgumentException(exception);
    }
}

