/*
 * Decompiled with CFR 0.152.
 */
package common.gui.component;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class JTextFieldFilter
extends PlainDocument {
    public static final String LOWERCASE = "abcdefghijklmnopqrstuvwxyz";
    public static final String UPPERCASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String NUMERIC = "0123456789";
    public static final String Dot = ".";
    public static final String Dash = "-";
    public static final String Colan = ":";
    public static final String ALPHA = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String MBILE = "+- 0123456789";
    public static final String FLOAT = "0123456789.";
    public static final String ALPHA_NUMERIC = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 ";
    public static final String SCRIP = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-";
    public static final String SCRIP_MARKET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-:";
    public static final String UPPERCASE_NUMERIC = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    protected String acceptedChars = null;
    protected boolean negativeAccepted = false;
    private int limit = 999999999;

    public JTextFieldFilter() {
        this(ALPHA_NUMERIC);
    }

    public JTextFieldFilter(String acceptedchars) {
        this.acceptedChars = acceptedchars;
    }

    public JTextFieldFilter(String acceptedchars, int limit) {
        this.acceptedChars = acceptedchars;
        this.limit = limit;
    }

    public void setNegativeAccepted(boolean negativeaccepted) {
        if (this.acceptedChars.equals(NUMERIC) || this.acceptedChars.equals(FLOAT) || this.acceptedChars.equals(ALPHA_NUMERIC)) {
            this.negativeAccepted = negativeaccepted;
            this.acceptedChars = this.acceptedChars + Dash;
        }
    }

    @Override
    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        String a;
        int count;
        if (str == null) {
            return;
        }
        if (this.getLength() + str.length() > this.limit) {
            return;
        }
        if (this.acceptedChars.equals(UPPERCASE) || this.acceptedChars.equals(UPPERCASE_NUMERIC) || this.acceptedChars.equals(SCRIP) || this.acceptedChars.equals(SCRIP_MARKET)) {
            str = str.toUpperCase();
        } else if (this.acceptedChars.equals(LOWERCASE)) {
            str = str.toLowerCase();
        }
        for (int i = 0; i < str.length(); ++i) {
            if (this.acceptedChars.indexOf(String.valueOf(str.charAt(i))) != -1) continue;
            return;
        }
        if ((this.acceptedChars.equals(FLOAT) || this.acceptedChars.equals("0123456789.-") && this.negativeAccepted) && str.indexOf(Dot) != -1 && this.getText(0, this.getLength()).indexOf(Dot) != -1) {
            return;
        }
        if (this.negativeAccepted && str.indexOf(Dash) != -1 && (str.indexOf(Dash) != 0 || offset != 0)) {
            return;
        }
        if ((this.acceptedChars.equals(SCRIP) || this.acceptedChars.equals(SCRIP_MARKET)) && (count = (a = this.getText(0, this.getLength()) + str).split(Dash, -1).length - 1) > 1) {
            return;
        }
        super.insertString(offset, str, attr);
    }
}

