/*
 * Decompiled with CFR 0.152.
 */
package common.gui.component;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import org.jdesktop.swingx.JXLabel;

public class NxGLabelDoubleColor
extends JXLabel {
    private Color startPercentColor = new Color(213, 214, 217);
    private Color endPercentColor = Color.WHITE;
    private Color startDefault = new Color(213, 214, 217);
    private Color endDefault = Color.WHITE;
    private boolean isLinearGradient = true;
    private int paintWidthPercent = 0;
    private int paintRemainPercent = 0;

    public void setText(String text) {
        super.setText(" " + text + " ");
    }

    public void paint(Graphics g) {
        if (!this.isIsLinearGradient()) {
            this.setOpaque(false);
            int width = this.getWidth();
            int height = this.getHeight();
            GradientPaint paint = new GradientPaint(0.0f, height, this.startPercentColor, 0.0f, 0.0f, this.endPercentColor, false);
            Graphics2D g2d = (Graphics2D)g;
            Paint oldPaint = g2d.getPaint();
            g2d.setPaint(paint);
            g2d.fillRect(0, 0, width / 2, height);
            GradientPaint paint2 = new GradientPaint(0.0f, height, this.getStartDefault(), 0.0f, 0.0f, this.getEndDefault(), false);
            g2d.setPaint(paint2);
            g2d.fillRect(width / 2, 0, width / 2, height);
            g2d.setPaint(oldPaint);
            super.paint(g);
        } else {
            this.setOpaque(false);
            Graphics2D g2 = (Graphics2D)g;
            int height = this.getHeight();
            int width = this.getWidth();
            int paint = (int)((double)width * (Double.valueOf(this.paintWidthPercent + "") / 100.0));
            int paintRemain = (int)((double)width * (Double.valueOf(this.paintRemainPercent + "") / 100.0));
            GradientPaint painter = new GradientPaint(0.0f, 0.0f, this.endPercentColor, 0.0f, height / 2, this.startPercentColor);
            g2.setPaint(painter);
            Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, paint, (double)height / 2.0);
            g2.fill(rect);
            painter = new GradientPaint(0.0f, height / 2, this.startPercentColor, 0.0f, height, this.endPercentColor);
            g2.setPaint(painter);
            rect = new Rectangle2D.Double(0.0, (double)height / 2.0 - 1.0, paint, height);
            g2.fill(rect);
            painter = new GradientPaint(0.0f, 0.0f, this.getEndDefault(), 0.0f, height / 2, this.getStartDefault());
            g2.setPaint(painter);
            rect = new Rectangle2D.Double(paint, 0.0, paintRemain, (double)height / 2.0);
            g2.fill(rect);
            painter = new GradientPaint(0.0f, height / 2, this.getStartDefault(), 0.0f, height, this.getEndDefault());
            g2.setPaint(painter);
            rect = new Rectangle2D.Double(paint, (double)height / 2.0 - 1.0, paintRemain, height);
            g2.fill(rect);
            super.paint(g);
        }
    }

    public int getPaintWidthPercent() {
        return this.paintWidthPercent;
    }

    public void setPaintWidthPercent(int paintWidthPercent) {
        if (paintWidthPercent > 100) {
            paintWidthPercent = 100;
        }
        this.paintWidthPercent = paintWidthPercent;
        this.paintRemainPercent = 100 - paintWidthPercent;
        this.repaint();
    }

    public Color getStart() {
        return this.startPercentColor;
    }

    public void setStartPercentColor(Color start) {
        this.startPercentColor = start;
    }

    public Color getEnd() {
        return this.endPercentColor;
    }

    public void setEndPercentColor(Color end) {
        this.endPercentColor = end;
    }

    public Color getStartDefault() {
        return this.startDefault;
    }

    public void setStartDefault(Color startDefault) {
        this.startDefault = startDefault;
    }

    public Color getEndDefault() {
        return this.endDefault;
    }

    public void setEndDefault(Color endDefault) {
        this.endDefault = endDefault;
    }

    public boolean isIsLinearGradient() {
        return this.isLinearGradient;
    }

    public void setIsLinearGradient(boolean isLinearGradient) {
        this.isLinearGradient = isLinearGradient;
    }
}

