/*
 * Decompiled with CFR 0.152.
 */
package common.gui.component;

import common.gui.util.ColorUtility;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class NxGScrollBarUI
extends BasicScrollBarUI {
    private Color start = ColorUtility.ScrollerMouseExit;
    boolean isFreeStanding = true;

    public void setMyScrollBarUI(final JScrollBar vbar) {
        vbar.setUI(this);
        vbar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                NxGScrollBarUI.this.start = ColorUtility.ScrollerMouseExit;
                vbar.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                NxGScrollBarUI.this.start = ColorUtility.ScrollerMouseEnter;
                vbar.repaint();
            }
        });
    }

    public static ComponentUI createUI(JComponent c) {
        return new NxGScrollBarUI();
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        JButton b = new JButton();
        Dimension d = new Dimension(0, 0);
        b.setSize(d);
        b.setPreferredSize(d);
        b.setMaximumSize(d);
        b.setMinimumSize(d);
        return b;
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        JButton b = new JButton();
        Dimension d = new Dimension(0, 0);
        b.setSize(d);
        b.setPreferredSize(d);
        b.setMaximumSize(d);
        b.setMinimumSize(d);
        return b;
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (!c.isEnabled()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.translate(thumbBounds.x, thumbBounds.y);
        if (this.scrollbar.getOrientation() == 1) {
            if (!this.isFreeStanding) {
                thumbBounds.width += 2;
            }
            g.setColor(this.start);
            g.fillRoundRect(1, 0, thumbBounds.width - 2, thumbBounds.height - 1, 7, 7);
            if (!this.isFreeStanding) {
                thumbBounds.width -= 20;
            }
        } else {
            if (!this.isFreeStanding) {
                thumbBounds.height += 2;
            }
            g.setColor(Color.DARK_GRAY);
            g.fillOval(0, 0, thumbBounds.width - 1, thumbBounds.height - 2);
            if (!this.isFreeStanding) {
                thumbBounds.height -= 2;
            }
        }
        g.translate(-thumbBounds.x, -thumbBounds.y);
    }
}

