/*
 * Decompiled with CFR 0.152.
 */
package common.gui.render;

import common.gui.component.NxGLabelGradeint;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class NxGTableCellRender
extends DefaultTableCellRenderer
implements MouseListener,
MouseMotionListener {
    private int rowNo = -1;
    private boolean isColored = true;
    private Color oddColorStart = new Color(249, 249, 249);
    private Color oddColorEnd = new Color(225, 225, 225);
    private Color evenColorStart = new Color(221, 232, 242);
    private Color evenColorEnd = new Color(192, 207, 220);
    private Color selectColorStart = new Color(28, 78, 111);
    private Color selectColorEnd = new Color(96, 140, 187);
    private Color roleOverColorStart = new Color(89, 136, 166);
    private Color roleOverColorEnd = new Color(139, 187, 218);
    private JTable table = null;

    public NxGTableCellRender(JTable table) {
        if (table != null) {
            this.table = table;
            this.table.addMouseListener(this);
            this.table.addMouseMotionListener(this);
            this.addMouseMotionListener(this);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        NxGLabelGradeint cell = null;
        try {
            if (table.getColumnClass(column) == Double.class) {
                cell = new NxGLabelGradeint();
                cell.setText(Util.format2digit(value.toString()) + " ");
                cell.setHorizontalAlignment(4);
            } else if (table.getColumnClass(column) == Integer.class) {
                cell = new NxGLabelGradeint();
                cell.setText(Util.format0digit(value.toString()) + " ");
                cell.setHorizontalAlignment(4);
            } else if (table.getColumnClass(column) == String.class) {
                cell = new NxGLabelGradeint();
                cell.setText(" " + value);
                cell.setHorizontalAlignment(2);
            } else if (table.getColumnClass(column) == Date.class) {
                cell = new NxGLabelGradeint();
                if (value != null) {
                    Date dt = (Date)value;
                    cell.setText(" " + Util.formatDate(dt));
                    cell.setHorizontalAlignment(2);
                }
            }
            if (cell instanceof NxGLabelGradeint) {
                if (this.isColored) {
                    if (row % 2 == 0) {
                        cell.setGradient(this.getOddColorStart(), this.getOddColorEnd());
                    } else {
                        cell.setGradient(this.getEvenColorStart(), this.getEvenColorEnd());
                    }
                    if (isSelected) {
                        cell.setGradient(this.getSelectColorStart(), this.getSelectColorEnd());
                        ((Component)((Object)cell)).setForeground(Color.WHITE);
                    }
                    if ((this.getRowNo() != -1 || this.getRowNo() <= row) && this.getRowNo() == row) {
                        cell.setGradient(this.getRoleOverColorStart(), this.getRoleOverColorEnd());
                        ((Component)((Object)cell)).setForeground(Color.WHITE);
                    }
                } else if (isSelected) {
                    cell.setGradient(table.getSelectionBackground(), table.getSelectionBackground());
                    ((Component)((Object)cell)).setForeground(Color.WHITE);
                } else {
                    cell.setGradient(Color.WHITE, Color.WHITE);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cell;
    }

    public boolean isColored() {
        return this.isColored;
    }

    public void setColored(boolean Colored) {
        this.isColored = Colored;
    }

    public void setOddColor(Color oddColorStart, Color oddColorEnd) {
        this.setOddColorStart(oddColorStart);
        this.setOddColorEnd(oddColorEnd);
    }

    public void setEvenColor(Color evenColorStart, Color evenColorEnd) {
        this.setEvenColorStart(evenColorStart);
        this.setEvenColorEnd(evenColorEnd);
    }

    public void setSelectionColor(Color selectColorStart, Color selectColorEnd) {
        this.setSelectColorStart(selectColorStart);
        this.setSelectColorEnd(selectColorEnd);
    }

    public void setRoleOverColor(Color roleOverColorStart, Color roleOverColorEnd) {
        this.setRoleOverColorStart(roleOverColorStart);
        this.setRoleOverColorEnd(roleOverColorEnd);
    }

    public Color getOddColorStart() {
        return this.oddColorStart;
    }

    public void setOddColorStart(Color oddColorStart) {
        this.oddColorStart = oddColorStart;
    }

    public Color getOddColorEnd() {
        return this.oddColorEnd;
    }

    public void setOddColorEnd(Color oddColorEnd) {
        this.oddColorEnd = oddColorEnd;
    }

    public Color getEvenColorStart() {
        return this.evenColorStart;
    }

    public void setEvenColorStart(Color evenColorStart) {
        this.evenColorStart = evenColorStart;
    }

    public Color getEvenColorEnd() {
        return this.evenColorEnd;
    }

    public void setEvenColorEnd(Color evenColorEnd) {
        this.evenColorEnd = evenColorEnd;
    }

    public Color getSelectColorStart() {
        return this.selectColorStart;
    }

    public void setSelectColorStart(Color selectColorStart) {
        this.selectColorStart = selectColorStart;
    }

    public Color getSelectColorEnd() {
        return this.selectColorEnd;
    }

    public void setSelectColorEnd(Color selectColorEnd) {
        this.selectColorEnd = selectColorEnd;
    }

    public Color getRoleOverColorStart() {
        return this.roleOverColorStart;
    }

    public void setRoleOverColorStart(Color roleOverColorStart) {
        this.roleOverColorStart = roleOverColorStart;
    }

    public Color getRoleOverColorEnd() {
        return this.roleOverColorEnd;
    }

    public void setRoleOverColorEnd(Color roleOverColorEnd) {
        this.roleOverColorEnd = roleOverColorEnd;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        int row = this.table.rowAtPoint(evt.getPoint());
        if (row != this.getRowNo()) {
            this.setRowNo(row);
            this.table.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setRowNo(-1);
        this.table.repaint();
    }

    public int getRowNo() {
        return this.rowNo;
    }

    public void setRowNo(int rowNo) {
        this.rowNo = rowNo;
    }
}

