/*
 * Decompiled with CFR 0.152.
 */
package common.gui.render;

import common.gui.component.NxGTextFieldGradient;
import common.gui.util.ColorUtility;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.DefaultHighlighter;

public class SearchHighLighterRender
extends NxGTextFieldGradient
implements TableCellRenderer,
MouseListener,
MouseMotionListener {
    private int rowNo = -1;
    private boolean Colored = true;
    private Color oddColorStart = new Color(249, 249, 249);
    private Color oddColorEnd = new Color(225, 225, 225);
    private Color evenColorStart = new Color(221, 232, 242);
    private Color evenColorEnd = new Color(192, 207, 220);
    private Color selectColorStart = new Color(28, 78, 111);
    private Color selectColorEnd = new Color(96, 140, 187);
    private Color roleOverColorStart = new Color(89, 136, 166);
    private Color roleOverColorEnd = new Color(139, 187, 218);
    public DefaultHighlighter high = new DefaultHighlighter();
    public DefaultHighlighter.DefaultHighlightPainter highlight_painter = new DefaultHighlighter.DefaultHighlightPainter(ColorUtility.SearchGB);
    private String searchText = "";
    private final JTable table;
    private int serachingColumn = 0;
    public static final int ANY_WHERE = -123;

    public SearchHighLighterRender(JTable table) {
        this.table = table;
        this.table.addMouseListener(this);
        this.table.addMouseMotionListener(this);
        this.addMouseMotionListener(this);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setHighlighter(this.high);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        block19: {
            String pattern;
            int pos;
            block18: {
                this.setFont(table.getFont());
                if (table.getColumnClass(column) == Double.class) {
                    this.setValue(Util.format2digit(value.toString()));
                    this.setHorizontalAlignment(4);
                } else if (table.getColumnClass(column) == Integer.class) {
                    this.setValue(Util.format0digit(value.toString()));
                    this.setHorizontalAlignment(4);
                } else if (table.getColumnClass(column) == String.class) {
                    this.setValue(value);
                    this.setHorizontalAlignment(2);
                } else if (table.getColumnClass(column) == Date.class && value != null) {
                    Date dt = (Date)value;
                    value = Util.formatDate(dt);
                    this.setValue(value);
                    this.setHorizontalAlignment(2);
                }
                pos = 0;
                pattern = this.searchText.trim().toUpperCase();
                this.setForeground(Color.BLACK);
                if (row % 2 == 0) {
                    this.setGradient(this.oddColorStart, this.oddColorEnd);
                } else {
                    this.setGradient(this.evenColorStart, this.evenColorEnd);
                }
                if (isSelected) {
                    this.setGradient(this.selectColorStart, this.selectColorEnd);
                    this.setForeground(Color.WHITE);
                }
                if ((this.rowNo != -1 || this.rowNo <= row) && this.rowNo == row) {
                    this.setGradient(this.roleOverColorStart, this.roleOverColorEnd);
                    this.setForeground(Color.WHITE);
                }
                if (pattern.length() <= 0) {
                    return this;
                }
                if (this.serachingColumn != -123) break block18;
                while ((pos = value.toString().toUpperCase().indexOf(pattern, pos)) >= 0) {
                    try {
                        this.high.addHighlight(++pos, pos + pattern.length(), this.highlight_painter);
                        pos += pattern.length();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                break block19;
            }
            if (column != this.serachingColumn) break block19;
            while ((pos = value.toString().toUpperCase().indexOf(pattern, pos)) >= 0) {
                try {
                    this.high.addHighlight(++pos, pos + pattern.length(), this.highlight_painter);
                    pos += pattern.length();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this;
    }

    protected void setValue(Object value) {
        this.setText(value == null ? "" : " " + value.toString() + " ");
    }

    public int getRowNo() {
        return this.rowNo;
    }

    public void setRowNo(int rowNo) {
        this.rowNo = rowNo;
    }

    public boolean isColored() {
        return this.Colored;
    }

    public void setColored(boolean Colored) {
        this.Colored = Colored;
    }

    public void setOddColor(Color oddColorStart, Color oddColorEnd) {
        this.setOddColorStart(oddColorStart);
        this.setOddColorEnd(oddColorEnd);
    }

    public void setEvenColor(Color evenColorStart, Color evenColorEnd) {
        this.setEvenColorStart(evenColorStart);
        this.setEvenColorEnd(evenColorEnd);
    }

    public void setSelectionColor(Color selectColorStart, Color selectColorEnd) {
        this.setSelectColorStart(selectColorStart);
        this.setSelectColorEnd(selectColorEnd);
    }

    public void setRoleOverColor(Color roleOverColorStart, Color roleOverColorEnd) {
        this.setRoleOverColorStart(roleOverColorStart);
        this.setRoleOverColorEnd(roleOverColorEnd);
    }

    public Color getOddColorStart() {
        return this.oddColorStart;
    }

    public void setOddColorStart(Color oddColorStart) {
        this.oddColorStart = oddColorStart;
    }

    public Color getOddColorEnd() {
        return this.oddColorEnd;
    }

    public void setOddColorEnd(Color oddColorEnd) {
        this.oddColorEnd = oddColorEnd;
    }

    public Color getEvenColorStart() {
        return this.evenColorStart;
    }

    public void setEvenColorStart(Color evenColorStart) {
        this.evenColorStart = evenColorStart;
    }

    public Color getEvenColorEnd() {
        return this.evenColorEnd;
    }

    public void setEvenColorEnd(Color evenColorEnd) {
        this.evenColorEnd = evenColorEnd;
    }

    public Color getSelectColorStart() {
        return this.selectColorStart;
    }

    public void setSelectColorStart(Color selectColorStart) {
        this.selectColorStart = selectColorStart;
    }

    public Color getSelectColorEnd() {
        return this.selectColorEnd;
    }

    public void setSelectColorEnd(Color selectColorEnd) {
        this.selectColorEnd = selectColorEnd;
    }

    public Color getRoleOverColorStart() {
        return this.roleOverColorStart;
    }

    public void setRoleOverColorStart(Color roleOverColorStart) {
        this.roleOverColorStart = roleOverColorStart;
    }

    public Color getRoleOverColorEnd() {
        return this.roleOverColorEnd;
    }

    public void setRoleOverColorEnd(Color roleOverColorEnd) {
        this.roleOverColorEnd = roleOverColorEnd;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public int getSearchingColumn() {
        return this.serachingColumn;
    }

    public void setSearchingColumn(int serachingColumn) {
        this.serachingColumn = serachingColumn;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.rowNo = -1;
        this.table.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int row = this.table.rowAtPoint(e.getPoint());
        if (row != this.rowNo) {
            this.rowNo = row;
            this.table.repaint();
        }
    }
}

