/*
 * Decompiled with CFR 0.152.
 */
package common.gui.util;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.Timer;

public class InactivityListener
implements ActionListener,
AWTEventListener {
    public static final long KEY_EVENTS = 8L;
    public static final long MOUSE_EVENTS = 48L;
    public static final long USER_EVENTS = 56L;
    private Action action;
    private int interval;
    private long eventMask;
    private Timer timer = new Timer(0, this);

    public InactivityListener(Action action) {
        this(action, 1);
    }

    public InactivityListener(Action action, int interval) {
        this(action, interval, 56L);
    }

    public InactivityListener(Action action, int minutes, long eventMask) {
        this.setAction(action);
        this.setInterval(minutes);
        this.setEventMask(eventMask);
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public void setInterval(int minutes) {
        this.setIntervalInMillis(minutes * 1000 * 60);
    }

    public void setIntervalInMillis(int interval) {
        this.interval = interval;
        this.timer.setInitialDelay(interval);
    }

    public void setEventMask(long eventMask) {
        this.eventMask = eventMask;
    }

    public void start() {
        this.timer.setInitialDelay(this.interval);
        this.timer.setRepeats(false);
        this.timer.start();
        Toolkit.getDefaultToolkit().addAWTEventListener(this, this.eventMask);
    }

    public void stop() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        this.timer.stop();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.action.actionPerformed(e);
    }

    @Override
    public void eventDispatched(AWTEvent e) {
        if (this.timer.isRunning()) {
            this.timer.restart();
        }
    }
}

