/*
 * Decompiled with CFR 0.152.
 */
package common.gui.util;

import com.sun.awt.AWTUtilities;
import common.gui.util.ColorUtility;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class Util {
    private static DateFormat dateFormatAcc = new SimpleDateFormat("MMM dd, yyyy");
    private static NumberFormat numberFormat = NumberFormat.getInstance();
    private static NumberFormat decimalFormat = new DecimalFormat("###,###,###");
    private static NumberFormat decimalFormat2 = new DecimalFormat("#.##");
    private static NumberFormat decimalFormat4 = new DecimalFormat("#.####");
    private static final DecimalFormat PMEX_Digit_Format = new DecimalFormat("###,##0.00##");
    private static final DecimalFormat PMEX_4_Digit_Format = new DecimalFormat("###,##0.0000");
    private static final DecimalFormat PMEX_Digit_Format_AS_COME = new DecimalFormat("###,###.####");
    public static NumberFormat numberFormatInMillion = NumberFormat.getInstance();
    public static String FileSeparator = File.separator;
    public static String LineSeparator = System.getProperty("line.separator");

    public static String format2digit(String number) {
        String num;
        block11: {
            num = "";
            if (number.equalsIgnoreCase("NaN")) {
                return "0.00";
            }
            try {
                number = number.replaceAll("\\,", "");
                num = decimalFormat2.format(Double.parseDouble(number.trim()));
                Double Vol = Double.parseDouble(num.toString());
                if (Double.isNaN(Vol)) {
                    Vol = 0.0;
                }
                if ((num = numberFormat.format(Vol)).indexOf(".") >= 0) {
                    String[] t = num.split("\\.", -1);
                    if (t[1].length() == 0) {
                        num = t[0] + ".00";
                    } else if (t[1].length() == 1) {
                        num = t[0] + "." + t[1] + "0";
                    } else {
                        if (t[1].length() == 2) {
                            return num;
                        }
                        num = number;
                    }
                    break block11;
                }
                return num + ".00";
            }
            catch (Exception ex) {
                return number;
            }
        }
        if (num.equalsIgnoreCase("NaN")) {
            num = "0.00";
        }
        return num;
    }

    public static String format4digit(String number) {
        String num;
        block14: {
            num = "";
            if (number.equalsIgnoreCase("NaN")) {
                return "0.0000";
            }
            try {
                number = number.replaceAll("\\,", "");
                num = decimalFormat4.format(Double.parseDouble(number.trim()));
                Double Vol = Double.parseDouble(num.toString());
                if (Double.isNaN(Vol)) {
                    Vol = 0.0;
                }
                if ((num = numberFormat.format(Vol)).indexOf(".") >= 0) {
                    String[] t = num.split("\\.", -1);
                    if (t[1].length() == 0) {
                        num = t[0] + ".0000";
                    } else if (t[1].length() == 1) {
                        num = t[0] + "." + t[1] + "000";
                    } else if (t[1].length() == 2) {
                        num = t[0] + "." + t[1] + "00";
                    } else if (t[1].length() == 3) {
                        num = t[0] + "." + t[1] + "0";
                    } else {
                        if (t[1].length() == 4) {
                            return num;
                        }
                        num = number;
                    }
                    break block14;
                }
                return num + ".0000";
            }
            catch (Exception ex) {
                return number;
            }
        }
        return num;
    }

    public static String format0digit(String number) {
        String num = "";
        if (number.equalsIgnoreCase("NaN")) {
            return "0";
        }
        try {
            number = number.replaceAll("\\,", "");
            Double number2 = Double.parseDouble(number);
            num = decimalFormat.format(number2);
        }
        catch (Exception ex) {
            return number;
        }
        return num;
    }

    public static String formatPMEX(String value) {
        try {
            if (value.equalsIgnoreCase("NaN")) {
                return "0.00";
            }
            double d = Double.parseDouble(value.trim());
            return PMEX_Digit_Format.format(d);
        }
        catch (Exception ex) {
            System.out.println("formatPMEX exception on = " + value);
            return value + "";
        }
    }

    public static String format4PMEX(String value) {
        try {
            if (value.equalsIgnoreCase("NaN")) {
                return "0.0000";
            }
            double d = Double.parseDouble(value.trim());
            return PMEX_4_Digit_Format.format(d);
        }
        catch (Exception ex) {
            System.out.println("format4PMEX  exception on = " + value);
            return value + "";
        }
    }

    public static String formatPMEXAsCome(String value) {
        try {
            double d = Double.parseDouble(value.trim());
            return PMEX_Digit_Format_AS_COME.format(d);
        }
        catch (Exception ex) {
            System.out.println("formatPMEXAsCome exception on = " + value);
            return value + "";
        }
    }

    public static String formatDate(Date date) {
        if (date != null) {
            return dateFormatAcc.format(date);
        }
        return "";
    }

    public static synchronized void setMessage(JLabel lblMessage, MessageType type, String text) {
        lblMessage.setIcon(null);
        lblMessage.setText("");
        lblMessage.setForeground(Color.BLACK);
        if (text.lastIndexOf(".") != text.length() - 1) {
            text = text + ".";
        }
        if (type == MessageType.Information) {
            lblMessage.setIcon(Util.icon("/common/gui/images/info.png"));
            lblMessage.setText(text);
            lblMessage.setForeground(ColorUtility.informationFG);
        } else if (type == MessageType.Warring) {
            lblMessage.setIcon(Util.icon("/common/gui/images/warrning.png"));
            lblMessage.setText(text);
            lblMessage.setForeground(ColorUtility.warrningFG);
        } else if (type == MessageType.Sussess) {
            lblMessage.setIcon(Util.icon("/common/gui/images/success.png"));
            lblMessage.setText(text);
            lblMessage.setForeground(ColorUtility.successFG);
        } else if (type == MessageType.Error) {
            lblMessage.setIcon(Util.icon("/common/gui/images/error.png"));
            lblMessage.setText(text);
            lblMessage.setForeground(ColorUtility.errorFG);
        } else if (type == MessageType.EMPTY) {
            lblMessage.setIcon(null);
            lblMessage.setText("");
            lblMessage.setForeground(Color.BLACK);
        } else if (type == MessageType.Loading) {
            lblMessage.setIcon(Util.icon("/common/gui/images/loader.gif"));
            lblMessage.setText(text);
            lblMessage.setForeground(Color.BLACK);
        } else if (type == MessageType.Normal) {
            lblMessage.setIcon(null);
            lblMessage.setText(text);
            lblMessage.setForeground(Color.BLACK);
        }
    }

    private static Icon icon(String path) {
        URL resource = Util.class.getResource(path);
        if (resource == null) {
            return new ImageIcon();
        }
        return new ImageIcon(resource);
    }

    public static void removeRowsTable(DefaultTableModel model) {
        int numrows = model.getRowCount();
        for (int i = 0; i < numrows; ++i) {
            model.removeRow(0);
        }
    }

    public static void setScrollbarHeightInCenter(final JScrollPane scrollPane) {
        scrollPane.revalidate();
        scrollPane.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Dimension portSize = scrollPane.getViewport().getSize();
                Dimension viewSize = scrollPane.getViewport().getView().getSize();
                Rectangle rect = new Rectangle(0, (viewSize.height - portSize.height) / 2, portSize.width, portSize.height);
                scrollPane.getViewport().scrollRectToVisible(rect);
                scrollPane.repaint();
            }
        });
    }

    public static void setScrollbarWidthInCenter(final JScrollPane scrollPane) {
        scrollPane.revalidate();
        scrollPane.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Dimension portSize = scrollPane.getViewport().getSize();
                Dimension viewSize = scrollPane.getViewport().getView().getSize();
                Rectangle rect = new Rectangle((viewSize.width - portSize.width) / 2, 0, portSize.width, portSize.height);
                scrollPane.getViewport().scrollRectToVisible(rect);
                scrollPane.repaint();
            }
        });
    }

    public static void setScrollbarInCenterBothSide(final JScrollPane scrollPane) {
        scrollPane.revalidate();
        scrollPane.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Dimension portSize = scrollPane.getViewport().getSize();
                Dimension viewSize = scrollPane.getViewport().getView().getSize();
                Rectangle rect = new Rectangle((viewSize.width - portSize.width) / 2, (viewSize.height - portSize.height) / 2, portSize.width, portSize.height);
                scrollPane.getViewport().scrollRectToVisible(rect);
                scrollPane.repaint();
            }
        });
    }

    public static void ScrollToFirstOrLastRow(final boolean isFirst, final JTable table, final JScrollPane scrollPane) {
        if (SwingUtilities.isEventDispatchThread()) {
            Util.ScrollToFirstOrLastRow2(isFirst, table, scrollPane);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Util.ScrollToFirstOrLastRow2(isFirst, table, scrollPane);
                }
            });
        }
    }

    private static void ScrollToFirstOrLastRow2(boolean isFirst, JTable table, JScrollPane scrollPane) {
        JScrollBar verticalScrollBar = scrollPane.getVerticalScrollBar();
        if (isFirst) {
            verticalScrollBar.setValue(verticalScrollBar.getMinimum());
        } else {
            verticalScrollBar.setValue(verticalScrollBar.getMaximum());
            Rectangle rect = table.getCellRect(table.getModel().getRowCount() - 1, 0, true);
            table.scrollRectToVisible(rect);
        }
    }

    public static void ScrollToFirstOrLastRow(final boolean isFirst, final JPanel panel, final JScrollPane scrollPane) {
        if (SwingUtilities.isEventDispatchThread()) {
            Util.ScrollToFirstOrLastRow2(isFirst, panel, scrollPane);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Util.ScrollToFirstOrLastRow2(isFirst, panel, scrollPane);
                }
            });
        }
    }

    private static void ScrollToFirstOrLastRow2(boolean isFirst, JPanel panel, JScrollPane scrollPane) {
        JScrollBar verticalScrollBar = scrollPane.getVerticalScrollBar();
        if (isFirst) {
            verticalScrollBar.setValue(verticalScrollBar.getMinimum());
        } else {
            Rectangle rect = panel.getVisibleRect();
            panel.scrollRectToVisible(rect);
            JScrollBar sb = scrollPane.getVerticalScrollBar();
            sb.setValue(sb.getMaximum());
            scrollPane.repaint();
        }
    }

    public static BufferedImage createTranslucentImage(int width, int height) {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(width, height, 3);
    }

    public static Color deriveColorHSB(Color base, float dH, float dS, float dB) {
        float[] hsb = Color.RGBtoHSB(base.getRed(), base.getGreen(), base.getBlue(), null);
        hsb[0] = hsb[0] + dH;
        hsb[1] = hsb[1] + dS;
        hsb[2] = hsb[2] + dB;
        return Color.getHSBColor(hsb[0] < 0.0f ? 0.0f : (hsb[0] > 1.0f ? 1.0f : hsb[0]), hsb[1] < 0.0f ? 0.0f : (hsb[1] > 1.0f ? 1.0f : hsb[1]), hsb[2] < 0.0f ? 0.0f : (hsb[2] > 1.0f ? 1.0f : hsb[2]));
    }

    public static String inMillion(long volume) {
        BigDecimal div = BigDecimal.valueOf(1000000L);
        BigDecimal a = BigDecimal.valueOf(volume);
        a = a.divide(div);
        String formattedNr = numberFormatInMillion.format(a) + "m";
        return formattedNr;
    }

    public static String inMilliondigits(double volume) {
        BigDecimal div = BigDecimal.valueOf(1000000L);
        BigDecimal a = BigDecimal.valueOf(volume);
        a = a.divide(div);
        String formattedNr = numberFormatInMillion.format(a) + "m";
        return formattedNr;
    }

    public static boolean isPageExists(String URLName) throws MalformedURLException, IOException {
        HttpURLConnection.setFollowRedirects(false);
        HttpURLConnection con = (HttpURLConnection)new URL(URLName).openConnection();
        con.setReadTimeout(15000);
        con.setRequestMethod("HEAD");
        return con.getResponseCode() == 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean FileDownload(String url, String path) {
        boolean status = false;
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new URL(url).openStream());
            FileOutputStream fos = new FileOutputStream(path);
            BufferedOutputStream bout = new BufferedOutputStream(fos, 1024);
            byte[] data = new byte[1024];
            int x = 0;
            while ((x = in.read(data, 0, 1024)) >= 0) {
                bout.write(data, 0, x);
            }
            bout.close();
            in.close();
            status = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return status;
    }

    public static String getClipboard() {
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        try {
            if (t != null && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String text = (String)t.getTransferData(DataFlavor.stringFlavor);
                return text;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static void setClipboard(String str) {
        StringSelection ss = new StringSelection(str);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
    }

    public static void PlayBeep() {
        if (LogCommon.PlayBeep) {
            try {
                Toolkit.getDefaultToolkit().beep();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String MakeSingleCharacterVoice(String s) {
        char[] a = s.toCharArray();
        String ret = "";
        for (int i = 0; i < a.length; ++i) {
            ret = ret + a[i] + " ";
        }
        return ret;
    }

    public static void deleteLogFiles(File folder, String fileName) {
        try {
            String strDateFormat = "MMM dd yyyy";
            SimpleDateFormat sdf = new SimpleDateFormat(strDateFormat);
            Date dd = Util.addSubtractDaysFormDate(new Date(System.currentTimeMillis()), -30);
            File[] listOfFiles = folder.listFiles();
            for (int i = 0; i < listOfFiles.length; ++i) {
                if (!listOfFiles[i].isFile()) continue;
                Date dt = new Date(listOfFiles[i].lastModified());
                String ext = listOfFiles[i].getName().substring(listOfFiles[i].getName().lastIndexOf(".") + 1);
                if (!ext.equalsIgnoreCase("txt") || dd.compareTo(dt) != 1) continue;
                System.out.println("File " + listOfFiles[i].getName() + " , " + dt + ", " + ext);
                listOfFiles[i].delete();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Date addSubtractDaysFormDate(Date date, int days) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(date);
        c1.add(5, days);
        return c1.getTime();
    }

    public static Date addSubtractMonthFormDate(Date date, int month) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(date);
        c1.add(2, month);
        return c1.getTime();
    }

    public static Date addSubtractYearFormDate(Date date, int year) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(date);
        c1.add(1, year);
        return c1.getTime();
    }

    public static Date getFirstDayOfWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(7, 2);
        return new Date(c.getTimeInMillis());
    }

    public static Date getFirstDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, Calendar.getInstance().getActualMinimum(5));
        return new Date(c.getTimeInMillis());
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, Calendar.getInstance().getActualMaximum(5));
        return new Date(c.getTimeInMillis());
    }

    public static boolean isWindow7() {
        String osName = System.getProperty("os.name");
        return osName.equalsIgnoreCase("Windows 7");
    }

    public static boolean isWindowXP() {
        String osName = System.getProperty("os.name");
        return osName.equalsIgnoreCase("Windows XP");
    }

    public static int getMacOSSpace() {
        if (Util.isMacOSX()) {
            return 10;
        }
        return 0;
    }

    public static boolean isMacOSX() {
        String osName = System.getProperty("os.name");
        return osName.startsWith("Mac");
    }

    public static boolean isLinux() {
        String osName = System.getProperty("os.name");
        return osName.equalsIgnoreCase("Linux");
    }

    public static void setWindowOpaque(Window win, boolean isOpaque) {
        if (!Util.isLinux() && Util.getJavaVersion() < 1.9) {
            AWTUtilities.setWindowOpaque((Window)win, (boolean)isOpaque);
        }
    }

    public static double getJavaVersion() {
        String javaVersion = System.getProperty("java.specification.version");
        double d = Double.parseDouble(javaVersion);
        return d;
    }

    public static boolean isValidEmailAddress(String email) {
        boolean status = false;
        Pattern p = Pattern.compile(".+@.+\\.[a-z]+");
        Matcher m = p.matcher(email);
        boolean matchFound = m.matches();
        if (matchFound) {
            status = true;
        }
        return status;
    }

    public static String removeLeadingZeros(String str) {
        return str;
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return Util.isSameDay(cal1, cal2);
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        if (cal1 == null || cal2 == null) {
            return false;
        }
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    public static int getStringWidth(JLabel com) {
        try {
            if (!com.isVisible()) {
                return 0;
            }
            if (com.getText() == null) {
                return 0;
            }
            FontMetrics fm = com.getFontMetrics(com.getFont());
            return fm.stringWidth(com.getText());
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public static void setPropertiesForMAC() {
        Util.setUIFontValues("Button.font");
        Util.setUIFontValues("CheckBox.font");
        Util.setUIFontValues("CheckBoxMenuItem.acceleratorFont");
        Util.setUIFontValues("CheckBoxMenuItem.font");
        Util.setUIFontValues("ColorChooser.font");
        Util.setUIFontValues("ComboBox.font");
        Util.setUIFontValues("EditorPane.font");
        Util.setUIFontValues("FileChooser.listFont");
        Util.setUIFontValues("FormattedTextField.font");
        Util.setUIFontValues("Label.font");
        Util.setUIFontValues("List.font");
        Util.setUIFontValues("Menu.acceleratorFont");
        Util.setUIFontValues("Menu.font");
        Util.setUIFontValues("MenuBar.font");
        Util.setUIFontValues("MenuItem.acceleratorFont");
        Util.setUIFontValues("MenuItem.font");
        Util.setUIFontValues("OptionPane.buttonFont");
        Util.setUIFontValues("Panel.font");
        Util.setUIFontValues("PasswordField.font");
        Util.setUIFontValues("PopupMenu.font");
        Util.setUIFontValues("RadioButton.font");
        Util.setUIFontValues("ProgressBar.font");
        Util.setUIFontValues("RadioButtonMenuItem.acceleratorFont");
        Util.setUIFontValues("RadioButtonMenuItem.font");
        Util.setUIFontValues("ScrollPane.font");
        Util.setUIFontValues("Slider.font");
        Util.setUIFontValues("Spinner.font");
        Util.setUIFontValues("TabbedPane.font");
        Util.setUIFontValues("Table.font");
        Util.setUIFontValues("TableHeader.font");
        Util.setUIFontValues("TextArea.font");
        Util.setUIFontValues("TextField.font");
        Util.setUIFontValues("TextPane.font");
        Util.setUIFontValues("TitledBorder.font");
        Util.setUIFontValues("ToggleButton.font");
        Util.setUIFontValues("ToolBar.font");
        Util.setUIFontValues("ToolTip.font");
        Util.setUIFontValues("Tree.font");
        Util.setUIFontValues("Viewport.font");
    }

    private static void setUIFontValues(String string) {
        Object obj = UIManager.get(string);
        if (obj != null && obj instanceof Font) {
            Font f = (Font)obj;
            UIManager.put(string, new Font(f.getName(), 0, 11));
        }
    }

    public static boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isDouble(String value) {
        try {
            Double.parseDouble(value);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static Color convertToColor(String s, Color _default) {
        Color c;
        int i = 0;
        int j = 0;
        String h = "0123456789abcdef";
        int[] hex = new int[6];
        if (s != null && s.length() == 7) {
            for (i = 0; i < 6; ++i) {
                for (j = 0; j < 16; ++j) {
                    if (Character.toLowerCase(s.charAt(i + 1)) != h.charAt(j)) continue;
                    hex[i] = j;
                }
            }
            c = new Color(hex[0] * 16 + hex[1], hex[2] * 16 + hex[3], hex[4] * 16 + hex[5]);
        } else {
            c = _default;
        }
        return c;
    }

    public static double round(double value, int decimalPlace) {
        double power_of_ten = 1.0;
        while (decimalPlace-- > 0) {
            power_of_ten *= 10.0;
        }
        return (double)Math.round(value * power_of_ten) / power_of_ten;
    }

    public static String FormatedText(Number Num) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(true);
        return nf.format(Num);
    }

    public static String DateNow(String DateFormat2) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(DateFormat2);
        return sdf.format(cal.getTime());
    }

    public static boolean WriteTableIntoFile(JTable table, String filePath) throws IOException {
        OutputStreamWriter fileWriter = null;
        boolean status = false;
        try {
            StringBuilder fileContent = new StringBuilder();
            TableModel tModel = table.getModel();
            for (int i = 0; i < tModel.getRowCount(); ++i) {
                for (int j = 0; j < table.getColumnCount(); ++j) {
                    Object cellValue = tModel.getValueAt(i, j);
                    fileContent.append(cellValue);
                }
                fileContent.append(System.getProperty("line.separator"));
            }
            fileWriter = new FileWriter(new File(filePath));
            fileWriter.write(fileContent.toString());
            fileWriter.flush();
            fileWriter.close();
            status = true;
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            try {
                fileWriter.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return status;
    }

    public static String getUnicode(String str) {
        String result = "";
        for (char ch : str.toCharArray()) {
            result = result + "\\u" + Integer.toHexString(ch | 0x10000).substring(1);
        }
        return result;
    }

    static {
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).setDecimalSeparatorAlwaysShown(false);
        }
        decimalFormat2.setMinimumFractionDigits(2);
        decimalFormat2.setMaximumFractionDigits(2);
        decimalFormat2.setGroupingUsed(true);
        decimalFormat.setMinimumFractionDigits(0);
        decimalFormat.setMaximumFractionDigits(0);
        decimalFormat.setGroupingUsed(true);
        decimalFormat4.setMinimumFractionDigits(4);
        decimalFormat4.setMaximumFractionDigits(4);
        decimalFormat4.setGroupingUsed(true);
    }
}

