/*
 * Decompiled with CFR 0.152.
 */
package common.test;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.applet.AppletAudioClip;

public class RunAppletInFrame
extends Frame
implements Runnable,
AppletStub,
AppletContext {
    private String[] args = null;
    private static int instances = 0;
    private String name;
    private boolean barebones = false;
    private Applet applet;
    private Label label = null;
    private Dimension appletSize;
    private static final String PARAM_PROP_PREFIX = "parameter.";
    Map streamMap = new HashMap();

    public RunAppletInFrame(Applet applet, String[] args, int width, int height) {
        this.build(applet, args, width, height);
    }

    public RunAppletInFrame(Applet applet, String[] args) {
        this.build(applet, args, -1, -1);
    }

    public RunAppletInFrame(Applet applet, int width, int height) {
        this.build(applet, null, width, height);
    }

    private void build(Applet applet, String[] args, int width, int height) {
        String heightStr;
        String widthStr;
        ++instances;
        this.applet = applet;
        this.args = args;
        applet.setStub(this);
        this.name = applet.getClass().getName();
        this.setTitle(this.name);
        Properties props = System.getProperties();
        props.put("browser", "Acme.MainFrame");
        props.put("browser.version", "11jul96");
        props.put("browser.vendor", "Acme Laboratories");
        props.put("browser.vendor.url", "http://www.acme.com/");
        if (args != null) {
            RunAppletInFrame.parseArgs(args, props);
        }
        if ((widthStr = this.getParameter("width")) != null) {
            width = Integer.parseInt(widthStr);
        }
        if ((heightStr = this.getParameter("height")) != null) {
            height = Integer.parseInt(heightStr);
        }
        if (width == -1 || height == -1) {
            System.err.println("Width and height must be specified.");
            return;
        }
        String bonesStr = this.getParameter("barebones");
        if (bonesStr != null && bonesStr.equals("true")) {
            this.barebones = true;
        }
        if (!this.barebones) {
            MenuBar mb = new MenuBar();
            Menu m = new Menu("Applet");
            m.add(new MenuItem("Restart"));
            m.add(new MenuItem("Clone"));
            m.add(new MenuItem("Close"));
            m.add(new MenuItem("Quit"));
            mb.add(m);
            this.setMenuBar(mb);
        }
        this.setLayout(new BorderLayout());
        this.add("Center", applet);
        if (!this.barebones) {
            Panel borderPanel = new Panel();
            borderPanel.setLayout(new BorderLayout());
            this.label = new Label("");
            borderPanel.add("Center", this.label);
            this.add("South", borderPanel);
        }
        this.pack();
        this.validate();
        this.appletSize = applet.size();
        applet.resize(width, height);
        this.show();
        new Thread(this).start();
    }

    private static void parseArgs(String[] args, Properties props) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            int ind = arg.indexOf(61);
            if (ind == -1) {
                props.put(PARAM_PROP_PREFIX + arg.toLowerCase(), "");
                continue;
            }
            props.put(PARAM_PROP_PREFIX + arg.substring(0, ind).toLowerCase(), arg.substring(ind + 1));
        }
    }

    @Override
    public boolean handleEvent(Event evt) {
        switch (evt.id) {
            case 1001: {
                if (evt.arg.equals("Restart")) {
                    this.applet.stop();
                    this.applet.destroy();
                    Thread thread = new Thread(this);
                    thread.start();
                    break;
                }
                if (evt.arg.equals("Clone")) {
                    try {
                        new RunAppletInFrame((Applet)this.applet.getClass().newInstance(), this.args, this.appletSize.width, this.appletSize.height);
                    }
                    catch (IllegalAccessException e) {
                        this.showStatus(e.getMessage());
                    }
                    catch (InstantiationException e) {
                        this.showStatus(e.getMessage());
                    }
                    break;
                }
                if (evt.arg.equals("Close")) {
                    this.setVisible(false);
                    this.remove(this.applet);
                    this.applet.stop();
                    this.applet.destroy();
                    if (this.label != null) {
                        this.remove(this.label);
                    }
                    this.dispose();
                    if (--instances != 0) break;
                    System.exit(0);
                    break;
                }
                if (!evt.arg.equals("Quit")) break;
                System.exit(0);
                break;
            }
            case 201: {
                System.exit(0);
            }
        }
        return super.handleEvent(evt);
    }

    @Override
    public void run() {
        this.showStatus(this.name + " initializing...");
        this.applet.init();
        this.validate();
        this.showStatus(this.name + " starting...");
        this.applet.start();
        this.validate();
        this.showStatus(this.name + " running...");
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public URL getDocumentBase() {
        String dir = System.getProperty("user.dir");
        String urlDir = dir.replace(File.separatorChar, '/');
        try {
            return new URL("file:" + urlDir + "/");
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public URL getCodeBase() {
        String path = System.getProperty("java.class.path");
        StringTokenizer st = new StringTokenizer(path, ":");
        while (st.hasMoreElements()) {
            String dir = (String)st.nextElement();
            String filename = dir + File.separatorChar + this.name + ".class";
            File file = new File(filename);
            if (!file.exists()) continue;
            String urlDir = dir.replace(File.separatorChar, '/');
            try {
                return new URL("file:" + urlDir + "/");
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getParameter(String name) {
        return System.getProperty(PARAM_PROP_PREFIX + name.toLowerCase());
    }

    @Override
    public void appletResize(int width, int height) {
        Dimension frameSize = this.size();
        frameSize.width += width - this.appletSize.width;
        frameSize.height += height - this.appletSize.height;
        this.resize(frameSize);
        this.appletSize = this.applet.size();
    }

    @Override
    public AppletContext getAppletContext() {
        return this;
    }

    @Override
    public AudioClip getAudioClip(URL url) {
        return new AppletAudioClip(url);
    }

    @Override
    public Image getImage(URL url) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        try {
            ImageProducer prod = (ImageProducer)url.getContent();
            return tk.createImage(prod);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public Applet getApplet(String name) {
        if (name.equals(this.name)) {
            return this.applet;
        }
        return null;
    }

    public Enumeration getApplets() {
        Vector<Applet> v = new Vector<Applet>();
        v.addElement(this.applet);
        return v.elements();
    }

    @Override
    public void showDocument(URL url) {
    }

    @Override
    public void showDocument(URL url, String target) {
    }

    @Override
    public void showStatus(String status) {
        if (this.label != null) {
            this.label.setText(status);
        }
    }

    @Override
    public void setStream(String key, InputStream stream) throws IOException {
        this.streamMap.put(key, stream);
    }

    @Override
    public InputStream getStream(String key) {
        return (InputStream)this.streamMap.get(key);
    }

    public Iterator getStreamKeys() {
        return this.streamMap.keySet().iterator();
    }

    public static void main(String[] arg) {
        try {
            Applet app = (Applet)new URLClassLoader(new URL[]{new File("D:\\TradeCastVersion\\wizard.jar").toURI().toURL()}).loadClass("com.ve.kavachart.editor.ChartWizardApplet").newInstance();
            RunAppletInFrame runAppletInFrame = new RunAppletInFrame(app, 100, 200);
        }
        catch (Exception ex) {
            Logger.getLogger(RunAppletInFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

