/*
 * Decompiled with CFR 0.152.
 */
package kse.gui.render;

import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import kse.gui.bean.StrategyOrderDetailsBean;

public class StrategyOrderDetailsRender
extends DefaultTableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel cell = new JLabel();
        cell.setHorizontalAlignment(2);
        cell.setOpaque(true);
        String transType = "";
        String colName = table.getColumnName(column);
        if (value == null) {
            value = "";
        }
        StrategyOrderDetailsBean b = null;
        if (value instanceof StrategyOrderDetailsBean) {
            b = (StrategyOrderDetailsBean)value;
            transType = b.getType();
            if (b.getType().indexOf("SEL") >= 0) {
                b.setType("SELL");
            }
            if (colName.equalsIgnoreCase("Market")) {
                cell.setText(" " + b.getMarket());
            } else if (colName.equalsIgnoreCase("Scrip")) {
                cell.setText(" " + b.getScrip());
            } else if (colName.equalsIgnoreCase("Volume")) {
                cell.setText(Util.format0digit((String)(b.getVolume() + "")) + " ");
                cell.setHorizontalAlignment(4);
            } else if (colName.equalsIgnoreCase("Price")) {
                cell.setText(Util.format2digit((String)(b.getPrice() + "")) + " ");
                cell.setHorizontalAlignment(4);
            } else if (colName.equalsIgnoreCase("Type")) {
                cell.setText(" " + b.getType());
            } else if (colName.equalsIgnoreCase("Account")) {
                cell.setText(" " + b.getAccount());
            } else if (colName.equalsIgnoreCase("Client Order No")) {
                cell.setText(" " + b.getClientOrderID());
            } else if (colName.equalsIgnoreCase("Order No")) {
                cell.setText(" " + b.getOrderNo());
            } else if (colName.equalsIgnoreCase("Time")) {
                cell.setText(" " + b.getTime());
            }
        }
        if (transType.equalsIgnoreCase("SELL")) {
            cell.setBackground(MyColors.tradeLogSellBG);
            cell.setForeground(MyColors.tradeLogSellFG);
        } else if (transType.equalsIgnoreCase("BUY")) {
            cell.setBackground(MyColors.tradeLogBuyBG);
            cell.setForeground(MyColors.tradeLogBuyFG);
        }
        return cell;
    }
}

