/*
 * Decompiled with CFR 0.152.
 */
package kse.gui.render;

import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import kse.gui.bean.StrategyOrderBean;

public class StrategyOrderRender
extends DefaultTableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel cell = new JLabel();
        cell.setHorizontalAlignment(2);
        cell.setOpaque(true);
        String transType = "";
        String colName = table.getColumnName(column);
        if (value == null) {
            value = "";
        }
        StrategyOrderBean b = null;
        if (value instanceof StrategyOrderBean) {
            b = (StrategyOrderBean)value;
            transType = b.getType();
            if (b.getType().indexOf("SEL") >= 0) {
                b.setType("SELL");
            }
            if (colName.equalsIgnoreCase("ID")) {
                cell.setText(" " + b.getId());
                cell.setHorizontalAlignment(0);
            } else if (colName.equalsIgnoreCase("Market")) {
                cell.setText(" " + b.getMarket());
            } else if (colName.equalsIgnoreCase("Scrip")) {
                cell.setText(" " + b.getScrip());
            } else if (colName.equalsIgnoreCase("Volume")) {
                cell.setText(Util.format0digit((String)(b.getVolume() + "")) + " ");
                cell.setHorizontalAlignment(4);
            } else if (colName.equalsIgnoreCase("Price")) {
                cell.setText(Util.format2digit((String)(b.getPrice() + "")) + " ");
                cell.setHorizontalAlignment(4);
            } else if (colName.equalsIgnoreCase("Type")) {
                cell.setText(" " + b.getType());
            } else if (colName.equalsIgnoreCase("Account")) {
                cell.setText(" " + b.getAccount());
            } else if (colName.equalsIgnoreCase("Client Order ID")) {
                cell.setText(" " + b.getClientOrderID());
            } else if (colName.equalsIgnoreCase("Cancel Request")) {
                cell.setText(" " + b.isCancelRequest());
            } else if (colName.equalsIgnoreCase("Replace Request")) {
                cell.setText(" " + b.isReplaceRequest());
            } else if (colName.equalsIgnoreCase("Traded Volume")) {
                cell.setText(Util.format0digit((String)(b.getTradedVolume() + "")) + " ");
                cell.setHorizontalAlignment(4);
            } else if (colName.equalsIgnoreCase("Average Price")) {
                cell.setText(Util.format2digit((String)(b.getAveragePrice() + "")) + " ");
                cell.setHorizontalAlignment(4);
            } else if (colName.equalsIgnoreCase("Details")) {
                cell.setText("<HTMl><U>Details</U></HTML>");
                cell.setHorizontalAlignment(0);
                cell.setForeground(MyColors.ForgotPincodeFG);
                cell.setFont(cell.getFont().deriveFont(1));
                cell.setHorizontalAlignment(0);
            }
        }
        if (transType.equalsIgnoreCase("SELL")) {
            cell.setBackground(MyColors.tradeLogSellBG);
            cell.setForeground(MyColors.tradeLogSellFG);
        } else if (transType.equalsIgnoreCase("BUY")) {
            cell.setBackground(MyColors.tradeLogBuyBG);
            cell.setForeground(MyColors.tradeLogBuyFG);
        }
        if (b.isCancelRequest()) {
            cell.setForeground(Color.WHITE);
            cell.setBackground(new Color(240, 70, 79));
        }
        if (b.isReplaceRequest()) {
            cell.setForeground(Color.WHITE);
            cell.setBackground(MyColors.orange);
        }
        return cell;
    }
}

