/*
 * Decompiled with CFR 0.152.
 */
package kse.gui.render;

import common.gui.util.LogCommon;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import kse.gui.bean.TradeOutLogBean;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class TradeOutLogRender
extends DefaultTableCellRenderer {
    private LanguageCentre languageCentre = new LanguageCentre();
    private Color sellTotal = new Color(153, 128, 54);
    private Color buyTotal = new Color(18, 117, 166);

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel cell = new JLabel();
        cell.setFont(LogCommon.LogFont);
        cell.setOpaque(true);
        String transType = "";
        String order_Type = "";
        String colName = table.getColumnName(column);
        if (value == null) {
            value = "";
        }
        if (value instanceof TradeOutLogBean) {
            TradeOutLogBean b = (TradeOutLogBean)value;
            transType = b.getType();
            order_Type = b.getOrder_Type();
            if (colName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Trader))) {
                if (b.getAccount().equalsIgnoreCase("Total") || b.getAccount().equalsIgnoreCase("Gr. Total") || b.getAccount().equalsIgnoreCase("G.Total")) {
                    cell.setBackground(MyColors.TotalBG);
                } else {
                    cell.setText(" " + b.getTrader());
                    cell.setHorizontalAlignment(2);
                }
            } else if (colName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Market))) {
                if (b.getAccount().equalsIgnoreCase("Total") || b.getAccount().equalsIgnoreCase("Gr. Total") || b.getAccount().equalsIgnoreCase("G.Total")) {
                    cell.setText(" " + b.getAccount());
                    cell.setFont(cell.getFont().deriveFont(1));
                    cell.setBackground(MyColors.TotalBG);
                } else {
                    cell.setText(" " + b.getMarket());
                    cell.setHorizontalAlignment(2);
                }
            } else if (colName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Scrip))) {
                if (b.getAccount().equalsIgnoreCase("Total") || b.getAccount().equalsIgnoreCase("Gr. Total") || b.getAccount().equalsIgnoreCase("G.Total")) {
                    cell.setBackground(MyColors.TotalBG);
                } else {
                    cell.setText(" " + b.getScrip());
                    cell.setHorizontalAlignment(2);
                }
            } else if (colName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Time))) {
                if (b.getAccount().equalsIgnoreCase("Total") || b.getAccount().equalsIgnoreCase("Gr. Total") || b.getAccount().equalsIgnoreCase("G.Total")) {
                    cell.setBackground(MyColors.TotalBG);
                } else {
                    cell.setText(" " + b.getTime());
                    cell.setHorizontalAlignment(2);
                }
            } else if (colName.equalsIgnoreCase(this.languageCentre.getValue("Counter"))) {
                if (b.getAccount().equalsIgnoreCase("Total")) {
                    cell.setText(Util.format2digit((String)(b.getAverageSell() + "")) + " ");
                    cell.setHorizontalAlignment(4);
                    cell.setForeground(this.sellTotal);
                    cell.setFont(cell.getFont().deriveFont(1));
                    cell.setBackground(MyColors.TotalBG);
                } else if (b.getAccount().equalsIgnoreCase("Gr. Total")) {
                    cell.setText("");
                    cell.setHorizontalAlignment(4);
                    cell.setForeground(this.sellTotal);
                    cell.setFont(cell.getFont().deriveFont(1));
                    cell.setBackground(MyColors.TotalBG);
                } else if (b.getAccount().equalsIgnoreCase("G.Total")) {
                    cell.setText(Util.format2digit((String)(b.getAverageSell() + "")) + " ");
                    cell.setHorizontalAlignment(4);
                    cell.setForeground(this.sellTotal);
                    cell.setFont(cell.getFont().deriveFont(1));
                    cell.setBackground(MyColors.TotalBG);
                } else {
                    cell.setText(b.getCounter() + " ");
                    cell.setHorizontalAlignment(4);
                }
            } else if (colName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.OrderNo))) {
                if (b.getAccount().equalsIgnoreCase("Total") || b.getAccount().equalsIgnoreCase("Gr. Total")) {
                    cell.setText(Util.format0digit((String)(b.getTotalFillSell() + "")) + " ");
                    cell.setHorizontalAlignment(4);
                    cell.setForeground(this.sellTotal);
                    cell.setFont(cell.getFont().deriveFont(1));
                    cell.setBackground(MyColors.TotalBG);
                } else if (b.getAccount().equalsIgnoreCase("G.Total")) {
                    cell.setText(Util.format0digit((String)(b.getTotalFillSell() + "")) + " ");
                    cell.setHorizontalAlignment(4);
                    cell.setForeground(this.sellTotal);
                    cell.setFont(cell.getFont().deriveFont(1));
                    cell.setBackground(MyColors.TotalBG);
                } else {
                    cell.setText(b.getOrderNo() + " ");
                    cell.setHorizontalAlignment(4);
                }
            } else if (colName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Type))) {
                if (b.getAccount().equalsIgnoreCase("Total") || b.getAccount().equalsIgnoreCase("Gr. Total") || b.getAccount().equalsIgnoreCase("G.Total")) {
                    cell.setText(Util.format2digit((String)(b.getTotolAmountSell() + "")) + " ");
                    cell.setHorizontalAlignment(4);
                    cell.setForeground(this.sellTotal);
                    cell.setFont(cell.getFont().deriveFont(1));
                    cell.setBackground(MyColors.TotalBG);
                } else {
                    cell.setText(" " + b.getType());
                    cell.setHorizontalAlignment(2);
                }
            } else if (colName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.FillVolume))) {
                if (b.getAccount().equalsIgnoreCase("Total") || b.getAccount().equalsIgnoreCase("Gr. Total") || b.getAccount().equalsIgnoreCase("G.Total")) {
                    cell.setBackground(MyColors.TotalBG);
                } else {
                    cell.setText(Util.format0digit((String)(b.getFillVolume() + "")) + " ");
                    cell.setHorizontalAlignment(4);
                }
            } else if (colName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Price))) {
                if (b.getAccount().equalsIgnoreCase("Total")) {
                    cell.setText(Util.format2digit((String)(b.getAverageBuy() + "")) + " ");
                    cell.setHorizontalAlignment(4);
                    cell.setForeground(this.buyTotal);
                    cell.setFont(cell.getFont().deriveFont(1));
                    cell.setBackground(MyColors.TotalBG);
                } else if (b.getAccount().equalsIgnoreCase("Gr. Total")) {
                    cell.setText("");
                    cell.setHorizontalAlignment(4);
                    cell.setForeground(this.buyTotal);
                    cell.setFont(cell.getFont().deriveFont(1));
                    cell.setBackground(MyColors.TotalBG);
                } else if (b.getAccount().equalsIgnoreCase("G.Total")) {
                    cell.setText(Util.format2digit((String)(b.getAverageBuy() + "")) + " ");
                    cell.setHorizontalAlignment(4);
                    cell.setForeground(this.buyTotal);
                    cell.setFont(cell.getFont().deriveFont(1));
                    cell.setBackground(MyColors.TotalBG);
                } else {
                    cell.setText(Util.formatPMEX((String)(b.getPrice() + "")) + " ");
                    cell.setHorizontalAlignment(4);
                }
            } else if (colName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Ticket))) {
                if (b.getAccount().equalsIgnoreCase("Total") || b.getAccount().equalsIgnoreCase("Gr. Total") || b.getAccount().equalsIgnoreCase("G.Total")) {
                    cell.setText(Util.format0digit((String)(b.getTotalFillBuy() + "")) + " ");
                    cell.setHorizontalAlignment(4);
                    cell.setForeground(this.buyTotal);
                    cell.setFont(cell.getFont().deriveFont(1));
                    cell.setBackground(MyColors.TotalBG);
                } else {
                    cell.setText(b.getTicket() + " ");
                    cell.setHorizontalAlignment(4);
                }
            } else if (colName.equalsIgnoreCase(this.languageCentre.getValue("Account"))) {
                if (b.getAccount().equalsIgnoreCase("Total") || b.getAccount().equalsIgnoreCase("Gr. Total") || b.getAccount().equalsIgnoreCase("G.Total")) {
                    cell.setText(Util.formatPMEX((String)(b.getTotolAmountBuy() + "")) + " ");
                    cell.setHorizontalAlignment(4);
                    cell.setForeground(this.buyTotal);
                    cell.setFont(cell.getFont().deriveFont(1));
                    cell.setBackground(MyColors.TotalBG);
                } else {
                    cell.setText(" " + b.getAccount());
                    cell.setHorizontalAlignment(2);
                }
            } else if (colName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Action))) {
                if (b.getAccount().equalsIgnoreCase("Total") || b.getAccount().equalsIgnoreCase("Gr. Total") || b.getAccount().equalsIgnoreCase("G.Total")) {
                    cell.setText(" ");
                    cell.setBackground(MyColors.TotalBG);
                } else {
                    cell.setText(" " + b.getAction());
                    cell.setHorizontalAlignment(2);
                }
            } else if (colName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Flag))) {
                if (b.getAccount().equalsIgnoreCase("Total") || b.getAccount().equalsIgnoreCase("Gr. Total") || b.getAccount().equalsIgnoreCase("G.Total")) {
                    cell.setBackground(MyColors.TotalBG);
                } else {
                    cell.setText(" " + b.getFlag());
                    cell.setHorizontalAlignment(0);
                }
            } else if (colName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.TotalValue))) {
                if (b.getAccount().equalsIgnoreCase("Total") || b.getAccount().equalsIgnoreCase("Gr. Total")) {
                    cell.setBackground(MyColors.TotalBG);
                } else if (b.getAccount().equalsIgnoreCase("G.Total")) {
                    cell.setText(" ");
                    cell.setBackground(MyColors.TotalBG);
                } else {
                    cell.setText(Util.formatPMEX((String)(b.getTotalValue() + "")) + " ");
                    cell.setHorizontalAlignment(4);
                }
            } else if (colName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.TotalVolume))) {
                if (b.getAccount().equalsIgnoreCase("Total") || b.getAccount().equalsIgnoreCase("Gr. Total") || b.getAccount().equalsIgnoreCase("G.Total")) {
                    cell.setText(" ");
                    cell.setBackground(MyColors.TotalBG);
                } else {
                    cell.setText(Util.format0digit((String)(b.getTotalVolume() + "")) + " ");
                    cell.setHorizontalAlignment(4);
                }
            } else if (colName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Remaining))) {
                if (b.getAccount().equalsIgnoreCase("Total") || b.getAccount().equalsIgnoreCase("Gr. Total") || b.getAccount().equalsIgnoreCase("G.Total")) {
                    cell.setText(" ");
                    cell.setBackground(MyColors.TotalBG);
                } else {
                    cell.setText(Util.format0digit((String)(b.getRemaining() + "")) + " ");
                    cell.setHorizontalAlignment(4);
                }
            }
        }
        if (transType.equalsIgnoreCase("SELL")) {
            cell.setBackground(MyColors.tradeLogSellBG);
            cell.setForeground(MyColors.tradeLogSellFG);
        } else if (transType.equalsIgnoreCase("BUY")) {
            cell.setBackground(MyColors.tradeLogBuyBG);
            cell.setForeground(MyColors.tradeLogBuyFG);
        }
        if (order_Type.equalsIgnoreCase("SHS")) {
            cell.setForeground(MyColors.tradeLogSellFG.darker().darker().darker());
        }
        return cell;
    }
}

