/*
 * Decompiled with CFR 0.152.
 */
package kse.util;

import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class UtilKSE {
    static final boolean MC_DEBUG = false;
    static final boolean FC_DEBUG = false;
    public static final int Tradelog_Index_TRADER = 0;
    public static final int Tradelog_Index_SYMBOL = 1;
    public static final int Tradelog_Index_MKT = 2;
    public static final int Tradelog_Index_TIME = 3;
    public static final int Tradelog_Index_COUNTER = 4;
    public static final int Tradelog_Index_ORDERNO = 5;
    public static final int Tradelog_Index_TYPE = 6;
    public static final int Tradelog_Index_FILLVOLUME = 7;
    public static final int Tradelog_Index_PRICE = 8;
    public static final int Tradelog_Index_TICKET = 9;
    public static final int Tradelog_Index_ACCOUNT = 10;
    public static final int Tradelog_Index_ACTION = 11;
    public static final int Tradelog_Index_FLAG = 12;
    public static final int Tradelog_Index_TOTALVOLUME = 13;
    public static final int Tradelog_Index_TOTALVALUE = 14;
    public static final int Tradelog_Index_REMAINING = 15;
    public static final int Tradelog_Index_Order_Type = 16;
    public static final String[] Tradelog_Index_Type = new String[]{"STRING", "STRING", "STRING", "STRING", "DOUBLE", "DOUBLE", "STRING", "DOUBLE", "DOUBLE", "DOUBLE", "STRING", "STRING", "STRING", "STRING", "DOUBLE", "DOUBLE", "DOUBLE", "STRING"};
    public static int Activitylog_Index_Market_Code = 0;
    public static int Activitylog_Index_Symbol_Code = 1;
    public static int Activitylog_Index_OrderType = 2;
    public static int Activitylog_Index_Order_Action = 3;
    public static int Activitylog_Index_Volume_Traded = 4;
    public static int Activitylog_Index_Price = 5;
    public static int Activitylog_Index_Client_Order_No = 6;
    public static int Activitylog_Index_Client_Account_No = 7;
    public static int Activitylog_Index_Date = 8;
    public static int OpenPosition_Index_Market = 0;
    public static int OpenPosition_Index_SYMBOL = 1;
    public static int OpenPosition_Index_Volume = 2;
    public static int OpenPosition_Index_Price = 3;
    public static int OpenPosition_Index_Amount = 4;
    public static int OpenPosition_Index_MTMPrice = 5;
    public static int OpenPosition_Index_MTM = 6;
    public static int OpenPosition_Index_ProfitLoss = 7;
    public static int Collateral_Index_SYMBOL = 0;
    public static int Collateral_Index_Volume = 1;
    public static int Collateral_Index_MTM = 2;
    public static int Collateral_Index_HairCut = 3;
    public static int Collateral_Index_MarginizedValue = 4;
    public static int Collateral_Index_RegAmount = 5;
    public static int Collateral_Index_FutAmount = 6;
    public static String folderURL = System.getProperty("user.home") + System.getProperty("file.separator") + LogCommon.UserID + System.getProperty("file.separator") + "flexdock" + System.getProperty("file.separator") + "perspectives";
    public static NumberFormat numberFormat = NumberFormat.getInstance();
    public static NumberFormat numberFormatInMillion = NumberFormat.getInstance();
    public static Toolkit kit = Toolkit.getDefaultToolkit();
    static HashMap<String, Long> LateOrderMap = new HashMap();
    public static HashMap<String, String> MonthName = new HashMap();
    public static TrayIcon trayIcon = null;

    public UtilKSE() {
        System.err.println("CATALYSTKSE v3.4.2");
    }

    public static String GetMarketFromsymbol(String Symbol_) {
        Symbol_ = Symbol_.toUpperCase();
        String[] MarketMonth = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
        String[] SIF_Scrip = new String[]{"KSE100", "KSE30", "KMI30", "ALLSHR"};
        String Market = "REG";
        if (Symbol_.indexOf("-") > 1) {
            String[] SymbilWithMarket = Symbol_.split("\\-", -1);
            if (SymbilWithMarket[1].equalsIgnoreCase("PRO")) {
                Market = "IPO";
            } else {
                for (int i = 0; i < MarketMonth.length; ++i) {
                    if (SymbilWithMarket[1].indexOf(MarketMonth[i]) < 0) continue;
                    for (int j = 0; j < SIF_Scrip.length; ++j) {
                        if (!SIF_Scrip[j].equals(SymbilWithMarket[0])) continue;
                        Market = "SIF";
                        break;
                    }
                    if (Market.equals("SIF")) break;
                    Market = "FUT";
                    break;
                }
            }
        }
        return Market;
    }

    public static void copyFile(String client, String server) {
        try {
            if (!UtilKSE.readFile(client)) {
                int c;
                File inputFile = new File(client);
                URL copyurl = new URL(server);
                InputStream outputFile = copyurl.openStream();
                FileOutputStream out = new FileOutputStream(inputFile);
                while ((c = outputFile.read()) != -1) {
                    out.write(c);
                }
                outputFile.close();
                out.flush();
                out.close();
                UtilKSE.makeFile(client);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean readFile(String path) {
        boolean status = false;
        File file = new File(path);
        file.setWritable(true);
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        try {
            fis = new FileInputStream(file);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            if (dis.available() != 0) {
                return true;
            }
            fis.close();
            bis.close();
            dis.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return status;
    }

    public static void saveWindowPositions(Hashtable ht) {
        String filename = AppConfig.userDocuments + AppConfig.houseName;
        File f = new File(filename);
        f.mkdirs();
        filename = AppConfig.userDocuments + AppConfig.houseName + "\\" + LogCommon.UserID + "\\Layout1.cat";
        try {
            ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream(filename));
            output.writeObject(ht);
            output.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static Hashtable getWindowPositions() {
        String filename = System.getProperty("user.home") + "\\TradeCast\\" + AppConfig.houseName + "\\" + LogCommon.UserID;
        File f = new File(filename);
        f.mkdirs();
        filename = System.getProperty("user.home") + "\\TradeCast\\" + AppConfig.houseName + "\\" + LogCommon.UserID + "\\Layout1.cat";
        Hashtable ht = null;
        try {
            if (f.exists()) {
                ObjectInputStream input = new ObjectInputStream(new FileInputStream(filename));
                ht = (Hashtable)input.readObject();
                input.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ht;
    }

    public static Dimension getScreenDimension() {
        return kit.getScreenSize();
    }

    public static void makeFile2(String fileName) {
        if (!UtilKSE.readFile(fileName)) {
            FileWriter file1 = null;
            try {
                file1 = new FileWriter(fileName);
                BufferedWriter out = new BufferedWriter(file1);
                out.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    file1.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeFile(String path) {
        if (!UtilKSE.readFile(path)) {
            OutputStreamWriter file1 = null;
            try {
                File a = new File(folderURL);
                a.setWritable(true);
                a.setReadable(true);
                a.mkdirs();
                file1 = new FileWriter(path);
                BufferedWriter out = new BufferedWriter(file1);
                out.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    file1.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static void resetWindow(String client, String server) {
        File f = new File(client);
        f.delete();
        UtilKSE.copyFile(client, server);
    }

    public static String getFormattedValue(double d, String Pattern) {
        try {
            Locale loc = new Locale("en", "US");
            NumberFormat nf = NumberFormat.getNumberInstance(loc);
            DecimalFormat df = (DecimalFormat)nf;
            df.applyPattern(Pattern);
            return df.format(d);
        }
        catch (Exception e) {
            return String.valueOf(d);
        }
    }

    public static String getFormattedValue(String ds, String Pattern) {
        try {
            double d = Double.parseDouble(ds);
            Locale loc = new Locale("en", "US");
            NumberFormat nf = NumberFormat.getNumberInstance(loc);
            DecimalFormat df = (DecimalFormat)nf;
            df.applyPattern(Pattern);
            return df.format(d);
        }
        catch (Exception e) {
            return ds;
        }
    }

    public static Point getLocation(Point location) {
        double x = location.getX();
        double y = location.getY();
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension d = kit.getScreenSize();
        double Y = d.getHeight() * y / 100.0;
        double X = d.getWidth() * x / 100.0;
        return new Point((int)X, (int)Y);
    }

    public static Rectangle getBounds(int width, int heigth, double widthPer, double heightPer) {
        Rectangle r = new Rectangle();
        int w = width;
        int h = heigth;
        Toolkit kitt = Toolkit.getDefaultToolkit();
        Dimension d = kitt.getScreenSize();
        double wPer = widthPer / 100.0;
        double hPer = (100.0 - heightPer) / 100.0;
        double wLocation = (double)d.width * wPer;
        double hLocation = (double)d.height * hPer;
        int finalWPoint = (int)(wLocation - (double)w);
        int finalHPoint = (int)(hLocation - (double)h);
        r.setBounds(finalWPoint, finalHPoint, w, h);
        return r;
    }

    public static String getUniqueSymbols(String mrtSymbol, String other) {
        int i;
        HashSet<String> symbolSet = new HashSet<String>();
        String symbols = "";
        String[] sym = mrtSymbol.split("\\;", -1);
        for (i = 0; i < sym.length; ++i) {
            symbolSet.add(sym[i]);
        }
        sym = other.split("\\;", -1);
        for (i = 0; i < sym.length; ++i) {
            symbolSet.add(sym[i]);
        }
        for (String item : symbolSet) {
            if (item.equalsIgnoreCase("")) continue;
            symbols = symbols + item + ";";
        }
        return symbols;
    }

    public static void SelectRow(JTable m_table, JScrollPane scrollPane, int row) {
        if (m_table.getModel().getRowCount() > row) {
            m_table.addRowSelectionInterval(0, m_table.getModel().getRowCount() - 1);
            m_table.addRowSelectionInterval(0, row);
            UtilKSE.ScrollToRow(m_table, scrollPane, row);
        }
    }

    private static void ScrollToRow(JTable m_table, JScrollPane scrollPane, int row) {
        int RowHeight = m_table.getRowHeight();
        if ((row + 1) * RowHeight - scrollPane.getVerticalScrollBar().getValue() > scrollPane.getVerticalScrollBar().getVisibleAmount()) {
            JScrollBar verticalScrollBar = scrollPane.getVerticalScrollBar();
            verticalScrollBar.setValue(row * RowHeight);
        } else if (scrollPane.getVerticalScrollBar().getValue() > (row + 1) * RowHeight) {
            JScrollBar verticalScrollBar = scrollPane.getVerticalScrollBar();
            verticalScrollBar.setValue(row * RowHeight);
        }
    }

    static {
        MonthName.put("JAN", "January");
        MonthName.put("FEB", "February");
        MonthName.put("MAR", "March");
        MonthName.put("APR", "April");
        MonthName.put("MAY", "May");
        MonthName.put("JUN", "Jun");
        MonthName.put("JUL", "July");
        MonthName.put("AUG", "August");
        MonthName.put("SEP", "September");
        MonthName.put("OCT", "October");
        MonthName.put("NOV", "November");
        MonthName.put("DEC", "Decemeber");
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).setDecimalSeparatorAlwaysShown(false);
        }
        numberFormatInMillion.setMinimumFractionDigits(2);
        numberFormatInMillion.setMaximumFractionDigits(2);
        numberFormatInMillion.setGroupingUsed(true);
    }
}

