/*
 * Decompiled with CFR 0.152.
 */
import MyDocking.Mediator;
import Ticker.TickerParameters;
import Utilities.LogsTC;
import Utilities.UtilTC;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.LoginMode;
import common.gui.util.MyColors;
import common.gui.util.Title;
import common.services.WebService;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import kse.util.LogsKSE;
import languages.LanguageConstant;
import windows.MySplashScreen;

public class AppletTC
extends JApplet {
    String identifier = "";

    @Override
    public void init() {
        System.out.println("Trade Cast Applet.....");
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            UIManager.put("TabbedPane.selectedForeground", MyColors.tabPaneselectedForeground);
            String osName = System.getProperty("os.name");
            System.out.println("Operating system name =>" + osName);
            if (osName.equalsIgnoreCase("Windows XP") || osName.equalsIgnoreCase("Windows 2003")) {
                UIManager.put("MenuItem.margin", new Insets(2, -10, 2, 2));
            }
            System.out.println("Loading Properties From JNLP.....");
            this.LoadPropertiesFromJNLP();
            System.out.println("Loading Properties Done.");
            System.out.println("Loading Client Settings....");
            AppConfig.getAllValues();
            System.out.println("Loading Client Setting Done.");
            this.identifier = this.getParameter("identifier");
            System.out.println("identifier= " + this.identifier);
            if (this.identifier.equalsIgnoreCase("3")) {
                LogsKSE.ChangePasswordMessage = "Your password has been expired. Please change your password!";
                LogsKSE.ChangePasswordForcefully = true;
            }
            if (this.identifier.equalsIgnoreCase("4")) {
                LogsKSE.ChangePasswordMessage = "Please change your password!";
                LogsKSE.ChangePasswordForcefully = true;
            }
            if (this.identifier.equalsIgnoreCase("9")) {
                LogsKSE.ChangePinCodeMessage = "Please Change your PIN!";
                LogsKSE.ChangePinCodeForcefully = true;
            }
            if (this.identifier.equalsIgnoreCase("10")) {
                LogsKSE.ChangePasswordMessage = "Please change your password!";
                LogsKSE.ChangePasswordForcefully = true;
                LogsKSE.ChangePinCodeMessage = "Please Change your PIN!";
                LogsKSE.ChangePinCodeForcefully = true;
            }
            if (this.identifier.equalsIgnoreCase("11")) {
                LogsKSE.ChangePasswordMessage = "Please change your password!";
                LogsKSE.ChangePasswordForcefully = true;
                LogsKSE.Identifier = this.identifier;
            }
            if (this.identifier.equalsIgnoreCase("12")) {
                LogsKSE.ChangePasswordMessage = "Please change your password!";
                LogsKSE.ChangePasswordForcefully = true;
                LogsKSE.ChangePinCodeMessage = "Please Change your PIN!";
                LogsKSE.ChangePinCodeForcefully = true;
                LogsKSE.Identifier = this.identifier;
            }
            LogCommon.UserID = this.getParameter("UserIDFromApplet");
            LogCommon.UserPassword = this.getParameter("parameter1");
            LogsKSE.UserPasswordIndex = this.getParameter("parameter2");
            LogCommon.UserCode = this.getParameter("UserCode");
            LogCommon.UserType = this.getParameter("UserType");
            String loginMode = this.getParameter("LoginMode");
            LogsKSE.CheckPriceLimit = Boolean.parseBoolean(this.getParameter("CheckPriceLimit"));
            Steganography s = new Steganography();
            LogCommon.web = s.decode("/common/gui/images/", "webservice").toCharArray();
            char[] a = s.decode("/common/gui/images/", "webservice3").toCharArray();
            LogCommon.web2 = new char[a.length - 1];
            for (int i = 1; i < a.length; ++i) {
                char j = a[i];
                LogCommon.web2[i - 1] = s.decode("/common/gui/images/", "webservice2").charAt(j);
            }
            if (loginMode.equalsIgnoreCase("KSE")) {
                AppConfig.loginMode = LoginMode.KSE;
                LogCommon.ShowPMEXBuyingPower = false;
            } else if (loginMode.equalsIgnoreCase("KSEPMEX")) {
                AppConfig.loginMode = LoginMode.KSEPMEX;
                Title.KSE = "";
                Title.PMEX = "";
                Title.Reset();
                LogsTC.tickerMap.put(LanguageConstant.UpperCapped, new TickerParameters(LanguageConstant.UpperCapped));
                LogsTC.tickerMap.put(LanguageConstant.LowerLocked, new TickerParameters(LanguageConstant.LowerLocked));
                LogsTC.tickerMap.put(Title.Custom, new TickerParameters(Title.Custom));
                LogsTC.tickerMap.put(LanguageConstant.TopMovers, new TickerParameters(LanguageConstant.TopMovers));
                if (!LogCommon.isPropertyFileRead) {
                    LogCommon.ShowPMEXBuyingPower = false;
                }
            } else if (loginMode.equalsIgnoreCase("PMEX")) {
                AppConfig.loginMode = LoginMode.PMEX;
            }
            UtilTC.GetAccounts(LogCommon.UserID);
            try {
                String appParam = WebService.getInstance().getPort().getInfo(LogCommon.UserID, "AppParam=", "");
                UtilTC.setParam(appParam);
                Mediator.getInstance().println("appParam = " + appParam);
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "System was unable to detect initial settings, please contact technical support", "Error", 0);
                System.exit(0);
            }
            AppConfig.isApplet = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MySplashScreen frame = MySplashScreen.getInstance();
                    frame.ShowSplashScreen();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void ShowForm(String UserID, String Parameter1, String Parameter2) {
        try {
            LogCommon.UserID = UserID;
            LogCommon.UserPassword = Parameter1;
            LogsKSE.UserPasswordIndex = Parameter2;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private void LoadPropertiesFromJNLP() {
        try {
            if (this.getParameter("companyName") != null) {
                AppConfig.companyName = this.getParameter("companyName");
                System.out.println(AppConfig.companyName);
            }
            if (this.getParameter("tradeCastServerPort") != null) {
                AppConfig.tradeCastServerPort = Integer.parseInt(this.getParameter("tradeCastServerPort"));
            }
            if (this.getParameter("feedServerPort") != null) {
                AppConfig.feedServerPort = Integer.parseInt(this.getParameter("feedServerPort"));
            }
            if (this.getParameter("tradeCastIP") != null) {
                AppConfig.tradeCastIP = this.getParameter("tradeCastIP").split("\\|")[0];
                AppConfig.tradeCastIPList = AppConfig.GetIPList((String)this.getParameter("tradeCastIP"));
            }
            if (this.getParameter("feedServerIP") != null) {
                AppConfig.feedServerIP = this.getParameter("feedServerIP").split("\\|")[0];
                AppConfig.feedServerIPList = AppConfig.GetIPList((String)this.getParameter("tradeCastIP"));
            }
            if (this.getParameter("houseName") != null) {
                AppConfig.houseName = this.getParameter("houseName");
                Title.CapitalAnalytics = AppConfig.houseName + " Analytics";
                Title.InvestorLounge = AppConfig.houseName + " Research";
            }
            if (this.getParameter("welcomeMsg") != null) {
                AppConfig.welcomeMsg = this.getParameter("welcomeMsg");
            }
            if (this.getParameter("version") != null) {
                AppConfig.version = this.getParameter("version");
            }
            if (this.getParameter("WebServiceURL") != null) {
                AppConfig.WebServiceURL = this.getParameter("WebServiceURL").split("\\|")[0];
                AppConfig.GetIPList((String)AppConfig.WebServiceURL);
            }
            if (this.getParameter("WebServiceTraderPositionURL") != null) {
                AppConfig.WebServiceTraderPositionURL = this.getParameter("WebServiceTraderPositionURL").split("\\|")[0];
                AppConfig.GetIPList((String)AppConfig.WebServiceTraderPositionURL);
            }
            if (this.getParameter("WriteLogInClientMachine") != null) {
                AppConfig.WriteLogInClientMachine = Boolean.parseBoolean(this.getParameter("WriteLogInClientMachine"));
            }
            if (this.getParameter("WriteLogInServer") != null) {
                AppConfig.WriteLogInServer = Boolean.parseBoolean(this.getParameter("WriteLogInServer"));
            }
            if (this.getParameter("iSSecureAuthentication") != null) {
                AppConfig.iSSecureAuthentication = Boolean.parseBoolean(this.getParameter("iSSecureAuthentication"));
            }
            if (this.getParameter("welcomeMsg") != null) {
                AppConfig.welcomeMsg = this.getParameter("welcomeMsg");
            }
            if (this.getParameter("isDebug") != null) {
                LogCommon.isDebug = Boolean.parseBoolean(this.getParameter("isDebug"));
            }
            if (this.getParameter("isWriteLogIntoFile") != null) {
                LogCommon.isWriteLogIntoFile = Boolean.parseBoolean(this.getParameter("isWriteLogIntoFile"));
            }
            if (this.getParameter("TradeCastURL") != null) {
                AppConfig.TradeCastURL = this.getParameter("TradeCastURL");
                System.setProperty("TradeCastURL", AppConfig.TradeCastURL);
            }
            if (this.getParameter("AnnouncementURL") != null) {
                AppConfig.AnnouncementURL = this.getParameter("AnnouncementURL");
            }
            if (this.getParameter("companyURL") != null) {
                AppConfig.companyURL = this.getParameter("companyURL");
            }
            if (this.getParameter("ServerCode") != null) {
                AppConfig.ServerCode = this.getParameter("ServerCode");
            }
            if (this.getParameter("MarketTimingLink") != null) {
                AppConfig.MarketTimingLink = this.getParameter("MarketTimingLink");
            }
            if (this.getParameter("KSEAnnouncementLink") != null) {
                AppConfig.KSEAnnouncementLink = this.getParameter("KSEAnnouncementLink");
            }
            if (this.getParameter("ShowTradeButton") != null) {
                AppConfig.ShowTradeButton = Boolean.parseBoolean(this.getParameter("ShowTradeButton"));
            }
            if (this.getParameter("ShowCompanySnapshotButton") != null) {
                AppConfig.ShowCompanySnapshotButton = Boolean.parseBoolean(this.getParameter("ShowCompanySnapshotButton"));
            }
            if (this.getParameter("reportURL") != null) {
                AppConfig.reportURL = this.getParameter("reportURL");
            }
            if (this.getParameter("DisclaimerURL") != null) {
                AppConfig.DisclaimerURL = this.getParameter("DisclaimerURL");
            }
            if (this.getParameter("WithdrawalRequestType") != null) {
                AppConfig.WithdrawalRequestType = this.getParameter("WithdrawalRequestType");
            }
            if (this.getParameter("ExposureWindowType") != null) {
                AppConfig.ExposureWindowType = this.getParameter("ExposureWindowType");
            }
            if (this.getParameter("isStandardCapital") != null) {
                AppConfig.isStandardCapital = Boolean.parseBoolean(this.getParameter("isStandardCapital"));
            }
            if (this.getParameter("isPMEX") != null) {
                AppConfig.isPMEX = Boolean.parseBoolean(this.getParameter("isPMEX"));
            }
            if (this.getParameter("isOrderExportImport") != null) {
                AppConfig.isOrderExportImport = Boolean.parseBoolean(this.getParameter("isOrderExportImport"));
            }
            if (this.getParameter("isXDividendWindow") != null) {
                AppConfig.isXDividendWindow = Boolean.parseBoolean(this.getParameter("isXDividendWindow"));
            }
            if (this.getParameter("UserIDTitle") != null) {
                AppConfig.UserIDTitle = this.getParameter("UserIDTitle");
            }
            if (this.getParameter("BrokerageDisclaimer") != null) {
                AppConfig.BrokerageDisclaimer = this.getParameter("BrokerageDisclaimer");
            }
            if (this.getParameter("isExBenefitsWindow") != null) {
                AppConfig.isExBenefitsWindow = Boolean.parseBoolean(this.getParameter("isExBenefitsWindow"));
            }
            if (this.getParameter("isHouseMessagePopup") != null) {
                AppConfig.isHouseMessagePopup = Boolean.parseBoolean(this.getParameter("isHouseMessagePopup"));
            }
            if (this.getParameter("isVolumeEditInChangeOrder") != null) {
                AppConfig.isVolumeEditInChangeOrder = Boolean.parseBoolean(this.getParameter("isVolumeEditInChangeOrder"));
            }
            if (this.getParameter("isShowLogo") != null) {
                AppConfig.isShowLogo = Boolean.parseBoolean(this.getParameter("isShowLogo"));
            }
            if (this.getParameter("isShowResetButton") != null) {
                AppConfig.isShowResetButton = Boolean.parseBoolean(this.getParameter("isShowResetButton"));
            }
            if (this.getParameter("isWriteTradeLog") != null) {
                AppConfig.isWriteTradeLog = Boolean.parseBoolean(this.getParameter("isWriteTradeLog"));
            }
            if (this.getParameter("isStrategyOrder") != null) {
                AppConfig.isStrategyOrder = Boolean.parseBoolean(this.getParameter("isStrategyOrder"));
            }
            if (this.getParameter("isFundTransferStatement") != null) {
                AppConfig.isFundTransferStatement = Boolean.parseBoolean(this.getParameter("isFundTransferStatement"));
            }
            if (this.getParameter("isFundTransfer") != null) {
                AppConfig.isFundTransfer = Boolean.parseBoolean(this.getParameter("isFundTransfer"));
            }
            if (this.getParameter("isFundTransferBIPL") != null) {
                AppConfig.isFundTransferBIPL = Boolean.parseBoolean(this.getParameter("isFundTransferBIPL"));
            }
            if (this.getParameter("isCustomerVerificationBIPL") != null) {
                AppConfig.isCustomerVerificationBIPL = Boolean.parseBoolean(this.getParameter("isCustomerVerificationBIPL"));
            }
            if (this.getParameter("isCashWithdrawal") != null) {
                AppConfig.isCashWithdrawal = Boolean.parseBoolean(this.getParameter("isCashWithdrawal"));
            }
            if (this.getParameter("isPortfolioWatch") != null) {
                AppConfig.isPortfolioWatch = Boolean.parseBoolean(this.getParameter("isPortfolioWatch"));
            }
            if (this.getParameter("isShortSell") != null) {
                AppConfig.isShortSell = Boolean.parseBoolean(this.getParameter("isShortSell"));
            }
            if (this.getParameter("isLeverageBuy") != null) {
                AppConfig.isLeverageBuy = Boolean.parseBoolean(this.getParameter("isLeverageBuy"));
            }
            if (this.getParameter("isAccountStatement") != null) {
                AppConfig.isAccountStatement = Boolean.parseBoolean(this.getParameter("isAccountStatement"));
            }
            if (this.getParameter("isBankHistorical") != null) {
                AppConfig.isBankHistorical = Boolean.parseBoolean(this.getParameter("isBankHistorical"));
            }
            if (this.getParameter("isPeriodicTradeDetail") != null) {
                AppConfig.isPeriodicTradeDetail = Boolean.parseBoolean(this.getParameter("isPeriodicTradeDetail"));
            }
            if (this.getParameter("isPeriodicTradeSummary") != null) {
                AppConfig.isPeriodicTradeSummary = Boolean.parseBoolean(this.getParameter("isPeriodicTradeSummary"));
            }
            if (this.getParameter("isPeriodicTradeDetailByDealer") != null) {
                AppConfig.isPeriodicTradeDetailByDealer = Boolean.parseBoolean(this.getParameter("isPeriodicTradeDetailByDealer"));
            }
            if (this.getParameter("isPeriodicTradeSummaryByDealer") != null) {
                AppConfig.isPeriodicTradeSummaryByDealer = Boolean.parseBoolean(this.getParameter("isPeriodicTradeSummaryByDealer"));
            }
            if (this.getParameter("isOrderHistory") != null) {
                AppConfig.isOrderHistory = Boolean.parseBoolean(this.getParameter("isOrderHistory"));
            }
            if (this.getParameter("isCapitalAnalaytic") != null) {
                AppConfig.isCapitalAnalaytic = Boolean.parseBoolean(this.getParameter("isCapitalAnalaytic"));
            }
            if (this.getParameter("isInvestorLounge") != null) {
                AppConfig.isInvestorLounge = Boolean.parseBoolean(this.getParameter("isInvestorLounge"));
            }
            if (this.getParameter("isMaiers") != null) {
                AppConfig.isMaiers = Boolean.parseBoolean(this.getParameter("isMaiers"));
            }
            if (this.getParameter("isSpotWatch") != null) {
                AppConfig.isSpotWatch = Boolean.parseBoolean(this.getParameter("isSpotWatch"));
            }
            if (this.getParameter("isExposureViaF1") != null) {
                AppConfig.isExposureViaF1 = Boolean.parseBoolean(this.getParameter("isExposureViaF1"));
            }
            if (this.getParameter("isPreviousOrderHistory") != null) {
                AppConfig.isPreviousOrderHistory = Boolean.parseBoolean(this.getParameter("isPreviousOrderHistory"));
            }
            if (this.getParameter("isCustodyNetShares") != null) {
                AppConfig.isCustodyNetShares = Boolean.parseBoolean(this.getParameter("isCustodyNetShares"));
            }
            if (this.getParameter("isScripHistory") != null) {
                AppConfig.isScripHistory = Boolean.parseBoolean(this.getParameter("isScripHistory"));
            }
            if (this.getParameter("isScripWisePosition") != null) {
                AppConfig.isScripWisePosition = Boolean.parseBoolean(this.getParameter("isScripWisePosition"));
            }
            if (this.getParameter("isClosePriceExport") != null) {
                AppConfig.isClosePriceExport = Boolean.parseBoolean(this.getParameter("isClosePriceExport"));
            }
            if (this.getParameter("isAvgPriceInMarketWatch") != null) {
                AppConfig.isAvgPriceInMarketWatch = Boolean.parseBoolean(this.getParameter("isAvgPriceInMarketWatch"));
            }
            if (this.getParameter("isUseSecondaryPassword") != null) {
                AppConfig.isUseSecondaryPassword = Boolean.parseBoolean(this.getParameter("isUseSecondaryPassword"));
            }
            if (this.getParameter("isSecondaryPasswordOT") != null) {
                AppConfig.isSecondaryPasswordOT = Boolean.parseBoolean(this.getParameter("isSecondaryPasswordOT"));
            }
            if (this.getParameter("isShowAnnouncementInGrid") != null) {
                AppConfig.isShowAnnouncementInGrid = Boolean.parseBoolean(this.getParameter("isShowAnnouncementInGrid"));
            }
            if (this.getParameter("isTCPEncryption") != null) {
                AppConfig.isTCPEncryption = Boolean.parseBoolean(this.getParameter("isTCPEncryption"));
            }
            if (this.getParameter("fundamentalURL") != null) {
                AppConfig.fundamentalURL = this.getParameter("fundamentalURL");
            }
            if (this.getParameter("CompanySnapshotURL") != null) {
                AppConfig.CompanySnapshotURL = this.getParameter("CompanySnapshotURL");
            }
            if (this.getParameter("CompanySnapshotURL_SC") != null) {
                AppConfig.CompanySnapshotURL_SC = this.getParameter("CompanySnapshotURL_SC");
            }
            if (this.getParameter("AdvancedChartingURL_SC") != null) {
                AppConfig.AdvancedChartingURL_SC = this.getParameter("AdvancedChartingURL_SC");
            }
            if (this.getParameter("StockComparisonURL_SC") != null) {
                AppConfig.StockComparisonURL_SC = this.getParameter("StockComparisonURL_SC");
            }
            if (this.getParameter("MarketValuationsURL_SC") != null) {
                AppConfig.MarketValuationsURL_SC = this.getParameter("MarketValuationsURL_SC");
            }
            if (this.getParameter("ResearchReportsURL_SC") != null) {
                AppConfig.ResearchReportsURL_SC = this.getParameter("ResearchReportsURL_SC");
            }
            if (this.getParameter("tradingSignalURL") != null) {
                AppConfig.tradingSignalURL = this.getParameter("tradingSignalURL");
            }
            if (this.getParameter("graphURL") != null) {
                AppConfig.graphURLSC = this.getParameter("graphURL");
            }
            if (this.getParameter("opinionURL") != null) {
                AppConfig.opinionURL = this.getParameter("opinionURL");
            }
            if (this.getParameter("AnalyticsOpenURL_Maiers") != null) {
                AppConfig.AnalyticsOpenURL_Maiers = this.getParameter("AnalyticsOpenURL_Maiers");
            }
            if (this.getParameter("AnalyticsOpenURL_IL") != null) {
                AppConfig.AnalyticsOpenURL_IL = this.getParameter("AnalyticsOpenURL_IL");
            }
            if (this.getParameter("AnalyticsPostbackURL_IL") != null) {
                AppConfig.AnalyticsPostbackURL_IL = this.getParameter("AnalyticsPostbackURL_IL");
            }
            if (this.getParameter("ServiceAuthentication") != null) {
                AppConfig.ServiceAuthentication = Boolean.parseBoolean(this.getParameter("ServiceAuthentication"));
            }
            if (this.getParameter("isCashWithdrawalWithBank") != null) {
                AppConfig.isCashWithdrawalWithBank = Boolean.parseBoolean(this.getParameter("isCashWithdrawalWithBank"));
            }
            if (this.getParameter("isTickerEnable") != null) {
                AppConfig.isTickerEnable = Boolean.parseBoolean(this.getParameter("isTickerEnable"));
            }
            if (this.getParameter("isGeneratePinCode") != null) {
                AppConfig.isCreatePinCode = Boolean.parseBoolean(this.getParameter("isGeneratePinCode"));
            }
            if (this.getParameter("isMFSOrder") != null) {
                AppConfig.isMFSOrder = Boolean.parseBoolean(this.getParameter("isMFSOrder"));
            }
            if (this.getParameter("ResreachMenuText") != null) {
                AppConfig.ResreachMenuText = this.getParameter("ResreachMenuText");
            }
            if (this.getParameter("ResreachMenuLink") != null) {
                AppConfig.ResreachMenuLink = this.getParameter("ResreachMenuLink");
            }
            if (this.getParameter("DemoRegistrationLink") != null) {
                AppConfig.DemoRegistrationLink = this.getParameter("DemoRegistrationLink");
            }
            if (this.getParameter("DemoRegistrationText") != null) {
                AppConfig.DemoRegistrationText = this.getParameter("DemoRegistrationText");
            }
            if (this.getParameter("isPMEXAccountStatement") != null) {
                AppConfig.isPMEXAccountStatement = Boolean.parseBoolean(this.getParameter("isPMEXAccountStatement"));
            }
            if (this.getParameter("isPMEXPeriodicTradeDetail") != null) {
                AppConfig.isPMEXPeriodicTradeDetail = Boolean.parseBoolean(this.getParameter("isPMEXPeriodicTradeDetail"));
            }
            if (this.getParameter("isPMEXVaultPosition") != null) {
                AppConfig.isPMEXVaultPosition = Boolean.parseBoolean(this.getParameter("isPMEXVaultPosition"));
            }
            if (this.getParameter("isPMEXExpiringPosition") != null) {
                AppConfig.isPMEXExpiringPosition = Boolean.parseBoolean(this.getParameter("isPMEXExpiringPosition"));
            }
            if (this.getParameter("isPMEXPeriodicTradeSummary") != null) {
                AppConfig.isPMEXPeriodicTradeSummary = Boolean.parseBoolean(this.getParameter("isPMEXPeriodicTradeSummary"));
            }
            if (this.getParameter("LoginWindowTextColor") != null) {
                int intValue = Integer.parseInt(AppConfig.GetSixCharacterHexColor((String)this.getParameter("LoginWindowTextColor")), 16);
                MyColors.LoginWindowTextColor = new Color(intValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isAlive() {
        return true;
    }

    private class Steganography {
        public String decode(String path, String name) {
            try {
                BufferedImage image = this.user_space(this.getImage(this.image_path(path, name, "png")));
                byte[] decode = this.decode_text(this.get_byte_data(image));
                return new String(decode);
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }

        private String image_path(String path, String name, String ext) {
            return path + name + "." + ext;
        }

        private BufferedImage getImage(String f) {
            BufferedImage image = null;
            try {
                ImageIcon im = new ImageIcon(this.getClass().getResource(f));
                image = this.toBufferedImage(im.getImage());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return image;
        }

        private BufferedImage toBufferedImage(Image img) {
            if (img instanceof BufferedImage) {
                return (BufferedImage)img;
            }
            BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
            Graphics2D bGr = bimage.createGraphics();
            bGr.drawImage(img, 0, 0, null);
            bGr.dispose();
            return bimage;
        }

        private BufferedImage user_space(BufferedImage image) {
            BufferedImage new_img = new BufferedImage(image.getWidth(), image.getHeight(), 5);
            Graphics2D graphics = new_img.createGraphics();
            graphics.drawRenderedImage(image, null);
            graphics.dispose();
            return new_img;
        }

        private byte[] get_byte_data(BufferedImage image) {
            WritableRaster raster = image.getRaster();
            DataBufferByte buffer = (DataBufferByte)raster.getDataBuffer();
            return buffer.getData();
        }

        private byte[] decode_text(byte[] image) {
            int length = 0;
            int offset = 32;
            for (int i = 0; i < 32; ++i) {
                length = length << 1 | image[i] & 1;
            }
            byte[] result = new byte[length];
            for (int b = 0; b < result.length; ++b) {
                int i = 0;
                while (i < 8) {
                    result[b] = (byte)(result[b] << 1 | image[offset] & 1);
                    ++i;
                    ++offset;
                }
            }
            return result;
        }
    }
}

