/*
 * Decompiled with CFR 0.152.
 */
package Chart;

import Beans.OrderBean;
import CATALYST.Control.MarketFeed;
import CustomComponent.ForgetMouseListner;
import CustomComponent.MyOptionPane;
import CustomComponent.MyTime;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import Orders.OrderConfirmation;
import Orders.OrderErrorPopup;
import Orders.PriceOutOfRange;
import Utilities.CompressManager;
import Utilities.LogsTC;
import Utilities.UtilTC;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import catalystchart.ChartActionEvent;
import catalystchart.ChartActionListener;
import catalystchart.ChartType;
import catalystchart.OptionPanel;
import catalystchart.PnlIntraday;
import catalystchart.pnlBar;
import common.gui.component.JTextFieldFilter;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.ImageUtil;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.MyColors;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import kse.util.LogsKSE;
import kse.util.UtilKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;
import login.LoginServer;
import windows.ExchangeStats;

public class NewOrder
extends JPanel
implements FocusListener,
ChartActionListener {
    String lastSymbol = "";
    JFrame frame = null;
    JDialog window = null;
    public static boolean isFromShortCutKey = false;
    public String transactionType = "";
    public String feedSymbol = "";
    private SpinnerNumberModel volumeModel;
    int lastwidth;
    private String Market = "";
    private String Symbol = "";
    private PnlIntraday pnlIntraday;
    Mediator mediator = null;
    boolean IsHistoryDataReceived = false;
    boolean isLoading = false;
    JTextFieldFilter numericdis = new JTextFieldFilter("0123456789");
    JTextFieldFilter fnumeric = new JTextFieldFilter("0123456789.");
    JTextFieldFilter fnumericlimit = new JTextFieldFilter("0123456789.");
    JTextFieldFilter upperCap = new JTextFieldFilter("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
    public final String MarketOrder = "Market Order";
    public final String LimitOrder = "Limit Order";
    public final String StopLossOrder = "Stop Loss Order";
    private boolean isInvalidPrice = false;
    private boolean isInvalidVolume = false;
    int num = 0;
    Date BuySellLastDate = null;
    double BuySellLastBid = 0.0;
    double BuySellLastAsk = 0.0;
    private int key;
    private LanguageCentre languageCentre = new LanguageCentre();
    boolean LoadingThread = false;
    Image img;
    public JButton btnBuy;
    public JButton btnSell;
    private JComboBox cbAccountNo;
    public JComboBox cbMarket;
    private JCheckBox cbSave;
    public JComboBox cbType;
    private JLabel jLabel1;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    public static JLabel jLabel8;
    public static JLabel jLabel9;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSplitPane jSplitPane1;
    private JLabel lblForgetPinCode;
    private JLabel lblIndexGraph;
    private JLabel lblMessage;
    private JLabel lblScripDetails;
    private JLabel lblSymbolName;
    private JLabel lblimage;
    private JLabel lblrateleft;
    private JLabel lblrateright;
    private JPanel leftSplitPane;
    private OptionPanel optionPanel1;
    private pnlBar pnlBar1;
    private JPanel pnlBottom;
    private JPanel pnlChart;
    private JPanel pnlChartRegion;
    private JPanel pnlGap;
    private JPanel pnlRate_left;
    private JPanel pnlRate_right;
    private JPanel pnlSeprator;
    private JPanel pnlTop;
    private JPanel rightSplitPane;
    private JSeparator sepOrder;
    private JSeparator seprator1;
    private JSpinner spPrice;
    private JSpinner spVolume;
    public JTextField txtDisclosedVolume;
    public JTextField txtLimit;
    private JPasswordField txtPinCode;
    public JTextField txtSymbol;

    public NewOrder(int num, int key) {
        this.mediator = Mediator.getInstance();
        PnlIntraday.lastChartType = ChartType.PRICEVOLUME;
        this.mediator.setNewOrder(this);
        this.initComponents();
        this.txtSymbol.setEnabled(false);
        this.txtSymbol.setDisabledTextColor(Color.BLACK);
        this.num = num;
        this.key = key;
        this.optionPanel1.setMarketList(LogCommon.markets);
        this.optionPanel1.setSymbolList(new Vector(LogCommon.SymbolAndSymbolName.keySet()));
        this.lblSymbolName.setText("");
        this.lblrateleft.setText("0.00 (0.00");
        this.pnlIntraday = new PnlIntraday();
        this.pnlIntraday.setWaterMarkText(AppConfig.houseName);
        this.pnlChartRegion.add((Component)this.pnlIntraday);
        this.optionPanel1.addListener((ChartActionListener)this);
        this.cbMarket.setModel(new DefaultComboBoxModel<String>(LogCommon.markets));
        this.cbMarket.removeItem("");
        this.cbType.setModel(new DefaultComboBoxModel<String>(new String[]{"Limit Order", "Stop Loss Order", "Market Order"}));
        this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(LogsTC.accountAll.keySet().toArray()));
        AutoCompleteSupport support = AutoCompleteSupport.install((JComboBox)this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])LogsTC.accountAll.keySet().toArray()));
        this.fnumeric.setNegativeAccepted(true);
        this.txtSymbol.setDocument((Document)new JTextFieldFilter("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-"));
        this.txtLimit.setDocument((Document)this.fnumericlimit);
        this.txtDisclosedVolume.setDocument((Document)this.numericdis);
        this.cbMarket.addFocusListener(this);
        this.txtSymbol.addFocusListener(this);
        this.cbAccountNo.addFocusListener(this);
        this.txtPinCode.addFocusListener(this);
        this.btnBuy.addFocusListener(this);
        this.btnSell.addFocusListener(this);
        this.lblForgetPinCode.setForeground(MyColors.ForgotPincodeFG);
        this.lblForgetPinCode.setText("<html>Forgot PIN?</html>");
        this.lblForgetPinCode.addMouseListener(new ForgetMouseListner(this.lblForgetPinCode));
        this.lblScripDetails.setCursor(Cursor.getPredefinedCursor(12));
        if (AppConfig.isHistoricalDataWatch) {
            this.lblScripDetails.setText("<html>" + this.languageCentre.getValue(LanguageConstant.ScripDetail) + "</html>");
            this.lblScripDetails.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/scripDetail.png")));
        } else {
            this.lblScripDetails.setText("<html>" + this.languageCentre.getValue(LanguageConstant.DetailedQuote) + "</html>");
        }
        this.lblIndexGraph.setCursor(Cursor.getPredefinedCursor(12));
        this.lblIndexGraph.setText("<html>" + this.languageCentre.getValue(LanguageConstant.IndexGraph) + "</html>");
        this.volumeModel = new SpinnerNumberModel(0, 0, 999999999, 1);
        this.spVolume.setModel(this.volumeModel);
        ((JSpinner.DefaultEditor)this.spVolume.getEditor()).getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (!(evt.getKeyCode() != 10 && evt.getKeyCode() != 9 || NewOrder.this.isInvalidVolume)) {
                    if (NewOrder.this.spVolume.getValue().toString().trim().equalsIgnoreCase("0")) {
                        Util.setMessage((JLabel)NewOrder.this.lblMessage, (MessageType)MessageType.Information, (String)"Please enter volume.");
                        return;
                    }
                    ((JSpinner.DefaultEditor)NewOrder.this.spPrice.getEditor()).getTextField().requestFocus();
                }
            }
        });
        ((JSpinner.DefaultEditor)this.spVolume.getEditor()).getTextField().addFocusListener(this);
        this.spPrice.setModel(new SpinnerNumberModel(0.0, 0.0, 1000000.0, 0.01));
        ((JSpinner.DefaultEditor)this.spPrice.getEditor()).getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (!(evt.getKeyCode() != 10 && evt.getKeyCode() != 9 || NewOrder.this.isInvalidPrice)) {
                    NewOrder.this.cbAccountNo.requestFocus();
                }
            }
        });
        ((JSpinner.DefaultEditor)this.spPrice.getEditor()).getTextField().addFocusListener(this);
        this.cbAccountNo.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                super.keyPressed(evt);
                if (evt.getKeyCode() == 10) {
                    if (NewOrder.this.cbAccountNo.getSelectedItem() == null) {
                        Util.setMessage((JLabel)NewOrder.this.lblMessage, (MessageType)MessageType.Information, (String)"Please enter account.");
                        NewOrder.this.cbAccountNo.requestFocus();
                        return;
                    }
                    if (NewOrder.this.cbAccountNo.getSelectedItem().toString().length() < 1) {
                        Util.setMessage((JLabel)NewOrder.this.lblMessage, (MessageType)MessageType.Information, (String)"Please enter account.");
                        NewOrder.this.cbAccountNo.requestFocus();
                        return;
                    }
                    NewOrder.this.txtPinCode.requestFocus();
                }
            }
        });
        this.cbSave.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10 || evt.getKeyCode() == 9) {
                    if (NewOrder.this.txtLimit.isEditable()) {
                        NewOrder.this.txtLimit.requestFocus();
                    } else {
                        NewOrder.this.btnBuy.requestFocus();
                    }
                }
            }
        });
        this.txtPinCode.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10 || evt.getKeyCode() == 9) {
                    Util.setMessage((JLabel)NewOrder.this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
                    if (NewOrder.this.txtPinCode.getText().trim().length() <= 0) {
                        Util.setMessage((JLabel)NewOrder.this.lblMessage, (MessageType)MessageType.Information, (String)"Please enter PIN.");
                    } else {
                        NewOrder.this.cbSave.requestFocus();
                    }
                }
            }
        });
        this.btnBuy.setBackground(new Color(159, 184, 251));
        this.txtSymbol.setFocusTraversalKeys(0, Collections.EMPTY_SET);
        this.txtPinCode.setFocusTraversalKeys(0, Collections.EMPTY_SET);
        this.cbSave.setFocusTraversalKeys(0, Collections.EMPTY_SET);
        ((JSpinner.DefaultEditor)this.spPrice.getEditor()).getTextField().setFocusTraversalKeys(0, Collections.EMPTY_SET);
        ((JSpinner.DefaultEditor)this.spPrice.getEditor()).getTextField().addFocusListener(this);
        this.reset(true);
        this.btnBuy.setName("NewOrder -> btnBuy");
        this.btnSell.setName("NewOrder -> btnSell");
    }

    private void ChangeChart() {
        this.pnlIntraday.setWaterMarkText(this.Market + " - " + this.Symbol);
        this.isLoading = true;
        try {
            String returnMessage = "";
            this.mediator.sendFeedSymbols("", "New Order (Chart) : " + this.Market + " - " + this.Symbol);
            if (PnlIntraday.lastChartType == ChartType.BUYSELL) {
                ArrayList<Date> date = new ArrayList<Date>();
                ArrayList<Double> buy = new ArrayList<Double>();
                ArrayList<Double> sell = new ArrayList<Double>();
                this.pnlIntraday.initializeChart(this.Market, this.Symbol, PnlIntraday.lastChartType);
                returnMessage = this.getData("BuySell", date, buy, sell);
                this.pnlIntraday.setInitialDataForbuySellChart(date, buy, sell);
                this.pnlIntraday.showChart();
                this.pnlIntraday.addBuySellTick(this.BuySellLastDate, this.BuySellLastBid, this.BuySellLastAsk);
                this.clearCandle();
                this.updateCandle();
                this.clearRetaInPanel();
                this.updateRateInPanel();
            } else if (PnlIntraday.lastChartType == ChartType.PRICEVOLUME) {
                ArrayList<Date> date = new ArrayList<Date>();
                ArrayList<Double> ltrdPrice = new ArrayList<Double>();
                ArrayList<Double> ltrVolume = new ArrayList<Double>();
                this.pnlIntraday.initializeChart(this.Market, this.Symbol, PnlIntraday.lastChartType);
                returnMessage = this.getData("PriceVolume", date, ltrdPrice, ltrVolume);
                this.pnlIntraday.setInitialDataForPriceVolumeChart(date, ltrdPrice, ltrVolume);
                this.pnlIntraday.showChart();
                this.updateChart();
                this.clearCandle();
                this.updateCandle();
                this.clearRetaInPanel();
                this.updateRateInPanel();
            }
            if (returnMessage.equalsIgnoreCase("Error")) {
                this.isLoading = false;
                MyOptionPane.showMessage(MessageType.Error, "Error in loading data", LanguageConstant.GraphsAndCharts, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.isLoading = false;
    }

    private String getData(String Type2, List<Date> date, List<Double> data1, List<Double> data2) {
        String returnMessage = "OK";
        try {
            if (AppConfig.GraphURL.equalsIgnoreCase("Service")) {
                LoginServer port = WebService.getInstance().getPort();
                byte[] bdata = port.getCompressedData(LogCommon.UserID, "CHART_DATA", this.Symbol + "|" + Type2 + "|" + this.Market);
                String result = CompressManager.unzipStringFromBytes(bdata);
                if (result.indexOf("=") > 0) {
                    SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
                    this.parseData(result, Type2, date, data1, data2, sdf);
                } else if (result.equalsIgnoreCase("No Record(s) found")) {
                    Mediator.getInstance().println("Historical Data not found!");
                }
            } else {
                String result;
                URL url = new URL(AppConfig.GraphURL + "?action=Market&identifier=" + Type2 + "&market=" + this.Market + "&symbol=" + this.Symbol);
                Mediator.getInstance().println("Graph URL = " + AppConfig.GraphURL + "?action=Market&identifier=" + Type2 + "&market=" + this.Market + "&symbol=" + this.Symbol);
                URLConnection yc = url.openConnection();
                BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
                StringBuilder sb = new StringBuilder();
                while ((result = in.readLine()) != null) {
                    sb.append(result);
                }
                in.close();
                result = "=" + sb.toString();
                if (result.length() > 0) {
                    SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
                    this.parseData(result, Type2, date, data1, data2, sdf);
                } else {
                    Mediator.getInstance().println("Historical Data not found!");
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            returnMessage = "Error";
        }
        return returnMessage;
    }

    private void parseData(String result, String Type2, List<Date> date, List<Double> data1, List<Double> data2, DateFormat sdf) throws ParseException {
        String Feed_ = result.split("\\=", -1)[1];
        String[] Tick = Feed_.split("\\|", -1);
        for (int i = 0; i < Tick.length; ++i) {
            if (Tick[i].length() <= 0) continue;
            String[] data = Tick[i].split("\\;", -1);
            Date dt = sdf.parse(data[0]);
            double d1 = Double.parseDouble(data[1]);
            double d2 = Double.parseDouble(data[2]);
            date.add(dt);
            data1.add(d1);
            data2.add(d2);
            if (Type2.indexOf("BuySell") < 0) continue;
            this.BuySellLastDate = dt;
            this.BuySellLastBid = d1;
            this.BuySellLastAsk = d2;
        }
    }

    public void showInFrmae() {
        this.frame = new JFrame();
        this.frame.setIconImage(AppConfig.houseIcon);
        this.frame.setMinimumSize(new Dimension(770, 500));
        this.frame.setDefaultCloseOperation(2);
        this.window.remove(this);
        this.frame.add(this);
        this.frame.setLocation(this.window.getLocation());
        this.frame.setSize(this.window.getSize());
        this.frame.validate();
        this.window.setVisible(false);
        this.window.validate();
        this.window.dispose();
        this.window = null;
        this.setTitle();
        KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
        InputMap inputMap = this.frame.getRootPane().getInputMap(2);
        inputMap.put(stroke, "ESCAPE");
        this.frame.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewOrder.this.initClose();
                NewOrder.this.frame.dispose();
                TradeCast.getInstance().GetTopWindow();
            }
        });
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                super.windowClosed(e);
                if (NewOrder.this.frame != null) {
                    NewOrder.this.initClose();
                    TradeCast.getInstance().GetTopWindow();
                }
                if (NewOrder.this.frame != null) {
                    TradeCast.getInstance().SaveSizeAndLocation(FormName.GraphsAndCharts, NewOrder.this.frame.getSize(), NewOrder.this.frame.getLocation());
                }
            }
        });
        TradeCast.getInstance().GraphWindowHolder.put(this.num, this);
        this.frame.setVisible(true);
    }

    private void initClose() {
        TradeCast.getInstance().GraphWindowHolder.remove(this.num);
        LogsTC.GraphSymbol.remove(this.Symbol);
        TradeCast.getInstance().dynamicViews.remove(this.key);
    }

    public void dispose() {
        if (this.frame != null) {
            this.frame.dispose();
        }
        if (this.window != null) {
            this.window.dispose();
        }
    }

    public JDialog showInJDialog() {
        this.window = new JDialog(TradeCast.getInstance().frame);
        this.window.setMinimumSize(new Dimension(770, 500));
        this.window.setDefaultCloseOperation(2);
        if (this.frame != null) {
            this.window.setLocation(this.frame.getLocation());
            this.window.setSize(this.frame.getSize());
            this.frame.remove(this);
            this.frame.validate();
            this.frame.dispose();
            this.frame = null;
        }
        this.setTitle();
        this.window.add(this);
        this.window.validate();
        KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
        InputMap inputMap = this.window.getRootPane().getInputMap(2);
        inputMap.put(stroke, "ESCAPE");
        this.window.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewOrder.this.initClose();
                NewOrder.this.window.dispose();
                TradeCast.getInstance().GetTopWindow();
            }
        });
        this.window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                super.windowClosed(e);
                if (NewOrder.this.window != null) {
                    NewOrder.this.initClose();
                    TradeCast.getInstance().GetTopWindow();
                }
                if (NewOrder.this.window != null) {
                    TradeCast.getInstance().SaveSizeAndLocation(FormName.GraphsAndCharts, NewOrder.this.window.getSize(), NewOrder.this.window.getLocation());
                }
            }
        });
        TradeCast.getInstance().GraphWindowHolder.put(this.num, this);
        this.window.setVisible(true);
        return this.window;
    }

    public void requestFocusWindow() {
        if (this.window != null) {
            this.window.requestFocus();
        } else if (this.frame != null) {
            this.frame.requestFocus();
        }
    }

    public void updateTick() {
        MarketFeed mktfeed = new MarketFeed();
        this.pnlIntraday.addTick(mktfeed);
    }

    public void InitilizeWindow() {
        if (this.LoadingThread) {
            return;
        }
        this.LoadingThread = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                NewOrder.this.ChangeChart();
                NewOrder.this.LoadingThread = false;
            }
        }).start();
    }

    public void FeedRecieved(final String Feed2) {
        final String Sym = this.Symbol;
        final String mkt = this.Market;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Feed2.indexOf(Sym) >= 0 && Feed2.indexOf(mkt) >= 0) {
                    NewOrder.this.updateCandle();
                    NewOrder.this.updateRateInPanel();
                    if (!NewOrder.this.isLoading) {
                        NewOrder.this.updateChart();
                    }
                }
            }
        });
    }

    private void updateChart() {
        try {
            MarketFeed mktFeed = this.mediator.MwPanel.GetSingleFeed(this.Symbol, this.Market);
            if (this.pnlIntraday != null && mktFeed != null) {
                SimpleDateFormat sdf;
                if (PnlIntraday.lastChartType == ChartType.BUYSELL && (LogsKSE.MarketStauts.toUpperCase().indexOf("OHP") >= 0 || LogsKSE.MarketStauts.toUpperCase().indexOf("OPN") >= 0 || LogsKSE.MarketStauts.toUpperCase().indexOf("PRE") >= 0)) {
                    sdf = new SimpleDateFormat("HH:mm:ss");
                    String time = sdf.format(MyTime.getInstance().getDate2());
                    this.pnlIntraday.addBuySellTick(sdf.parse(time), Double.parseDouble(mktFeed.buy), Double.parseDouble(mktFeed.sell));
                }
                if (PnlIntraday.lastChartType == ChartType.PRICEVOLUME) {
                    sdf = new SimpleDateFormat("HH:mm:ss");
                    if (mktFeed.lTrdTime.trim().length() > 0) {
                        this.pnlIntraday.addPriceVolumeTick(sdf.parse(mktFeed.lTrdTime), Double.parseDouble(mktFeed.lTrdPrice), Double.parseDouble(mktFeed.ltrdVolume));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void clearCandle() {
        if (this.pnlBar1 != null) {
            this.pnlBar1.clear();
        }
    }

    private void updateCandle() {
        try {
            MarketFeed mktFeed = this.mediator.MwPanel.GetSingleFeed(this.Symbol, this.Market);
            if (this.pnlBar1 != null) {
                String cps;
                double uppercap = 0.0;
                double lowerlock = 0.0;
                String Key2 = this.txtSymbol.getText() + ":" + this.Market;
                if (LogsTC.CAPForGraph.containsKey(Key2) && (cps = LogsTC.CAPForGraph.get(Key2)).length() > 0) {
                    uppercap = Double.parseDouble(cps.split(":")[0]);
                    lowerlock = Double.parseDouble(cps.split(":")[1]);
                }
                if (mktFeed != null) {
                    this.pnlBar1.updateData(mktFeed, uppercap, lowerlock);
                    this.pnlBar1.validate();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void clearRetaInPanel() {
        Color color = Color.BLUE;
        this.lblimage.setIcon(ExchangeStats.loadImage("level.png"));
        this.lblrateleft.setText("000.00 (0.00");
        this.lblrateright.setText("0.00%)");
        this.lblrateleft.setForeground(Color.BLUE);
        this.lblrateright.setForeground(Color.BLUE);
    }

    private void updateRateInPanel() {
        try {
            MarketFeed mktFeed = this.mediator.MwPanel.GetSingleFeed(this.Symbol, this.Market);
            if (mktFeed != null) {
                double change = Double.parseDouble(mktFeed.change);
                double ltrdPrice = Double.parseDouble(mktFeed.lTrdPrice);
                double percentage = change / (ltrdPrice - change) * 100.0;
                Color color = Color.BLUE;
                if (change > 0.0) {
                    color = Util.convertToColor((String)"#009900", (Color)Color.GREEN);
                } else if (change < 0.0) {
                    color = Color.RED;
                }
                this.lblrateleft.setText(Util.format2digit((String)(ltrdPrice + "")) + " (" + Util.format2digit((String)(change + "")));
                this.lblrateright.setText(Util.format2digit((String)(percentage + "")) + "%)");
                if (change == 0.0) {
                    this.lblimage.setIcon(ExchangeStats.loadImage("level.png"));
                    this.lblrateleft.setForeground(Color.BLUE);
                    this.lblrateright.setForeground(Color.BLUE);
                } else if (change > 0.0) {
                    this.lblimage.setIcon(ExchangeStats.loadImage("up.png"));
                    this.lblrateleft.setForeground(Util.convertToColor((String)"#009900", (Color)Color.GREEN));
                    this.lblrateright.setForeground(Util.convertToColor((String)"#009900", (Color)Color.GREEN));
                } else if (change < 0.0) {
                    this.lblimage.setIcon(ExchangeStats.loadImage("down.png"));
                    this.lblrateleft.setForeground(Color.RED);
                    this.lblrateright.setForeground(Color.RED);
                }
                this.pnlRate_left.validate();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void ChartChanged(String str) {
        this.InitilizeWindow();
    }

    public void ZoomIn(ChartActionEvent e) {
        this.pnlIntraday.ZoomIn(e);
    }

    public void ZoomOut(ChartActionEvent e) {
        this.pnlIntraday.ZoomOut(e);
    }

    public void ResetZoom(ChartActionEvent e) {
        this.pnlIntraday.ResetZoom(e);
    }

    public void setInterval(ChartActionEvent e) {
        this.pnlIntraday.setInterval(e);
    }

    public void setChartType(ChartActionEvent e) {
        PnlIntraday.lastChartType = e.getChartType();
        this.InitilizeWindow();
    }

    public void ChangeSymbol(ChartActionEvent e) {
        this.setPrefrence(e.getMarket().toUpperCase(), e.getSymbol().toUpperCase());
    }

    public void AddIndicator(ChartActionEvent e) {
        this.pnlIntraday.AddIndicator(e);
    }

    public void Detach() {
        if (this.frame == null) {
            this.showInFrmae();
        } else {
            this.showInJDialog();
        }
    }

    public void drawLoading(Graphics g) {
        if (this.img == null) {
            this.img = new ImageIcon(this.getClass().getResource("/Images/loaderbgblack.gif")).getImage();
        }
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, this.pnlChartRegion.getWidth(), this.pnlChartRegion.getHeight());
        g.drawImage(this.img, this.pnlChartRegion.getWidth() / 2 - this.img.getWidth(this) / 2, this.pnlChartRegion.getHeight() / 2 - this.img.getHeight(this) / 2, this);
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.rightSplitPane = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.cbMarket = new JComboBox();
        this.jLabel6 = new JLabel();
        this.cbType = new JComboBox();
        this.txtSymbol = new JTextField(10);
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.spPrice = new JSpinner();
        this.jLabel5 = new JLabel();
        this.cbAccountNo = new JComboBox();
        this.jLabel7 = new JLabel();
        this.txtPinCode = new JPasswordField();
        this.cbSave = new JCheckBox();
        jLabel8 = new JLabel();
        this.txtLimit = new JTextField(10);
        jLabel9 = new JLabel();
        this.txtDisclosedVolume = new JTextField(10);
        this.btnBuy = new JButton();
        this.btnSell = new JButton();
        this.lblMessage = new JLabel();
        this.lblForgetPinCode = new JLabel();
        this.spVolume = new JSpinner();
        this.sepOrder = new JSeparator();
        this.leftSplitPane = new JPanel();
        this.pnlTop = new JPanel();
        this.jLabel20 = new JLabel();
        this.pnlRate_left = new JPanel();
        this.lblrateleft = new JLabel();
        this.lblimage = new JLabel();
        this.lblrateright = new JLabel();
        this.jLabel21 = new JLabel();
        this.pnlRate_right = new JPanel();
        this.lblSymbolName = new JLabel();
        this.lblScripDetails = new JLabel();
        this.lblIndexGraph = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.pnlSeprator = new JPanel();
        this.seprator1 = new JSeparator();
        this.pnlBottom = new JPanel();
        this.jLabel18 = new JLabel();
        this.pnlBar1 = new pnlBar();
        this.jLabel16 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabel17 = new JLabel();
        this.pnlChart = new JPanel();
        this.optionPanel1 = new OptionPanel();
        this.pnlChartRegion = new JPanel(){

            @Override
            public void paint(Graphics g) {
                if (NewOrder.this.isLoading) {
                    NewOrder.this.drawLoading(g);
                } else {
                    super.paint(g);
                }
            }
        };
        this.jLabel19 = new JLabel();
        this.pnlGap = new JPanel();
        this.setMinimumSize(new Dimension(750, 200));
        this.setPreferredSize(new Dimension(750, 200));
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                NewOrder.this.formKeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                NewOrder.this.formKeyReleased(evt);
            }
        });
        this.jSplitPane1.setDividerLocation(5000);
        this.jSplitPane1.setDividerSize(7);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(1.0);
        this.jSplitPane1.setLastDividerLocation(5000);
        this.jSplitPane1.setMinimumSize(new Dimension(700, 450));
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jSplitPane1.setPreferredSize(new Dimension(750, 450));
        this.jSplitPane1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                NewOrder.this.jSplitPane1MouseClicked(evt);
            }
        });
        this.rightSplitPane.setBorder(BorderFactory.createTitledBorder(""));
        this.rightSplitPane.setMaximumSize(new Dimension(230, 130));
        this.rightSplitPane.setMinimumSize(new Dimension(230, 130));
        this.rightSplitPane.setPreferredSize(new Dimension(230, 130));
        this.rightSplitPane.setLayout(null);
        this.jLabel1.setText("Scrip");
        this.rightSplitPane.add(this.jLabel1);
        this.jLabel1.setBounds(280, 10, 40, 20);
        this.jLabel2.setText("Market");
        this.rightSplitPane.add(this.jLabel2);
        this.jLabel2.setBounds(20, 10, 40, 10);
        this.cbMarket.setModel(new DefaultComboBoxModel<String>(new String[]{"REG", "FUT"}));
        this.cbMarket.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                NewOrder.this.cbMarketItemStateChanged(evt);
            }
        });
        this.cbMarket.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                NewOrder.this.cbMarketKeyReleased(evt);
            }
        });
        this.rightSplitPane.add(this.cbMarket);
        this.cbMarket.setBounds(10, 30, 60, 20);
        this.jLabel6.setText("Type:");
        this.rightSplitPane.add(this.jLabel6);
        this.jLabel6.setBounds(110, 10, 40, 14);
        this.cbType.setModel(new DefaultComboBoxModel<String>(new String[]{"Limit Order", "Stop Loss Order", "Market Order", "Short Sell Order"}));
        this.cbType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewOrder.this.cbTypeActionPerformed(evt);
            }
        });
        this.cbType.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                NewOrder.this.cbTypeKeyReleased(evt);
            }
        });
        this.rightSplitPane.add(this.cbType);
        this.cbType.setBounds(80, 30, 90, 20);
        this.txtSymbol.setEditable(false);
        this.txtSymbol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewOrder.this.txtSymbolActionPerformed(evt);
            }
        });
        this.txtSymbol.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                NewOrder.this.txtSymbolKeyReleased(evt);
            }
        });
        this.rightSplitPane.add(this.txtSymbol);
        this.txtSymbol.setBounds(260, 30, 70, 20);
        this.jLabel3.setText("Volume");
        this.rightSplitPane.add(this.jLabel3);
        this.jLabel3.setBounds(190, 10, 40, 20);
        this.jLabel4.setText("Price");
        this.rightSplitPane.add(this.jLabel4);
        this.jLabel4.setBounds(360, 10, 30, 20);
        this.rightSplitPane.add(this.spPrice);
        this.spPrice.setBounds(340, 30, 70, 20);
        this.jLabel5.setText("Account");
        this.rightSplitPane.add(this.jLabel5);
        this.jLabel5.setBounds(440, 10, 50, 20);
        this.cbAccountNo.setEditable(true);
        this.cbAccountNo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.rightSplitPane.add(this.cbAccountNo);
        this.cbAccountNo.setBounds(420, 30, 80, 20);
        this.jLabel7.setText("PIN");
        this.rightSplitPane.add(this.jLabel7);
        this.jLabel7.setBounds(530, 10, 30, 20);
        this.txtPinCode.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                NewOrder.this.txtPinCodeKeyReleased(evt);
            }
        });
        this.rightSplitPane.add(this.txtPinCode);
        this.txtPinCode.setBounds(510, 30, 60, 20);
        this.cbSave.setText("Save");
        this.cbSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewOrder.this.cbSaveActionPerformed(evt);
            }
        });
        this.cbSave.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                NewOrder.this.cbSaveKeyReleased(evt);
            }
        });
        this.rightSplitPane.add(this.cbSave);
        this.cbSave.setBounds(580, 20, 60, 20);
        jLabel8.setText("Limit Price");
        this.rightSplitPane.add(jLabel8);
        jLabel8.setBounds(20, 60, 50, 10);
        this.txtLimit.setEditable(false);
        this.txtLimit.setHorizontalAlignment(4);
        this.txtLimit.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                NewOrder.this.txtLimitKeyReleased(evt);
            }
        });
        this.rightSplitPane.add(this.txtLimit);
        this.txtLimit.setBounds(10, 80, 70, 20);
        jLabel9.setText("Disclosed Volume");
        this.rightSplitPane.add(jLabel9);
        jLabel9.setBounds(100, 60, 90, 10);
        this.txtDisclosedVolume.setEditable(false);
        this.txtDisclosedVolume.setHorizontalAlignment(4);
        this.txtDisclosedVolume.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                NewOrder.this.txtDisclosedVolumeKeyReleased(evt);
            }
        });
        this.rightSplitPane.add(this.txtDisclosedVolume);
        this.txtDisclosedVolume.setBounds(90, 80, 100, 20);
        this.btnBuy.setIcon(new ImageIcon(this.getClass().getResource("/Images/Buy.jpg")));
        this.btnBuy.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.btnBuy.setPreferredSize(new Dimension(125, 29));
        this.btnBuy.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                NewOrder.this.btnBuyMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                NewOrder.this.btnBuyMouseExited(evt);
            }
        });
        this.btnBuy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewOrder.this.btnBuyActionPerformed(evt);
            }
        });
        this.rightSplitPane.add(this.btnBuy);
        this.btnBuy.setBounds(400, 60, 80, 20);
        this.btnSell.setIcon(new ImageIcon(this.getClass().getResource("/Images/Sell.jpg")));
        this.btnSell.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.btnSell.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                NewOrder.this.btnSellMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                NewOrder.this.btnSellMouseExited(evt);
            }
        });
        this.btnSell.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewOrder.this.btnSellActionPerformed(evt);
            }
        });
        this.rightSplitPane.add(this.btnSell);
        this.btnSell.setBounds(490, 60, 80, 20);
        this.lblMessage.setText(" ");
        this.rightSplitPane.add(this.lblMessage);
        this.lblMessage.setBounds(10, 110, 630, 20);
        this.lblForgetPinCode.setText("  Forgot PIN?");
        this.rightSplitPane.add(this.lblForgetPinCode);
        this.lblForgetPinCode.setBounds(580, 40, 70, 20);
        this.spVolume.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                NewOrder.this.spVolumeKeyReleased(evt);
            }
        });
        this.rightSplitPane.add(this.spVolume);
        this.spVolume.setBounds(180, 30, 70, 20);
        this.rightSplitPane.add(this.sepOrder);
        this.sepOrder.setBounds(0, 105, 3000, 2);
        this.jSplitPane1.setRightComponent(this.rightSplitPane);
        this.leftSplitPane.setMinimumSize(new Dimension(508, 25));
        this.leftSplitPane.setPreferredSize(new Dimension(898, 300));
        this.leftSplitPane.setLayout(new BoxLayout(this.leftSplitPane, 1));
        this.pnlTop.setMaximumSize(new Dimension(65534, 30));
        this.pnlTop.setPreferredSize(new Dimension(800, 30));
        this.pnlTop.setLayout(new BoxLayout(this.pnlTop, 0));
        this.jLabel20.setMaximumSize(new Dimension(5, 5));
        this.jLabel20.setMinimumSize(new Dimension(5, 5));
        this.jLabel20.setPreferredSize(new Dimension(5, 5));
        this.pnlTop.add(this.jLabel20);
        this.pnlRate_left.setMaximumSize(new Dimension(200, 30));
        this.pnlRate_left.setPreferredSize(new Dimension(200, 30));
        this.lblrateleft.setFont(new Font("Tahoma", 1, 11));
        this.lblrateleft.setForeground(new Color(51, 0, 255));
        this.lblrateleft.setHorizontalAlignment(4);
        this.lblrateleft.setText("000.00 (0.00");
        this.lblrateleft.setMaximumSize(new Dimension(81, 30));
        this.lblrateleft.setMinimumSize(new Dimension(81, 30));
        this.lblrateleft.setPreferredSize(new Dimension(81, 30));
        this.lblimage.setFont(new Font("Tahoma", 1, 12));
        this.lblimage.setForeground(new Color(51, 0, 255));
        this.lblimage.setIcon(new ImageIcon(this.getClass().getResource("/Images/level.png")));
        this.lblimage.setMaximumSize(new Dimension(10, 30));
        this.lblimage.setMinimumSize(new Dimension(10, 30));
        this.lblimage.setPreferredSize(new Dimension(10, 30));
        this.lblrateright.setFont(new Font("Tahoma", 1, 11));
        this.lblrateright.setForeground(new Color(51, 0, 255));
        this.lblrateright.setText("0.00%)");
        this.lblrateright.setMaximumSize(new Dimension(47, 30));
        this.lblrateright.setMinimumSize(new Dimension(47, 30));
        this.lblrateright.setPreferredSize(new Dimension(47, 30));
        GroupLayout pnlRate_leftLayout = new GroupLayout(this.pnlRate_left);
        this.pnlRate_left.setLayout(pnlRate_leftLayout);
        pnlRate_leftLayout.setHorizontalGroup(pnlRate_leftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlRate_leftLayout.createSequentialGroup().addContainerGap().addComponent(this.lblrateleft, -2, 105, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblimage, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblrateright, -2, 69, -2).addContainerGap(-1, Short.MAX_VALUE)));
        pnlRate_leftLayout.setVerticalGroup(pnlRate_leftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlRate_leftLayout.createSequentialGroup().addGroup(pnlRate_leftLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblrateright, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.lblimage, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.lblrateleft, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.pnlTop.add(this.pnlRate_left);
        this.jLabel21.setMaximumSize(new Dimension(5, 5));
        this.jLabel21.setMinimumSize(new Dimension(5, 5));
        this.jLabel21.setPreferredSize(new Dimension(5, 5));
        this.pnlTop.add(this.jLabel21);
        this.pnlRate_right.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        this.pnlRate_right.setPreferredSize(new Dimension(512, 30));
        this.lblSymbolName.setFont(new Font("Tahoma", 0, 18));
        this.lblSymbolName.setText("Symbol");
        this.lblSymbolName.setMaximumSize(new Dimension(65, 30));
        this.lblSymbolName.setMinimumSize(new Dimension(65, 30));
        this.lblSymbolName.setPreferredSize(new Dimension(65, 30));
        this.lblScripDetails.setFont(new Font("Tahoma", 1, 11));
        this.lblScripDetails.setHorizontalAlignment(0);
        this.lblScripDetails.setIcon(new ImageIcon(this.getClass().getResource("/Images/detailQuote.png")));
        this.lblScripDetails.setText("Detail Quote");
        this.lblScripDetails.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                NewOrder.this.lblScripDetailsMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                NewOrder.this.lblScripDetailsMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                NewOrder.this.lblScripDetailsMousePressed(evt);
            }
        });
        this.lblIndexGraph.setFont(new Font("Tahoma", 1, 11));
        this.lblIndexGraph.setHorizontalAlignment(0);
        this.lblIndexGraph.setIcon(new ImageIcon(this.getClass().getResource("/Images/indexgraph.png")));
        this.lblIndexGraph.setText("Index Graph");
        this.lblIndexGraph.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                NewOrder.this.lblIndexGraphMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                NewOrder.this.lblIndexGraphMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                NewOrder.this.lblIndexGraphMousePressed(evt);
            }
        });
        this.jSeparator2.setOrientation(1);
        this.jSeparator2.setPreferredSize(new Dimension(10, 0));
        GroupLayout pnlRate_rightLayout = new GroupLayout(this.pnlRate_right);
        this.pnlRate_right.setLayout(pnlRate_rightLayout);
        pnlRate_rightLayout.setHorizontalGroup(pnlRate_rightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlRate_rightLayout.createSequentialGroup().addContainerGap().addComponent(this.lblSymbolName, -1, 286, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblIndexGraph, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblScripDetails, -2, 112, -2).addContainerGap()));
        pnlRate_rightLayout.setVerticalGroup(pnlRate_rightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlRate_rightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblSymbolName, -1, -1, Short.MAX_VALUE).addComponent(this.lblIndexGraph, -2, 30, -2).addComponent(this.lblScripDetails, -1, 30, Short.MAX_VALUE)).addGroup(pnlRate_rightLayout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jSeparator2, -2, 22, -2).addGap(5, 5, 5)));
        pnlRate_rightLayout.linkSize(1, this.lblScripDetails, this.lblSymbolName);
        this.pnlTop.add(this.pnlRate_right);
        this.leftSplitPane.add(this.pnlTop);
        this.pnlSeprator.setPreferredSize(new Dimension(898, 5));
        GroupLayout pnlSepratorLayout = new GroupLayout(this.pnlSeprator);
        this.pnlSeprator.setLayout(pnlSepratorLayout);
        pnlSepratorLayout.setHorizontalGroup(pnlSepratorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlSepratorLayout.createSequentialGroup().addContainerGap().addComponent(this.seprator1, -1, 728, Short.MAX_VALUE).addContainerGap()));
        pnlSepratorLayout.setVerticalGroup(pnlSepratorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.seprator1, -2, -1, -2));
        this.leftSplitPane.add(this.pnlSeprator);
        this.pnlBottom.setLayout(new BoxLayout(this.pnlBottom, 0));
        this.jLabel18.setMaximumSize(new Dimension(5, 5));
        this.jLabel18.setMinimumSize(new Dimension(5, 5));
        this.jLabel18.setPreferredSize(new Dimension(5, 5));
        this.pnlBottom.add(this.jLabel18);
        this.pnlBar1.setMinimumSize(new Dimension(0, 0));
        this.pnlBar1.setPreferredSize(new Dimension(200, 100));
        this.pnlBottom.add((Component)this.pnlBar1);
        this.jLabel16.setMaximumSize(new Dimension(5, 5));
        this.jLabel16.setMinimumSize(new Dimension(5, 5));
        this.jLabel16.setPreferredSize(new Dimension(5, 5));
        this.pnlBottom.add(this.jLabel16);
        this.jSeparator1.setOrientation(1);
        this.pnlBottom.add(this.jSeparator1);
        this.jLabel17.setText("jLabel17");
        this.jLabel17.setMaximumSize(new Dimension(5, 5));
        this.jLabel17.setMinimumSize(new Dimension(5, 5));
        this.jLabel17.setPreferredSize(new Dimension(5, 5));
        this.pnlBottom.add(this.jLabel17);
        this.pnlChart.setBackground(new Color(204, 204, 255));
        this.pnlChart.setPreferredSize(new Dimension(516, 25));
        this.pnlChart.setLayout(new BoxLayout(this.pnlChart, 1));
        this.pnlChart.add((Component)this.optionPanel1);
        this.pnlChartRegion.setBackground(new Color(0, 0, 0));
        this.pnlChartRegion.setLayout(new BorderLayout());
        this.pnlChart.add(this.pnlChartRegion);
        this.pnlBottom.add(this.pnlChart);
        this.jLabel19.setMaximumSize(new Dimension(5, 5));
        this.jLabel19.setMinimumSize(new Dimension(5, 5));
        this.jLabel19.setPreferredSize(new Dimension(5, 5));
        this.pnlBottom.add(this.jLabel19);
        this.leftSplitPane.add(this.pnlBottom);
        this.pnlGap.setPreferredSize(new Dimension(748, 5));
        GroupLayout pnlGapLayout = new GroupLayout(this.pnlGap);
        this.pnlGap.setLayout(pnlGapLayout);
        pnlGapLayout.setHorizontalGroup(pnlGapLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 748, Short.MAX_VALUE));
        pnlGapLayout.setVerticalGroup(pnlGapLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 5, Short.MAX_VALUE));
        this.leftSplitPane.add(this.pnlGap);
        this.jSplitPane1.setLeftComponent(this.leftSplitPane);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, -1, Short.MAX_VALUE));
    }

    private void formKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 27) {
            // empty if block
        }
    }

    private void formKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 27) {
            // empty if block
        }
    }

    private void btnSellActionPerformed(ActionEvent evt) {
        this.btnSell.setIcon(new ImageIcon(this.getClass().getResource("/Images/Sell-pressed.jpg")));
        this.ExecuteOrder("SELL");
    }

    private void btnBuyActionPerformed(ActionEvent evt) {
        this.btnBuy.setIcon(new ImageIcon(this.getClass().getResource("/Images/Buy-pressed.jpg")));
        this.ExecuteOrder("BUY");
    }

    private void txtDisclosedVolumeKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            if (this.txtDisclosedVolume.getText().trim().length() <= 0) {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please enter disclosed volume.");
                return;
            }
            this.btnBuy.requestFocus();
        }
    }

    private void txtLimitKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            if (this.txtLimit.getText().trim().length() <= 0) {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please enter limit price.");
                return;
            }
            if (this.txtDisclosedVolume.isEnabled()) {
                this.txtDisclosedVolume.requestFocus();
            } else {
                this.btnBuy.requestFocus();
            }
        }
    }

    private void cbSaveKeyReleased(KeyEvent evt) {
    }

    private void cbSaveActionPerformed(ActionEvent evt) {
        LogCommon.pinCode = this.cbSave.isSelected() ? this.txtPinCode.getText() : "";
    }

    private void txtPinCodeKeyReleased(KeyEvent evt) {
    }

    private void txtSymbolActionPerformed(ActionEvent evt) {
        if (this.txtSymbol.getText().trim().length() > 1) {
            ((JSpinner.DefaultEditor)this.spPrice.getEditor()).getTextField().requestFocus();
        }
    }

    private void cbTypeKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            ((JSpinner.DefaultEditor)this.spVolume.getEditor()).getTextField().requestFocus();
        }
    }

    private void cbMarketItemStateChanged(ItemEvent evt) {
    }

    private void cbMarketKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.cbType.requestFocus();
        }
    }

    private void txtSymbolKeyReleased(KeyEvent evt) {
    }

    private void cbTypeActionPerformed(ActionEvent evt) {
        String Typecom = "" + this.cbType.getSelectedItem();
        if (Typecom.equalsIgnoreCase("Limit Order")) {
            this.txtLimit.setText("");
            this.txtDisclosedVolume.setText("");
            this.txtLimit.setEnabled(false);
            this.txtDisclosedVolume.setEnabled(false);
            this.btnBuy.setEnabled(true);
            this.spPrice.setEnabled(true);
        } else if (Typecom.equalsIgnoreCase("Stop Loss Order")) {
            this.txtLimit.setEditable(true);
            this.txtLimit.setEnabled(true);
            this.btnBuy.setEnabled(true);
            this.spPrice.setEnabled(true);
        } else if (Typecom.equalsIgnoreCase("Market If Touch Order")) {
            this.txtLimit.setEditable(true);
            this.txtLimit.setEnabled(true);
            this.txtDisclosedVolume.setEditable(true);
            this.txtDisclosedVolume.setEnabled(true);
            this.btnBuy.setEnabled(true);
            this.spPrice.setEnabled(true);
        } else if (Typecom.equalsIgnoreCase("Market Order")) {
            this.txtLimit.setText("");
            this.txtDisclosedVolume.setText("");
            this.txtLimit.setEnabled(false);
            this.txtDisclosedVolume.setEnabled(false);
            this.btnBuy.setEnabled(true);
            this.btnSell.setEnabled(true);
            this.spPrice.setEnabled(false);
            this.spPrice.setValue(0);
        }
    }

    private void btnBuyMouseEntered(MouseEvent evt) {
        this.btnBuy.requestFocus();
    }

    private void btnSellMouseEntered(MouseEvent evt) {
        this.btnSell.requestFocus();
    }

    private void btnBuyMouseExited(MouseEvent evt) {
        this.btnBuy.setIcon(new ImageIcon(this.getClass().getResource("/Images/Buy.jpg")));
    }

    private void btnSellMouseExited(MouseEvent evt) {
        this.btnSell.setIcon(new ImageIcon(this.getClass().getResource("/Images/Sell.jpg")));
    }

    private void jSplitPane1MouseClicked(MouseEvent evt) {
    }

    private void spVolumeKeyReleased(KeyEvent evt) {
    }

    private void lblScripDetailsMouseEntered(MouseEvent evt) {
        if (AppConfig.isHistoricalDataWatch) {
            this.lblScripDetails.setText("<html><U>" + this.languageCentre.getValue(LanguageConstant.ScripDetail) + "<U></html>");
        } else {
            this.lblScripDetails.setText("<html><U>" + this.languageCentre.getValue(LanguageConstant.DetailedQuote) + "<U></html>");
        }
    }

    private void lblScripDetailsMouseExited(MouseEvent evt) {
        if (AppConfig.isHistoricalDataWatch) {
            this.lblScripDetails.setText("<html>" + this.languageCentre.getValue(LanguageConstant.ScripDetail) + "</html>");
        } else {
            this.lblScripDetails.setText("<html>" + this.languageCentre.getValue(LanguageConstant.DetailedQuote) + "</html>");
        }
    }

    private void lblScripDetailsMousePressed(MouseEvent evt) {
        if (AppConfig.isHistoricalDataWatch) {
            this.mediator.openScripDetails(this.Symbol);
        } else {
            this.openDetailQuote();
        }
    }

    private void lblIndexGraphMouseEntered(MouseEvent evt) {
        this.lblIndexGraph.setText("<html><U>" + this.languageCentre.getValue(LanguageConstant.IndexGraph) + "</U></html>");
    }

    private void lblIndexGraphMouseExited(MouseEvent evt) {
        this.lblIndexGraph.setText("<html>" + this.languageCentre.getValue(LanguageConstant.IndexGraph) + "</html>");
    }

    private void lblIndexGraphMousePressed(MouseEvent evt) {
        TradeCast.getInstance().ShowGraphWindow(FormName.IndexGraph, this.languageCentre.getValue(LanguageConstant.IndexGraph), "", "");
    }

    private void setTitle() {
        if (this.frame != null) {
            if (PnlIntraday.lastChartType == ChartType.PRICEVOLUME) {
                this.frame.setTitle(this.Symbol + " - " + this.languageCentre.getValue(LanguageConstant.PriceVolumeChart));
            } else {
                this.frame.setTitle(this.Symbol + " - " + this.languageCentre.getValue(LanguageConstant.BuySellChart));
            }
        } else if (this.window != null) {
            if (PnlIntraday.lastChartType == ChartType.PRICEVOLUME) {
                this.window.setTitle(this.Symbol + " - " + this.languageCentre.getValue(LanguageConstant.PriceVolumeChart));
            } else {
                this.window.setTitle(this.Symbol + " - " + this.languageCentre.getValue(LanguageConstant.BuySellChart));
            }
        }
    }

    public void setPrefrence(String market, String SelectedSymbol) {
        if (this.isLoading) {
            return;
        }
        if (market.trim().length() <= 0) {
            market = UtilKSE.GetMarketFromsymbol((String)SelectedSymbol);
        }
        this.Market = market;
        this.Symbol = SelectedSymbol;
        this.CheckAndLoadCapValues();
        String tempSymbol = SelectedSymbol.trim().split("\\-", -1)[0];
        if (SelectedSymbol.length() > 0 && LogCommon.SymbolAndSymbolName.size() > 0 && !LogCommon.SymbolAndSymbolName.containsKey(tempSymbol)) {
            MyOptionPane.showMessage(MessageType.Error, "Invalid Scrip", this.languageCentre.getValue(LanguageConstant.GraphsAndCharts), true);
            return;
        }
        this.setTitle();
        this.optionPanel1.setSymbol(SelectedSymbol);
        this.optionPanel1.setMarket(market);
        this.setPrefrenceOld(market, SelectedSymbol);
        this.txtSymbol.setText(SelectedSymbol);
        this.cbMarket.setSelectedItem(market);
        if (!LogsTC.GraphSymbol.contains(this.Symbol)) {
            LogsTC.GraphSymbol.add(this.Symbol);
        }
        String Sector = "";
        if (UtilTC.getScripSector(tempSymbol).length() > 0) {
            Sector = UtilTC.getScripSector(tempSymbol) + " Sector";
        }
        if (LogCommon.SymbolAndSymbolName.containsKey(tempSymbol)) {
            this.lblSymbolName.setText("<HTML><table><tr><td nowrap='nowrap'><font size='5'>" + ((String)LogCommon.SymbolAndSymbolName.get(tempSymbol)).toString() + "</font><font size='3'>  " + Sector + "</font></td><tr><table></HTML>");
        } else {
            this.lblSymbolName.setText("");
        }
        this.InitilizeWindow();
    }

    public void setPrefrenceOld(String market, String symbol) {
        try {
            this.txtDisclosedVolume.setText("");
            this.txtLimit.setText("");
            this.spPrice.setValue(0);
            this.txtSymbol.setText("");
            this.spVolume.setValue(0);
            this.cbMarket.setModel(new DefaultComboBoxModel<String>(LogCommon.markets));
            if (LogCommon.pinCode.length() > 0) {
                this.txtPinCode.setText(LogCommon.pinCode);
                this.cbSave.setSelected(true);
            }
            if (LogCommon.preferredAccount.equalsIgnoreCase("")) {
                this.cbAccountNo.setSelectedItem("");
            } else {
                this.cbAccountNo.setSelectedItem(LogCommon.preferredAccount);
            }
            this.cbMarket.requestFocus();
            if (symbol.indexOf(":") > 0) {
                this.txtSymbol.setText(symbol.split(":")[0]);
                this.cbMarket.setSelectedItem(symbol.split(":")[1]);
                this.feedSymbol = symbol;
                MarketFeed mktFeed = this.mediator.MwPanel.GetSingleFeed(symbol.split(":")[0], symbol.split(":")[1]);
                if (mktFeed == null) {
                    this.spPrice.setValue(0);
                } else {
                    this.spPrice.setValue(0);
                }
            } else {
                this.feedSymbol = symbol + ":" + market;
                this.cbMarket.setSelectedItem(market);
                this.txtSymbol.setText(symbol);
                MarketFeed mktFeed = this.mediator.MwPanel.GetSingleFeed(symbol, market);
                if (mktFeed == null) {
                    this.spPrice.setValue(0);
                } else {
                    this.spPrice.setValue(0);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void CheckAndLoadCapValues() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    LoginServer port;
                    byte[] bdata;
                    String result;
                    if (LogsTC.CAPForGraph.size() < 1 && (result = CompressManager.unzipStringFromBytes(bdata = (port = WebService.getInstance().getPort()).getCompressedData(LogCommon.UserID, "CAP_VALUES_FOR_CHART", ""))).length() > 0) {
                        String[] data = result.split("\\|", -1);
                        for (int i = 0; i < data.length; ++i) {
                            String[] symbolCAP;
                            if (data[i].indexOf(";") < 0 || (symbolCAP = data[i].split("\\;", -1)).length <= 3 || LogsTC.CAPForGraph.contains(symbolCAP[0] + ":" + symbolCAP[1])) continue;
                            LogsTC.CAPForGraph.put(symbolCAP[0] + ":" + symbolCAP[1], symbolCAP[2] + ":" + symbolCAP[3]);
                        }
                        NewOrder.this.updateCandle();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public boolean IsPriceInRange() {
        boolean Ret = true;
        if (!LogsKSE.CheckPriceLimit) {
            return Ret;
        }
        String Scrip = this.txtSymbol.getText().trim();
        String market = this.cbMarket.getSelectedItem().toString().trim();
        double uppercap = 0.0;
        double lowerlock = 0.0;
        try {
            double Price;
            String cps = this.mediator.logsCommon.getCaps(Scrip, market);
            if (cps.length() > 0) {
                uppercap = Double.parseDouble(cps.split(":")[0]);
                lowerlock = Double.parseDouble(cps.split(":")[1]);
            }
            if (uppercap > 0.0 && lowerlock > 0.0 && ((Price = Double.parseDouble(this.spPrice.getValue().toString())) > uppercap || Price < lowerlock)) {
                PriceOutOfRange pricerange = new PriceOutOfRange(TradeCast.getInstance().frame, true, Scrip, Price + "", uppercap + "", lowerlock + "");
                Ret = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Ret;
    }

    public void ExecuteOrder(String btnType) {
        this.transactionType = btnType;
        boolean result = false;
        this.isInvalidPrice = false;
        this.isInvalidVolume = false;
        String orderType = this.cbType.getSelectedItem().toString().trim();
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
        if (this.txtSymbol.getText().trim().length() < 1) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please enter scrip.");
            this.setOrderMessagePopup("Please enter scrip");
            this.txtSymbol.requestFocus();
            return;
        }
        if (this.spVolume.getValue().toString().trim().length() < 1) {
            this.isInvalidVolume = true;
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please enter volume.");
            this.setOrderMessagePopup("Please enter volume");
            ((JSpinner.DefaultEditor)this.spVolume.getEditor()).getTextField().requestFocus();
            this.setInvalideVolume();
            return;
        }
        if (this.spVolume.getValue().toString().trim().equalsIgnoreCase("0")) {
            this.isInvalidVolume = true;
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please enter volume.");
            this.setOrderMessagePopup("Please enter volume");
            ((JSpinner.DefaultEditor)this.spVolume.getEditor()).getTextField().requestFocus();
            this.setInvalideVolume();
            return;
        }
        if (this.spPrice.getValue().toString().length() < 1 && this.spPrice.isEnabled()) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please enter price.");
            this.setOrderMessagePopup("Please enter price");
            ((JSpinner.DefaultEditor)this.spPrice.getEditor()).getTextField().requestFocus();
            return;
        }
        if (this.spPrice.getValue().toString().trim().equalsIgnoreCase("0") && this.spPrice.isEnabled()) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please enter price.");
            this.setOrderMessagePopup("Please enter price");
            ((JSpinner.DefaultEditor)this.spPrice.getEditor()).getTextField().requestFocus();
            return;
        }
        if (this.cbAccountNo.getSelectedItem() == null) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please enter account.");
            this.setOrderMessagePopup("Please enter account");
            this.cbAccountNo.requestFocus();
            return;
        }
        if (this.cbAccountNo.getSelectedItem().toString().length() < 1) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please enter account.");
            this.setOrderMessagePopup("Please enter account");
            this.cbAccountNo.requestFocus();
            return;
        }
        if (this.txtPinCode.getText().trim().length() < 1) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please enter PIN.");
            this.setOrderMessagePopup("Please enter PIN");
            this.txtPinCode.requestFocus();
            return;
        }
        if (orderType.equalsIgnoreCase("Stop Loss Order") && this.txtLimit.getText().trim().length() < 1) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please enter limit price.");
            this.txtLimit.requestFocus();
            return;
        }
        if (this.cbMarket.getSelectedItem().toString().equalsIgnoreCase("FUT")) {
            String sym = this.txtSymbol.getText();
            if (sym.indexOf("-") >= 0) {
                boolean isFut = false;
                String[] ss = sym.split("\\-", -1);
                String[] MarketMonth = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
                for (int i = 0; i < MarketMonth.length; ++i) {
                    if (ss[1].toUpperCase().indexOf(MarketMonth[i]) < 0) continue;
                    isFut = true;
                    break;
                }
                if (!isFut) {
                    Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Invalid Scrip");
                    this.setOrderMessagePopup("Invalid Scrip");
                    this.txtSymbol.requestFocus();
                    return;
                }
            } else {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Invalid Scrip");
                this.setOrderMessagePopup("Invalid Scrip");
                return;
            }
        }
        try {
            int iVol = Integer.parseInt(this.spVolume.getValue().toString());
            if (iVol < 1) {
                this.isInvalidVolume = true;
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Invalid volume.");
                ((JSpinner.DefaultEditor)this.spVolume.getEditor()).getTextField().requestFocus();
                this.setInvalideVolume();
                return;
            }
        }
        catch (Exception e) {
            this.isInvalidVolume = true;
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Invalid volume.");
            ((JSpinner.DefaultEditor)this.spVolume.getEditor()).getTextField().requestFocus();
            this.setInvalideVolume();
            return;
        }
        try {
            double dPrice = Double.parseDouble(this.spPrice.getValue().toString());
            if (dPrice <= 0.0 && this.spPrice.isEnabled()) {
                this.isInvalidPrice = true;
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Invalid price.");
                ((JSpinner.DefaultEditor)this.spPrice.getEditor()).getTextField().requestFocus();
                this.setInvalidePrice();
                return;
            }
        }
        catch (Exception e) {
            this.isInvalidPrice = true;
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Invalid price.");
            ((JSpinner.DefaultEditor)this.spPrice.getEditor()).getTextField().requestFocus();
            this.setInvalidePrice();
            return;
        }
        if (orderType.equalsIgnoreCase("Market Order")) {
            orderType = "MKT";
        } else if (orderType.equalsIgnoreCase("Stop Loss Order")) {
            orderType = "SLO";
            if (LogsKSE.MarketStauts.equalsIgnoreCase("OHO") || LogsKSE.MarketStauts.equalsIgnoreCase("OHP")) {
                new Thread(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, "Stop Loss Order is not allowed in Off Hour Transaction");
                    }
                }.start();
                return;
            }
        }
        OrderBean bean = new OrderBean();
        bean.setMarket(this.cbMarket.getSelectedItem().toString());
        bean.setScrip(this.txtSymbol.getText());
        bean.setVolume(this.spVolume.getValue().toString());
        bean.setPrice(this.spPrice.getValue().toString());
        bean.setOrderType(orderType);
        bean.setAccount(this.cbAccountNo.getSelectedItem().toString());
        bean.setPIN(this.txtPinCode.getText());
        bean.setOrderTransactionType(btnType);
        if (bean.getOrderType().equalsIgnoreCase("Stop Loss Order") || bean.getOrderType().equalsIgnoreCase("SLO")) {
            bean.setLimit(Double.parseDouble(this.txtLimit.getText()));
        }
        if (!bean.getOrderType().equalsIgnoreCase("MKT") && !this.IsPriceInRange()) {
            this.isInvalidPrice = true;
            ((JSpinner.DefaultEditor)this.spPrice.getEditor()).getTextField().requestFocus();
            this.setInvalidePrice();
            return;
        }
        if (LogCommon.isConfirmation) {
            OrderConfirmation OC = new OrderConfirmation(btnType, bean, false);
            final JDialog jd = new JDialog((Frame)TradeCast.getInstance().frame, true);
            try {
                if (AppConfig.houseIcon == null) {
                    AppConfig.houseIcon = ImageUtil.downloadImage((String)(AppConfig.TradeCastURL + "/HouseImages/small.png"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            jd.setIconImage(AppConfig.houseIcon);
            jd.getContentPane().add(OC);
            jd.setTitle(this.languageCentre.getValue(btnType.replaceAll("\\s", "")) + " " + this.languageCentre.getValue(LanguageConstant.OrderConfirmation));
            if (Util.isWindow7()) {
                jd.setSize(310, 215);
            } else {
                jd.setSize(320, 220);
            }
            Toolkit kit = Toolkit.getDefaultToolkit();
            Dimension d = kit.getScreenSize();
            jd.setLocation(new Point((d.width - 320) / 2, (d.height - 190) / 2));
            jd.setResizable(false);
            jd.setVisible(true);
            KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
            InputMap inputMap = jd.getRootPane().getInputMap(2);
            inputMap.put(stroke, "ESCAPE");
            AbstractAction action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    jd.dispose();
                }
            };
            jd.getRootPane().getActionMap().put("ESCAPE", action);
        } else {
            String TransType = "";
            if (btnType.equalsIgnoreCase("BUY")) {
                TransType = "BUY";
            } else if (btnType.equalsIgnoreCase("SELL") || btnType.equalsIgnoreCase("SEL")) {
                TransType = "SEL";
            } else if (btnType.equalsIgnoreCase("Stop Loss Order")) {
                TransType = "SLO";
            }
            if (bean.getOrderType().equalsIgnoreCase("SLO")) {
                if (LogsKSE.MarketStauts.equalsIgnoreCase("OHO") || LogsKSE.MarketStauts.equalsIgnoreCase("OHP")) {
                    JOptionPane.showMessageDialog(null, "Stop Loss Order is not allowed in Off Hour Transaction");
                } else {
                    result = this.mediator.SendOrderSLO(bean);
                }
            } else if (bean.getOrderType().equalsIgnoreCase("MKT")) {
                result = this.mediator.SendMarketOrder(bean);
            } else {
                bean.setOrderTransactionType(TransType);
                result = this.mediator.SendOrder(bean);
            }
        }
        if (!this.cbSave.isSelected()) {
            this.txtPinCode.setText("");
        }
        this.reset(result);
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
    }

    @Override
    public void focusGained(FocusEvent e) {
        Object source = e.getSource();
        if (source == this.cbMarket) {
            return;
        }
        if (source == this.txtSymbol) {
            this.txtSymbol.selectAll();
            return;
        }
        if (source == this.cbType) {
            return;
        }
        if (source == ((JSpinner.DefaultEditor)this.spVolume.getEditor()).getTextField()) {
            JFormattedTextField textField = (JFormattedTextField)e.getComponent();
            textField.setText(textField.getText());
            textField.selectAll();
            return;
        }
        if (source == ((JSpinner.DefaultEditor)this.spPrice.getEditor()).getTextField()) {
            JFormattedTextField textField = (JFormattedTextField)e.getComponent();
            textField.setText(textField.getText());
            textField.selectAll();
            return;
        }
        if (source == this.cbAccountNo) {
            return;
        }
        if (source == this.txtPinCode) {
            this.txtPinCode.selectAll();
            return;
        }
        if (source == this.btnBuy) {
            this.btnBuy.setIcon(new ImageIcon(this.getClass().getResource("/Images/Buy-Over1.jpg")));
        } else if (source == this.btnSell) {
            this.btnSell.setIcon(new ImageIcon(this.getClass().getResource("/Images/Sell-Over1.jpg")));
        } else {
            return;
        }
    }

    @Override
    public void focusLost(FocusEvent evt) {
        Object source = evt.getSource();
        if (source == ((JSpinner.DefaultEditor)this.spPrice.getEditor()).getTextField()) {
            MarketFeed mktFeed;
            JFormattedTextField textField = (JFormattedTextField)evt.getComponent();
            try {
                Double.parseDouble(textField.getText().replace(",", ""));
            }
            catch (Exception e) {
                textField.setText("0");
            }
            if ((textField.getText().trim().equalsIgnoreCase("0") || textField.getText().trim().length() < 1) && (mktFeed = this.mediator.MwPanel.GetSingleFeed(this.txtSymbol.getText().trim(), this.cbMarket.getSelectedItem().toString())) != null) {
                textField.setText(Double.parseDouble(mktFeed.lTrdPrice) + "");
            }
        } else if (source == this.btnBuy) {
            this.btnBuy.setIcon(new ImageIcon(this.getClass().getResource("/Images/Buy.jpg")));
        } else if (source == this.btnSell) {
            this.btnSell.setIcon(new ImageIcon(this.getClass().getResource("/Images/Sell.jpg")));
        }
    }

    private void setOrderMessagePopup(String message) {
        if (LogCommon.isOrderMessageInPopup) {
            new OrderErrorPopup(message, true);
        }
    }

    public void reset(boolean result) {
        if (result) {
            this.spVolume.setValue(0);
            this.cbType.setSelectedItem("Limit Order");
            this.spPrice.setValue(0);
            if (LogCommon.preferredAccount.trim().length() > 0) {
                this.cbAccountNo.setSelectedItem(LogCommon.preferredAccount);
            } else {
                this.cbAccountNo.setSelectedItem("");
            }
            if (LogCommon.pinCode.length() > 0) {
                this.txtPinCode.setText(LogCommon.pinCode);
                this.cbSave.setSelected(true);
            }
            this.txtLimit.setText("");
            this.txtLimit.setEnabled(false);
            this.txtDisclosedVolume.setText("");
            this.txtDisclosedVolume.setEnabled(false);
            ((JSpinner.DefaultEditor)this.spVolume.getEditor()).getTextField().requestFocus();
        }
    }

    private void setInvalidePrice() {
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    NewOrder.this.isInvalidPrice = false;
                }
                NewOrder.this.isInvalidPrice = false;
            }
        }.start();
    }

    private void setInvalideVolume() {
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    NewOrder.this.isInvalidVolume = false;
                }
                NewOrder.this.isInvalidVolume = false;
            }
        }.start();
    }

    private void openDetailQuote() {
        try {
            TradeCast.getInstance().ShowDynamicForm(FormName.DetailedQuote, LanguageConstant.DetailedQuote);
            if (Mediator.getInstance().detailedQuote != null) {
                Mediator.getInstance().detailedQuote.AddSymbol(this.Market, this.Symbol);
                Mediator.getInstance().detailedQuote.setTitle("");
            }
        }
        catch (Exception ex) {
            Mediator.getInstance().PrintLog(ex, "");
        }
    }
}

