/*
 * Decompiled with CFR 0.152.
 */
package Control;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public class HttpPostRaw {
    private final int CONNECT_TIMEOUT = 15000;
    private final int READ_TIMEOUT = 60000;
    private HttpURLConnection httpConn;
    private String postData;
    private String charset;

    public HttpPostRaw(String requestURL, String charset, Map<String, String> headers, String postData) throws IOException {
        this.charset = charset;
        this.postData = postData;
        URL url = new URL(requestURL);
        this.httpConn = (HttpURLConnection)url.openConnection();
        this.httpConn.setConnectTimeout(15000);
        this.httpConn.setReadTimeout(60000);
        this.httpConn.setUseCaches(false);
        this.httpConn.setDoOutput(true);
        this.httpConn.setDoInput(true);
        this.httpConn.setRequestProperty("Content-Type", "text/plain");
        if (headers != null && headers.size() > 0) {
            for (String key : headers.keySet()) {
                String value = headers.get(key);
                this.httpConn.setRequestProperty(key, value);
            }
        }
    }

    public HttpPostRaw(String requestURL, String charset, Map<String, String> headers) throws IOException {
        this(requestURL, charset, headers, null);
    }

    public HttpPostRaw(String requestURL, String charset) throws IOException {
        this(requestURL, charset, null, null);
    }

    public void addHeader(String key, String value) {
        this.httpConn.setRequestProperty(key, value);
    }

    public void setPostData(String postData) {
        this.postData = postData;
    }

    private byte[] getParamsByte() {
        byte[] result = null;
        try {
            result = this.postData.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String finish() throws IOException {
        ByteArrayOutputStream result;
        String response = "";
        byte[] postDataBytes = this.getParamsByte();
        this.httpConn.getOutputStream().write(postDataBytes);
        int status = this.httpConn.getResponseCode();
        if (status == 200) {
            int length;
            result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = this.httpConn.getInputStream().read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
        } else {
            throw new IOException("Server returned non-OK status: " + status);
        }
        response = result.toString(this.charset);
        this.httpConn.disconnect();
        return response;
    }
}

