/*
 * Decompiled with CFR 0.152.
 */
package Control;

import Control.CheckJar;
import Control.ReportControlEvent;
import Control.ReportControlListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class ReportControl
extends JPanel {
    private CheckJar cj;
    private LanguageCentre languageCentre = new LanguageCentre();
    static boolean LoadingInProgress = false;
    public boolean RunReport = true;
    public static boolean FirstTimeCheck = true;
    static ActionType ActionBeforeLoading;
    private JButton btnCustomExport;
    private JButton btnPdf;
    private JButton btnPrint;
    private JButton btnSave;
    private JButton btnView;
    private JToolBar jToolBar1;
    private List _listeners = new ArrayList();

    public ReportControl() {
        this.initComponents();
        this.btnCustomExport.setVisible(false);
        this.setLanguageValues();
    }

    private void Save() {
        ReportControlEvent event = new ReportControlEvent(this);
        Iterator listeners = this._listeners.iterator();
        while (listeners.hasNext()) {
            ((ReportControlListener)listeners.next()).ReportControl_Save(event);
        }
    }

    private void Print() {
        ReportControlEvent event = new ReportControlEvent(this);
        Iterator listeners = this._listeners.iterator();
        while (listeners.hasNext()) {
            ((ReportControlListener)listeners.next()).ReportControl_Print(event);
        }
    }

    private void View() {
        ReportControlEvent event = new ReportControlEvent(this);
        Iterator listeners = this._listeners.iterator();
        while (listeners.hasNext()) {
            ((ReportControlListener)listeners.next()).ReportControl_View(event);
        }
    }

    private void GeneratePDF() {
        ReportControlEvent event = new ReportControlEvent(this);
        Iterator listeners = this._listeners.iterator();
        while (listeners.hasNext()) {
            ((ReportControlListener)listeners.next()).ReportControl_Pdf(event);
        }
    }

    private void CustomExport() {
        ReportControlEvent event = new ReportControlEvent(this);
        Iterator listeners = this._listeners.iterator();
        while (listeners.hasNext()) {
            ((ReportControlListener)listeners.next()).ReportControl_CustomExport(event);
        }
    }

    private void MyMethod(ActionType AT) {
        if (AT == ActionType.View) {
            this.View();
        } else if (AT == ActionType.Pdf) {
            this.GeneratePDF();
        } else if (AT == ActionType.Print) {
            this.Print();
        } else if (AT == ActionType.Save) {
            this.Save();
        } else if (AT == ActionType.CustomExport) {
            this.CustomExport();
        }
    }

    private void MyAction(ActionType AT) {
        this.MyMethod(AT);
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.btnSave = new JButton();
        this.btnPdf = new JButton();
        this.btnPrint = new JButton();
        this.btnView = new JButton();
        this.btnCustomExport = new JButton();
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.btnSave.setIcon(new ImageIcon(this.getClass().getResource("/Images/save.png")));
        this.btnSave.setToolTipText("Save");
        this.btnSave.setFocusable(false);
        this.btnSave.setHorizontalTextPosition(0);
        this.btnSave.setName("ReportControl -> btnSave");
        this.btnSave.setVerticalTextPosition(3);
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportControl.this.btnSaveActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnSave);
        this.btnPdf.setIcon(new ImageIcon(this.getClass().getResource("/Images/pdf.png")));
        this.btnPdf.setToolTipText("Export to PDF");
        this.btnPdf.setFocusable(false);
        this.btnPdf.setHorizontalTextPosition(0);
        this.btnPdf.setName("ReportControl -> btnPdf");
        this.btnPdf.setVerticalTextPosition(3);
        this.btnPdf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportControl.this.btnPdfActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnPdf);
        this.btnPrint.setIcon(new ImageIcon(this.getClass().getResource("/Images/print.png")));
        this.btnPrint.setToolTipText("Print");
        this.btnPrint.setFocusable(false);
        this.btnPrint.setHorizontalTextPosition(0);
        this.btnPrint.setName("ReportControl -> btnPrint");
        this.btnPrint.setVerticalTextPosition(3);
        this.btnPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportControl.this.btnPrintActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnPrint);
        this.btnView.setIcon(new ImageIcon(this.getClass().getResource("/Images/view.png")));
        this.btnView.setToolTipText("Print Preview");
        this.btnView.setFocusable(false);
        this.btnView.setHorizontalTextPosition(0);
        this.btnView.setName("ReportControl -> btnView");
        this.btnView.setVerticalTextPosition(3);
        this.btnView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportControl.this.btnViewActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnView);
        this.btnCustomExport.setIcon(new ImageIcon(this.getClass().getResource("/Images/xls.png")));
        this.btnCustomExport.setToolTipText("Custom Export to CSV");
        this.btnCustomExport.setFocusable(false);
        this.btnCustomExport.setHorizontalTextPosition(0);
        this.btnCustomExport.setName("ReportControl -> btnCustomExport");
        this.btnCustomExport.setVerticalTextPosition(3);
        this.btnCustomExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportControl.this.btnCustomExportActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnCustomExport);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -2, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -2, 23, -2));
    }

    private void btnSaveActionPerformed(ActionEvent evt) {
        this.MyAction(ActionType.Save);
    }

    private void btnPrintActionPerformed(ActionEvent evt) {
        this.MyAction(ActionType.Print);
    }

    private void btnPdfActionPerformed(ActionEvent evt) {
        this.MyAction(ActionType.Pdf);
    }

    private void btnViewActionPerformed(ActionEvent evt) {
        this.MyAction(ActionType.View);
    }

    private void btnCustomExportActionPerformed(ActionEvent evt) {
        this.MyAction(ActionType.CustomExport);
    }

    public void ShowCustomExportButton() {
        this.btnCustomExport.setVisible(true);
    }

    public synchronized void addListener(ReportControlListener l) {
        this._listeners.add(l);
    }

    public synchronized void removeListener(ReportControlListener l) {
        this._listeners.remove(l);
    }

    public synchronized int CountListener() {
        return this._listeners.size();
    }

    public void LoadJar(final ActionType AT) {
        try {
            this.cj = new CheckJar(this);
            ArrayList<String> Jar = new ArrayList<String>();
            ArrayList<String> FoundJar = new ArrayList<String>();
            String JarName = "jasperreports-3.7.1.jar";
            if (!this.cj.isExist(JarName)) {
                Jar.add(JarName);
            } else {
                FoundJar.add(JarName);
            }
            JarName = "commons-collections-3.2.1.jar";
            if (!this.cj.isExist(JarName)) {
                Jar.add(JarName);
            } else {
                FoundJar.add(JarName);
            }
            JarName = "commons-beanutils-1.8.0.jar";
            if (!this.cj.isExist(JarName)) {
                Jar.add(JarName);
            } else {
                FoundJar.add(JarName);
            }
            JarName = "commons-digester-1.7.jar";
            if (!this.cj.isExist(JarName)) {
                Jar.add(JarName);
            } else {
                FoundJar.add(JarName);
            }
            JarName = "groovy-all-1.5.5.jar";
            if (!this.cj.isExist(JarName)) {
                Jar.add(JarName);
            } else {
                FoundJar.add(JarName);
            }
            JarName = "iText-2.1.7.jar";
            if (!this.cj.isExist(JarName)) {
                Jar.add(JarName);
            } else {
                FoundJar.add(JarName);
            }
            if (Jar.size() > 0) {
                Object[] options = new Object[]{"Sure", "Not now"};
                int i = JOptionPane.showOptionDialog(null, "The system will download necessary files to complete your request!", "Confirmation", 0, 1, null, options, options[0]);
                if (i == 0) {
                    ActionBeforeLoading = AT;
                    LoadingInProgress = true;
                    this.cj.DownloadJar(Jar);
                    FirstTimeCheck = false;
                } else {
                    this.cj = null;
                    this.RunReport = false;
                }
            }
            if (FoundJar.size() > 0) {
                if (Jar.size() < 1) {
                    this.cj.LoadFromCache = true;
                }
                LoadingInProgress = true;
                this.cj.DownloadJar(FoundJar);
                FirstTimeCheck = false;
                if (Jar.size() < 1) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            ReportControl.this.MyMethod(AT);
                            LoadingInProgress = false;
                        }
                    }, "Report Control").start();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void LoadReportAfterDownload() {
        LoadingInProgress = false;
        if (ActionBeforeLoading != null) {
            this.MyMethod(ActionBeforeLoading);
        }
    }

    private void setLanguageValues() {
        this.btnSave.setToolTipText(this.languageCentre.getValue(LanguageConstant.Save));
        this.btnPdf.setToolTipText(this.languageCentre.getValue(LanguageConstant.ExportToPDF));
        this.btnPrint.setToolTipText(this.languageCentre.getValue(LanguageConstant.Print));
        this.btnView.setToolTipText(this.languageCentre.getValue(LanguageConstant.PrintPreview));
        this.btnCustomExport.setToolTipText(this.languageCentre.getValue(LanguageConstant.CustomExportToCSV));
    }

    public static enum ActionType {
        View,
        Print,
        Save,
        Pdf,
        CustomExport;

    }
}

