/*
 * Decompiled with CFR 0.152.
 */
package CustomComponent;

import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontSettings
extends JDialog {
    public static Font ResultFont;
    public Font CurrentFont;
    protected Font resultFont;
    protected String resultName;
    protected int resultSize;
    protected String[] fontList;
    protected String[] fontStyle = new String[]{"Regular", "Bold", "Italic"};
    protected String[] fontSizes = new String[]{"8", "10", "11", "12", "14", "16", "18", "20", "24", "30", "36", "40", "48", "60", "72"};
    protected static final int DEFAULT_SIZE = 4;
    protected AbstractListModel FontNameModel;
    private JButton btnCancel;
    private JButton btnOK;
    private JList fontNameChoice;
    private JList fontSizeChoice;
    private JList fontStyleChoice;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JLabel previewArea;
    private JTextField txtFont;
    private JTextField txtFontSize;
    private JTextField txtFontStyle;

    public FontSettings(Frame parent, boolean modal) {
        super(parent, modal);
        this.setTitle("Font");
        this.initComponents();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        FontModel FontListModel = new FontModel();
        FontListModel.setStrings(this.fontList);
        this.fontNameChoice.setModel(FontListModel);
        FontModel FontStyleModel = new FontModel();
        FontStyleModel.setStrings(this.fontStyle);
        this.fontStyleChoice.setModel(FontStyleModel);
        FontModel FontSizeModel = new FontModel();
        FontSizeModel.setStrings(this.fontSizes);
        this.fontSizeChoice.setModel(FontSizeModel);
    }

    protected void previewFont() {
        String FontName = this.fontNameChoice.getModel().getElementAt(0).toString();
        String FontSizeName = this.fontSizeChoice.getModel().getElementAt(0).toString();
        String FontStyle = this.fontStyleChoice.getModel().getElementAt(0).toString();
        if (!this.fontNameChoice.isSelectionEmpty()) {
            FontName = this.fontNameChoice.getSelectedValue().toString();
        }
        if (!this.fontSizeChoice.isSelectionEmpty()) {
            FontSizeName = this.fontSizeChoice.getSelectedValue().toString();
        }
        int resultSize = Integer.parseInt(FontSizeName);
        if (!this.fontStyleChoice.isSelectionEmpty()) {
            FontStyle = this.fontStyleChoice.getSelectedValue().toString();
        }
        int attrs = 0;
        if (FontStyle.equalsIgnoreCase("Bold")) {
            attrs = 1;
        }
        if (FontStyle.equalsIgnoreCase("Italic")) {
            attrs = 2;
        }
        if (FontStyle.equalsIgnoreCase("Regular")) {
            attrs = 0;
        }
        this.resultFont = new Font(FontName, attrs, resultSize);
        this.previewArea.setFont(this.resultFont);
        this.pack();
    }

    public void SetFont(Font F) {
        ResultFont = F;
        this.CurrentFont = F;
        this.fontNameChoice.setSelectedValue(F.getFamily(), true);
        String Style2 = "Regular";
        if (F.getStyle() == 1) {
            Style2 = "Bold";
        } else if (F.getStyle() == 2) {
            Style2 = "Italic";
        } else if (F.getStyle() == 0) {
            Style2 = "Regular";
        }
        this.fontStyleChoice.setSelectedValue(Style2, true);
        this.fontSizeChoice.setSelectedValue(String.valueOf(F.getSize()), true);
        if (this.txtFont.getText().length() == 0) {
            this.txtFont.setText(F.getFamily());
        }
        if (this.txtFontStyle.getText().length() == 0) {
            this.txtFontStyle.setText(Style2);
        }
        if (this.txtFontSize.getText().length() == 0) {
            this.txtFontSize.setText(String.valueOf(F.getSize()));
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.fontNameChoice = new JList();
        this.txtFont = new JTextField();
        this.jScrollPane2 = new JScrollPane();
        this.fontStyleChoice = new JList();
        this.txtFontStyle = new JTextField();
        this.txtFontSize = new JTextField();
        this.jScrollPane3 = new JScrollPane();
        this.fontSizeChoice = new JList();
        this.jPanel1 = new JPanel();
        this.previewArea = new JLabel();
        this.btnOK = new JButton();
        this.btnCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Font");
        this.jLabel1.setName("jLabel1");
        this.jLabel2.setText("Font Style");
        this.jLabel2.setName("jLabel2");
        this.jLabel3.setText("Font Size");
        this.jLabel3.setName("jLabel3");
        this.jScrollPane1.setName("jScrollPane1");
        this.fontNameChoice.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.fontNameChoice.setName("fontNameChoice");
        this.fontNameChoice.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FontSettings.this.fontValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.fontNameChoice);
        this.txtFont.setEditable(false);
        this.txtFont.setName("txtFont");
        this.jScrollPane2.setName("jScrollPane2");
        this.fontStyleChoice.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.fontStyleChoice.setName("fontStyleChoice");
        this.fontStyleChoice.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FontSettings.this.fontValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.fontStyleChoice);
        this.txtFontStyle.setEditable(false);
        this.txtFontStyle.setName("txtFontStyle");
        this.txtFontSize.setName("txtFontSize");
        this.jScrollPane3.setName("jScrollPane3");
        this.fontSizeChoice.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.fontSizeChoice.setName("fontSizeChoice");
        this.fontSizeChoice.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FontSettings.this.fontValueChanged(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.fontSizeChoice);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Preview"));
        this.jPanel1.setName("jPanel1");
        this.previewArea.setHorizontalAlignment(0);
        this.previewArea.setText("AaBbYyZz");
        this.previewArea.setName("previewArea");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.previewArea, GroupLayout.Alignment.TRAILING, -1, 315, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.previewArea, -1, 77, Short.MAX_VALUE));
        this.btnOK.setText("OK");
        this.btnOK.setName("FontSettings -> btnOK");
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontSettings.this.btnOKActionPerformed(evt);
            }
        });
        this.btnCancel.setText("Cancel");
        this.btnCancel.setName("FontSettings -> btnCancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontSettings.this.btnCancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1).addComponent(this.txtFont).addComponent(this.jScrollPane1, -2, 154, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jScrollPane2).addComponent(this.txtFontStyle, -1, 99, Short.MAX_VALUE)).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane3).addComponent(this.txtFontSize, -1, 66, Short.MAX_VALUE)).addComponent(this.jLabel3)).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.btnOK, -2, 79, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel, -2, 80, -2).addGap(28, 28, 28)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtFont, -2, -1, -2).addComponent(this.txtFontStyle, -2, -1, -2).addComponent(this.txtFontSize, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, -2, -1, -2).addComponent(this.jScrollPane2, -2, -1, -2))).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnOK).addComponent(this.btnCancel)).addContainerGap(22, Short.MAX_VALUE)));
        this.pack();
    }

    private void fontValueChanged(ListSelectionEvent evt) {
        if (evt.getSource() == this.fontNameChoice) {
            this.txtFont.setText(this.fontNameChoice.getSelectedValue().toString());
        } else if (evt.getSource() == this.fontStyleChoice) {
            this.txtFontStyle.setText(this.fontStyleChoice.getSelectedValue().toString());
        } else if (evt.getSource() == this.fontSizeChoice) {
            this.txtFontSize.setText(this.fontSizeChoice.getSelectedValue().toString());
        }
        this.previewFont();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.dispose();
        ResultFont = null;
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        String FontName = this.txtFont.getText();
        int style = 0;
        if (this.txtFontStyle.getText().equalsIgnoreCase("Regular")) {
            style = 0;
        } else if (this.txtFontStyle.getText().equalsIgnoreCase("Bold")) {
            style = 1;
        } else if (this.txtFontStyle.getText().equalsIgnoreCase("Italic")) {
            style = 2;
        }
        int size = 8;
        try {
            size = Integer.parseInt(this.txtFontSize.getText());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(new JFrame(), "Invalid Font Size");
            return;
        }
        ResultFont = new Font(FontName, style, size);
        this.dispose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FontSettings dialog = new FontSettings((Frame)new JFrame(), true);
                dialog.SetFont(new Font("Tahom111a", 1, 9));
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    class FontModel
    extends AbstractListModel {
        public String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

        FontModel() {
        }

        @Override
        public int getSize() {
            return this.strings.length;
        }

        @Override
        public Object getElementAt(int i) {
            return this.strings[i];
        }

        public void setStrings(String[] strings) {
            this.strings = strings;
        }
    }
}

