/*
 * Decompiled with CFR 0.152.
 */
package CustomComponent;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ProgressBarUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class ImageProgressBar
extends JProgressBar {
    private BufferedImage theImage;

    public ImageProgressBar() {
    }

    public ImageProgressBar(int orient) {
        super(orient);
    }

    public ImageProgressBar(int min, int max) {
        super(min, max);
    }

    public ImageProgressBar(int orient, int min, int max) {
        super(orient, min, max);
    }

    public ImageProgressBar(BoundedRangeModel newModel) {
        super(newModel);
    }

    public void setImage(BufferedImage aBufferedImage) {
        this.theImage = aBufferedImage;
    }

    @Override
    public void setUI(ProgressBarUI ui) {
        super.setUI(new CustomProgressBarUI());
    }

    public static void main(String[] args) {
        final JFrame frame = new JFrame("Test");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JPanel panel = new JPanel(new GridLayout(2, 1));
        final ImageProgressBar progressBar = new ImageProgressBar(0, 0, 100);
        progressBar.setStringPainted(true);
        final JSlider slider = new JSlider(0, 0, 100, 0);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                progressBar.setValue(slider.getValue());
            }
        });
        panel.add(progressBar);
        panel.add(slider);
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File("C:\\focus.jpg"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (image != null) {
            progressBar.setImage(image);
        }
        frame.setContentPane(panel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                frame.pack();
                frame.show();
            }
        });
    }

    private class CustomProgressBarUI
    extends BasicProgressBarUI {
        private CustomProgressBarUI() {
        }

        @Override
        protected void paintDeterminate(Graphics g, JComponent c) {
            if (!(g instanceof Graphics2D)) {
                return;
            }
            if (ImageProgressBar.this.theImage == null) {
                super.paintDeterminate(g, c);
                return;
            }
            Insets b = ImageProgressBar.this.getInsets();
            int barRectWidth = ImageProgressBar.this.getWidth() - (b.right + b.left);
            int barRectHeight = ImageProgressBar.this.getHeight() - (b.top + b.bottom);
            int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(ImageProgressBar.this.getForeground());
            if (ImageProgressBar.this.getOrientation() == 0) {
                if (c.getComponentOrientation().isLeftToRight()) {
                    this.fillHorizontal(b.left, b.top, amountFull + b.left, barRectHeight, barRectWidth, g2);
                } else {
                    this.fillHorizontal(barRectWidth + b.left - amountFull, b.top, amountFull, barRectHeight, barRectWidth, g2);
                }
            } else {
                this.fillVertical(b.left, b.top + barRectHeight - amountFull, barRectWidth, amountFull, barRectHeight, g2);
            }
            if (this.progressBar.isStringPainted()) {
                this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
            }
        }

        private void fillHorizontal(int x, int y, int aWidth, int aHeight, int aTotalWidth, Graphics2D aGraphics) {
            if (ImageProgressBar.this.theImage == null) {
                aGraphics.fillRect(x, y, aWidth, aHeight);
                return;
            }
            Rectangle originalBounds = aGraphics.getClipBounds();
            aGraphics.setClip(x, y, aWidth, aHeight);
            double scaleX = (double)aTotalWidth / (double)ImageProgressBar.this.theImage.getWidth();
            double scaleY = (double)aHeight / (double)ImageProgressBar.this.theImage.getHeight();
            AffineTransform transform = AffineTransform.getScaleInstance(scaleX, scaleY);
            aGraphics.drawImage(ImageProgressBar.this.theImage, transform, null);
            aGraphics.setClip(originalBounds);
        }

        private void fillVertical(int x, int y, int aWidth, int aHeight, int aTotalHeight, Graphics2D aGraphics) {
            if (ImageProgressBar.this.theImage == null) {
                aGraphics.fillRect(x, y, aWidth, aHeight);
                return;
            }
            Rectangle originalBounds = aGraphics.getClipBounds();
            aGraphics.setClip(x, y, aWidth, aHeight);
            double scaleX = (double)aWidth / (double)ImageProgressBar.this.theImage.getWidth();
            double scaleY = (double)aTotalHeight / (double)ImageProgressBar.this.theImage.getHeight();
            AffineTransform transform = AffineTransform.getScaleInstance(scaleX, scaleY);
            aGraphics.drawImage(ImageProgressBar.this.theImage, transform, null);
            aGraphics.setClip(originalBounds);
        }
    }
}

