/*
 * Decompiled with CFR 0.152.
 */
package CustomComponent;

import common.gui.component.JTextFieldFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.event.CellEditorListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.Document;

public class JTableFilter
extends JPanel {
    JTable table;
    TableRowSorter<TableModel> sorter = null;
    Double FilterVal = null;
    Operator OperatorVal = null;
    int FilterCol = 0;
    ArrayList<JTextField> ComponentList = new ArrayList();
    RowFilter<TableModel, Integer> MyCustomFilter = new RowFilter<TableModel, Integer>(){

        @Override
        public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
            if (JTableFilter.this.OperatorVal == null || JTableFilter.this.FilterVal == null || JTableFilter.this.FilterCol == -1) {
                return false;
            }
            Double DoubleVal = null;
            try {
                String str = entry.getValue(JTableFilter.this.FilterCol).toString();
                str = str.replaceAll(",", "");
                DoubleVal = Double.parseDouble(str);
            }
            catch (Exception e) {
                return false;
            }
            switch (JTableFilter.this.OperatorVal) {
                case EQUAL: {
                    if (Double.compare(JTableFilter.this.FilterVal, DoubleVal) != 0) break;
                    return true;
                }
                case GREATERTHAN: {
                    if (Double.compare(DoubleVal, JTableFilter.this.FilterVal) <= 0) break;
                    return true;
                }
                case LESSTHAN: {
                    if (Double.compare(DoubleVal, JTableFilter.this.FilterVal) >= 0) break;
                    return true;
                }
                case NOTEQUAL: {
                    if (Double.compare(DoubleVal, JTableFilter.this.FilterVal) == 0) break;
                    return true;
                }
            }
            return false;
        }
    };
    private JScrollPane jScrollPane1;
    private JTable jtableFilter;

    public JTableFilter(JTable table, ArrayList FilterType) {
        int j;
        this.initComponents();
        this.jtableFilter.setTableHeader(null);
        this.jtableFilter.setRowHeight(22);
        this.jtableFilter.setToolTipText("Filter");
        this.table = table;
        this.sorter = new TableRowSorter<TableModel>(table.getModel());
        table.setRowSorter(this.sorter);
        this.jtableFilter.setAutoCreateColumnsFromModel(false);
        for (j = this.jtableFilter.getColumnCount(); j < FilterType.size(); ++j) {
            this.AddColumn(this.jtableFilter, "Col" + j, new Object[]{""});
        }
        for (j = 0; j < FilterType.size(); ++j) {
            if (FilterType.get(j).toString().equalsIgnoreCase("String")) {
                this.setUpTextFieldColumn(this.jtableFilter, this.jtableFilter.getColumnModel().getColumn(j), j);
                continue;
            }
            if (FilterType.get(j).toString().equalsIgnoreCase("Double") || FilterType.get(j).toString().equalsIgnoreCase("Integer")) {
                this.setUpComboFieldColumn(this.jtableFilter, this.jtableFilter.getColumnModel().getColumn(j), j);
                continue;
            }
            if (!FilterType.get(j).toString().equalsIgnoreCase("Blank")) continue;
            this.setUpPanelColumn(this.jtableFilter, this.jtableFilter.getColumnModel().getColumn(j));
        }
        this.changeMargin();
    }

    public void AddColumn(JTable table, Object headerLabel, Object[] values) {
        DefaultTableModel model = (DefaultTableModel)table.getModel();
        TableColumn col = new TableColumn(model.getColumnCount());
        if (table.getAutoCreateColumnsFromModel()) {
            throw new IllegalStateException();
        }
        col.setHeaderValue(headerLabel);
        table.addColumn(col);
        model.addColumn((Object)headerLabel.toString(), values);
    }

    public void setUpTextFieldColumn(JTable table, TableColumn sportColumn, final int index) {
        final JTextField txtField = new JTextField();
        this.ComponentList.add(txtField);
        txtField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                String text = txtField.getText();
                if (text.length() == 0) {
                    JTableFilter.this.sorter.setRowFilter(null);
                } else {
                    JTableFilter.this.sorter.setRowFilter(RowFilter.regexFilter("(?i)" + text, index));
                }
            }
        });
        sportColumn.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable tblDataTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return txtField;
            }
        });
        sportColumn.setCellEditor(new CustomTextEditor(txtField));
    }

    public void setUpComboFieldColumn(JTable table, TableColumn sportColumn, final int index) {
        final CustomComboAndText Combobox = new CustomComboAndText();
        Combobox.jTextField1.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                JTableFilter.this.FilterCol = index;
                String text = Combobox.jTextField1.getText();
                if (text.length() == 0 || JTableFilter.this.OperatorVal == null) {
                    JTableFilter.this.sorter.setRowFilter(null);
                } else {
                    JTableFilter.this.FilterVal = Double.parseDouble(text);
                    JTableFilter.this.sorter.setRowFilter(JTableFilter.this.MyCustomFilter);
                }
            }
        });
        Combobox.jComboBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JTableFilter.this.FilterCol = index;
                if (Combobox.jComboBox1.getSelectedItem().toString().trim().length() == 0) {
                    JTableFilter.this.OperatorVal = null;
                } else if (Combobox.jComboBox1.getSelectedItem().toString().trim().equalsIgnoreCase("=")) {
                    JTableFilter.this.OperatorVal = Operator.EQUAL;
                } else if (Combobox.jComboBox1.getSelectedItem().toString().trim().equalsIgnoreCase(">")) {
                    JTableFilter.this.OperatorVal = Operator.GREATERTHAN;
                } else if (Combobox.jComboBox1.getSelectedItem().toString().trim().equalsIgnoreCase("<")) {
                    JTableFilter.this.OperatorVal = Operator.LESSTHAN;
                } else if (Combobox.jComboBox1.getSelectedItem().toString().trim().equalsIgnoreCase("<>")) {
                    JTableFilter.this.OperatorVal = Operator.NOTEQUAL;
                }
                String text = Combobox.jTextField1.getText();
                if (text.length() == 0 || JTableFilter.this.OperatorVal == null) {
                    JTableFilter.this.sorter.setRowFilter(null);
                } else {
                    try {
                        JTableFilter.this.FilterVal = Double.parseDouble(text);
                        JTableFilter.this.sorter.setRowFilter(JTableFilter.this.MyCustomFilter);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        sportColumn.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable tblDataTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return Combobox;
            }
        });
        sportColumn.setCellEditor(new CustomComboAndTextEditor(Combobox));
    }

    public void setUpPanelColumn(JTable table, TableColumn sportColumn) {
        final JPanel panel = new JPanel();
        sportColumn.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable tblDataTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return panel;
            }
        });
        sportColumn.setCellEditor(new CustomBlankPanel(panel));
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jtableFilter = new JTable();
        this.jtableFilter.setModel(new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Title 1", "Title 2"}));
        this.jScrollPane1.setViewportView(this.jtableFilter);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 40, -2));
    }

    public void changeMargin() {
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            int width = this.table.getColumn(this.table.getColumnName(i)).getPreferredWidth();
            this.jtableFilter.getColumn(this.jtableFilter.getColumnName(i)).setPreferredWidth(width);
        }
    }

    public void setPrefMinMax() {
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            int width = this.table.getColumn(this.table.getColumnName(i)).getPreferredWidth();
            this.jtableFilter.getColumn(this.jtableFilter.getColumnName(i)).setPreferredWidth(width);
            width = this.table.getColumn(this.table.getColumnName(i)).getMaxWidth();
            this.jtableFilter.getColumn(this.jtableFilter.getColumnName(i)).setMaxWidth(width);
            width = this.table.getColumn(this.table.getColumnName(i)).getMinWidth();
            this.jtableFilter.getColumn(this.jtableFilter.getColumnName(i)).setMinWidth(width);
        }
    }

    public void removeColumn(int i) {
        this.jtableFilter.removeColumn(this.jtableFilter.getColumnModel().getColumn(0));
    }

    class CustomBlankPanel
    implements TableCellEditor {
        private JPanel panel;

        public CustomBlankPanel(JPanel panel) {
            this.panel = panel;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.panel;
        }

        @Override
        public Object getCellEditorValue() {
            return this.panel;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            return true;
        }

        @Override
        public void cancelCellEditing() {
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
        }
    }

    public class CustomComboAndText
    extends JPanel {
        public JComboBox jComboBox1;
        public JTextField jTextField1;

        public CustomComboAndText() {
            this.initComponents();
        }

        private void initComponents() {
            this.jTextField1 = new JTextField();
            this.jTextField1.setDocument((Document)new JTextFieldFilter("0123456789."));
            this.jComboBox1 = new JComboBox();
            this.setLayout(new BoxLayout(this, 2));
            this.add(this.jTextField1);
            this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"", "=", "<>", ">", "<"}));
            this.jComboBox1.setMaximumSize(new Dimension(45, 22));
            this.jComboBox1.setMinimumSize(new Dimension(45, 22));
            this.jComboBox1.setPreferredSize(new Dimension(45, 22));
            this.add(this.jComboBox1);
        }
    }

    class CustomComboAndTextEditor
    implements TableCellEditor {
        private JPanel panel;

        public CustomComboAndTextEditor(JPanel panel) {
            this.panel = panel;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.panel;
        }

        @Override
        public Object getCellEditorValue() {
            return this.panel;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            return true;
        }

        @Override
        public void cancelCellEditing() {
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
        }
    }

    class CustomTextEditor
    implements TableCellEditor {
        private JTextField textfield;

        public CustomTextEditor(JTextField textfield) {
            this.textfield = textfield;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.textfield;
        }

        @Override
        public Object getCellEditorValue() {
            return this.textfield;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            return true;
        }

        @Override
        public void cancelCellEditing() {
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
        }
    }

    public static enum Operator {
        EQUAL,
        NOTEQUAL,
        LESSTHAN,
        GREATERTHAN;

    }
}

