/*
 * Decompiled with CFR 0.152.
 */
package CustomComponent;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class JTableTotal
extends JPanel {
    JTable table;
    int FilterCol = 0;
    Vector Row = new Vector();
    ArrayList DataType = new ArrayList();
    static DecimalFormat twoPlacesWithComma = new DecimalFormat("###,###.##");
    static DecimalFormat NumberWithComma;
    private JScrollPane jScrollPane1;
    private JTable jtableTotal;

    public JTableTotal(JTable table, ArrayList DataType_) {
        this.initComponents();
        this.DataType = DataType_;
        this.jtableTotal.setTableHeader(null);
        this.jtableTotal.setRowHeight(20);
        this.jtableTotal.setToolTipText("Total");
        this.table = table;
        int ColCount = table.getColumnCount();
        this.AddColumn(ColCount);
        for (int j = 0; j < ColCount; ++j) {
            this.setUpTextFieldColumn(this.jtableTotal, this.jtableTotal.getColumnModel().getColumn(j), j);
        }
        this.changeMargin();
        this.jtableTotal.setEnabled(false);
    }

    public void AddColumn(int Count) {
        Vector<String> Col = new Vector<String>();
        Vector<String> Cell = new Vector<String>();
        for (int i = 0; i < Count; ++i) {
            Col.addElement("Col " + i);
            Cell.addElement("");
        }
        this.Row.addElement(Cell);
        DefaultTableModel model = new DefaultTableModel(this.Row, Col);
        this.jtableTotal.setModel(model);
    }

    public void setUpTextFieldColumn(JTable table, TableColumn sportColumn, int index) {
        sportColumn.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable tblDataTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel cell = (JLabel)super.getTableCellRendererComponent(tblDataTable, value, isSelected, hasFocus, row, column);
                if (JTableTotal.this.DataType.get(column).toString().equalsIgnoreCase("Double")) {
                    double Val = 0.0;
                    try {
                        Val = Double.parseDouble(value.toString().trim().replaceAll("\\,", ""));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    cell.setHorizontalAlignment(4);
                    cell.setText(" " + twoPlacesWithComma.format(Val) + " ");
                } else if (JTableTotal.this.DataType.get(column).toString().equalsIgnoreCase("Integer")) {
                    double Val = 0.0;
                    try {
                        Val = Double.parseDouble(value.toString().trim().replaceAll("\\,", ""));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    cell.setHorizontalAlignment(4);
                    cell.setText(" " + NumberWithComma.format(Val) + " ");
                } else if (JTableTotal.this.DataType.get(column).toString().equalsIgnoreCase("String")) {
                    cell.setHorizontalAlignment(2);
                    cell.setText(" " + value.toString() + " ");
                }
                cell.setFont(new Font(cell.getFont().getFontName(), 1, cell.getFont().getSize()));
                cell.setBackground(Color.WHITE);
                cell.setForeground(Color.BLACK);
                return cell;
            }
        });
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jtableTotal = new JTable();
        this.jScrollPane1.setViewportView(this.jtableTotal);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 40, -2));
    }

    public void changeMargin() {
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            int width = this.table.getColumn(this.table.getColumnName(i)).getPreferredWidth();
            this.jtableTotal.getColumn(this.jtableTotal.getColumnName(i)).setPreferredWidth(width);
        }
    }

    public void setPrefMinMax() {
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            int width = this.table.getColumn(this.table.getColumnName(i)).getPreferredWidth();
            this.jtableTotal.getColumn(this.jtableTotal.getColumnName(i)).setPreferredWidth(width);
            width = this.table.getColumn(this.table.getColumnName(i)).getMaxWidth();
            this.jtableTotal.getColumn(this.jtableTotal.getColumnName(i)).setMaxWidth(width);
            width = this.table.getColumn(this.table.getColumnName(i)).getMinWidth();
            this.jtableTotal.getColumn(this.jtableTotal.getColumnName(i)).setMinWidth(width);
        }
    }

    public void setTotalValues(Vector v) {
        this.Row.clear();
        this.Row.addElement(v);
        this.jtableTotal.addNotify();
    }

    public void setTotalValues() {
        this.Row.clear();
        Vector<String> Cell = new Vector<String>();
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            if (i == 0) {
                Cell.addElement("Total");
                continue;
            }
            Cell.addElement("");
        }
        this.Row.addElement(Cell);
        this.jtableTotal.addNotify();
    }

    static {
        twoPlacesWithComma.setMinimumFractionDigits(2);
        twoPlacesWithComma.setMaximumFractionDigits(2);
        NumberWithComma = new DecimalFormat("###,###");
        NumberWithComma.setMinimumFractionDigits(0);
        NumberWithComma.setMaximumFractionDigits(0);
    }
}

