/*
 * Decompiled with CFR 0.152.
 */
package CustomComponent;

import MyDocking.TradeCast;
import common.gui.component.NxGDialogBox;
import common.gui.util.AppConfig;
import common.gui.util.MessageType;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import languages.LanguageCentre;
import languages.LanguageConstant;
import org.jdesktop.swingx.JXImagePanel;

public class MyOptionPane
extends NxGDialogBox {
    private final int hei = 150;
    private final int diff = 105;
    private LanguageCentre languageCentre = new LanguageCentre();
    private JButton btnOK;
    private JLabel jLabel1;
    private JSeparator jSeparator1;
    private JXImagePanel lblImage;
    private JLabel lblMessage;

    private MyOptionPane(MessageType type, String message, String title, boolean isModel) {
        super((Frame)TradeCast.getInstance().frame, isModel);
        try {
            this.initComponents();
            this.setTitle(type);
            if (message.lastIndexOf(".") != message.length() - 1) {
                message = message + ".";
            }
            this.lblMessage.setText(message);
            int wid = Util.getStringWidth((JLabel)this.lblMessage);
            this.setPreferredSize(new Dimension(wid += 105, 150));
            this.setMaximumSize(new Dimension(wid, 150));
            this.setMinimumSize(new Dimension(wid, 150));
            this.setResizable(false);
            this.setImage(type);
            this.lblImage.setOpaque(false);
            this.btnOK.requestFocus();
            this.setLanguageValues();
            this.setDialogLocation(TradeCast.getInstance().frame);
            this.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setDialogLocation(JFrame f) {
        Rectangle r = f.getBounds();
        int x = r.x + (r.width - this.getSize().width) / 2;
        int y = r.y + (r.height - this.getSize().height) / 2;
        this.setLocation(x, y);
    }

    public static void showMessage(MessageType type, String message, boolean isModel) {
        new MyOptionPane(type, message, type.toString(), isModel);
    }

    public static void showMessage(MessageType type, String message, String title, boolean isModel) {
        new MyOptionPane(type, message, title, isModel);
    }

    private void initComponents() {
        this.lblMessage = new JLabel();
        this.jLabel1 = new JLabel();
        this.lblImage = new JXImagePanel();
        this.btnOK = new JButton();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(322, 150));
        this.lblMessage.setHorizontalAlignment(2);
        this.lblMessage.setText("jLabel1");
        this.lblImage.setBackground(new Color(0, 51, 204));
        this.lblImage.setPreferredSize(new Dimension(65, 65));
        GroupLayout lblImageLayout = new GroupLayout((Container)this.lblImage);
        this.lblImage.setLayout((LayoutManager)lblImageLayout);
        lblImageLayout.setHorizontalGroup(lblImageLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 65, Short.MAX_VALUE));
        lblImageLayout.setVerticalGroup(lblImageLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 65, Short.MAX_VALUE));
        this.btnOK.setText("OK");
        this.btnOK.setName("MyOptionPane -> btnOK");
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyOptionPane.this.btnOKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent((Component)this.lblImage, -2, -1, -2).addGap(15, 15, 15).addComponent(this.lblMessage, -1, -1, Short.MAX_VALUE).addGap(12, 12, 12)).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addGap(252, 252, 252).addComponent(this.jLabel1, -2, 9, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnOK).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.lblImage, -2, -1, -2).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.lblMessage, -2, 23, -2))).addGap(10, 10, 10).addComponent(this.jSeparator1, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addGap(3, 3, 3).addComponent(this.btnOK)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1, -2, 24, -2))).addGap(0, 0, 0)));
        this.pack();
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void setImage(MessageType messageType) {
        if (MessageType.EMPTY == messageType) {
            this.lblImage.setVisible(false);
        } else if (MessageType.Error == messageType) {
            this.lblImage.setImage(new ImageIcon(((Object)((Object)this)).getClass().getResource("/Images/error64.png")).getImage());
        } else if (MessageType.Information == messageType) {
            this.lblImage.setImage(new ImageIcon(((Object)((Object)this)).getClass().getResource("/Images/info64.png")).getImage());
        } else if (MessageType.Loading == messageType) {
            this.lblImage.setVisible(false);
        } else if (MessageType.Normal == messageType) {
            this.setTitle(AppConfig.houseName);
        } else if (MessageType.Sussess == messageType) {
            this.lblImage.setImage(new ImageIcon(((Object)((Object)this)).getClass().getResource("/Images/success64.png")).getImage());
        } else if (MessageType.Warring == messageType) {
            this.lblImage.setImage(new ImageIcon(((Object)((Object)this)).getClass().getResource("/Images/Alert64.png")).getImage());
        } else {
            this.setTitle(AppConfig.houseName);
        }
    }

    private void setTitle(MessageType messageType) {
        if (MessageType.EMPTY == messageType) {
            this.setTitle(AppConfig.houseName);
        } else if (MessageType.Error == messageType) {
            this.setTitle(this.languageCentre.getValue(LanguageConstant.Error));
        } else if (MessageType.Information == messageType) {
            this.setTitle(this.languageCentre.getValue(LanguageConstant.Information));
        } else if (MessageType.Loading == messageType) {
            this.setTitle(this.languageCentre.getValue(LanguageConstant.Loading));
        } else if (MessageType.Normal == messageType) {
            this.setTitle(AppConfig.houseName);
        } else if (MessageType.Sussess == messageType) {
            this.setTitle(this.languageCentre.getValue(LanguageConstant.Success));
        } else if (MessageType.Warring == messageType) {
            this.setTitle(this.languageCentre.getValue(LanguageConstant.Warring));
        } else {
            this.setTitle(AppConfig.houseName);
        }
    }

    private void setLanguageValues() {
        this.btnOK.setText(this.languageCentre.getValue(LanguageConstant.OK));
    }
}

