/*
 * Decompiled with CFR 0.152.
 */
package CustomComponent;

import CustomComponent.DocumentType;
import common.gui.component.JTextFieldFilter;
import common.gui.util.AppConfig;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JPasswordField;
import javax.swing.Timer;
import javax.swing.text.Document;

public class NxGPassword
extends JPasswordField
implements FocusListener {
    private DocumentType docType;

    public NxGPassword() {
        this.setBorder(AppConfig.emptyBorder);
        this.addFocusListener(this);
    }

    @Override
    public String getText() {
        return super.getText().trim();
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.selectAll();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public void setError(boolean isError) {
        final Timer BlinkTimmer = new Timer(0, null);
        if (isError) {
            ActionListener ac = new ActionListener(){
                int i = 0;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (this.i >= 6) {
                        BlinkTimmer.stop();
                        NxGPassword.this.setBorder(AppConfig.errorBorder);
                    } else {
                        if (this.i % 2 == 0) {
                            NxGPassword.this.setBorder(AppConfig.errorBorder);
                        } else {
                            NxGPassword.this.setBorder(AppConfig.emptyBorder);
                        }
                        ++this.i;
                    }
                }
            };
            BlinkTimmer.addActionListener(ac);
            BlinkTimmer.setDelay(100);
            BlinkTimmer.setRepeats(true);
            BlinkTimmer.start();
        } else {
            BlinkTimmer.stop();
            this.setBorder(AppConfig.emptyBorder);
        }
    }

    public void setDocument(DocumentType docType) {
        if (docType == DocumentType.LOWERCASE) {
            this.setDocument((Document)new JTextFieldFilter("abcdefghijklmnopqrstuvwxyz"));
            this.setHorizontalAlignment(2);
        } else if (docType == DocumentType.UPPERCASE) {
            this.setDocument((Document)new JTextFieldFilter("ABCDEFGHIJKLMNOPQRSTUVWXYZ"));
            this.setHorizontalAlignment(2);
        } else if (docType == DocumentType.NUMERIC) {
            this.setDocument((Document)new JTextFieldFilter("0123456789"));
            this.setHorizontalAlignment(4);
        } else if (docType == DocumentType.ALPHA) {
            this.setDocument((Document)new JTextFieldFilter("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"));
            this.setHorizontalAlignment(2);
        } else if (docType == DocumentType.MBILE) {
            this.setDocument((Document)new JTextFieldFilter("+- 0123456789"));
            this.setHorizontalAlignment(4);
        } else if (docType == DocumentType.FLOAT) {
            this.setDocument((Document)new JTextFieldFilter("0123456789."));
            this.setHorizontalAlignment(4);
        } else if (docType == DocumentType.ALPHA_NUMERIC) {
            this.setDocument((Document)new JTextFieldFilter("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 "));
            this.setHorizontalAlignment(2);
        } else if (docType == DocumentType.SCRIP) {
            this.setDocument((Document)new JTextFieldFilter("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-"));
            this.setHorizontalAlignment(2);
        } else {
            this.setDocument((Document)new JTextFieldFilter("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 "));
        }
        this.docType = docType;
    }

    public void setDocument(DocumentType docType, int lengthAllowed) {
        if (docType == DocumentType.LOWERCASE) {
            this.setDocument((Document)new JTextFieldFilter("abcdefghijklmnopqrstuvwxyz", lengthAllowed));
            this.setHorizontalAlignment(2);
        } else if (docType == DocumentType.UPPERCASE) {
            this.setDocument((Document)new JTextFieldFilter("ABCDEFGHIJKLMNOPQRSTUVWXYZ", lengthAllowed));
            this.setHorizontalAlignment(2);
        } else if (docType == DocumentType.NUMERIC) {
            this.setDocument((Document)new JTextFieldFilter("0123456789", lengthAllowed));
            this.setHorizontalAlignment(2);
        } else if (docType == DocumentType.ALPHA) {
            this.setDocument((Document)new JTextFieldFilter("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ", lengthAllowed));
            this.setHorizontalAlignment(2);
        } else if (docType == DocumentType.MBILE) {
            this.setDocument((Document)new JTextFieldFilter("+- 0123456789", lengthAllowed));
            this.setHorizontalAlignment(4);
        } else if (docType == DocumentType.FLOAT) {
            this.setDocument((Document)new JTextFieldFilter("0123456789.", lengthAllowed));
            this.setHorizontalAlignment(4);
        } else if (docType == DocumentType.ALPHA_NUMERIC) {
            this.setDocument((Document)new JTextFieldFilter("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 ", lengthAllowed));
            this.setHorizontalAlignment(2);
        } else if (docType == DocumentType.SCRIP) {
            this.setDocument((Document)new JTextFieldFilter("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-"));
            this.setHorizontalAlignment(2);
        } else {
            this.setDocument((Document)new JTextFieldFilter("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 ", lengthAllowed));
        }
        this.docType = docType;
    }

    public DocumentType getDocumentType() {
        return this.docType;
    }
}

