/*
 * Decompiled with CFR 0.152.
 */
package CustomComponent;

public final class PasswordStrengthAnalyzer {
    private static final PasswordStrengthAnalyzer INSTANCE = new PasswordStrengthAnalyzer();

    public static float getInstanceStrength(String password) {
        return INSTANCE.getStrength(password);
    }

    PasswordStrengthAnalyzer() {
    }

    public float getStrength(String password) {
        if (password == null) {
            return 0.0f;
        }
        int digitCount = 0;
        int lowerCount = 0;
        int upperCount = 0;
        int otherCount = 0;
        for (int i = 0; i < password.length(); ++i) {
            char passwordChar = password.charAt(i);
            if (Character.isDigit(passwordChar)) {
                ++digitCount;
                continue;
            }
            if (Character.isUpperCase(passwordChar)) {
                ++upperCount;
                continue;
            }
            if (Character.isLowerCase(passwordChar)) {
                ++lowerCount;
                continue;
            }
            ++otherCount;
        }
        if (digitCount == 0 && upperCount == 0 && lowerCount == 0 && otherCount == 0) {
            return 0.0f;
        }
        if (otherCount > 0) {
            return 0.01f;
        }
        if (password.length() < 4) {
            return 0.2f;
        }
        if (password.length() < 8) {
            return 0.4f;
        }
        if (digitCount == 0 || upperCount + lowerCount == 0) {
            return 0.6f;
        }
        int range = 0;
        if (digitCount > 0 && digitCount < 2) {
            ++range;
        } else if (digitCount > 1) {
            range += 2;
        }
        if (lowerCount + upperCount > 0 && lowerCount + upperCount < 2) {
            ++range;
        } else if (lowerCount + upperCount > 1) {
            range += 2;
        }
        if (range < 5 && password.length() < 12) {
            return 0.9f;
        }
        return 1.0f;
    }
}

