/*
 * Decompiled with CFR 0.152.
 */
package CustomComponent;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;

public class PasswordStrengthBar
extends JComponent {
    private static final int START = 218;
    private static final int MID = 255;
    private static final int END = 130;
    private static final Color[] RED_COLORS = new Color[]{new Color(218, 0, 0), new Color(255, 0, 0), new Color(130, 0, 0)};
    private static final Color[] YELLOW_COLORS = new Color[]{new Color(218, 218, 0), new Color(255, 255, 0), new Color(130, 130, 0)};
    private static final Color[] GREEN_COLORS = new Color[]{new Color(0, 218, 0), new Color(0, 255, 0), new Color(0, 130, 0)};
    private float strength;

    public void setStrength(float strength) {
        float oldStrength = this.strength;
        this.strength = strength;
        this.firePropertyChange("strength", oldStrength, strength);
        this.repaint();
    }

    public float getStrength() {
        return this.strength;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        Insets insets = this.getInsets();
        Graphics2D g2 = (Graphics2D)g.create();
        g2.translate(insets.left, insets.top);
        float strength = this.getStrength();
        int w = this.getWidth() - insets.left - insets.right;
        int h = this.getHeight() - insets.top - insets.bottom;
        int p1Height = w * 5 / 8;
        int barWidth = (int)(strength * (float)w);
        Color[] colors = strength <= 0.5f ? RED_COLORS : (strength <= 0.8f ? YELLOW_COLORS : GREEN_COLORS);
        g2.setPaint(new GradientPaint(0.0f, 0.0f, colors[0], 0.0f, p1Height, colors[1]));
        g2.fillRect(0, 0, barWidth, p1Height);
        g2.setPaint(new GradientPaint(0.0f, p1Height, colors[1], 0.0f, h, colors[2]));
        g2.fillRect(0, p1Height, barWidth, h - p1Height);
        g2.dispose();
    }
}

