/*
 * Decompiled with CFR 0.152.
 */
package CustomComponent;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class RoundBorderPanel
extends JPanel {
    Color GradientColor1 = null;
    Color GradientColor2 = null;
    int radius = 0;

    public RoundBorderPanel(Color GradientColor1, Color GradientColor2, int radius) {
        this.GradientColor1 = GradientColor1;
        this.GradientColor2 = GradientColor2;
        this.radius = radius;
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(new RoundedBorder(radius));
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Dimension d = this.getSize();
        g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.GradientColor1, 0.0f, d.height, this.GradientColor2, true));
        g2d.fillRoundRect(0, 0, d.width, d.height, this.radius, this.radius);
    }

    private static class RoundedBorder
    implements Border {
        private int radius;

        RoundedBorder(int radius) {
            this.radius = radius;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, 0, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.drawRoundRect(x, y, width - 1, height - 1, this.radius, this.radius);
        }
    }
}

