/*
 * Decompiled with CFR 0.152.
 */
package CustomComponent;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingConstants;
import javax.swing.border.Border;

public class ToolBarArrowButton
extends JButton
implements SwingConstants,
MouseListener {
    private static int defaultW = 35;
    private static int defaultH = 25;
    private static Polygon upIcon = new Polygon(new int[]{0, 5, 9}, new int[]{7, 2, 7}, 3);
    private static Polygon downIcon = new Polygon(new int[]{26, 30, 34}, new int[]{11, 15, 11}, 3);
    private static Polygon leftIcon = new Polygon(new int[]{7, 3, 7}, new int[]{1, 5, 9}, 3);
    private static Polygon rightIcon = new Polygon(new int[]{3, 7, 3}, new int[]{1, 5, 9}, 3);
    protected int direction;
    private transient Color shadow = Color.GRAY;
    private transient Color darkShadow = Color.DARK_GRAY;
    private transient Color highlight = Color.WHITE;
    private transient Border buttonBorder = new Border(){

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, 0, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        }
    };
    JPopupMenu Menu = new JPopupMenu();
    private String[] MenuText;
    private String[] MenuIcon;
    private String Current = "";
    private List _listeners = new ArrayList();

    public ToolBarArrowButton(int direction) {
        this.setBorder(this.buttonBorder);
        this.setDirection(direction);
        this.addMouseListener(this);
    }

    public ToolBarArrowButton(int direction, Color background, Color shadow, Color darkShadow, Color highlight) {
        this(direction);
        this.setBackground(background);
        this.shadow = shadow;
        this.darkShadow = darkShadow;
        this.highlight = highlight;
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int dir) {
        this.direction = dir;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Insets insets = this.getInsets();
        Rectangle bounds = this.getBounds();
        int x = insets.left + (bounds.width - insets.left - insets.right - defaultW) / 2;
        int y = insets.top + (bounds.height - insets.left - insets.right - defaultH) / 2;
        this.paintTriangle(g, x, y, defaultH, this.direction, this.isEnabled());
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        int w = defaultW + insets.left + insets.right;
        int h = defaultH + insets.top + insets.bottom;
        return new Dimension(w, h);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void paintTriangle(Graphics g, int x, int y, int size, int direction, boolean isEnabled) {
        Polygon arrow = null;
        switch (direction) {
            case 1: {
                arrow = upIcon;
                break;
            }
            case 5: {
                arrow = downIcon;
                break;
            }
            case 3: 
            case 4: {
                arrow = rightIcon;
                break;
            }
            case 2: 
            case 7: {
                arrow = leftIcon;
            }
        }
        int[] xPoints = arrow.xpoints;
        int[] yPoints = arrow.ypoints;
        int y2 = 0;
        int x2 = 0;
        int y1 = 0;
        int x1 = 0;
        if (size != defaultH) {
            float scale = (float)size * 1.0f / (float)defaultH;
            int i = 0;
            while (i < 3) {
                int n = i;
                xPoints[n] = (int)((float)xPoints[n] * scale);
                int n2 = i++;
                yPoints[n2] = (int)((float)yPoints[n2] * scale);
            }
        }
        g.translate(x, y);
        switch (direction) {
            case 1: {
                x1 = xPoints[0] + 2;
                y2 = y1 = yPoints[0];
                x2 = xPoints[2] - 1;
                break;
            }
            case 5: {
                x1 = xPoints[1];
                y1 = yPoints[1] + 1;
                x2 = xPoints[2] - 1;
                y2 = yPoints[2];
                break;
            }
            case 2: 
            case 7: {
                x1 = xPoints[0] + 1;
                y1 = yPoints[0] + 1;
                x2 = x1;
                y2 = yPoints[2] + 1;
                break;
            }
            case 3: 
            case 4: {
                x1 = xPoints[2];
                y1 = yPoints[2] + 1;
                x2 = xPoints[1] - 1;
                y2 = yPoints[1] + 1;
            }
        }
        Color saved = g.getColor();
        if (isEnabled) {
            g.setColor(Color.DARK_GRAY);
            if (arrow != null) {
                g.fillPolygon(xPoints, yPoints, 3);
            }
        } else {
            g.setColor(Color.GRAY);
            g.fillPolygon(xPoints, yPoints, 3);
            g.setColor(Color.WHITE);
            g.drawLine(x1, y1, x2, y2);
        }
        g.setColor(saved);
        g.translate(-x, -y);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getX() < 23) {
            this.fireActionPerformed();
        } else {
            this.Menu.show(this, 0, this.getHeight());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void RegisterPopMenu(final String[] MenuText, final String[] MenuIcon) {
        this.MenuText = MenuText;
        this.MenuIcon = MenuIcon;
        for (int i = 0; i < MenuText.length; ++i) {
            JMenuItem menuitem = new JMenuItem(MenuText[i], new ImageIcon(this.getClass().getResource(MenuIcon[i])));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ToolBarArrowButton.this.Current = e.getActionCommand();
                    for (int j = 0; j < MenuText.length; ++j) {
                        if (!MenuText[j].equalsIgnoreCase(ToolBarArrowButton.this.Current)) continue;
                        ToolBarArrowButton.this.setBtnIcon(MenuIcon[j]);
                    }
                    ToolBarArrowButton.this.fireActionPerformed();
                }
            });
            this.Menu.add(menuitem);
        }
        this.setIcon(new ImageIcon(this.getClass().getResource(MenuIcon[0])));
        this.Current = MenuText[0];
    }

    public void setBtnIcon(String IconString) {
        this.setIcon(new ImageIcon(this.getClass().getResource(IconString)));
    }

    public synchronized void addListener(ArrowButtonActionListener l) {
        this._listeners.add(l);
    }

    public synchronized void removeListener(ArrowButtonActionListener l) {
        this._listeners.remove(l);
    }

    public synchronized int CountListener() {
        return this._listeners.size();
    }

    private void fireActionPerformed() {
        ArrowButtonActionEvent event = new ArrowButtonActionEvent(this, this.Current);
        Iterator listeners = this._listeners.iterator();
        while (listeners.hasNext()) {
            ((ArrowButtonActionListener)listeners.next()).actionPerformed(event);
        }
    }

    public class ArrowButtonActionEvent
    extends EventObject {
        public String Text;

        public ArrowButtonActionEvent(Object source, String text) {
            super(source);
            this.Text = "";
            this.Text = text;
        }
    }

    public static interface ArrowButtonActionListener {
        public void popupActionPerformed(ArrowButtonActionEvent var1);

        public void actionPerformed(ArrowButtonActionEvent var1);
    }
}

