/*
 * Decompiled with CFR 0.152.
 */
package Exposure;

import MyDocking.Mediator;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.util.Vector;
import windows.ExposureWatch;

public class Collateral {
    ExposureWatch ew = null;
    double mtmTotal = 0.0;
    Mediator mediator = Mediator.getInstance();

    public Collateral(ExposureWatch ExposureWatch2) {
        this.ew = ExposureWatch2;
    }

    public synchronized void fillCollateral(String msg) {
        this.ew.lblCollateralsMesssage.setText("");
        this.removeCollTable();
        msg = this.addMTMAmount(msg);
        if (msg.indexOf("#") < 0) {
            this.ew.lblCollateralsMesssage.setForeground(MyColors.successMessageFG);
            this.ew.lblCollateralsMesssage.setText("No record found");
            this.ew.lblCollateralsMesssage.setIcon(null);
            this.ew.lblCollateralTotal.setText("0.00");
            return;
        }
        String[] str = msg.split("\\#");
        for (int rowS = 0; rowS < str.length; ++rowS) {
            String[] str2 = str[rowS].split(";");
            Vector<Object> row = new Vector<Object>();
            for (int col = 0; col < str2.length; ++col) {
                String s = str2[col].replaceAll("\\,", "");
                double d = 0.0;
                if (col == 0) {
                    row.addElement(String.valueOf(s));
                    continue;
                }
                try {
                    d = Double.valueOf(s);
                    row.addElement(d);
                    continue;
                }
                catch (NumberFormatException ex) {
                    row.addElement(s);
                }
            }
            this.ew.collateraRow.addElement(row);
            this.ew.tblCollateral.addNotify();
        }
        this.ew.lblCollateralTotal.setText(Util.format2digit((String)(this.mtmTotal + "".trim().replaceAll("\\,", ""))));
        this.ew.lblCollateralsMesssage.setText(Util.format0digit((String)(this.ew.tblCollateral.getRowCount() + "".trim().replaceAll("\\,", ""))) + " Record(s) ");
        this.ew.lblCollateralsMesssage.setIcon(null);
        if (this.ew.lblCollateralTotal.getText().indexOf(".") < 0) {
            this.ew.lblCollateralTotal.setText(this.ew.lblCollateralTotal.getText() + ".00");
        }
        this.ew.collateralsSorter.sort();
        this.ew.tblCollateral.updateUI();
        this.ew.repaint();
    }

    private synchronized String addMTMAmount(String msg) {
        this.mtmTotal = 0.0;
        String data = "";
        try {
            String[] str = msg.split("\\#", -1);
            for (int row = 0; row < str.length - 1; ++row) {
                String[] val = str[row].split("\\;", -1);
                if (val[1].length() <= 0 || val[2].length() <= 0) continue;
                double mtmp = Double.parseDouble(val[1]) * Double.parseDouble(val[2]);
                this.mtmTotal += mtmp;
                data = data + str[row] + ";" + Util.format2digit((String)(mtmp + "".trim().replaceAll("\\,", ""))) + "#";
            }
        }
        catch (Exception ex) {
            this.mediator.PrintLog(ex, msg);
        }
        return data;
    }

    public void removeCollTable() {
        this.ew.collateraRow.clear();
        this.ew.collateralsSorter.sort();
        this.ew.tblCollateral.updateUI();
        this.ew.tblCollateral.repaint();
    }
}

