/*
 * Decompiled with CFR 0.152.
 */
package Exposure;

import common.gui.util.MyColors;
import common.gui.util.Util;
import java.util.Vector;
import windows.ExposureWatch;

public class OpenPosition {
    ExposureWatch ew = null;

    public OpenPosition(ExposureWatch ew) {
        this.ew = ew;
    }

    public synchronized void fillOpenPosition(String msg) {
        this.ew.lblOpenPositionMessage.setText("");
        this.ew.lblOpenPositionMessage.setIcon(null);
        this.removeOpenTable();
        if (msg.equalsIgnoreCase(";;;;;;;#")) {
            this.ew.lblOpenPositionMessage.setForeground(MyColors.successMessageFG);
            this.ew.lblOpenPositionMessage.setText("No record found");
            this.ew.lblOpenPositionMessage.setIcon(null);
            this.ew.lblTransAmount.setText("0.00");
            this.ew.lblMTMAmount.setText("0.00");
            this.ew.lblPLAmount.setText("0.00");
            return;
        }
        String[] str = msg.trim().split("#");
        double tranAmount = 0.0;
        double mtmAmount = 0.0;
        double plAmount = 0.0;
        for (int rowS = 0; rowS < str.length; ++rowS) {
            Vector<Object> row = new Vector<Object>();
            String[] str2 = str[rowS].split(";");
            if (str2.length <= 0) {
                this.ew.lblOpenPositionMessage.setForeground(MyColors.successMessageFG);
                this.ew.lblOpenPositionMessage.setText("No record found");
                this.ew.lblOpenPositionMessage.setIcon(null);
                this.ew.lblTransAmount.setText("0.00");
                this.ew.lblMTMAmount.setText("0.00");
                this.ew.lblPLAmount.setText("0.00");
                return;
            }
            for (int col = 0; col < str2.length; ++col) {
                String s = str2[col].replaceAll("\\,", "");
                double d = 0.0;
                if (col == 0 || col == 1) {
                    row.addElement(s);
                    continue;
                }
                try {
                    d = Double.parseDouble(s);
                    row.addElement(d);
                    if (col == 4) {
                        tranAmount += d;
                    }
                    if (col == 6) {
                        mtmAmount += d;
                    }
                    if (col != 7) continue;
                    plAmount += d;
                    continue;
                }
                catch (NumberFormatException ex) {
                    row.addElement(s);
                }
            }
            this.ew.openRow.addElement(row);
            this.ew.tblOpenPosition.addNotify();
        }
        this.ew.lblTransAmount.setText(Util.format2digit((String)(tranAmount + "")));
        this.ew.lblMTMAmount.setText(Util.format2digit((String)(mtmAmount + "")));
        this.ew.lblPLAmount.setText(Util.format2digit((String)(plAmount + "")));
        this.ew.lblOpenPositionMessage.setText(Util.format0digit((String)(this.ew.tblOpenPosition.getRowCount() + "".trim().replaceAll("\\,", ""))) + " Record(s)");
        this.ew.lblOpenPositionMessage.setIcon(null);
        this.ew.openSorter.sort();
        this.ew.tblOpenPosition.updateUI();
        this.ew.repaint();
    }

    public void removeOpenTable() {
        this.ew.openRow.clear();
        this.ew.openSorter.sort();
        this.ew.tblOpenPosition.updateUI();
        this.ew.tblOpenPosition.repaint();
    }
}

