/*
 * Decompiled with CFR 0.152.
 */
package Exposure;

import CustomComponent.JTableFilter;
import CustomComponent.JTableTotal;
import CustomComponent.NxGLabelGradeint;
import CustomComponent.NxGTableCellRender;
import MyDocking.Mediator;
import RendersNModels.CollateralModel;
import RendersNModels.FilteredCollateralModel;
import Utilities.LoadLogs;
import Utilities.ThreadWithName;
import common.gui.util.AppConfig;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class PanelCollaterals
extends JPanel {
    Collateral collateral = new Collateral();
    public CollateralModel collateralModel = null;
    Vector collateralColumns = new Vector();
    public Vector collateraRow = new Vector();
    public TableRowSorter<TableModel> collateralsSorter = null;
    JTableFilter collateralFilter = null;
    JTableTotal collateralTotal = null;
    ImageIcon loaderIcon = new ImageIcon(this.getClass().getResource(AppConfig.loaderIconPath));
    ArrayList DataType = new ArrayList();
    List<Class> columnDataType = new ArrayList<Class>();
    public boolean IsModelExist = false;
    public double[] Total;
    CollateralTableCellRender render = new CollateralTableCellRender();
    FilteredCollateralModel filtercollateralmodel;
    private LanguageCentre languageCentre = new LanguageCentre();
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator3;
    public JLabel lblCollateralsMesssage;
    private JPanel pnlCollateralsFilter;
    private JPanel pnlCollateralsTotal;
    public JTable table;

    public PanelCollaterals() {
        this.initComponents();
    }

    private void setCollateralFilter() {
        this.pnlCollateralsFilter.removeAll();
        ArrayList collateralsFilterType = new ArrayList();
        collateralsFilterType = (ArrayList)this.DataType.clone();
        if (this.collateralFilter == null) {
            this.collateralFilter = new JTableFilter(this.table, collateralsFilterType);
            this.collateralFilter.setPrefMinMax();
        }
        this.pnlCollateralsFilter.add(this.collateralFilter);
        this.table.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                PanelCollaterals.this.collateralFilter.changeMargin();
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
        this.repaint();
    }

    private void setCollateralTotal() {
        this.pnlCollateralsTotal.removeAll();
        if (this.collateralTotal == null) {
            this.collateralTotal = new JTableTotal(this.table, (ArrayList)this.DataType.clone());
            this.collateralTotal.setPrefMinMax();
        }
        this.pnlCollateralsTotal.add(this.collateralTotal);
        this.table.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                PanelCollaterals.this.collateralTotal.changeMargin();
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
        this.repaint();
    }

    public void GetData() {
        this.lblCollateralsMesssage.setIcon(this.loaderIcon);
        this.lblCollateralsMesssage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
        LoadLogs loadLogs = new LoadLogs("Collateral=", true);
        new ThreadWithName(loadLogs, "Collateral").start();
    }

    public void ClearAll() {
        this.collateral.removeCollTable();
        this.lblCollateralsMesssage.setText("No record found.");
        this.lblCollateralsMesssage.setIcon(null);
    }

    void updatestatus(String str) {
        this.lblCollateralsMesssage.setIcon(null);
        this.lblCollateralsMesssage.setText(str);
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.table = new JTable();
        this.jSeparator3 = new JSeparator();
        this.pnlCollateralsFilter = new JPanel();
        this.lblCollateralsMesssage = new JLabel();
        this.pnlCollateralsTotal = new JPanel();
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.table.setSelectionForeground(new Color(0, 0, 0));
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                PanelCollaterals.this.tableMouseExited(evt);
            }
        });
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                PanelCollaterals.this.tableMouseMoved(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.table);
        this.pnlCollateralsFilter.setLayout(new GridLayout(1, 0));
        this.lblCollateralsMesssage.setText(" ");
        this.lblCollateralsMesssage.setVerticalAlignment(1);
        this.pnlCollateralsTotal.setLayout(new GridLayout(1, 0));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlCollateralsFilter, -1, 637, Short.MAX_VALUE).addComponent(this.jSeparator3, -1, 637, Short.MAX_VALUE).addComponent(this.pnlCollateralsTotal, -1, 637, Short.MAX_VALUE).addComponent(this.jScrollPane2, -1, 637, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblCollateralsMesssage, -2, 600, -2).addContainerGap(27, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.pnlCollateralsFilter, -2, 23, -2).addGap(0, 0, 0).addComponent(this.pnlCollateralsTotal, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 151, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblCollateralsMesssage, -2, 18, -2)));
    }

    private void tableMouseMoved(MouseEvent evt) {
        int row = this.table.rowAtPoint(evt.getPoint());
        if (row != this.render.getRowNo()) {
            this.render.setRowNo(row);
            this.repaint();
        }
    }

    private void tableMouseExited(MouseEvent evt) {
        this.render.setRowNo(-1);
    }

    void setMessage(String message) {
        this.lblCollateralsMesssage.setText(message);
    }

    public TableModel NewModel() {
        int count = this.table.getRowCount();
        Vector rows = new Vector();
        for (int i = 0; i < count; ++i) {
            Vector<Object> rowsData = new Vector<Object>();
            for (int j = 0; j < 13; ++j) {
                rowsData.addElement(this.table.getModel().getValueAt(this.table.convertRowIndexToModel(i), j));
            }
            rows.add(rowsData);
        }
        this.filtercollateralmodel = new FilteredCollateralModel(rows, this.collateralColumns);
        return this.filtercollateralmodel;
    }

    class Collateral {
        Mediator mediator = Mediator.getInstance();

        public synchronized void fillCollateral(String msg) {
            try {
                PanelCollaterals.this.collateralsSorter = new TableRowSorter<TableModel>(PanelCollaterals.this.table.getModel());
                PanelCollaterals.this.table.setRowSorter(PanelCollaterals.this.collateralsSorter);
                PanelCollaterals.this.lblCollateralsMesssage.setText("");
                this.removeCollTable();
                if (msg.trim().equalsIgnoreCase("Invalid Account")) {
                    PanelCollaterals.this.lblCollateralsMesssage.setForeground(MyColors.ErrorBG);
                    PanelCollaterals.this.lblCollateralsMesssage.setText("Invalid Account");
                    PanelCollaterals.this.lblCollateralsMesssage.setIcon(null);
                    return;
                }
                if (msg.indexOf("|") < 0) {
                    PanelCollaterals.this.lblCollateralsMesssage.setForeground(MyColors.successMessageFG);
                    PanelCollaterals.this.lblCollateralsMesssage.setText("No record found");
                    PanelCollaterals.this.lblCollateralsMesssage.setIcon(null);
                    return;
                }
                boolean Added = false;
                String[] str = msg.split("\\|", -1);
                PanelCollaterals.this.collateralColumns.clear();
                String[] Header = str[0].split("\\;", -1);
                for (int i = 0; i < Header.length; ++i) {
                    PanelCollaterals.this.collateralColumns.add(Header[i]);
                }
                PanelCollaterals.this.DataType.clear();
                PanelCollaterals.this.columnDataType.clear();
                if (str.length < 2) {
                    PanelCollaterals.this.lblCollateralsMesssage.setForeground(MyColors.successMessageFG);
                    PanelCollaterals.this.lblCollateralsMesssage.setText("No record found");
                    PanelCollaterals.this.lblCollateralsMesssage.setIcon(null);
                    return;
                }
                for (int rowS = 1; rowS < str.length; ++rowS) {
                    String[] str2 = str[rowS].split("\\;", -1);
                    Vector<String> row = new Vector<String>();
                    for (int col = 0; col < str2.length; ++col) {
                        String s = str2[col].replaceAll("\\,", "");
                        row.addElement(String.valueOf(s));
                        if (rowS != 1) continue;
                        this.SetDataType(s);
                    }
                    Added = true;
                    PanelCollaterals.this.collateraRow.addElement(row);
                }
                if (Added && PanelCollaterals.this.IsModelExist) {
                    PanelCollaterals.this.table.addNotify();
                }
                if (!PanelCollaterals.this.IsModelExist) {
                    PanelCollaterals.this.IsModelExist = true;
                    PanelCollaterals.this.collateralModel = new CollateralModel(PanelCollaterals.this.collateraRow, PanelCollaterals.this.collateralColumns);
                    PanelCollaterals.this.table.setModel(PanelCollaterals.this.collateralModel);
                    for (int k = 0; k < PanelCollaterals.this.collateralColumns.size(); ++k) {
                        PanelCollaterals.this.table.getColumn(PanelCollaterals.this.collateralColumns.elementAt(k)).setCellRenderer(PanelCollaterals.this.render);
                    }
                    PanelCollaterals.this.table.setRowHeight(AppConfig.rowHeight);
                    PanelCollaterals.this.table.getTableHeader().setReorderingAllowed(false);
                    PanelCollaterals.this.table.setSelectionMode(0);
                    PanelCollaterals.this.collateralModel.setCloumnDataType(PanelCollaterals.this.columnDataType);
                    PanelCollaterals.this.setCollateralFilter();
                    PanelCollaterals.this.setCollateralTotal();
                    JTableHeader header = PanelCollaterals.this.table.getTableHeader();
                    ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(0);
                }
                if (PanelCollaterals.this.table.getRowCount() > 1) {
                    PanelCollaterals.this.lblCollateralsMesssage.setText(Util.format0digit((String)(PanelCollaterals.this.table.getRowCount() + "".trim().replaceAll("\\,", ""))) + " records found.");
                } else {
                    PanelCollaterals.this.lblCollateralsMesssage.setText(Util.format0digit((String)(PanelCollaterals.this.table.getRowCount() + "".trim().replaceAll("\\,", ""))) + " record found.");
                }
                PanelCollaterals.this.lblCollateralsMesssage.setIcon(null);
                this.MakeTotal();
                if (PanelCollaterals.this.collateralsSorter != null) {
                    PanelCollaterals.this.collateralsSorter.sort();
                }
                PanelCollaterals.this.table.updateUI();
                PanelCollaterals.this.repaint();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void removeCollTable() {
            PanelCollaterals.this.collateraRow.clear();
            if (PanelCollaterals.this.collateralsSorter != null) {
                PanelCollaterals.this.collateralsSorter.sort();
            }
            if (PanelCollaterals.this.collateralTotal != null) {
                PanelCollaterals.this.collateralTotal.setTotalValues();
            }
            PanelCollaterals.this.table.updateUI();
            PanelCollaterals.this.table.repaint();
        }

        public void SetDataType(String Val) {
            try {
                if (Val.indexOf(".") > -1) {
                    Double.parseDouble(Val.replaceAll("\\,", ""));
                    PanelCollaterals.this.DataType.add("Double");
                    PanelCollaterals.this.columnDataType.add(Double.class);
                } else {
                    Integer.parseInt(Val.replaceAll("\\,", ""));
                    PanelCollaterals.this.DataType.add("Integer");
                    PanelCollaterals.this.columnDataType.add(Integer.class);
                }
            }
            catch (Exception e) {
                PanelCollaterals.this.DataType.add("String");
                PanelCollaterals.this.columnDataType.add(String.class);
            }
        }

        public void MakeTotal() {
            try {
                int i;
                PanelCollaterals.this.Total = new double[PanelCollaterals.this.DataType.size()];
                for (i = 0; i < PanelCollaterals.this.DataType.size(); ++i) {
                    PanelCollaterals.this.Total[i] = 0.0;
                }
                for (i = 0; i < PanelCollaterals.this.collateraRow.size(); ++i) {
                    Vector Col = (Vector)PanelCollaterals.this.collateraRow.get(i);
                    for (int j = 0; j < PanelCollaterals.this.DataType.size(); ++j) {
                        PanelCollaterals.this.Total[j] = PanelCollaterals.this.Total[j] + this.CheckISDouble(Col.get(j).toString());
                    }
                }
                Vector<String> NewRow = new Vector<String>();
                NewRow.addElement("Total");
                DecimalFormat twoPlacesWithComma = new DecimalFormat("###.##");
                twoPlacesWithComma.setMinimumFractionDigits(2);
                twoPlacesWithComma.setMaximumFractionDigits(2);
                for (int i2 = 1; i2 < PanelCollaterals.this.Total.length; ++i2) {
                    NewRow.addElement(twoPlacesWithComma.format(PanelCollaterals.this.Total[i2]));
                }
                if (PanelCollaterals.this.collateralTotal != null) {
                    PanelCollaterals.this.collateralTotal.setTotalValues(NewRow);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public double CheckISDouble(String str) {
            double RetVal = 0.0;
            try {
                RetVal = Double.parseDouble(str.replaceAll("\\,", ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return RetVal;
        }
    }

    public class CollateralTableCellRender
    extends NxGTableCellRender {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
            NxGLabelGradeint cell = new NxGLabelGradeint();
            String stCol = table.getColumnModel().getColumn(column).getIdentifier().toString();
            cell.setForeground(MyColors.cellRenderFG);
            cell.setVerticalAlignment(0);
            if (obj == null) {
                obj = "";
            }
            boolean isTotalRow = false;
            if (row == PanelCollaterals.this.collateralModel.getRowCount() - 1 && PanelCollaterals.this.collateralModel.getValueAt(row, 0).toString().equalsIgnoreCase("Total")) {
                isTotalRow = true;
            }
            if (PanelCollaterals.this.DataType.get(column).toString().equalsIgnoreCase("Double")) {
                cell.setHorizontalAlignment(4);
                cell.setText(" " + Util.format2digit((String)obj.toString().trim().replaceAll("\\,", "")) + " ");
            } else if (PanelCollaterals.this.DataType.get(column).toString().equalsIgnoreCase("Integer")) {
                cell.setHorizontalAlignment(4);
                cell.setText(" " + Util.format0digit((String)obj.toString().trim().replaceAll("\\,", "")) + " ");
            } else if (PanelCollaterals.this.DataType.get(column).toString().equalsIgnoreCase("String")) {
                cell.setHorizontalAlignment(2);
                cell.setText(" " + obj.toString() + " ");
            }
            if (row % 2 == 0) {
                cell.setGradient(this.getOddColorStart(), this.getOddColorEnd());
            } else {
                cell.setGradient(this.getEvenColorStart(), this.getEvenColorEnd());
            }
            if (isSelected) {
                cell.setGradient(this.getSelectColorStart(), this.getSelectColorEnd());
                cell.setForeground(Color.WHITE);
            }
            if ((this.getRowNo() != -1 || this.getRowNo() <= row) && this.getRowNo() == row) {
                cell.setGradient(this.getRoleOverColorStart(), this.getRoleOverColorEnd());
                cell.setForeground(Color.WHITE);
            }
            if (isTotalRow) {
                cell.setFont(new Font(cell.getFont().getFontName(), 1, cell.getFont().getSize()));
            }
            return cell;
        }
    }
}

