/*
 * Decompiled with CFR 0.152.
 */
package Exposure;

import CustomComponent.JTableFilter;
import CustomComponent.NxGLabelGradeint;
import CustomComponent.NxGTableCellRender;
import RendersNModels.CumulativeSummaryModel;
import Utilities.LoadLogs;
import Utilities.ThreadWithName;
import common.gui.util.AppConfig;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class PanelCumulativeSummery
extends JPanel {
    CumulativeSummary cumulativeSummary = new CumulativeSummary();
    public DefaultTableModel commSummaryModel = null;
    Vector commColumns = new Vector();
    public Vector commRow = new Vector();
    public TableRowSorter<TableModel> cummSorter = null;
    ArrayList commSummaryFilterType = new ArrayList();
    JTableFilter commSummaryfilter = null;
    ImageIcon loaderIcon = new ImageIcon(this.getClass().getResource(AppConfig.loaderIconPath));
    ArrayList DataType = new ArrayList();
    public boolean IsModelExist = false;
    private CommSummaryTableCellRenderer render = new CommSummaryTableCellRenderer();
    private LanguageCentre languageCentre = new LanguageCentre();
    private JScrollPane jScrollPane4;
    private JSeparator jSeparator2;
    public JLabel lblCumSummaryMessage;
    private JPanel pnlCommSummaryFilter;
    public JTable table;

    public PanelCumulativeSummery() {
        this.initComponents();
    }

    public void setCommSummaryFilter() {
        this.pnlCommSummaryFilter.removeAll();
        this.commSummaryFilterType = (ArrayList)this.DataType.clone();
        if (this.commSummaryfilter == null) {
            this.commSummaryfilter = new JTableFilter(this.table, this.commSummaryFilterType);
            this.commSummaryfilter.setPrefMinMax();
        }
        this.pnlCommSummaryFilter.add(this.commSummaryfilter);
        this.table.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                PanelCumulativeSummery.this.commSummaryfilter.changeMargin();
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
    }

    public void fillCumulativeSummary(String result) {
        this.cumulativeSummary.fillCumulativeSummary(result);
    }

    public void GetData() {
        this.lblCumSummaryMessage.setIcon(this.loaderIcon);
        this.lblCumSummaryMessage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
        LoadLogs loadLogs = new LoadLogs("CommSummary=", true);
        new ThreadWithName(loadLogs, "CommSummary").start();
    }

    public void ClearAll() {
        this.lblCumSummaryMessage.setText("No record found.");
        this.lblCumSummaryMessage.setIcon(null);
    }

    void updatestatus(String str) {
        this.lblCumSummaryMessage.setIcon(null);
        this.lblCumSummaryMessage.setText(str);
    }

    private void initComponents() {
        this.jScrollPane4 = new JScrollPane();
        this.table = new JTable(this.commSummaryModel);
        this.lblCumSummaryMessage = new JLabel();
        this.pnlCommSummaryFilter = new JPanel();
        this.jSeparator2 = new JSeparator();
        this.table.setAutoCreateRowSorter(true);
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.table.setSelectionForeground(new Color(0, 0, 0));
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                PanelCumulativeSummery.this.tableMouseExited(evt);
            }
        });
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                PanelCumulativeSummery.this.tableMouseMoved(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.table);
        this.lblCumSummaryMessage.setText(" ");
        this.lblCumSummaryMessage.setVerticalAlignment(1);
        this.pnlCommSummaryFilter.setLayout(new GridLayout(1, 0));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlCommSummaryFilter, -1, -1, Short.MAX_VALUE).addComponent(this.jSeparator2).addComponent(this.jScrollPane4, GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblCumSummaryMessage, -2, 521, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.pnlCommSummaryFilter, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane4, -1, 164, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblCumSummaryMessage, -2, 18, -2)));
    }

    private void tableMouseExited(MouseEvent evt) {
        this.render.setRowNo(-1);
    }

    private void tableMouseMoved(MouseEvent evt) {
        int row = this.table.rowAtPoint(evt.getPoint());
        if (row != this.render.getRowNo()) {
            this.render.setRowNo(row);
            this.repaint();
        }
    }

    void setMessage(String message) {
        this.lblCumSummaryMessage.setText(message);
    }

    public class CommSummaryTableCellRenderer
    extends NxGTableCellRender {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
            NxGLabelGradeint cell = new NxGLabelGradeint();
            String stCol = table.getColumnModel().getColumn(column).getIdentifier().toString();
            cell.setForeground(MyColors.cellRenderFG);
            cell.setVerticalAlignment(0);
            if (obj == null) {
                obj = "";
            }
            boolean isTotalRow = false;
            if (row == PanelCumulativeSummery.this.commSummaryModel.getRowCount() - 1 && PanelCumulativeSummery.this.commSummaryModel.getValueAt(row, 0).toString().equalsIgnoreCase("Total")) {
                isTotalRow = true;
            }
            if (PanelCumulativeSummery.this.DataType.get(column).toString().equalsIgnoreCase("Double")) {
                cell.setHorizontalAlignment(4);
                cell.setText(" " + Util.format2digit((String)obj.toString().trim().replaceAll("\\,", "")) + " ");
            } else if (PanelCumulativeSummery.this.DataType.get(column).toString().equalsIgnoreCase("Integer")) {
                cell.setHorizontalAlignment(4);
                cell.setText(" " + Util.format0digit((String)obj.toString().trim().replaceAll("\\,", "")) + " ");
            } else if (PanelCumulativeSummery.this.DataType.get(column).toString().equalsIgnoreCase("String")) {
                cell.setHorizontalAlignment(2);
                cell.setText(" " + obj.toString() + " ");
            }
            if (row % 2 == 0) {
                cell.setGradient(this.getOddColorStart(), this.getOddColorEnd());
            } else {
                cell.setGradient(this.getEvenColorStart(), this.getEvenColorEnd());
            }
            if (isSelected) {
                cell.setGradient(this.getSelectColorStart(), this.getSelectColorEnd());
                cell.setForeground(Color.WHITE);
            }
            if ((this.getRowNo() != -1 || this.getRowNo() <= row) && this.getRowNo() == row) {
                cell.setGradient(this.getRoleOverColorStart(), this.getRoleOverColorEnd());
                cell.setForeground(Color.WHITE);
            }
            if (isTotalRow) {
                cell.setFont(new Font(cell.getFont().getFontName(), 1, cell.getFont().getSize()));
            }
            return cell;
        }
    }

    class CumulativeSummary {
        public void fillCumulativeSummary(String msg) {
            PanelCumulativeSummery.this.lblCumSummaryMessage.setText("");
            this.removeCummSymmaryTable();
            if (msg.indexOf("|") < 0) {
                PanelCumulativeSummery.this.lblCumSummaryMessage.setForeground(MyColors.successMessageFG);
                PanelCumulativeSummery.this.lblCumSummaryMessage.setText("No record found");
                PanelCumulativeSummery.this.lblCumSummaryMessage.setIcon(null);
                return;
            }
            boolean Added = false;
            String[] str = msg.split("\\|", -1);
            PanelCumulativeSummery.this.commColumns.clear();
            String[] Header = str[0].split("\\;", -1);
            for (int i = 0; i < Header.length; ++i) {
                PanelCumulativeSummery.this.commColumns.add(Header[i]);
            }
            PanelCumulativeSummery.this.DataType.clear();
            if (str.length < 2) {
                PanelCumulativeSummery.this.lblCumSummaryMessage.setForeground(MyColors.successMessageFG);
                PanelCumulativeSummery.this.lblCumSummaryMessage.setText("No record found");
                PanelCumulativeSummery.this.lblCumSummaryMessage.setIcon(null);
                return;
            }
            for (int rowS = 1; rowS < str.length; ++rowS) {
                String[] str2 = str[rowS].split("\\;", -1);
                Vector<String> row = new Vector<String>();
                for (int col = 0; col < str2.length; ++col) {
                    String s = str2[col].replaceAll("\\,", "");
                    row.addElement(String.valueOf(s));
                    if (rowS != 1) continue;
                    this.SetDataType(s);
                }
                Added = true;
                PanelCumulativeSummery.this.commRow.addElement(row);
            }
            if (Added && PanelCumulativeSummery.this.IsModelExist) {
                PanelCumulativeSummery.this.table.addNotify();
            }
            if (!PanelCumulativeSummery.this.IsModelExist) {
                PanelCumulativeSummery.this.IsModelExist = true;
                PanelCumulativeSummery.this.commSummaryModel = new CumulativeSummaryModel(PanelCumulativeSummery.this.commRow, PanelCumulativeSummery.this.commColumns);
                PanelCumulativeSummery.this.table.setModel(PanelCumulativeSummery.this.commSummaryModel);
                PanelCumulativeSummery.this.table.setRowHeight(AppConfig.rowHeight);
                PanelCumulativeSummery.this.table.getTableHeader().setReorderingAllowed(false);
                PanelCumulativeSummery.this.table.setSelectionMode(0);
                for (int k = 0; k < PanelCumulativeSummery.this.commColumns.size(); ++k) {
                    PanelCumulativeSummery.this.table.getColumn(PanelCumulativeSummery.this.commColumns.elementAt(k)).setCellRenderer(PanelCumulativeSummery.this.render);
                }
                PanelCumulativeSummery.this.cummSorter = new TableRowSorter<DefaultTableModel>(PanelCumulativeSummery.this.commSummaryModel);
                PanelCumulativeSummery.this.table.setRowSorter(PanelCumulativeSummery.this.cummSorter);
                PanelCumulativeSummery.this.setCommSummaryFilter();
                JTableHeader header = PanelCumulativeSummery.this.table.getTableHeader();
                ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(0);
            }
            if (PanelCumulativeSummery.this.table.getRowCount() > 1) {
                PanelCumulativeSummery.this.lblCumSummaryMessage.setText(Util.format0digit((String)(PanelCumulativeSummery.this.table.getRowCount() + "".trim().replaceAll("\\,", ""))) + " records found.");
            } else {
                PanelCumulativeSummery.this.lblCumSummaryMessage.setText(Util.format0digit((String)(PanelCumulativeSummery.this.table.getRowCount() + "".trim().replaceAll("\\,", ""))) + " record found.");
            }
            PanelCumulativeSummery.this.lblCumSummaryMessage.setIcon(null);
            if (PanelCumulativeSummery.this.cummSorter != null) {
                PanelCumulativeSummery.this.cummSorter.sort();
            }
            PanelCumulativeSummery.this.table.updateUI();
            PanelCumulativeSummery.this.table.repaint();
            PanelCumulativeSummery.this.repaint();
        }

        public void removeCummSymmaryTable() {
            PanelCumulativeSummery.this.commRow.clear();
            if (PanelCumulativeSummery.this.cummSorter != null) {
                PanelCumulativeSummery.this.cummSorter.sort();
            }
            PanelCumulativeSummery.this.table.updateUI();
            PanelCumulativeSummery.this.table.repaint();
        }

        public void SetDataType(String Val) {
            try {
                if (Val.indexOf(".") > -1) {
                    Double.parseDouble(Val.replaceAll("\\,", ""));
                    PanelCumulativeSummery.this.DataType.add("Double");
                } else {
                    Integer.parseInt(Val.replaceAll("\\,", ""));
                    PanelCumulativeSummery.this.DataType.add("Integer");
                }
            }
            catch (Exception e) {
                PanelCumulativeSummery.this.DataType.add("String");
            }
        }

        public double CheckISDouble(String str) {
            double RetVal = 0.0;
            try {
                RetVal = Double.parseDouble(str.replaceAll("\\,", ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return RetVal;
        }
    }
}

