/*
 * Decompiled with CFR 0.152.
 */
package Exposure;

import MyDocking.Mediator;
import Utilities.LoadLogs;
import Utilities.ThreadWithName;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import languages.LanguageCentre;
import languages.LanguageConstant;
import windows.js.JSFooter;
import windows.js.JSPortfolioDetail;
import windows.js.JSSummary;

public class PanelPortfolioSummary
extends JPanel {
    ImageIcon loaderIcon = new ImageIcon(this.getClass().getResource(AppConfig.loaderIconPath));
    JSFooter footer = new JSFooter();
    public Hashtable<String, ArrayList> ExposureGroups = new Hashtable();
    ArrayList<String> ExposureFieldAndValue1 = new ArrayList();
    ArrayList<String> ExposureFieldAndValue2 = new ArrayList();
    ArrayList<String> ExposureFieldAndValue3 = new ArrayList();
    JSPortfolioDetail porfolio;
    String temp;
    JTable table;
    private LanguageCentre languageCentre;
    private JPanel pnlFooter;
    private JPanel pnlHolder;

    public PanelPortfolioSummary() {
        this.porfolio = new JSPortfolioDetail(this.footer.lblMessage);
        this.temp = "*Account Summary%Equity Cash Balance;0|Commodity Cash Balance;0|$Market Value of Equity;0|Total Worth;0|$Reduced Equity;0|Working Capital;0|*Account Liquidity (KSE)%Net Liquidity(Margin);0|Free Margin;0|Pending Cash Withdrawal;0|$Open Position (Exposure);0|Pending Exposure;0|Ready Buying Power;0|Cash Withdrawal Limit;0|$Margin Required;0|Daily MTM;0|Cash Margin Call;0|$Cash Margin Required;0|Block MTM Profit;0|Net Margin Call;0|^Symbol;Quantity;Avg. BUY RATE;Sold Quantity;Avg. SELL RATE;MTM;MTM Amount;Haircut %;Marginized Value;PENDING SELL;SETTLED P/L;UNSETTLED P/L|";
        this.languageCentre = new LanguageCentre();
        this.initComponents();
        LogCommon.isExposureOpen = true;
        this.pnlFooter.add(this.footer);
        this.setData(this.temp);
        this.table = this.porfolio.getTable();
        Mediator.getInstance().setPortfolioSummary(this);
        this.ExposureGroups.put("1", this.ExposureFieldAndValue1);
        this.ExposureGroups.put("2", this.ExposureFieldAndValue2);
        this.ExposureGroups.put("3", this.ExposureFieldAndValue3);
    }

    private void initComponents() {
        this.pnlHolder = new JPanel();
        this.pnlFooter = new JPanel();
        this.pnlHolder.setLayout(new BoxLayout(this.pnlHolder, 1));
        this.pnlFooter.setLayout(new BoxLayout(this.pnlFooter, 2));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlHolder, -1, 121, Short.MAX_VALUE).addComponent(this.pnlFooter, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pnlHolder, -1, 95, Short.MAX_VALUE).addGap(1, 1, 1).addComponent(this.pnlFooter, -2, 24, -2)));
    }

    public void reset() {
        this.porfolio.reset();
        this.pnlHolder.removeAll();
    }

    public void setData(String result) {
        this.reset();
        if (result.equalsIgnoreCase("Invalid Account")) {
            this.setMessage("Invalid Account");
        } else if (result.indexOf("^") > 0) {
            this.ExposureGroups.clear();
            this.ExposureFieldAndValue1.clear();
            this.ExposureFieldAndValue2.clear();
            this.ExposureFieldAndValue3.clear();
            this.ExposureGroups.put("1", this.ExposureFieldAndValue1);
            this.ExposureGroups.put("2", this.ExposureFieldAndValue2);
            this.ExposureGroups.put("3", this.ExposureFieldAndValue3);
            String[] val = result.split("\\^", -1);
            this.setSummary(val[0]);
            this.porfolio.setPortfolio(val[1]);
            this.porfolio.IsModelExist = false;
            this.pnlHolder.add(this.porfolio);
        } else {
            this.setMessage("Error in loading Exposure Watch");
        }
        this.tableDataChange();
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.pnlHolder.revalidate();
            this.pnlHolder.repaint();
            this.revalidate();
            this.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PanelPortfolioSummary.this.pnlHolder.revalidate();
                    PanelPortfolioSummary.this.pnlHolder.repaint();
                    PanelPortfolioSummary.this.revalidate();
                    PanelPortfolioSummary.this.repaint();
                }
            });
        }
    }

    private void setSummary(String result) {
        if (result.indexOf("*") >= 0) {
            String[] summaries = result.split("\\*", -1);
            for (int i = 0; i < summaries.length; ++i) {
                String summary = summaries[i];
                if (summary.indexOf("%") <= 0) continue;
                String[] values = summary.split("%", -1);
                JSSummary sum = new JSSummary();
                sum.setSummary(values[0], values[1]);
                if (values[1].indexOf("$") > 0) {
                    String[] dt = values[1].split("\\$", -1);
                    for (int j = 0; j < dt.length; ++j) {
                        String string = dt[j];
                        if (string.indexOf("|") <= 0) continue;
                        String[] str = string.split("\\|", -1);
                        for (int k = 0; k < str.length; ++k) {
                            if (str[k].trim().length() <= 0) continue;
                            String string1 = str[k];
                            this.ExposureFieldAndValue1.add(string1.replaceAll(";", "~").trim());
                        }
                    }
                }
                this.pnlHolder.add(sum);
            }
        }
    }

    public void GetData() {
        this.footer.lblMessage.setIcon(this.loaderIcon);
        this.footer.lblMessage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
        LoadLogs loadLogs = new LoadLogs("PortfolioSummary=", true);
        new ThreadWithName(loadLogs, "PortfolioSummary").start();
    }

    public void ClearAll() {
        this.reset();
    }

    public void setMessage(String message) {
        this.footer.lblMessage.setIcon(null);
        this.footer.lblMessage.setText(message);
    }
}

