/*
 * Decompiled with CFR 0.152.
 */
package Logs;

import Beans.OrderBean;
import RendersNModels.LiquidateAllOrderRender;
import common.gui.component.NxGDialogBox;
import common.gui.component.NxGTable;
import common.gui.util.LogCommon;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class CancelAllOrderDialog
extends NxGDialogBox {
    DefaultTableModel outstandingModel = new DefaultTableModel();
    private ArrayList<OrderBean> outstandinglist = new ArrayList();
    public int Option = 1;
    private LanguageCentre languageCentre = new LanguageCentre();
    private JButton btnClose;
    private JButton btnExecute;
    public static JCheckBox isOrderConfirmation;
    private JLabel jLabel1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel lblOrderCount;
    private JLabel lblOrderHeader;
    private JScrollPane scrollPane;
    private NxGTable table;

    public CancelAllOrderDialog(Frame parent, ArrayList<OrderBean> outstandinglist) {
        super(parent, true);
        try {
            this.initComponents();
            this.setTitle(this.languageCentre.getValue("CancelOrders"));
            this.lblOrderHeader.setText("<html>" + this.languageCentre.getValue("FollowingOrdersWillBeCancelAtMarket") + "<html>");
            this.outstandinglist.clear();
            this.outstandinglist = (ArrayList)outstandinglist.clone();
            isOrderConfirmation.setSelected(LogCommon.isCancelOrderConfirmation);
            ((JLabel)((Object)this.table.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(0);
            this.outstandingModel = (DefaultTableModel)this.table.getModel();
            this.table.setModel((TableModel)this.outstandingModel);
            this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new LiquidateAllOrderRender());
            this.table.setRowHeight(18);
            this.table.getTableHeader().setReorderingAllowed(false);
            this.table.setColumnControlVisible(false);
            this.addRows();
            this.setLanguageValues();
            this.setFocus();
            this.setBounds(0, 0, 550, 557);
            this.setLocationRelativeTo((Component)((Object)this));
            this.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void addRows() {
        for (int i = 0; i < this.outstandinglist.size(); ++i) {
            OrderBean ord = this.outstandinglist.get(i);
            this.outstandingModel.addRow(new Object[]{"0", ord.getMarket(), ord.getScrip(), ord.getOrderType(), ord.getVolumeString(), ord.getPrice(), ord.getTime()});
        }
        String outstandingText = "";
        outstandingText = this.outstandinglist.size() <= 1 ? Util.format0digit((String)(this.outstandinglist.size() + "")) + " " + this.languageCentre.getValue(LanguageConstant.Order) + "." : Util.format0digit((String)(this.outstandinglist.size() + "")) + " " + this.languageCentre.getValue(LanguageConstant.Orders) + ".";
        this.tableDataChange();
        this.lblOrderCount.setText(outstandingText);
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.outstandingModel.fireTableDataChanged();
            this.table.addNotify();
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CancelAllOrderDialog.this.outstandingModel.fireTableDataChanged();
                    CancelAllOrderDialog.this.table.addNotify();
                    CancelAllOrderDialog.this.table.repaint();
                }
            });
        }
    }

    private void setFocus() {
        new Thread("Cancel All Order Dialog"){

            @Override
            public void run() {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                CancelAllOrderDialog.this.btnExecute.requestFocus();
            }
        }.start();
    }

    private void initComponents() {
        this.btnExecute = new JButton();
        this.btnClose = new JButton();
        this.jSeparator1 = new JSeparator();
        this.lblOrderHeader = new JLabel();
        this.jLabel1 = new JLabel();
        this.lblOrderCount = new JLabel();
        this.scrollPane = new JScrollPane();
        this.table = new NxGTable();
        isOrderConfirmation = new JCheckBox();
        this.jSeparator2 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        this.btnExecute.setText("Cancel selected order(s)");
        this.btnExecute.setName("CancelAllOrderDialog -> btnExecute");
        this.btnExecute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CancelAllOrderDialog.this.btnExecuteActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.btnExecute);
        this.btnExecute.setBounds(290, 500, 150, 23);
        this.btnClose.setText("Close");
        this.btnClose.setName("CancelAllOrderDialog -> btnClose");
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CancelAllOrderDialog.this.btnCloseActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.btnClose);
        this.btnClose.setBounds(445, 500, 90, 23);
        this.getContentPane().add(this.jSeparator1);
        this.jSeparator1.setBounds(0, 495, 550, 2);
        this.lblOrderHeader.setText("-------");
        this.getContentPane().add(this.lblOrderHeader);
        this.lblOrderHeader.setBounds(28, 14, 360, 30);
        this.jLabel1.setBackground(new Color(255, 255, 255));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/Images/HeaderBG.png")));
        this.jLabel1.setOpaque(true);
        this.getContentPane().add(this.jLabel1);
        this.jLabel1.setBounds(0, 0, 560, 60);
        this.lblOrderCount.setHorizontalAlignment(2);
        this.lblOrderCount.setText("100 found");
        this.getContentPane().add(this.lblOrderCount);
        this.lblOrderCount.setBounds(10, 503, 80, 20);
        this.table.setModel((TableModel)new DefaultTableModel(new Object[0][], new String[]{"Status", "Market", "Scrip", "Order Type", "Volume", "Price", "Time"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false, false, false, false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.table.setAutoResizeMode(0);
        this.scrollPane.setViewportView((Component)this.table);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(70);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(70);
        this.table.getColumnModel().getColumn(6).setPreferredWidth(130);
        this.getContentPane().add(this.scrollPane);
        this.scrollPane.setBounds(10, 70, 523, 420);
        isOrderConfirmation.setText("Always Open Confirmation window");
        isOrderConfirmation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CancelAllOrderDialog.this.isOrderConfirmationActionPerformed(evt);
            }
        });
        this.getContentPane().add(isOrderConfirmation);
        isOrderConfirmation.setBounds(90, 503, 200, 20);
        this.getContentPane().add(this.jSeparator2);
        this.jSeparator2.setBounds(0, 60, 550, 2);
        this.pack();
    }

    private void btnExecuteActionPerformed(ActionEvent evt) {
        this.Option = 0;
        this.dispose();
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.Option = 1;
        this.dispose();
    }

    private void isOrderConfirmationActionPerformed(ActionEvent evt) {
        LogCommon.isCancelOrderConfirmation = isOrderConfirmation.isSelected();
    }

    private void setLanguageValues() {
        this.btnExecute.setText(this.languageCentre.getValue(LanguageConstant.CancelSelectedOrders));
        this.btnClose.setText(this.languageCentre.getValue(LanguageConstant.Close));
        isOrderConfirmation.setText(this.languageCentre.getValue(LanguageConstant.AlwaysOpenConfirmationWindow));
        JTableHeader th = this.table.getTableHeader();
        TableColumnModel tcm = th.getColumnModel();
        TableColumn tc = tcm.getColumn(0);
        tc.setHeaderValue(this.languageCentre.getValue(LanguageConstant.Status));
        tc = tcm.getColumn(1);
        tc.setHeaderValue(this.languageCentre.getValue(LanguageConstant.Market));
        tc = tcm.getColumn(2);
        tc.setHeaderValue(this.languageCentre.getValue(LanguageConstant.Scrip));
        tc = tcm.getColumn(3);
        tc.setHeaderValue(this.languageCentre.getValue(LanguageConstant.OrderType));
        tc = tcm.getColumn(4);
        tc.setHeaderValue(this.languageCentre.getValue(LanguageConstant.Volume));
        tc = tcm.getColumn(5);
        tc.setHeaderValue(this.languageCentre.getValue(LanguageConstant.Price));
        tc = tcm.getColumn(6);
        tc.setHeaderValue(this.languageCentre.getValue(LanguageConstant.Time));
        th.repaint();
    }
}

