/*
 * Decompiled with CFR 0.152.
 */
package Logs;

import Beans.OrderHistoryBean;
import Control.JasperFileChooser;
import Control.ReportControl;
import Control.ReportControlEvent;
import Control.ReportControlListener;
import CustomComponent.JTableFilter;
import CustomComponent.MyTime;
import MyDocking.Mediator;
import RendersNModels.OrderHistoryModel;
import RendersNModels.OrderHistoryRender;
import Utilities.CompressManager;
import Utilities.LogsTC;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.bean.AccountBean;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import languages.LanguageCentre;
import languages.LanguageConstant;
import login.LoginServer;
import org.jdesktop.swingx.JXDatePicker;
import reports.Jasper_Report;
import reports.Report_OrderHistory;

public class OrderHistory
extends JPanel
implements FocusListener,
ReportControlListener,
ActionListener,
KeyListener {
    public static final int indexScrip = 0;
    public static final int indexQuantity = 1;
    public static final int indexGrossRate = 2;
    public static final int indexNetAmount = 3;
    public static final int indexType = 4;
    public static final int indexSettlementType = 5;
    public static final int indexExecutionDate = 6;
    public static final int indexClearingDate = 7;
    public static final int indexDescription = 8;
    public String JRXMLFileName = "OrderHistory.jrxml";
    Mediator mediator = Mediator.getInstance();
    public Vector<OrderHistoryBean> rows = new Vector();
    public Vector<OrderHistoryBean> reportRows = new Vector();
    public Vector columns = new Vector();
    OrderHistoryModel model = null;
    ReportModel reportModel = null;
    OrderHistoryRender render = new OrderHistoryRender();
    ArrayList FilterType = new ArrayList();
    JTableFilter filter = null;
    JTextComponent editorAccount;
    JTextComponent editorType;
    JTextComponent editorScrip;
    DateFormat df = new SimpleDateFormat("E MMM dd HH:mm:ss Z yyyy");
    private LanguageCentre languageCentre = new LanguageCentre();
    Timer timer = new Timer(10, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            OrderHistory.this.cbAccountNo.requestFocus();
            OrderHistory.this.timer.stop();
        }
    });
    Thread thear1 = new Thread(new Thread(){

        @Override
        public void run() {
            String result = "";
            try {
                OrderHistory.this.removeTable();
                String accountNo = OrderHistory.this.cbAccountNo.getSelectedItem().toString().trim();
                String scrip = "";
                scrip = OrderHistory.this.cbScrip.getSelectedItem() == null ? "All" : OrderHistory.this.cbScrip.getSelectedItem().toString().trim();
                if (scrip.equalsIgnoreCase("")) {
                    scrip = "ALL";
                }
                String type = OrderHistory.this.cbType.getSelectedItem().toString().trim();
                String startDate = LogsTC.dateFormatAcc.format(OrderHistory.this.txtStartDate.getDate());
                String endDate = LogsTC.dateFormatAcc.format(OrderHistory.this.txtEndDate.getDate());
                LoginServer port = WebService.getInstance().getPort();
                byte[] data = port.getOrderHistory(LogCommon.UserID, accountNo, "", scrip, type, startDate, endDate, "OrderHistory");
                result = CompressManager.unzipStringFromBytes(data);
                Mediator.getInstance().println("Order History = " + result);
                if (result.equalsIgnoreCase("Error")) {
                    Util.setMessage((JLabel)OrderHistory.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in Loading");
                }
                if (result.equalsIgnoreCase("Exception")) {
                    Util.setMessage((JLabel)OrderHistory.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in Loading");
                } else if (result.equalsIgnoreCase("No Record(s) found")) {
                    Util.setMessage((JLabel)OrderHistory.this.lblMessage, (MessageType)MessageType.Information, (String)"No Record(s) found");
                } else if (result.equalsIgnoreCase("AccountNotAssign")) {
                    Util.setMessage((JLabel)OrderHistory.this.lblMessage, (MessageType)MessageType.Error, (String)("Account '" + accountNo + "' is Not assign"));
                } else {
                    OrderHistory.this.fillTable(result);
                }
            }
            catch (Exception ex) {
                Util.setMessage((JLabel)OrderHistory.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in Loading");
                ex.printStackTrace();
                Mediator.getInstance().PrintLog(ex, result);
            }
        }
    });
    private JButton btnGet;
    public JComboBox cbAccountNo;
    private JComboBox cbName;
    public JComboBox cbScrip;
    private JComboBox cbType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lblMessage;
    private ReportControl reportControl1;
    private JTable table;
    public JXDatePicker txtEndDate;
    public JXDatePicker txtStartDate;

    public OrderHistory() {
        this.initComponents();
        this.columns.add("Scrip");
        this.columns.add("Quantity");
        this.columns.add("Gross Rate");
        this.columns.add("Net Amount");
        this.columns.add("Type");
        this.columns.add("Settlement Type");
        this.columns.add("Execution Date");
        this.columns.add("Clearing Date");
        this.columns.add("Description");
        this.FilterType.add("String");
        this.FilterType.add("Double");
        this.FilterType.add("Double");
        this.FilterType.add("Double");
        this.FilterType.add("String");
        this.FilterType.add("String");
        this.FilterType.add("String");
        this.FilterType.add("String");
        this.FilterType.add("String");
        this.model = new OrderHistoryModel((Vector)this.rows, this.columns);
        this.reportModel = new ReportModel(this.reportRows, this.columns);
        this.mediator.setOrderHistory(this);
        this.table.setModel(this.model);
        this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(LogsTC.accountAll.keySet().toArray()));
        AutoCompleteSupport support = AutoCompleteSupport.install((JComboBox)this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])LogsTC.accountAll.keySet().toArray()));
        support.setStrict(true);
        String[] names = new String[LogsTC.accountAll.size()];
        int j = 0;
        for (String key : LogsTC.accountAll.keySet()) {
            AccountBean ac = LogsTC.accountAll.get(key);
            names[j++] = ac.getName();
        }
        this.cbName.setModel(new DefaultComboBoxModel<String>(names));
        Object[] ty = new String[]{"ALL", "BUY", "SELL"};
        this.cbType.setModel(new DefaultComboBoxModel<String>(ty));
        AutoCompleteSupport support2 = AutoCompleteSupport.install((JComboBox)this.cbType, (EventList)GlazedLists.eventListOf((Object[])ty));
        support2.setStrict(true);
        this.editorAccount = (JTextComponent)this.cbAccountNo.getEditor().getEditorComponent();
        this.editorType = (JTextComponent)this.cbAccountNo.getEditor().getEditorComponent();
        this.editorScrip = (JTextComponent)this.cbAccountNo.getEditor().getEditorComponent();
        this.editorAccount.addFocusListener(this);
        if (LogCommon.preferredAccount.equalsIgnoreCase("")) {
            this.cbAccountNo.setSelectedItem("");
        } else {
            this.cbAccountNo.setSelectedItem(LogCommon.preferredAccount);
        }
        this.table.setRowHeight(AppConfig.rowHeight);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setSelectionMode(0);
        for (int i = 0; i < this.columns.size(); ++i) {
            this.table.getColumnModel().getColumn(i).setCellRenderer(this.render);
        }
        this.txtStartDate.setFormats(new DateFormat[]{LogsTC.dateFormatAcc});
        this.txtEndDate.setFormats(new DateFormat[]{LogsTC.dateFormatAcc});
        this.txtStartDate.setDate(new Date(System.currentTimeMillis()));
        this.txtEndDate.setDate(new Date(System.currentTimeMillis()));
        Vector allScrip = new Vector(LogCommon.SymbolAndSymbolName.keySet());
        allScrip.addElement("ALL");
        Collections.sort(allScrip);
        this.cbScrip.setModel(new DefaultComboBoxModel(allScrip));
        AutoCompleteSupport support3 = AutoCompleteSupport.install((JComboBox)this.cbScrip, (EventList)GlazedLists.eventListOf((Object[])allScrip.toArray()));
        this.cbScrip.setSelectedItem("ALL");
        this.lblMessage.setText("");
        this.cbAccountNo.addFocusListener(this);
        this.cbName.addFocusListener(this);
        this.cbType.addFocusListener(this);
        this.cbScrip.addFocusListener(this);
        this.txtStartDate.addFocusListener((FocusListener)this);
        this.txtEndDate.addFocusListener((FocusListener)this);
        this.cbAccountNo.addActionListener(this);
        this.cbName.addActionListener(this);
        this.cbType.addActionListener(this);
        this.cbScrip.addActionListener(this);
        this.txtStartDate.addActionListener((ActionListener)this);
        this.txtEndDate.addActionListener((ActionListener)this);
        this.reportControl1.addListener(this);
        this.filter = new JTableFilter(this.table, this.FilterType);
        this.jPanel1.add(this.filter);
        this.table.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                OrderHistory.this.filter.changeMargin();
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
        JTableHeader header = this.table.getTableHeader();
        ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(0);
        this.timer.start();
    }

    public synchronized void fillTable(String feed) {
        this.removeTable();
        if (feed.indexOf("|") >= 0) {
            String[] rowS = feed.split("\\|", -1);
            for (int rowSS = 0; rowSS < rowS.length; ++rowSS) {
                if (rowS[rowSS].indexOf(";") < 0) continue;
                this.rows.addElement(this.parse(rowS[rowSS]));
            }
            if (this.rows.size() <= 1) {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Normal, (String)(Util.format0digit((String)(this.rows.size() + "")) + " record found."));
            } else {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Normal, (String)(Util.format0digit((String)(this.rows.size() + "")) + " records found."));
            }
        } else {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Normal, (String)"No record found.");
        }
        this.tableDataChange();
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.model.fireTableDataChanged();
            this.table.addNotify();
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OrderHistory.this.model.fireTableDataChanged();
                    OrderHistory.this.table.addNotify();
                    OrderHistory.this.table.repaint();
                }
            });
        }
    }

    private void removeTable() {
        this.rows.clear();
        this.tableDataChange();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.cbType = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.txtStartDate = new JXDatePicker();
        this.txtEndDate = new JXDatePicker();
        this.cbScrip = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.cbAccountNo = new JComboBox();
        this.jLabel6 = new JLabel();
        this.cbName = new JComboBox();
        this.lblMessage = new JLabel();
        this.btnGet = new JButton();
        this.jPanel1 = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.reportControl1 = new ReportControl();
        this.jLabel1.setText("Account No");
        this.cbType.setModel(new DefaultComboBoxModel<String>(new String[]{"All", "Buy", "Sell"}));
        this.jLabel2.setText("Scrip");
        this.jLabel3.setText("End Date");
        this.jLabel4.setText("Type");
        this.jLabel5.setText("Start Date");
        this.cbScrip.setEditable(true);
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4", "null", "null", "null"}){
            Class[] types;
            {
                this.types = new Class[]{String.class, Long.class, Double.class, String.class, String.class, String.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                OrderHistory.this.tableMouseExited(evt);
            }
        });
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                OrderHistory.this.tableMouseMoved(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.table);
        this.cbAccountNo.setEditable(true);
        this.jLabel6.setText("Name");
        this.cbName.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.lblMessage.setText(" ");
        this.btnGet.setIcon(new ImageIcon(this.getClass().getResource("/Images/get.png")));
        this.btnGet.setText("Get");
        this.btnGet.setName("OrderHistory -> btnGet");
        this.btnGet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderHistory.this.btnGetActionPerformed(evt);
            }
        });
        this.jPanel1.setBackground(new Color(255, 204, 51));
        this.jPanel1.setLayout(new GridLayout(1, 0));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 60, -2).addGap(10, 10, 10).addComponent(this.cbAccountNo, -2, 170, -2).addGap(10, 10, 10).addComponent(this.jLabel6, -2, 40, -2).addGap(20, 20, 20).addComponent(this.cbName, -2, 260, -2).addGap(18, 18, Short.MAX_VALUE).addComponent(this.reportControl1, -2, -1, -2).addGap(18, 18, 18)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4, -2, 60, -2).addGap(10, 10, 10).addComponent(this.cbType, -2, 50, -2).addGap(10, 10, 10).addComponent(this.jLabel2, -2, 30, -2).addGap(10, 10, 10).addComponent(this.cbScrip, -2, 70, -2).addGap(10, 10, 10).addComponent(this.jLabel5).addGap(10, 10, 10).addComponent((Component)this.txtStartDate, -2, 100, -2).addGap(10, 10, 10).addComponent(this.jLabel3, -2, 50, -2).addGap(0, 0, 0).addComponent((Component)this.txtEndDate, -2, 100, -2).addGap(10, 10, 10).addComponent(this.btnGet)).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGap(20, 20, 20)).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1).addGap(20, 20, 20)).addComponent(this.lblMessage, -2, 670, -2))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, 20, -2).addComponent(this.cbAccountNo, -2, -1, -2).addComponent(this.jLabel6, -2, 20, -2).addComponent(this.cbName, -2, -1, -2).addComponent(this.reportControl1, -2, -1, -2)).addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4, -2, 20, -2).addComponent(this.cbType, -2, -1, -2).addComponent(this.jLabel2, -2, 20, -2).addComponent(this.cbScrip, -2, -1, -2).addComponent(this.jLabel5, -2, 20, -2).addComponent((Component)this.txtStartDate, -2, -1, -2).addComponent(this.jLabel3, -2, 20, -2).addComponent((Component)this.txtEndDate, -2, -1, -2).addComponent(this.btnGet)).addGap(7, 7, 7).addComponent(this.jPanel1, -2, 23, -2).addGap(0, 0, 0).addComponent(this.jScrollPane1, -1, 338, Short.MAX_VALUE).addGap(9, 9, 9).addComponent(this.jSeparator1, -2, -1, -2).addGap(8, 8, 8).addComponent(this.lblMessage, -2, 20, -2)));
    }

    private void btnGetActionPerformed(ActionEvent evt) {
        this.lblMessage.setText(" ");
        if (this.cbAccountNo.getSelectedItem() == null) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Please select account.");
            this.cbAccountNo.requestFocus();
            return;
        }
        if (this.cbAccountNo.getSelectedItem().toString().length() <= 0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Please select account.");
            this.cbAccountNo.requestFocus();
            return;
        }
        if (this.txtStartDate.getDate() == null) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Please select Start date.");
            this.txtStartDate.requestFocus();
            return;
        }
        if (this.txtEndDate.getDate() == null) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Please select End date");
            this.txtStartDate.requestFocus();
            return;
        }
        if (this.txtEndDate.getDate().compareTo(this.txtStartDate.getDate()) < 0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Start date should be greater then or equal to end date.");
            this.txtStartDate.requestFocus();
            return;
        }
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Loading, (String)this.languageCentre.getValue(LanguageConstant.Loading));
        new Thread((Runnable)this.thear1, "OrderHistory").start();
    }

    private void tableMouseExited(MouseEvent evt) {
        this.render.setRowNo(-1);
    }

    private void tableMouseMoved(MouseEvent evt) {
        int row = this.table.rowAtPoint(evt.getPoint());
        if (row != this.render.getRowNo()) {
            this.render.setRowNo(row);
            this.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.cbAccountNo) {
            if (e.getModifiers() == 16 || e.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
                this.editorAccount.selectAll();
                this.cbName.removeActionListener(this);
                this.cbName.setSelectedIndex(this.cbAccountNo.getSelectedIndex());
                this.cbName.addActionListener(this);
                this.cbType.requestFocus();
            }
        } else if (obj == this.cbName) {
            this.cbAccountNo.removeActionListener(this);
            this.cbAccountNo.setSelectedIndex(this.cbName.getSelectedIndex());
            this.cbAccountNo.addActionListener(this);
        } else if (obj == this.cbType) {
            this.cbScrip.requestFocus();
        } else if (obj == this.cbScrip) {
            if (e.getModifiers() == 16 || e.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
                this.txtStartDate.requestFocus();
            }
        } else if (obj == this.txtStartDate) {
            this.txtEndDate.requestFocus();
        } else if (obj == this.txtEndDate) {
            this.btnGet.requestFocus();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object source = e.getSource();
        if (source == this.editorAccount) {
            this.cbName.removeActionListener(this);
            this.cbName.setSelectedIndex(this.cbAccountNo.getSelectedIndex());
            this.cbName.addActionListener(this);
            this.cbType.requestFocus();
        }
    }

    @Override
    public void ReportControl_Print(ReportControlEvent e) {
        this.fillReportData();
        Report_OrderHistory Report = new Report_OrderHistory(this.JRXMLFileName, (TableModel)this.reportModel);
        this.SetParameter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        Report.PrintReport();
    }

    @Override
    public void ReportControl_Save(ReportControlEvent e) {
        String FileName;
        boolean result;
        this.fillReportData();
        Report_OrderHistory Report = new Report_OrderHistory(this.JRXMLFileName, (TableModel)this.reportModel);
        this.SetParameter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File("Order History-" + MyTime.getInstance().getDate()));
        fc.addAllJasperChoosableFileFilter();
        fc.setAcceptAllFileFilterUsed(false);
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null && !(result = Report.Export(FileName = fc.getSelectedFile().getAbsolutePath() + "." + fc.getExtenstion()))) {
            JOptionPane.showMessageDialog(null, "Error in saving file.");
        }
    }

    @Override
    public void ReportControl_Pdf(ReportControlEvent e) {
        int Option;
        String FileName;
        boolean result;
        this.fillReportData();
        Report_OrderHistory Report = new Report_OrderHistory(this.JRXMLFileName, (TableModel)this.reportModel);
        this.SetParameter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File("Order History-" + MyTime.getInstance().getDate()));
        fc.addPdfFileFilter();
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null && (result = Report.ExportToPdf(FileName = fc.getSelectedFile().getAbsolutePath().replaceAll("\"", "") + "." + fc.getExtenstion())) && (Option = JOptionPane.showConfirmDialog(null, "Order History report created. Do you want to open it?", "PDF", 0)) == 0) {
            try {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + FileName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void ReportControl_View(ReportControlEvent e) {
        this.fillReportData();
        Report_OrderHistory Report = new Report_OrderHistory(this.JRXMLFileName, (TableModel)this.reportModel);
        this.SetParameter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        Report.generateReport();
    }

    private void SetParameter(Jasper_Report Report) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("PrintDate", MyTime.getInstance().getTimeAndDateForReport().trim());
        param.put("AccountName", this.cbName.getSelectedItem().toString());
        param.put("AccountNo", this.cbAccountNo.getSelectedItem());
        param.put("FromDate", LogsTC.dateFormatAcc.format(this.txtStartDate.getDate()));
        param.put("ToDate", LogsTC.dateFormatAcc.format(this.txtEndDate.getDate()));
        Report.SetParameter(param);
    }

    @Override
    public void ReportControl_CustomExport(ReportControlEvent e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private OrderHistoryBean parse(String feed) {
        OrderHistoryBean bean = new OrderHistoryBean();
        if (feed.indexOf(";") >= 0) {
            String[] col = feed.split("\\;", -1);
            bean.setSCRIP(col[0]);
            try {
                bean.setQuantity(Long.parseLong(col[1]));
            }
            catch (Exception ex) {
                bean.setQuantity(0L);
                ex.printStackTrace();
            }
            try {
                bean.setGrossRate(Double.parseDouble(col[2]));
            }
            catch (Exception ex) {
                bean.setGrossRate(0.0);
                ex.printStackTrace();
            }
            try {
                bean.setNetAmount(Double.parseDouble(col[3]));
            }
            catch (Exception ex) {
                bean.setNetAmount(0.0);
                ex.printStackTrace();
            }
            bean.setType(col[4]);
            bean.setSettlementType(col[5]);
            try {
                bean.setClearingDate(LogsTC.dateFormatAcc.parse(col[7]));
            }
            catch (Exception ex) {
                bean.setClearingDate(null);
                ex.printStackTrace();
            }
            try {
                bean.setExecutionDate(LogsTC.dateFormatAcc.parse(col[6]));
            }
            catch (Exception ex) {
                bean.setExecutionDate(null);
                ex.printStackTrace();
            }
            try {
                bean.setDescription(col[8]);
            }
            catch (Exception ex) {
                bean.setExecutionDate(null);
                ex.printStackTrace();
            }
        }
        return bean;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        Object obj = evt.getSource();
        if (obj == this.editorAccount) {
            if (evt.getKeyCode() == 10) {
                this.cbType.removeFocusListener(this);
                this.cbType.requestFocus();
                this.cbType.addFocusListener(this);
            }
        } else if (obj == this.editorType) {
            if (evt.getKeyCode() == 10) {
                this.cbScrip.removeFocusListener(this);
                this.cbScrip.requestFocus();
                this.cbScrip.addFocusListener(this);
            }
        } else if (obj == this.editorScrip && evt.getKeyCode() == 10) {
            this.txtStartDate.removeFocusListener((FocusListener)this);
            this.txtStartDate.requestFocus();
            this.txtStartDate.addFocusListener((FocusListener)this);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public void fillReportData() {
        try {
            this.reportRows.clear();
            int count = this.table.getRowCount();
            for (int i = 0; i < count; ++i) {
                OrderHistoryBean beans = new OrderHistoryBean();
                beans.setSCRIP(this.table.getModel().getValueAt(this.table.convertRowIndexToModel(i), 0).toString());
                beans.setQuantity(Long.parseLong(this.table.getModel().getValueAt(this.table.convertRowIndexToModel(i), 1).toString()));
                beans.setGrossRate(Double.parseDouble(this.table.getModel().getValueAt(this.table.convertRowIndexToModel(i), 2).toString()));
                beans.setNetAmount(Double.parseDouble(this.table.getModel().getValueAt(this.table.convertRowIndexToModel(i), 3).toString()));
                beans.setType(this.table.getModel().getValueAt(this.table.convertRowIndexToModel(i), 4).toString());
                beans.setSettlementType(this.table.getModel().getValueAt(this.table.convertRowIndexToModel(i), 5).toString());
                beans.setExecutionDate(this.df.parse(this.table.getModel().getValueAt(this.table.convertRowIndexToModel(i), 6).toString()));
                beans.setClearingDate(this.df.parse(this.table.getModel().getValueAt(this.table.convertRowIndexToModel(i), 7).toString()));
                this.reportRows.addElement(beans);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private class ReportModel
    extends DefaultTableModel {
        public ReportModel() {
        }

        private ReportModel(Vector<OrderHistoryBean> rows, Vector columns) {
            super(rows, columns);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row < 0 || row >= this.getRowCount()) {
                return "";
            }
            Object obj = this.dataVector.elementAt(row);
            if (obj instanceof OrderHistoryBean) {
                OrderHistoryBean bean = (OrderHistoryBean)obj;
                switch (column) {
                    case 0: {
                        return bean.getSCRIP();
                    }
                    case 1: {
                        return Util.format0digit((String)(bean.getQuantity() + ""));
                    }
                    case 2: {
                        return Util.format2digit((String)(bean.getGrossRate() + ""));
                    }
                    case 3: {
                        return Util.format2digit((String)(bean.getNetAmount() + ""));
                    }
                    case 4: {
                        return bean.getType();
                    }
                    case 5: {
                        return bean.getSettlementType();
                    }
                    case 6: {
                        try {
                            return LogsTC.dateFormatAcc.format(bean.getExecutionDate());
                        }
                        catch (IllegalArgumentException e) {
                            return "";
                        }
                    }
                    case 7: {
                        try {
                            return LogsTC.dateFormatAcc.format(bean.getClearingDate());
                        }
                        catch (IllegalArgumentException e) {
                            return "";
                        }
                    }
                    case 8: {
                        return bean.getDescription();
                    }
                }
                return "";
            }
            return "";
        }
    }
}

