/*
 * Decompiled with CFR 0.152.
 */
package Logs;

import Control.JasperFileChooser;
import Control.ReportControl;
import Control.ReportControlEvent;
import Control.ReportControlListener;
import CustomComponent.JTableFilter;
import CustomComponent.MyTime;
import MyDocking.Mediator;
import RendersNModels.AccStatementCellRenderer;
import RendersNModels.AccStatementModel;
import RendersNModels.FilteredAccStatementModel;
import Utilities.LoadLogs;
import Utilities.LogsTC;
import Utilities.ThreadWithName;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.bean.AccountBean;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.MyColors;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import languages.LanguageCentre;
import languages.LanguageConstant;
import org.jdesktop.swingx.JXDatePicker;
import reports.Jasper_Report;
import reports.Report_AccountStatement;

public class PreviousAccountStatement
extends JPanel
implements FocusListener,
ReportControlListener,
ActionListener {
    Mediator mediator = Mediator.getInstance();
    public Vector rows = null;
    public Vector columns = new Vector();
    DefaultTableModel accStatementModel = null;
    DefaultTableModel filteredaccStatementModel = null;
    ArrayList FilterType = new ArrayList();
    JTableFilter filter = null;
    ImageIcon loaderIcon = new ImageIcon(this.getClass().getResource(AppConfig.loaderIconPath));
    private AccStatementCellRenderer render = new AccStatementCellRenderer();
    private AutoCompleteSupport autoCom;
    private LanguageCentre languageCentre = new LanguageCentre();
    private JButton btnGet;
    public JComboBox cbAccountNo;
    private JComboBox cbName;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lblMessage;
    private ReportControl reportControl1;
    private JTable table;
    public JXDatePicker txtFromDate;
    public JXDatePicker txtToDate;
    public String JRXMLFileName = "AccountStatement.jrxml";

    public PreviousAccountStatement() {
        this.rows = new Vector();
        this.columns.add("Voucher No");
        this.columns.add("Date");
        this.columns.add("Description");
        this.columns.add("Debit");
        this.columns.add("Credit");
        this.columns.add("Balance");
        this.FilterType.add("String");
        this.FilterType.add("String");
        this.FilterType.add("String");
        this.FilterType.add("Double");
        this.FilterType.add("Double");
        this.FilterType.add("Double");
        this.accStatementModel = new AccStatementModel(this.rows, this.columns);
        this.mediator.setPreviousAccountStatement(this);
        this.initComponents();
        this.table.setModel(this.accStatementModel);
        this.autoCom = AutoCompleteSupport.install((JComboBox)this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])LogsTC.accountAll.keySet().toArray()));
        this.cbAccountNo.addActionListener(this);
        String[] names = new String[LogsTC.accountAll.size()];
        Iterator<String> en = LogsTC.accountAll.keySet().iterator();
        int i = 0;
        while (en.hasNext()) {
            String key = en.next().toString();
            AccountBean ac = LogsTC.accountAll.get(key);
            names[i++] = ac.getName();
        }
        this.cbName.setModel(new DefaultComboBoxModel<String>(names));
        this.cbName.addActionListener(this);
        this.cbAccountNo.requestFocus();
        this.table.setModel(this.accStatementModel);
        this.table.setDefaultRenderer(Object.class, this.render);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(260);
        JTableHeader header = this.table.getTableHeader();
        ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(0);
        this.cbAccountNo.addFocusListener(this);
        if (LogCommon.preferredAccount.equalsIgnoreCase("")) {
            this.cbAccountNo.setSelectedItem("");
        } else {
            this.cbAccountNo.setSelectedItem(LogCommon.preferredAccount);
        }
        this.autoCom.setStrict(true);
        this.table.setRowHeight(AppConfig.rowHeight);
        this.table.getTableHeader().setReorderingAllowed(false);
        int year = 2015;
        int month = 6;
        int day = 30;
        String date = year + "/" + month + "/" + day;
        Date utilDate = null;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");
            utilDate = formatter.parse(date);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        this.txtFromDate.setFormats(new DateFormat[]{LogsTC.dateFormatAcc});
        this.txtToDate.setFormats(new DateFormat[]{LogsTC.dateFormatAcc});
        this.txtFromDate.getMonthView().setUpperBound(utilDate);
        this.txtFromDate.setDate(utilDate);
        this.txtToDate.getMonthView().setUpperBound(utilDate);
        this.txtToDate.setDate(utilDate);
        this.filter = new JTableFilter(this.table, this.FilterType);
        this.jPanel1.add(this.filter);
        this.table.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                PreviousAccountStatement.this.filter.changeMargin();
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
        this.reportControl1.addListener(this);
        this.filter.removeColumn(0);
        this.table.removeColumn(this.table.getColumnModel().getColumn(0));
        if (AppConfig.houseName.equalsIgnoreCase("JSGCL")) {
            this.jLabel4.setVisible(false);
            this.txtToDate.setVisible(false);
        }
    }

    public void Update(String feed) {
        this.removeAccStatementTable();
        if (feed.equalsIgnoreCase("Exception")) {
            this.lblMessage.setForeground(Color.BLACK);
            this.lblMessage.setText("Error in loading Previous Account Statement");
            this.lblMessage.setIcon(null);
            return;
        }
        if (feed.indexOf("|") < 0) {
            this.lblMessage.setForeground(MyColors.successMessageFG);
            this.lblMessage.setText("No record found");
            this.lblMessage.setIcon(null);
            return;
        }
        if (feed.indexOf("|") >= 0) {
            String[] rowS = feed.split("\\|", -1);
            for (int rowSS = 0; rowSS < rowS.length; ++rowSS) {
                if (rowS[rowSS].indexOf(";") < 0) continue;
                Vector<String> row = new Vector<String>();
                String[] str2 = rowS[rowSS].split("\\;", -1);
                for (int col = 0; col < str2.length; ++col) {
                    if (col == 1) continue;
                    String s = str2[col];
                    row.addElement(String.valueOf(s));
                }
                this.rows.addElement(row);
                this.tableDataChange();
            }
        }
        this.lblMessage.setText(" ");
        this.lblMessage.setIcon(null);
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.table.addNotify();
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PreviousAccountStatement.this.table.addNotify();
                    PreviousAccountStatement.this.table.repaint();
                }
            });
        }
    }

    private void removeAccStatementTable() {
        this.rows.clear();
        this.tableDataChange();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.btnGet = new JButton();
        this.jLabel4 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.lblMessage = new JLabel();
        this.cbAccountNo = new JComboBox();
        this.jPanel1 = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.reportControl1 = new ReportControl();
        this.txtFromDate = new JXDatePicker();
        this.txtToDate = new JXDatePicker();
        this.jLabel2 = new JLabel();
        this.cbName = new JComboBox();
        this.jLabel1.setHorizontalAlignment(2);
        this.jLabel1.setText("Account");
        this.btnGet.setIcon(new ImageIcon(this.getClass().getResource("/Images/get.png")));
        this.btnGet.setText("Get");
        this.btnGet.setName("PreviousAccountStatement -> btnGet");
        this.btnGet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreviousAccountStatement.this.btnGetActionPerformed(evt);
            }
        });
        this.jLabel4.setHorizontalAlignment(2);
        this.jLabel4.setText("To Date");
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText("From Date");
        this.jScrollPane1.setPreferredSize(new Dimension(452, 100));
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[]{"Voucher No.", "Date", "Description", "Credit", "Debit", "Balance"}));
        this.table.setFocusable(false);
        this.table.setMinimumSize(new Dimension(50, 0));
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                PreviousAccountStatement.this.tableMouseExited(evt);
            }
        });
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                PreviousAccountStatement.this.tableMouseMoved(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.table);
        this.lblMessage.setText(" ");
        this.cbAccountNo.setEditable(true);
        this.jPanel1.setLayout(new GridLayout(1, 0));
        this.jLabel2.setText("Name");
        this.cbName.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 710, Short.MAX_VALUE).addComponent(this.lblMessage, -2, 588, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel3, -2, 51, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.txtFromDate, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel4, -2, 47, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.txtToDate, -2, 121, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 33, Short.MAX_VALUE).addComponent(this.btnGet, -2, 91, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 45, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.cbAccountNo, 0, 125, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2, -2, 47, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbName, -2, 249, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.reportControl1, -2, -1, -2))).addContainerGap()));
        layout.linkSize(0, new Component[]{this.cbAccountNo, this.txtFromDate, this.txtToDate});
        layout.linkSize(0, this.jLabel1, this.jLabel3);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, 23, -2).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbAccountNo, -2, -1, -2).addComponent(this.cbName, -2, -1, -2).addComponent(this.jLabel2, -2, 17, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.txtFromDate, -2, -1, -2).addComponent(this.jLabel3).addComponent((Component)this.txtToDate, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.btnGet)).addComponent(this.reportControl1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, 23, -2).addGap(0, 0, 0).addComponent(this.jScrollPane1, -1, 110, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblMessage, -2, 19, -2)));
        layout.linkSize(1, this.cbAccountNo, this.jLabel3);
        layout.linkSize(1, this.jLabel2, this.jLabel4);
        layout.linkSize(1, new Component[]{this.cbName, this.txtToDate});
    }

    private void btnGetActionPerformed(ActionEvent evt) {
        this.lblMessage.setText(" ");
        this.removeAccStatementTable();
        if (this.cbAccountNo.getSelectedItem() == null) {
            this.lblMessage.setForeground(MyColors.errorMessageFG);
            this.lblMessage.setText("Please select account.");
            this.cbAccountNo.requestFocus();
            return;
        }
        if (this.cbAccountNo.getSelectedItem().toString().length() <= 0) {
            this.lblMessage.setForeground(MyColors.errorMessageFG);
            this.lblMessage.setText("Please select account.");
            this.cbAccountNo.requestFocus();
            return;
        }
        if (this.txtFromDate.getDate() == null) {
            this.lblMessage.setForeground(MyColors.errorMessageFG);
            this.lblMessage.setText("Please select From date.");
            this.txtFromDate.requestFocus();
            return;
        }
        if (AppConfig.houseName.equalsIgnoreCase("JSGCL")) {
            this.lblMessage.setForeground(MyColors.successMessageFG);
            this.lblMessage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
            this.lblMessage.setIcon(this.loaderIcon);
            LoadLogs accSt = new LoadLogs("PrevoiusAccountStatement=", true);
            new ThreadWithName(accSt, "PrevoiusAccountStatement").start();
        } else {
            if (this.txtToDate.getDate() == null) {
                this.lblMessage.setForeground(MyColors.errorMessageFG);
                this.lblMessage.setText("Please select To date.");
                this.txtFromDate.requestFocus();
                return;
            }
            if (this.txtToDate.getDate().compareTo(this.txtFromDate.getDate()) < 0) {
                this.lblMessage.setForeground(MyColors.errorMessageFG);
                this.lblMessage.setText("From date should be greater then or equal to To date.");
                this.txtFromDate.requestFocus();
                return;
            }
            this.lblMessage.setForeground(MyColors.successMessageFG);
            this.lblMessage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
            this.lblMessage.setIcon(this.loaderIcon);
            LoadLogs accSt = new LoadLogs("PreviousAccountStatement=", true);
            new ThreadWithName(accSt, "PreviousAccountStatement").start();
        }
    }

    private void tableMouseExited(MouseEvent evt) {
        this.render.setRowNo(-1);
    }

    private void tableMouseMoved(MouseEvent evt) {
        int row = this.table.rowAtPoint(evt.getPoint());
        if (row != this.render.getRowNo()) {
            this.render.setRowNo(row);
            this.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.cbAccountNo) {
            if (e.getModifiers() == 16) {
                this.AccountChange();
            } else if (e.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
                this.AccountChange();
            }
        } else if (obj == this.cbName) {
            this.cbAccountNo.removeActionListener(this);
            this.cbAccountNo.setSelectedIndex(this.cbName.getSelectedIndex());
            this.cbAccountNo.addActionListener(this);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        Object source = e.getSource();
        if (source == this.cbAccountNo) {
            // empty if block
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void ReportControl_Print(ReportControlEvent e) {
        Report_AccountStatement Report = new Report_AccountStatement(this.JRXMLFileName, this.NewModel());
        this.SetParameter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        Report.PrintReport();
    }

    @Override
    public void ReportControl_Save(ReportControlEvent e) {
        String FileName;
        boolean result;
        Report_AccountStatement Report = new Report_AccountStatement(this.JRXMLFileName, this.NewModel());
        this.SetParameter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File("Previous Account Statement-" + MyTime.getInstance().getDate()));
        fc.addAllJasperChoosableFileFilter();
        fc.setAcceptAllFileFilterUsed(false);
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null && !(result = Report.Export(FileName = fc.getSelectedFile().getAbsolutePath() + "." + fc.getExtenstion()))) {
            JOptionPane.showMessageDialog(null, "Error in saving file.");
        }
    }

    @Override
    public void ReportControl_Pdf(ReportControlEvent e) {
        int Option;
        String FileName;
        boolean result;
        Report_AccountStatement Report = new Report_AccountStatement(this.JRXMLFileName, this.NewModel());
        this.SetParameter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File("Previous Account Statement-" + MyTime.getInstance().getDate()));
        fc.addPdfFileFilter();
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null && (result = Report.ExportToPdf(FileName = fc.getSelectedFile().getAbsolutePath().replaceAll("\"", "") + "." + fc.getExtenstion())) && (Option = JOptionPane.showConfirmDialog(null, "Previous Account Statement report created. Do you want to open it?", "PDF", 0)) == 0) {
            try {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + FileName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void ReportControl_View(ReportControlEvent e) {
        Report_AccountStatement Report = new Report_AccountStatement(this.JRXMLFileName, this.NewModel());
        this.SetParameter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        Report.generateReport();
    }

    private void SetParameter(Jasper_Report Report) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("PrintDate", MyTime.getInstance().getTimeAndDateForReport());
        param.put("AccountName", this.cbName.getSelectedItem().toString());
        param.put("AccountNo", this.cbAccountNo.getSelectedItem());
        param.put("FromDate", LogsTC.dateFormatAcc.format(this.txtFromDate.getDate()));
        param.put("ToDate", LogsTC.dateFormatAcc.format(this.txtToDate.getDate()));
        Report.SetParameter(param);
    }

    @Override
    public void ReportControl_CustomExport(ReportControlEvent e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void AccountChange() {
        this.cbName.removeActionListener(this);
        this.cbName.setSelectedIndex(this.cbAccountNo.getSelectedIndex());
        this.cbName.addActionListener(this);
    }

    public TableModel NewModel() {
        int count = this.table.getRowCount();
        Vector rows = new Vector();
        for (int i = 0; i < count; ++i) {
            Vector<Object> rowsData = new Vector<Object>();
            for (int j = 0; j < 6; ++j) {
                rowsData.addElement(this.table.getModel().getValueAt(this.table.convertRowIndexToModel(i), j));
            }
            rows.add(rowsData);
        }
        this.filteredaccStatementModel = new FilteredAccStatementModel(rows, this.columns);
        return this.filteredaccStatementModel;
    }
}

