/*
 * Decompiled with CFR 0.152.
 */
package MessageWindow;

import Beans.Announcement;
import MessageWindow.AnnouncementTabComparator;
import MessageWindow.DisplayModel;
import MessageWindow.MessageDisplay;
import MessageWindow.MessageRender;
import MessageWindow.SearchPanelScripDetail;
import MyDocking.Mediator;
import Screener.TestPanel;
import Utilities.CompressManager;
import Utilities.LogsTC;
import common.gui.component.NxGScrollBarUI;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.LoginMode;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import kse.util.LogsKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;
import login.LoginServer;
import org.jdesktop.swingx.JXCollapsiblePane;

public class AnnouncementScripDetail
extends JPanel {
    public static final String rowSplit = "~";
    public static final String columnSplit = "@";
    String[] columnNames = new String[]{""};
    Hashtable<String, Timer> timerMap = new Hashtable();
    Vector<MessageDisplay> rows = new Vector();
    Vector columns = new Vector();
    DisplayModel model = new DisplayModel(this.rows, false);
    MessageRender messageRender = new MessageRender();
    Mediator mediator = Mediator.getInstance();
    private JButton dropDownDec;
    private JButton dropDownAsc;
    private JLabel lblCount = new JLabel(" ");
    private boolean isAsec = true;
    final SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
    final SimpleDateFormat dfDay = new SimpleDateFormat("EEEE, MMM dd, yyyy");
    public static int TotalMessage = 0;
    public static int TotalMessageSearch = 0;
    public static int MessageNo;
    public static int MessageNoSearch;
    public SearchPanelScripDetail searchPanelScripDetail = null;
    private boolean isUpdate = false;
    private TestPanel container;
    private LanguageCentre languageCentre = new LanguageCentre();
    private JButton btnAsen;
    private JButton btnDecn;
    private JButton btnSearch;
    private JToggleButton btnSwitch;
    private ButtonGroup buttonGroup1;
    private JXCollapsiblePane collapsiblePane;
    private JPanel jPanel1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JCheckBoxMenuItem menuCompany;
    private JCheckBoxMenuItem menuDate;
    private JCheckBoxMenuItem menuScrip;
    private JScrollPane scrollPaneMain;
    private JToolBar.Separator sepSwith;
    private JPopupMenu sortMenu;
    private JTable table;
    private JToolBar toolBar;

    public AnnouncementScripDetail(TestPanel container) {
        try {
            this.initComponents();
            this.container = container;
            if (Util.isWindow7()) {
                this.menuCompany.setIcon(null);
                this.menuDate.setIcon(null);
                this.menuScrip.setIcon(null);
            }
            this.searchPanelScripDetail = new SearchPanelScripDetail(this, LanguageConstant.Announcement);
            this.btnDecn.setLayout(new BorderLayout());
            this.btnDecn.setMargin(new Insets(-5, -5, -5, -5));
            this.dropDownDec = new BasicArrowButton(5);
            this.dropDownDec.setIcon(new ImageIcon(this.getClass().getResource("/Images/ascending12.png")));
            this.dropDownDec.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    AnnouncementScripDetail.this.isAsec = false;
                    AnnouncementScripDetail.this.sortMenu.show(AnnouncementScripDetail.this.btnDecn, evt.getX() + 2, evt.getY() + 7);
                }
            });
            this.btnDecn.add((Component)this.dropDownDec, "East");
            this.btnAsen.setLayout(new BorderLayout());
            this.btnAsen.setMargin(new Insets(-5, -5, -5, -5));
            this.dropDownAsc = new BasicArrowButton(5);
            this.dropDownAsc.setIcon(new ImageIcon(this.getClass().getResource("/Images/ascending12.png")));
            this.dropDownAsc.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    AnnouncementScripDetail.this.isAsec = true;
                    AnnouncementScripDetail.this.sortMenu.show(AnnouncementScripDetail.this.btnAsen, evt.getX() + 2, evt.getY() + 7);
                }
            });
            this.btnAsen.add((Component)this.dropDownAsc, "East");
            this.toolBar.add(Box.createHorizontalGlue());
            this.lblCount.setHorizontalAlignment(4);
            this.toolBar.add(this.lblCount);
            for (int i = 0; i < this.columnNames.length; ++i) {
                this.columns.addElement(this.columnNames[i]);
            }
            this.model.setDataVector(this.rows, this.columns);
            this.table.setModel(this.model);
            this.table.setDefaultRenderer(Object.class, this.messageRender);
            TableColumn com = this.table.getColumnModel().getColumn(0);
            com.setCellEditor(this.messageRender);
            this.table.setTableHeader(null);
            this.table.setRowHeight(200);
            this.table.setSelectionMode(0);
            this.collapsiblePane.add((Component)this.searchPanelScripDetail);
            this.collapsiblePane.setCollapsed(true);
            this.setScrollPane();
            this.btnSwitch.setVisible(AppConfig.isShowAnnouncementInGrid);
            this.sepSwith.setVisible(AppConfig.isShowAnnouncementInGrid);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private synchronized void addAllData(String msg, boolean isBlink) {
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
        if (msg.indexOf(rowSplit) >= 0) {
            String[] rowsVal = msg.split("\\~", -1);
            TotalMessage += rowsVal.length - 1;
            for (int i = 0; i < rowsVal.length; ++i) {
                if (rowsVal[i].indexOf(columnSplit) < 0) continue;
                String[] columnVal = rowsVal[i].split("\\@", -1);
                Announcement announcement = null;
                try {
                    announcement = this.parse(columnVal, false);
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    ex.printStackTrace();
                }
                if (announcement == null) {
                    --TotalMessage;
                    continue;
                }
                for (int j = 0; j < this.rows.size(); ++j) {
                    MessageDisplay messageDisplay = this.rows.elementAt(j);
                    if (messageDisplay.announcement.id.equalsIgnoreCase(announcement.id)) {
                        announcement.msgNo = messageDisplay.announcement.msgNo;
                        messageDisplay.announcement = announcement;
                        --TotalMessage;
                        this.updateAllData();
                        this.isUpdate = true;
                        break;
                    }
                    this.isUpdate = false;
                }
                if (this.isUpdate) continue;
                MessageDisplay display = new MessageDisplay(null, this, announcement, this.table, this.rows, "", TotalMessage);
                if (LogCommon.isTop) {
                    this.rows.add(0, display);
                } else {
                    this.rows.add(this.rows.size(), display);
                }
                this.timerMap.put(announcement.id, this.Blink(announcement.id, isBlink));
                if (this.mediator.toasterManager != null && isBlink && LogCommon.DesktopAlert_Announcement) {
                    this.mediator.toasterManager.showToaster(this.mediator.toasterManager, this.languageCentre.getValue(LanguageConstant.Announcement), announcement.scrip, LanguageConstant.Announcement);
                }
                if (isBlink) {
                    this.updateAllData();
                }
                this.table.addNotify();
                this.table.repaint();
                Util.ScrollToFirstOrLastRow((boolean)LogCommon.isTop, (JTable)this.table, (JScrollPane)this.scrollPaneMain);
            }
        }
        this.lblCount.setText(Util.format0digit((String)(this.rows.size() + "")) + " Record(s)  ");
    }

    private synchronized Timer Blink(final String idNO, boolean isStart) {
        final Timer BlinkTimmer = new Timer(0, null){

            @Override
            public void stop() {
                int rowNo = AnnouncementScripDetail.this.getRowNo(idNO);
                if (rowNo >= 0) {
                    MessageDisplay md = AnnouncementScripDetail.this.rows.get(rowNo);
                    md.setAnnouncementText(true, TotalMessage);
                    AnnouncementScripDetail.this.table.addNotify();
                    super.stop();
                }
            }
        };
        ActionListener ac = new ActionListener(){
            int i = 0;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.i >= AppConfig.BlinkInterval) {
                    int rowNo = AnnouncementScripDetail.this.getRowNo(idNO);
                    if (rowNo >= 0) {
                        MessageDisplay md = AnnouncementScripDetail.this.rows.get(rowNo);
                        md.setAnnouncementText(false, TotalMessage);
                        BlinkTimmer.stop();
                        AnnouncementScripDetail.this.table.addNotify();
                    }
                } else {
                    int rowNo = AnnouncementScripDetail.this.getRowNo(idNO);
                    if (rowNo >= 0) {
                        MessageDisplay md = AnnouncementScripDetail.this.rows.get(rowNo);
                        if (this.i % 2 == 0) {
                            md.setAnnouncementText(true, TotalMessage);
                        } else {
                            md.setAnnouncementText(false, TotalMessage);
                        }
                        AnnouncementScripDetail.this.table.addNotify();
                        ++this.i;
                    }
                }
            }
        };
        BlinkTimmer.addActionListener(ac);
        BlinkTimmer.setDelay(500);
        BlinkTimmer.setRepeats(true);
        if (isStart) {
            BlinkTimmer.start();
        }
        return BlinkTimmer;
    }

    public void stopBlink(String id) {
        if (this.timerMap.containsKey(id)) {
            this.timerMap.get(id).stop();
        }
    }

    private synchronized int getRowNo(String msgID) {
        int rowNo = -1;
        for (int i = 0; i < this.rows.size(); ++i) {
            Announcement object = this.rows.elementAt((int)i).announcement;
            if (!object.id.equalsIgnoreCase(msgID)) continue;
            return i;
        }
        return rowNo;
    }

    public void getAllMessagesForScrip(final String scrip) {
        if (AppConfig.loginMode != LoginMode.PMEX) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        AnnouncementScripDetail.this.searchPanelScripDetail.setSymbol(scrip);
                        Thread.sleep(200L);
                        AnnouncementScripDetail.this.setEmpty();
                        AnnouncementScripDetail.this.setWindowHight(false);
                        LoginServer port = WebService.getInstance().getPort();
                        String result = CompressManager.unzipStringFromBytes(port.userMessagesSearch(null, null, scrip, "AnnouncementsForScrip", LogCommon.UserID));
                        if (result != null) {
                            AnnouncementScripDetail.this.addAllData(result, false);
                            AnnouncementScripDetail.this.setWindowHight(true);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }).start();
        }
    }

    private void setEmpty() {
        this.rows.clear();
        TotalMessage = 0;
        TotalMessageSearch = 0;
        this.table.addNotify();
        this.table.repaint();
        MessageNo = 0;
    }

    private void setScrollPane() {
        this.scrollPaneMain.setHorizontalScrollBarPolicy(31);
        this.scrollPaneMain.setVerticalScrollBarPolicy(20);
        UIManager.put("ScrollBar.background", 1);
        JScrollBar vbar = this.scrollPaneMain.getVerticalScrollBar();
        NxGScrollBarUI ui2 = new NxGScrollBarUI();
        ui2.setMyScrollBarUI(vbar);
        vbar.setPreferredSize(new Dimension(7, 0));
    }

    private void initComponents() {
        this.sortMenu = new JPopupMenu();
        this.menuDate = new JCheckBoxMenuItem();
        this.menuCompany = new JCheckBoxMenuItem();
        this.menuScrip = new JCheckBoxMenuItem();
        this.buttonGroup1 = new ButtonGroup();
        this.scrollPaneMain = new JScrollPane();
        this.table = new JTable();
        this.toolBar = new JToolBar();
        this.btnSearch = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.btnAsen = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.btnDecn = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.btnSwitch = new JToggleButton();
        this.sepSwith = new JToolBar.Separator();
        this.jPanel1 = new JPanel();
        this.collapsiblePane = new JXCollapsiblePane();
        this.buttonGroup1.add(this.menuDate);
        this.menuDate.setSelected(true);
        this.menuDate.setText("Date");
        this.menuDate.setIcon(new ImageIcon(this.getClass().getResource("/Images/date16.png")));
        this.menuDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnnouncementScripDetail.this.menuDateActionPerformed(evt);
            }
        });
        this.sortMenu.add(this.menuDate);
        this.buttonGroup1.add(this.menuCompany);
        this.menuCompany.setText("Company");
        this.menuCompany.setIcon(new ImageIcon(this.getClass().getResource("/Images/subject16.png")));
        this.menuCompany.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnnouncementScripDetail.this.menuCompanyActionPerformed(evt);
            }
        });
        this.sortMenu.add(this.menuCompany);
        this.buttonGroup1.add(this.menuScrip);
        this.menuScrip.setText("Scrip");
        this.menuScrip.setIcon(new ImageIcon(this.getClass().getResource("/Images/description16.png")));
        this.menuScrip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnnouncementScripDetail.this.menuScripActionPerformed(evt);
            }
        });
        this.sortMenu.add(this.menuScrip);
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"Date Time", "Subject", "Detail"}));
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                AnnouncementScripDetail.this.tableMouseMoved(evt);
            }
        });
        this.scrollPaneMain.setViewportView(this.table);
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.toolBar.setMaximumSize(new Dimension(116, 21));
        this.toolBar.setMinimumSize(new Dimension(116, 21));
        this.toolBar.setPreferredSize(new Dimension(100, 18));
        this.btnSearch.setIcon(new ImageIcon(this.getClass().getResource("/Images/search12.png")));
        this.btnSearch.setText("Search");
        this.btnSearch.setToolTipText("Search");
        this.btnSearch.setFocusable(false);
        this.btnSearch.setHorizontalTextPosition(4);
        this.btnSearch.setMaximumSize(new Dimension(61, 21));
        this.btnSearch.setMinimumSize(new Dimension(61, 21));
        this.btnSearch.setName("AnnouncementScripDetail -> btnSearch");
        this.btnSearch.setPreferredSize(new Dimension(61, 21));
        this.btnSearch.setVerticalTextPosition(3);
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnnouncementScripDetail.this.btnSearchActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnSearch);
        this.toolBar.add(this.jSeparator3);
        this.btnAsen.setIcon(new ImageIcon(this.getClass().getResource("/Images/ascending12.png")));
        this.btnAsen.setToolTipText("Sort Ascending");
        this.btnAsen.setFocusable(false);
        this.btnAsen.setHorizontalTextPosition(0);
        this.btnAsen.setMaximumSize(new Dimension(35, 18));
        this.btnAsen.setMinimumSize(new Dimension(35, 18));
        this.btnAsen.setName("AnnouncementScripDetail -> btnAsen");
        this.btnAsen.setPreferredSize(new Dimension(38, 18));
        this.btnAsen.setVerticalTextPosition(3);
        this.btnAsen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnnouncementScripDetail.this.btnAsenActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnAsen);
        this.toolBar.add(this.jSeparator2);
        this.btnDecn.setIcon(new ImageIcon(this.getClass().getResource("/Images/descending12.png")));
        this.btnDecn.setToolTipText("Sort Desecnding");
        this.btnDecn.setFocusable(false);
        this.btnDecn.setHorizontalTextPosition(0);
        this.btnDecn.setMaximumSize(new Dimension(35, 18));
        this.btnDecn.setMinimumSize(new Dimension(35, 18));
        this.btnDecn.setName("AnnouncementScripDetail -> btnDecn");
        this.btnDecn.setPreferredSize(new Dimension(35, 18));
        this.btnDecn.setVerticalTextPosition(3);
        this.btnDecn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnnouncementScripDetail.this.btnDecnActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnDecn);
        this.toolBar.add(this.jSeparator1);
        this.btnSwitch.setIcon(new ImageIcon(this.getClass().getResource("/Images/switch16.png")));
        this.btnSwitch.setFocusable(false);
        this.btnSwitch.setHorizontalTextPosition(0);
        this.btnSwitch.setName("AnnouncementScripDetail -> btnSwitch");
        this.btnSwitch.setVerticalTextPosition(3);
        this.toolBar.add(this.btnSwitch);
        this.toolBar.add(this.sepSwith);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 222, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.toolBar.add(this.jPanel1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toolBar, GroupLayout.Alignment.TRAILING, -1, 405, Short.MAX_VALUE).addComponent(this.scrollPaneMain, GroupLayout.Alignment.TRAILING, -1, 405, Short.MAX_VALUE).addComponent((Component)this.collapsiblePane, -1, 405, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.toolBar, -2, 21, -2).addGap(0, 0, 0).addComponent((Component)this.collapsiblePane, -2, -1, -2).addGap(0, 0, 0).addComponent(this.scrollPaneMain, -1, 27, Short.MAX_VALUE)));
    }

    public Announcement parse(String[] columnVal, boolean isSearch) throws ArrayIndexOutOfBoundsException {
        Date date;
        Announcement announcement = new Announcement();
        announcement.company = columnVal[2];
        announcement.dateTime = columnVal[1];
        announcement.scrip = columnVal[4];
        announcement.AGM = columnVal[9];
        announcement.EPS = columnVal[8];
        announcement.FYE = columnVal[3];
        announcement.PLAfterTax = columnVal[7];
        announcement.PLBeforeTax = columnVal[6];
        announcement.bookClosure = columnVal[10];
        announcement.fileData = columnVal[13];
        announcement.id = columnVal[0];
        announcement.misc = columnVal[12];
        announcement.msgNo = !isSearch ? ++MessageNo : ++MessageNoSearch;
        if (announcement.misc.indexOf("|") >= 0) {
            String[] val = announcement.misc.split("\\|", -1);
            for (int i = 0; i < val.length; ++i) {
                Date date2;
                if (val[i].indexOf("Period") >= 0) {
                    announcement.period = val[i].split("\\=", -1)[1];
                }
                if (val[i].indexOf("Book Closure Start Date") >= 0) {
                    announcement.bookClosureStartDate = val[i].split("\\=", -1)[1];
                    try {
                        date2 = this.dfDay.parse(announcement.bookClosureStartDate);
                        announcement.bookClosureStartDate = LogsTC.dateFormatAcc.format(date2);
                    }
                    catch (ParseException ex) {
                        ex.printStackTrace();
                    }
                }
                if (val[i].indexOf("Book Closure End Date") >= 0) {
                    announcement.bookClosureEndDate = val[i].split("\\=", -1)[1];
                    try {
                        date2 = this.dfDay.parse(announcement.bookClosureEndDate);
                        announcement.bookClosureEndDate = LogsTC.dateFormatAcc.format(date2);
                    }
                    catch (ParseException ex) {
                        ex.printStackTrace();
                    }
                }
                if (val[i].indexOf("Divedend") >= 0) {
                    announcement.divedend = val[i].split("\\=", -1)[1];
                }
                if (val[i].indexOf("Bonus") >= 0) {
                    announcement.bonus = val[i].split("\\=", -1)[1];
                }
                if (val[i].indexOf("Right") >= 0) {
                    announcement.right = val[i].split("\\=", -1)[1];
                }
                if (val[i].indexOf("Discount") >= 0) {
                    announcement.discount = val[i].split("\\=", -1)[1];
                }
                if (val[i].indexOf("Premium") < 0) continue;
                announcement.premium = val[i].split("\\=", -1)[1];
            }
        }
        if (!announcement.dateTime.trim().equalsIgnoreCase("")) {
            try {
                date = this.df.parse(columnVal[1]);
                announcement.dateTime = LogsKSE.sdfMessage.format(date);
            }
            catch (ParseException ex) {
                ex.printStackTrace();
            }
        }
        if (!announcement.FYE.trim().equalsIgnoreCase("")) {
            try {
                date = this.df.parse(columnVal[3]);
                announcement.FYE = LogsTC.dateFormatAcc.format(date);
            }
            catch (ParseException ex) {
                ex.printStackTrace();
            }
        }
        if (!announcement.AGM.trim().equalsIgnoreCase("")) {
            try {
                date = this.df.parse(columnVal[9]);
                announcement.AGM = LogsTC.dateFormatAcc.format(date);
            }
            catch (ParseException ex) {
                ex.printStackTrace();
            }
        }
        try {
            announcement.isManualEntry = Boolean.parseBoolean(columnVal[11]);
        }
        catch (Exception ex) {
            announcement.isManualEntry = false;
            ex.printStackTrace();
        }
        try {
            announcement.isBlink = Boolean.parseBoolean(columnVal[14]);
        }
        catch (Exception ex) {
            announcement.isBlink = false;
            ex.printStackTrace();
        }
        try {
            announcement.isRead = Boolean.parseBoolean(columnVal[15]);
        }
        catch (Exception ex) {
            announcement.isRead = false;
            ex.printStackTrace();
        }
        announcement.hyperLink = columnVal[16];
        return announcement;
    }

    private void tableMouseMoved(MouseEvent evt) {
        try {
            int rowindex = this.table.rowAtPoint(evt.getPoint());
            this.table.editCellAt(rowindex, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void btnSearchActionPerformed(ActionEvent evt) {
        boolean state = this.collapsiblePane.isCollapsed();
        this.collapsiblePane.setCollapsed(!state);
        this.searchPanelScripDetail.setScrip();
    }

    private void btnAsenActionPerformed(ActionEvent evt) {
        if (this.menuDate.isSelected()) {
            this.callSort(1, true);
        } else if (this.menuCompany.isSelected()) {
            this.callSort(2, true);
        } else if (this.menuScrip.isSelected()) {
            this.callSort(4, true);
        }
    }

    private void btnDecnActionPerformed(ActionEvent evt) {
        if (this.menuDate.isSelected()) {
            this.callSort(1, false);
        } else if (this.menuCompany.isSelected()) {
            this.callSort(2, false);
        } else if (this.menuScrip.isSelected()) {
            this.callSort(4, false);
        }
    }

    private void menuDateActionPerformed(ActionEvent evt) {
        this.callSort(1, this.isAsec);
    }

    private void menuCompanyActionPerformed(ActionEvent evt) {
        this.callSort(2, this.isAsec);
    }

    private void menuScripActionPerformed(ActionEvent evt) {
        this.callSort(4, this.isAsec);
    }

    private void callSort(int index, boolean ascSec) {
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
        Collections.sort(this.rows, new AnnouncementTabComparator(index, ascSec));
        this.table.tableChanged(new TableModelEvent(this.model));
        this.table.repaint();
    }

    public void callSort(Vector<MessageDisplay> rows_, int index, boolean ascSec) {
        Collections.sort(rows_, new AnnouncementTabComparator(index, ascSec));
    }

    private void updateAllData() {
        for (int i = 0; i < this.rows.size(); ++i) {
            MessageDisplay messageDisplay = this.rows.elementAt(i);
            messageDisplay.setAnnouncementText(true, TotalMessage);
        }
    }

    public void setReadunRead(Announcement announcement) {
        for (int i = 0; i < this.rows.size(); ++i) {
            MessageDisplay messageDisplay = this.rows.elementAt(i);
            if (!messageDisplay.announcement.id.equalsIgnoreCase(announcement.id)) continue;
            messageDisplay.announcement.isRead = announcement.isRead;
            messageDisplay.setAnnouncementText(true, TotalMessage);
            break;
        }
    }

    public void deleteRow(String id) {
        for (int i = 0; i < this.rows.size(); ++i) {
            if (!this.rows.elementAt((int)i).announcement.id.equalsIgnoreCase(id)) continue;
            this.rows.remove(i);
            --TotalMessage;
            this.updateAllData();
            this.table.addNotify();
            break;
        }
    }

    private void setWindowHight(boolean isDataLoaded) {
        if (isDataLoaded && this.rows.size() > 0) {
            Dimension n = new Dimension(0, this.table.getRowHeight() + 22);
            this.container.setPreferredSize(n);
            this.container.revalidate();
            this.repaint();
        } else {
            Dimension n = new Dimension(0, 22);
            this.container.revalidate();
            this.container.setPreferredSize(n);
            this.repaint();
        }
    }
}

