/*
 * Decompiled with CFR 0.152.
 */
package MessageWindow;

import MessageWindow.BoardMeetingComparator;
import MessageWindow.DisplayModel;
import MessageWindow.Message;
import MessageWindow.MessageDisplay;
import MessageWindow.MessageRender;
import MessageWindow.SearchPanelScripDetail;
import MyDocking.Mediator;
import Screener.TestPanel;
import Utilities.CompressManager;
import Utilities.LogsTC;
import common.gui.component.NxGScrollBarUI;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.LoginMode;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import languages.LanguageConstant;
import login.LoginServer;
import org.jdesktop.swingx.JXCollapsiblePane;

public class BoardMeetingScripDetail
extends JPanel {
    String[] columnNames = new String[]{""};
    Vector<MessageDisplay> rows = new Vector();
    Vector columns = new Vector();
    DisplayModel model = new DisplayModel(this.rows, true);
    public DefaultTreeModel treeModel;
    public static DefaultMutableTreeNode nNode;
    public MutableTreeNode node;
    public TreePath path;
    int id = 0;
    Mediator mediator = Mediator.getInstance();
    String type;
    private boolean isAsec = true;
    private JButton dropDownDec;
    private JButton dropDownAsc;
    private JLabel lblCount = new JLabel(" ");
    MessageRender messageRender = new MessageRender();
    public static int totalMessage;
    private final long MilInDay = 86400000L;
    Date today = new Date(System.currentTimeMillis());
    Calendar cal = Calendar.getInstance();
    Date lastWeek = null;
    Date currentWeek = null;
    Date nextWeek = null;
    Date later = null;
    public static final String currentWeekTitle = "Current Week";
    public static final String lastWeekTitle = "Last Week";
    public static final String nextWeekTitle = "Next Week";
    public static final String laterTitle = "Later";
    public SearchPanelScripDetail searchPanelScripDetail = null;
    ArrayList<String> days = new ArrayList();
    private String lastSelection = null;
    private String scrip = "";
    private final TestPanel container;
    private JXCollapsiblePane Add_CollapsiblePane;
    private JButton btnAsen;
    private JButton btnDecn;
    private JButton btnExpand;
    private JButton btnSearch;
    private ButtonGroup buttonGroup1;
    private JXCollapsiblePane collapsiblePane;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JCheckBoxMenuItem menuCompanyName;
    private JCheckBoxMenuItem menuDate;
    private JCheckBoxMenuItem menuDetails;
    private JCheckBoxMenuItem menuScrip;
    private JScrollPane scrollPaneMain;
    private JPopupMenu sortMenu;
    public JTable table;
    private JToolBar toolBar;

    public BoardMeetingScripDetail(String type, TestPanel container) {
        this.initComponents();
        this.type = type;
        this.container = container;
        this.Add_CollapsiblePane.setDirection(JXCollapsiblePane.Direction.LEFT);
        this.Add_CollapsiblePane.setCollapsed(true);
        try {
            this.type = type;
            if (type.equalsIgnoreCase(LanguageConstant.BoardMeeting)) {
                this.type = "Board_Meeting";
            }
            if (Util.isWindow7()) {
                this.menuCompanyName.setIcon(null);
                this.menuScrip.setIcon(null);
                this.menuDetails.setIcon(null);
            }
            this.btnDecn.setLayout(new BorderLayout());
            this.btnDecn.setMargin(new Insets(-5, -5, -5, -5));
            this.dropDownDec = new BasicArrowButton(5);
            this.dropDownDec.setIcon(new ImageIcon(this.getClass().getResource("/Images/ascending12.png")));
            this.dropDownDec.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    BoardMeetingScripDetail.this.isAsec = false;
                    BoardMeetingScripDetail.this.sortMenu.show(BoardMeetingScripDetail.this.btnDecn, evt.getX() + 2, evt.getY() + 7);
                }
            });
            this.btnDecn.add((Component)this.dropDownDec, "East");
            this.btnAsen.setLayout(new BorderLayout());
            this.btnAsen.setMargin(new Insets(-5, -5, -5, -5));
            this.dropDownAsc = new BasicArrowButton(5);
            this.dropDownAsc.setIcon(new ImageIcon(this.getClass().getResource("/Images/ascending12.png")));
            this.dropDownAsc.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    BoardMeetingScripDetail.this.isAsec = true;
                    BoardMeetingScripDetail.this.sortMenu.show(BoardMeetingScripDetail.this.btnAsen, evt.getX() + 2, evt.getY() + 7);
                }
            });
            this.btnAsen.add((Component)this.dropDownAsc, "East");
            this.toolBar.add(Box.createHorizontalGlue());
            this.lblCount.setHorizontalAlignment(4);
            this.toolBar.add(this.lblCount);
            for (int i = 0; i < this.columnNames.length; ++i) {
                this.columns.addElement(this.columnNames[i]);
            }
            this.model.setDataVector(this.rows, this.columns);
            this.table.setModel(this.model);
            this.table.setDefaultRenderer(Object.class, this.messageRender);
            TableColumn com = this.table.getColumnModel().getColumn(0);
            com.setCellEditor(this.messageRender);
            this.table.setTableHeader(null);
            this.table.setRowHeight(90);
            this.table.setSelectionMode(0);
            this.collapsiblePane.setCollapsed(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.days.add("Mon");
        this.days.add("Tue");
        this.days.add("Wed");
        this.days.add("Thu");
        this.days.add("Fri");
        this.days.add("Sat");
        this.days.add("Sun");
        this.days.add("Today");
        this.setScrollPane();
        this.btnExpand.setVisible(false);
        this.Add_CollapsiblePane.setVisible(false);
        this.setDates();
    }

    public int getChildCount(TreeModel model, Object node) {
        if (node == null) {
            return 0;
        }
        int ub = model.getChildCount(node);
        int sum = 1;
        for (int i = 0; i < ub; ++i) {
            sum += this.getChildCount(model, model.getChild(node, i));
        }
        return sum;
    }

    public void getAllMessagesScrip(final String scrip2) {
        if (AppConfig.loginMode != LoginMode.PMEX) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        LoginServer port;
                        String result;
                        Thread.sleep(200L);
                        BoardMeetingScripDetail.this.setEmpty();
                        BoardMeetingScripDetail.this.setWindowHight(false);
                        BoardMeetingScripDetail.this.scrip = scrip2;
                        if (BoardMeetingScripDetail.this.searchPanelScripDetail != null) {
                            BoardMeetingScripDetail.this.searchPanelScripDetail.setSymbol(BoardMeetingScripDetail.this.scrip);
                        }
                        if ((result = CompressManager.unzipStringFromBytes((port = WebService.getInstance().getPort()).userMessagesSearch(null, null, BoardMeetingScripDetail.this.scrip, "BoardMeetingForScrip", LogCommon.UserID))) != null) {
                            BoardMeetingScripDetail.this.addAllData(result, false);
                            BoardMeetingScripDetail.this.setWindowHight(true);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }).start();
        }
    }

    private void setEmpty() {
        totalMessage = 0;
        this.rows.clear();
        this.tableDataChange();
    }

    private void setScrollPane() {
        this.scrollPaneMain.setHorizontalScrollBarPolicy(31);
        this.scrollPaneMain.setVerticalScrollBarPolicy(20);
        UIManager.put("ScrollBar.background", 1);
        JScrollBar vbar = this.scrollPaneMain.getVerticalScrollBar();
        NxGScrollBarUI ui2 = new NxGScrollBarUI();
        ui2.setMyScrollBarUI(vbar);
        vbar.setPreferredSize(new Dimension(7, 0));
    }

    public void addAllData(String msg, boolean isBlink) {
        Message message;
        this.mediator.println("All Board Meeting Scrip Detail = " + msg);
        Vector<Message> rowsTemp = new Vector<Message>();
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
        if (msg.indexOf("|") >= 0) {
            String[] rowsVal = msg.split("\\|", -1);
            message = null;
            for (int i = 0; i < rowsVal.length - 1; ++i) {
                if (rowsVal[i].indexOf(";") < 0) continue;
                String[] columnVal = rowsVal[i].split("\\;", -1);
                try {
                    message = this.parse(columnVal);
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    ex.printStackTrace();
                }
                try {
                    Date dd = LogsTC.boardMeetingDateFormat.parse(message.dateTime.value);
                    if (Util.isSameDay((Date)dd, (Date)this.today)) {
                        message.isBlink = true;
                        message.isDateBlink = true;
                    }
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                }
                if (message == null) continue;
                rowsTemp.add(message);
            }
        }
        totalMessage = rowsTemp.size();
        for (int i = 0; i < rowsTemp.size(); ++i) {
            message = (Message)rowsTemp.elementAt(i);
            MessageDisplay md = new MessageDisplay(this, message, this.table, this.type, this.rows, null);
            this.rows.add(md);
        }
        this.tableDataChange();
    }

    public Message parse(String[] columnVal) {
        Message m = new Message();
        boolean isBlink = false;
        boolean isRead = false;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        try {
            Date date = df.parse(columnVal[1]);
            m.dateTime.value = LogsTC.boardMeetingDateFormat.format(date);
        }
        catch (ParseException ex) {
            m.dateTime.value = columnVal[1];
            ex.printStackTrace();
        }
        m.description.value = columnVal[5];
        m.detail.value = columnVal[4];
        m.id.value = columnVal[0];
        m.subject.value = columnVal[3];
        m.type.value = columnVal[2];
        try {
            isBlink = Boolean.parseBoolean(columnVal[6]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        m.isBlink = isBlink;
        try {
            isRead = Boolean.parseBoolean(columnVal[7]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        m.isRead = isRead;
        return m;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.sortMenu = new JPopupMenu();
        this.menuDate = new JCheckBoxMenuItem();
        this.menuScrip = new JCheckBoxMenuItem();
        this.menuCompanyName = new JCheckBoxMenuItem();
        this.menuDetails = new JCheckBoxMenuItem();
        this.toolBar = new JToolBar();
        this.btnExpand = new JButton();
        this.btnSearch = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.btnAsen = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.btnDecn = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.collapsiblePane = new JXCollapsiblePane();
        this.scrollPaneMain = new JScrollPane();
        this.table = new JTable();
        this.Add_CollapsiblePane = new JXCollapsiblePane();
        this.buttonGroup1.add(this.menuDate);
        this.menuDate.setSelected(true);
        this.menuDate.setText("Date");
        this.menuDate.setIcon(new ImageIcon(this.getClass().getResource("/Images/date16.png")));
        this.menuDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BoardMeetingScripDetail.this.menuDateActionPerformed(evt);
            }
        });
        this.sortMenu.add(this.menuDate);
        this.buttonGroup1.add(this.menuScrip);
        this.menuScrip.setText("Scrip");
        this.menuScrip.setIcon(new ImageIcon(this.getClass().getResource("/Images/subject16.png")));
        this.menuScrip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BoardMeetingScripDetail.this.menuScripActionPerformed(evt);
            }
        });
        this.sortMenu.add(this.menuScrip);
        this.buttonGroup1.add(this.menuCompanyName);
        this.menuCompanyName.setText("Company Name");
        this.menuCompanyName.setIcon(new ImageIcon(this.getClass().getResource("/Images/description16.png")));
        this.menuCompanyName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BoardMeetingScripDetail.this.menuCompanyNameActionPerformed(evt);
            }
        });
        this.sortMenu.add(this.menuCompanyName);
        this.buttonGroup1.add(this.menuDetails);
        this.menuDetails.setText("Details");
        this.menuDetails.setIcon(new ImageIcon(this.getClass().getResource("/Images/detail16.png")));
        this.menuDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BoardMeetingScripDetail.this.menuDetailsActionPerformed(evt);
            }
        });
        this.sortMenu.add(this.menuDetails);
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.toolBar.setMaximumSize(new Dimension(116, 21));
        this.toolBar.setMinimumSize(new Dimension(116, 21));
        this.toolBar.setPreferredSize(new Dimension(100, 18));
        this.btnExpand.setIcon(new ImageIcon(this.getClass().getResource("/Images/RightArrow.png")));
        this.btnExpand.setFocusable(false);
        this.btnExpand.setHorizontalTextPosition(0);
        this.btnExpand.setName("BoardMeetingScripDetail -> btnExpand");
        this.btnExpand.setVerticalTextPosition(3);
        this.btnExpand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BoardMeetingScripDetail.this.btnExpandActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnExpand);
        this.btnSearch.setIcon(new ImageIcon(this.getClass().getResource("/Images/search12.png")));
        this.btnSearch.setText("Search");
        this.btnSearch.setToolTipText("Search");
        this.btnSearch.setFocusable(false);
        this.btnSearch.setHorizontalTextPosition(4);
        this.btnSearch.setMaximumSize(new Dimension(18, 18));
        this.btnSearch.setMinimumSize(new Dimension(18, 18));
        this.btnSearch.setName("BoardMeetingScripDetail -> btnSearch");
        this.btnSearch.setPreferredSize(new Dimension(61, 21));
        this.btnSearch.setVerticalTextPosition(3);
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BoardMeetingScripDetail.this.btnSearchActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnSearch);
        this.toolBar.add(this.jSeparator3);
        this.btnAsen.setIcon(new ImageIcon(this.getClass().getResource("/Images/ascending12.png")));
        this.btnAsen.setToolTipText("Sort Ascending");
        this.btnAsen.setFocusable(false);
        this.btnAsen.setHorizontalTextPosition(0);
        this.btnAsen.setMaximumSize(new Dimension(35, 18));
        this.btnAsen.setMinimumSize(new Dimension(35, 18));
        this.btnAsen.setName("BoardMeetingScripDetail -> btnAsen");
        this.btnAsen.setPreferredSize(new Dimension(38, 18));
        this.btnAsen.setVerticalTextPosition(3);
        this.btnAsen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BoardMeetingScripDetail.this.btnAsenActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnAsen);
        this.toolBar.add(this.jSeparator2);
        this.btnDecn.setIcon(new ImageIcon(this.getClass().getResource("/Images/descending12.png")));
        this.btnDecn.setToolTipText("Sort Descending");
        this.btnDecn.setFocusable(false);
        this.btnDecn.setHorizontalTextPosition(0);
        this.btnDecn.setMaximumSize(new Dimension(35, 18));
        this.btnDecn.setMinimumSize(new Dimension(35, 18));
        this.btnDecn.setName("BoardMeetingScripDetail -> btnDecn");
        this.btnDecn.setPreferredSize(new Dimension(35, 18));
        this.btnDecn.setVerticalTextPosition(3);
        this.btnDecn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BoardMeetingScripDetail.this.btnDecnActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnDecn);
        this.toolBar.add(this.jSeparator1);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 319, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 16, Short.MAX_VALUE));
        this.toolBar.add(this.jPanel2);
        this.jPanel1.setPreferredSize(new Dimension(461, 400));
        this.collapsiblePane.setOpaque(false);
        this.scrollPaneMain.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                BoardMeetingScripDetail.this.scrollPaneMainMouseClicked(evt);
            }
        });
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}}, new String[]{"Title", "Published Date", "Description", "Details"}));
        this.table.setRowSelectionAllowed(false);
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                BoardMeetingScripDetail.this.tableMouseMoved(evt);
            }
        });
        this.scrollPaneMain.setViewportView(this.table);
        this.Add_CollapsiblePane.setBackground(new Color(255, 255, 255));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.collapsiblePane, -1, 492, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent((Component)this.Add_CollapsiblePane, -2, -1, -2).addGap(0, 0, 0).addComponent(this.scrollPaneMain, -1, 492, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent((Component)this.collapsiblePane, -2, -1, -2).addGap(0, 0, 0).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.Add_CollapsiblePane, -1, 51, Short.MAX_VALUE).addComponent(this.scrollPaneMain, -1, 51, Short.MAX_VALUE)).addGap(0, 0, 0)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 492, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, 492, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toolBar, -1, 492, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 71, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.jPanel1, -1, 51, Short.MAX_VALUE))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.toolBar, -2, -1, -2).addGap(0, 0, 0))));
    }

    private void tableMouseMoved(MouseEvent evt) {
        try {
            int rowindex = this.table.rowAtPoint(evt.getPoint());
            this.table.editCellAt(rowindex, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void scrollPaneMainMouseClicked(MouseEvent evt) {
    }

    private void btnSearchActionPerformed(ActionEvent evt) {
        this.searchPanelScripDetail = new SearchPanelScripDetail(null, this, this.type);
        this.searchPanelScripDetail.setScrip();
        this.searchPanelScripDetail.setSymbol(this.scrip);
        this.collapsiblePane.removeAll();
        this.collapsiblePane.add((Component)this.searchPanelScripDetail);
        this.collapsiblePane.setCollapsed(!this.collapsiblePane.isCollapsed());
    }

    private void btnAsenActionPerformed(ActionEvent evt) {
        if (this.menuDate.isSelected()) {
            this.callSort(1, true);
        } else if (this.menuScrip.isSelected()) {
            this.callSort(3, true);
        } else if (this.menuCompanyName.isSelected()) {
            this.callSort(5, true);
        } else if (this.menuDetails.isSelected()) {
            this.callSort(4, true);
        }
    }

    private void btnDecnActionPerformed(ActionEvent evt) {
        if (this.menuDate.isSelected()) {
            this.callSort(1, false);
        } else if (this.menuScrip.isSelected()) {
            this.callSort(3, false);
        } else if (this.menuCompanyName.isSelected()) {
            this.callSort(5, false);
        } else if (this.menuDetails.isSelected()) {
            this.callSort(4, false);
        }
    }

    private void btnExpandActionPerformed(ActionEvent evt) {
    }

    private void menuScripActionPerformed(ActionEvent evt) {
        this.callSort(3, this.isAsec);
    }

    private void menuCompanyNameActionPerformed(ActionEvent evt) {
        this.callSort(5, this.isAsec);
    }

    private void menuDetailsActionPerformed(ActionEvent evt) {
        this.callSort(4, this.isAsec);
    }

    private void menuDateActionPerformed(ActionEvent evt) {
        this.callSort(1, this.isAsec);
    }

    private void callSort(int index, boolean ascSec) {
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
        Collections.sort(this.rows, new BoardMeetingComparator(index, ascSec));
        this.table.tableChanged(new TableModelEvent(this.model));
        this.table.repaint();
    }

    public void callSort(Vector<MessageDisplay> rows_, int index, boolean ascSec) {
        Collections.sort(rows_, new BoardMeetingComparator(index, ascSec));
    }

    private void setDates() {
        this.cal.setTime(this.today);
        this.cal.set(11, 0);
        this.cal.set(12, 0);
        this.cal.set(13, 0);
        this.cal.set(14, 0);
        this.today = this.cal.getTime();
        this.cal.set(7, 2);
        this.cal.add(5, -7);
        this.lastWeek = new Date(this.cal.getTimeInMillis());
        this.cal.add(5, 7);
        this.currentWeek = new Date(this.cal.getTimeInMillis());
        this.cal.add(5, 7);
        this.nextWeek = new Date(this.cal.getTimeInMillis());
        this.cal.add(5, 7);
        this.later = new Date(this.cal.getTimeInMillis());
    }

    public void setReadunRead(Message message) {
        for (int i = 0; i < this.rows.size(); ++i) {
            MessageDisplay messageDisplay = this.rows.elementAt(i);
            if (!messageDisplay.message.id.value.equalsIgnoreCase(message.id.value)) continue;
            messageDisplay.setBoardMeetingText(false);
            break;
        }
    }

    private void setWindowHight(boolean isDataLoaded) {
        if (isDataLoaded) {
            Dimension n = new Dimension(0, this.table.getRowCount() * this.table.getRowHeight() + 22);
            this.container.setPreferredSize(n);
            this.container.revalidate();
            this.repaint();
        } else {
            Dimension n = new Dimension(0, 22);
            this.container.revalidate();
            this.container.setPreferredSize(n);
            this.repaint();
        }
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.table.addNotify();
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BoardMeetingScripDetail.this.table.addNotify();
                    BoardMeetingScripDetail.this.table.repaint();
                }
            });
        }
    }

    static {
        totalMessage = 0;
    }
}

