/*
 * Decompiled with CFR 0.152.
 */
package MessageWindow;

import MessageWindow.BoardMeetingComparator;
import MessageWindow.BoardMeetingHolder;
import MessageWindow.DisplayModel;
import MessageWindow.Message;
import MessageWindow.MessageDisplay;
import MessageWindow.MessageRender;
import MessageWindow.SearchPanelScrip;
import MyDocking.Mediator;
import Utilities.CompressManager;
import Utilities.LogsTC;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.LoginMode;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kse.util.LogsKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;
import login.LoginServer;
import org.jdesktop.swingx.JXCollapsiblePane;

public class BoardMeetingTab
extends JPanel {
    String[] columnNames = new String[]{""};
    Hashtable<String, Timer> timerMap = new Hashtable();
    Vector<MessageDisplay> rows = new Vector();
    ArrayList<Message> allData = new ArrayList();
    ArrayList nodeSet = new ArrayList();
    Vector columns = new Vector();
    DisplayModel model = new DisplayModel(this.rows, true);
    public DefaultTreeModel treeModel;
    public static DefaultMutableTreeNode nNode;
    public MutableTreeNode node;
    public TreePath path;
    int id = 0;
    private final BoardMeetingHolder boardMeetingHolder;
    Mediator mediator = Mediator.getInstance();
    public static int boardMsgCount;
    String type;
    private boolean isAsec = true;
    private JButton dropDownDec;
    private JButton dropDownAsc;
    private JLabel lblCount = new JLabel(" ");
    MessageRender messageRender = new MessageRender();
    public static int totalMessage;
    private final long MilInDay = 86400000L;
    Date today = new Date(System.currentTimeMillis());
    Calendar cal = Calendar.getInstance();
    Date lastWeek = null;
    Date currentWeek = null;
    Date nextWeek = null;
    Date later = null;
    public static final String currentWeekTitle = "Current Week";
    public static final String lastWeekTitle = "Last Week";
    public static final String nextWeekTitle = "Next Week";
    public static final String laterTitle = "Later";
    public SearchPanelScrip searchPanel = null;
    ArrayList<String> days = new ArrayList();
    public static int currentWeekCount;
    public static int lastWeekCount;
    public static int nextWeekCount;
    public static int laterCount;
    public static int currentWeekUnreadCount;
    public static int lastWeekUnreadCount;
    public static int nextWeekUnreadCount;
    public static int laterUnreadCount;
    private String lastSelection = null;
    private LanguageCentre languageCentre = new LanguageCentre();
    Thread getMessages = new Thread(){

        @Override
        public void run() {
            try {
                LoginServer port = WebService.getInstance().getPort();
                String result = CompressManager.unzipStringFromBytes(port.getUserMessages("BOARD_MEETING", LogCommon.UserID, null, LogCommon.tabMessageDays));
                if (result != null) {
                    currentWeekUnreadCount = 0;
                    lastWeekUnreadCount = 0;
                    nextWeekUnreadCount = 0;
                    laterUnreadCount = 0;
                    currentWeekCount = 0;
                    lastWeekCount = 0;
                    nextWeekCount = 0;
                    laterCount = 0;
                    BoardMeetingTab.this.addAllDataSafe(result, false);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    };
    private JXCollapsiblePane Add_CollapsiblePane;
    private JButton btnAsen;
    private JButton btnDecn;
    private JButton btnExpand;
    private JButton btnSearch;
    private ButtonGroup buttonGroup1;
    private JXCollapsiblePane collapsiblePane;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JCheckBoxMenuItem menuCompanyName;
    private JCheckBoxMenuItem menuDate;
    private JCheckBoxMenuItem menuDetails;
    private JCheckBoxMenuItem menuScrip;
    private JPopupMenu sortMenu;
    public JTable table;
    private JToolBar toolBar;

    public BoardMeetingTab(String type) {
        this.initComponents();
        this.type = type;
        this.boardMeetingHolder = new BoardMeetingHolder(this);
        this.Add_CollapsiblePane.add((Component)this.boardMeetingHolder);
        this.Add_CollapsiblePane.setDirection(JXCollapsiblePane.Direction.LEFT);
        this.Add_CollapsiblePane.setCollapsed(true);
        try {
            this.type = type;
            if (type.equalsIgnoreCase(LanguageConstant.BoardMeeting)) {
                this.type = "Board_Meeting";
            }
            if (Util.isWindow7()) {
                this.menuCompanyName.setIcon(null);
                this.menuScrip.setIcon(null);
                this.menuDetails.setIcon(null);
            }
            this.btnDecn.setLayout(new BorderLayout());
            this.btnDecn.setMargin(new Insets(-5, -5, -5, -5));
            this.dropDownDec = new BasicArrowButton(5);
            this.dropDownDec.setIcon(new ImageIcon(this.getClass().getResource("/Images/ascending12.png")));
            this.dropDownDec.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    BoardMeetingTab.this.isAsec = false;
                    BoardMeetingTab.this.sortMenu.show(BoardMeetingTab.this.btnDecn, evt.getX() + 2, evt.getY() + 7);
                }
            });
            this.btnDecn.add((Component)this.dropDownDec, "East");
            this.btnAsen.setLayout(new BorderLayout());
            this.btnAsen.setMargin(new Insets(-5, -5, -5, -5));
            this.dropDownAsc = new BasicArrowButton(5);
            this.dropDownAsc.setIcon(new ImageIcon(this.getClass().getResource("/Images/ascending12.png")));
            this.dropDownAsc.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    BoardMeetingTab.this.isAsec = true;
                    BoardMeetingTab.this.sortMenu.show(BoardMeetingTab.this.btnAsen, evt.getX() + 2, evt.getY() + 7);
                }
            });
            this.btnAsen.add((Component)this.dropDownAsc, "East");
            this.toolBar.add(Box.createHorizontalGlue());
            this.lblCount.setHorizontalAlignment(4);
            this.toolBar.add(this.lblCount);
            for (int i = 0; i < this.columnNames.length; ++i) {
                this.columns.addElement(this.columnNames[i]);
            }
            this.model.setDataVector(this.rows, this.columns);
            this.table.setModel(this.model);
            this.table.setDefaultRenderer(Object.class, this.messageRender);
            TableColumn com = this.table.getColumnModel().getColumn(0);
            com.setCellEditor(this.messageRender);
            this.table.setTableHeader(null);
            this.table.setRowHeight(90);
            this.table.setSelectionMode(0);
            this.collapsiblePane.setCollapsed(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.days.add("Mon");
        this.days.add("Tue");
        this.days.add("Wed");
        this.days.add("Thu");
        this.days.add("Fri");
        this.days.add("Sat");
        this.days.add("Sun");
        this.days.add("Today");
        this.setDefaultNodes();
        this.setDates();
    }

    private void setDefaultNodes() {
        this.addNode("Last Week (" + lastWeekCount + ")", "Board Meetings");
        this.addNode("Current Week (" + currentWeekCount + ")", "Board Meetings");
        this.addNode("Next Week (" + nextWeekCount + ")", "Board Meetings");
        this.addNode("Later (" + laterCount + ")", "Board Meetings");
    }

    public void addNode(String nodeName, String addInto) {
        this.treeModel = (DefaultTreeModel)this.boardMeetingHolder.tree.getModel();
        if (nodeName.equals("")) {
            return;
        }
        this.Add_CollapsiblePane.setCollapsed(false);
        this.btnExpand.setIcon(new ImageIcon(this.getClass().getResource("/Images/LeftArrow.png")));
        nNode = new DefaultMutableTreeNode(nodeName);
        this.path = this.boardMeetingHolder.tree.getNextMatch(addInto, 0, Position.Bias.Forward);
        this.node = (MutableTreeNode)this.path.getLastPathComponent();
        this.treeModel.insertNodeInto(nNode, this.node, this.node.getChildCount());
        this.boardMeetingHolder.expandAll();
    }

    public void addNode(ArrayList allNodes) {
        try {
            int size;
            this.removeNodes();
            this.resetParentNodes();
            this.treeModel = (DefaultTreeModel)this.boardMeetingHolder.tree.getModel();
            for (int i = size = allNodes.size(); i > 0; --i) {
                String meetingDate = allNodes.toArray()[i - 1].toString();
                Date boardMeetingdDate = null;
                try {
                    boardMeetingdDate = LogsTC.boardMeetingDateFormat.parse(meetingDate);
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                }
                if (boardMeetingdDate.compareTo(this.lastWeek) == 0 || boardMeetingdDate.after(this.lastWeek) && boardMeetingdDate.before(this.currentWeek)) {
                    this.addNode(meetingDate, lastWeekTitle);
                    continue;
                }
                if (boardMeetingdDate.compareTo(this.currentWeek) == 0 || boardMeetingdDate.after(this.currentWeek) && boardMeetingdDate.before(this.nextWeek)) {
                    if (Util.isSameDay((Date)boardMeetingdDate, (Date)this.today)) {
                        this.addNode("Today", currentWeekTitle);
                        continue;
                    }
                    this.addNode(meetingDate, currentWeekTitle);
                    continue;
                }
                if (boardMeetingdDate.compareTo(this.nextWeek) == 0 || boardMeetingdDate.after(this.nextWeek) && boardMeetingdDate.before(this.later)) {
                    this.addNode(meetingDate, nextWeekTitle);
                    continue;
                }
                if (boardMeetingdDate.compareTo(this.lastWeek) < 0) continue;
                this.addNode(meetingDate, laterTitle);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void resetParentNodes() {
        try {
            MutableTreeNode node1;
            TreePath path1 = this.boardMeetingHolder.tree.getNextMatch(currentWeekTitle, 0, Position.Bias.Forward);
            if (path1 != null) {
                node1 = (MutableTreeNode)path1.getLastPathComponent();
                this.treeModel.removeNodeFromParent(node1);
            }
            if ((path1 = this.boardMeetingHolder.tree.getNextMatch(lastWeekTitle, 0, Position.Bias.Forward)) != null) {
                node1 = (MutableTreeNode)path1.getLastPathComponent();
                this.treeModel.removeNodeFromParent(node1);
            }
            if ((path1 = this.boardMeetingHolder.tree.getNextMatch(laterTitle, 0, Position.Bias.Forward)) != null) {
                node1 = (MutableTreeNode)path1.getLastPathComponent();
                this.treeModel.removeNodeFromParent(node1);
            }
            if ((path1 = this.boardMeetingHolder.tree.getNextMatch(nextWeekTitle, 0, Position.Bias.Forward)) != null) {
                node1 = (MutableTreeNode)path1.getLastPathComponent();
                this.treeModel.removeNodeFromParent(node1);
            }
            this.setDefaultNodes();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void removeNodes() {
        this.treeModel = (DefaultTreeModel)this.boardMeetingHolder.tree.getModel();
        int childCount = this.getChildCount(this.treeModel, this.treeModel.getRoot());
        int startRow = 0;
        for (int i = 0; i < childCount; ++i) {
            for (int j = 0; j < this.days.size(); ++j) {
                String prefix = this.days.get(j);
                TreePath path1 = this.boardMeetingHolder.tree.getNextMatch(prefix, startRow, Position.Bias.Forward);
                if (path1 == null) continue;
                MutableTreeNode node1 = (MutableTreeNode)path1.getLastPathComponent();
                this.treeModel.removeNodeFromParent(node1);
            }
        }
    }

    public int getChildCount(TreeModel model, Object node) {
        if (node == null) {
            return 0;
        }
        int ub = model.getChildCount(node);
        int sum = 1;
        for (int i = 0; i < ub; ++i) {
            sum += this.getChildCount(model, model.getChild(node, i));
        }
        return sum;
    }

    public void getAllMessages() {
        if (AppConfig.loginMode != LoginMode.PMEX) {
            new Thread((Runnable)this.getMessages, "Board Meeting getAllMessages").start();
        }
    }

    private void addAllDataSafe(final String result, final boolean b) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.addAllData(result, b);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BoardMeetingTab.this.addAllData(result, b);
                }
            });
        }
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.table.addNotify();
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BoardMeetingTab.this.table.addNotify();
                    BoardMeetingTab.this.table.repaint();
                }
            });
        }
    }

    private void addAllData(String msg, boolean isBlink) {
        this.mediator.println("All Board = " + msg);
        String lastMessage = "";
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
        if (msg.indexOf("|") >= 0) {
            String[] rowsVal = msg.split("\\|", -1);
            int MSG_count = 0;
            int Today_MSG_count = 0;
            boolean isAddNodes = true;
            boolean updatedNodes = true;
            Message message = null;
            for (int i = 0; i < rowsVal.length - 1; ++i) {
                if (rowsVal[i].indexOf(";") >= 0) {
                    String[] columnVal = rowsVal[i].split("\\;", -1);
                    try {
                        message = this.parse(columnVal);
                        lastMessage = message.dateTime.value;
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        ex.printStackTrace();
                    }
                    if (message.isBlink) {
                        ++MSG_count;
                    }
                    try {
                        Date dd = LogsTC.boardMeetingDateFormat.parse(message.dateTime.value);
                        if (Util.isSameDay((Date)dd, (Date)this.today)) {
                            message.isBlink = true;
                            message.isDateBlink = true;
                            ++Today_MSG_count;
                        }
                    }
                    catch (ParseException ex) {
                        ex.printStackTrace();
                    }
                    for (int j = 0; j < this.allData.size(); ++j) {
                        Message mm = this.allData.get(j);
                        if (!mm.id.value.equalsIgnoreCase(message.id.value)) continue;
                        if (mm.dateTime.value.equalsIgnoreCase(message.dateTime.value)) {
                            updatedNodes = false;
                        }
                        isAddNodes = false;
                        Date boardMeetingdDate = null;
                        try {
                            boardMeetingdDate = LogsTC.boardMeetingDateFormat.parse(mm.dateTime.value);
                        }
                        catch (ParseException ex) {
                            ex.printStackTrace();
                        }
                        if (boardMeetingdDate.compareTo(this.lastWeek) == 0 || boardMeetingdDate.after(this.lastWeek) && boardMeetingdDate.before(this.currentWeek)) {
                            --lastWeekCount;
                        } else if (boardMeetingdDate.compareTo(this.currentWeek) == 0 || boardMeetingdDate.after(this.currentWeek) && boardMeetingdDate.before(this.nextWeek)) {
                            --currentWeekCount;
                        } else if (boardMeetingdDate.compareTo(this.nextWeek) == 0 || boardMeetingdDate.after(this.nextWeek) && boardMeetingdDate.before(this.later)) {
                            --nextWeekCount;
                        } else {
                            if (boardMeetingdDate.compareTo(this.lastWeek) < 0) continue;
                            --laterCount;
                        }
                        mm.msgNo = message.msgNo;
                        mm = message;
                        this.allData.remove(j);
                        this.allData.add(j, mm);
                        if (updatedNodes) {
                            this.nodeSet.clear();
                            for (int k = 0; k < this.allData.size(); ++k) {
                                Message msgN = this.allData.get(k);
                                if (this.nodeSet.contains(msgN.dateTime.value)) continue;
                                this.nodeSet.add(msgN.dateTime.value);
                            }
                        }
                        if (this.boardMeetingHolder.tree.getLastSelectedPathComponent() != null) {
                            String url = this.boardMeetingHolder.tree.getLastSelectedPathComponent().toString();
                            if (url.equalsIgnoreCase("Today")) {
                                url = LogsTC.boardMeetingDateFormat.format(new Date(System.currentTimeMillis()));
                            }
                            this.addFilterRow(url);
                            break;
                        }
                        this.rows.clear();
                        this.tableDataChange();
                        break;
                    }
                    if (message == null) continue;
                    if (!this.nodeSet.contains(message.dateTime.value)) {
                        this.nodeSet.add(message.dateTime.value);
                    }
                    if (isAddNodes) {
                        this.allData.add(message);
                    }
                }
                Date boardMeetingdDate = null;
                try {
                    boardMeetingdDate = LogsTC.boardMeetingDateFormat.parse(message.dateTime.value);
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                }
                if (boardMeetingdDate.compareTo(this.lastWeek) == 0 || boardMeetingdDate.after(this.lastWeek) && boardMeetingdDate.before(this.currentWeek)) {
                    ++lastWeekCount;
                    continue;
                }
                if (boardMeetingdDate.compareTo(this.currentWeek) == 0 || boardMeetingdDate.after(this.currentWeek) && boardMeetingdDate.before(this.nextWeek)) {
                    ++currentWeekCount;
                    continue;
                }
                if (boardMeetingdDate.compareTo(this.nextWeek) == 0 || boardMeetingdDate.after(this.nextWeek) && boardMeetingdDate.before(this.later)) {
                    ++nextWeekCount;
                    continue;
                }
                if (boardMeetingdDate.compareTo(this.lastWeek) < 0) {
                    this.allData.remove(message);
                    --Today_MSG_count;
                    continue;
                }
                ++laterCount;
            }
            if (MSG_count == 1 && LogCommon.DesktopAlert_NewsHouseBoard) {
                if (this.mediator.toasterManager != null) {
                    this.mediator.toasterManager.showToaster(this.mediator.toasterManager, this.languageCentre.getValue(LanguageConstant.BoardMeeting), message.subject.value, this.languageCentre.getValue(LanguageConstant.BoardMeeting));
                }
            } else if (MSG_count > 1 && LogCommon.DesktopAlert_NewsHouseBoard && this.mediator.toasterManager != null) {
                this.mediator.toasterManager.showToaster(this.mediator.toasterManager, this.languageCentre.getValue(LanguageConstant.BoardMeeting), MSG_count + " New Messages!", this.languageCentre.getValue(LanguageConstant.BoardMeeting));
            }
            if (Today_MSG_count == 1 && LogCommon.DesktopAlert_NewsHouseBoard) {
                if (this.mediator.toasterManager != null) {
                    this.mediator.toasterManager.showToaster(this.mediator.toasterManager, this.languageCentre.getValue(LanguageConstant.BoardMeeting), Today_MSG_count + " Board Meeting Today!", this.languageCentre.getValue(LanguageConstant.BoardMeeting));
                }
            } else if (Today_MSG_count > 1 && LogCommon.DesktopAlert_NewsHouseBoard && this.mediator.toasterManager != null) {
                this.mediator.toasterManager.showToaster(this.mediator.toasterManager, this.languageCentre.getValue(LanguageConstant.BoardMeeting), Today_MSG_count + " Board Meetings Today!", this.languageCentre.getValue(LanguageConstant.BoardMeeting));
            }
            if (updatedNodes || isAddNodes) {
                this.addNode(this.nodeSet);
            }
        }
        this.addFilterRow("Board Meetings");
        if (!lastMessage.equalsIgnoreCase("")) {
            TreePath treePath;
            Date boardMeetingdDate = null;
            try {
                boardMeetingdDate = LogsTC.boardMeetingDateFormat.parse(lastMessage);
            }
            catch (ParseException ex) {
                ex.printStackTrace();
            }
            if (Util.isSameDay((Date)boardMeetingdDate, (Date)this.today)) {
                lastMessage = "Today";
            }
            if ((treePath = this.boardMeetingHolder.tree.getNextMatch(lastMessage, 0, Position.Bias.Forward)) == null) {
                treePath = this.boardMeetingHolder.tree.getNextMatch("Board Meetings", 0, Position.Bias.Forward);
            }
            this.boardMeetingHolder.tree.setSelectionPath(treePath);
            this.boardMeetingHolder.tree.scrollPathToVisible(treePath);
            if (lastMessage.equalsIgnoreCase("Today")) {
                lastMessage = LogsTC.boardMeetingDateFormat.format(new Date(System.currentTimeMillis()));
            }
            this.addFilterRow(lastMessage);
        }
        this.tableDataChange();
    }

    public void addFilterRow(String date) {
        this.lastSelection = date;
        this.rows.clear();
        LogsKSE.boardMsgCount2 = 0;
        for (int i = 0; i < this.allData.size(); ++i) {
            MessageDisplay display;
            Message message = this.allData.get(i);
            Date boardMeetingdDate = null;
            try {
                boardMeetingdDate = LogsTC.boardMeetingDateFormat.parse(message.dateTime.value);
            }
            catch (ParseException ex) {
                ex.printStackTrace();
            }
            if (date.indexOf("Board Meetings") >= 0) {
                ++LogsKSE.boardMsgCount2;
                display = new MessageDisplay(this, message, this.table, this.type, this.rows, null);
                if (LogCommon.isTop) {
                    this.rows.add(0, display);
                } else {
                    this.rows.add(this.rows.size(), display);
                }
                if (message.isDateBlink || message.isBlink) {
                    this.timerMap.put(message.id.value, this.Blink(message.id.value, true));
                    message.isDateBlink = false;
                    message.isBlink = false;
                }
                Util.ScrollToFirstOrLastRow((boolean)LogCommon.isTop, (JTable)this.table, (JScrollPane)this.jScrollPane1);
                continue;
            }
            if (date.indexOf(lastWeekTitle) >= 0) {
                if (boardMeetingdDate.compareTo(this.lastWeek) != 0 && (!boardMeetingdDate.after(this.lastWeek) || !boardMeetingdDate.before(this.currentWeek))) continue;
                ++LogsKSE.boardMsgCount2;
                display = new MessageDisplay(this, message, this.table, this.type, this.rows, null);
                if (LogCommon.isTop) {
                    this.rows.add(0, display);
                } else {
                    this.rows.add(this.rows.size(), display);
                }
                if (message.isDateBlink || message.isBlink) {
                    this.timerMap.put(message.id.value, this.Blink(message.id.value, true));
                    message.isDateBlink = false;
                    message.isBlink = false;
                }
                Util.ScrollToFirstOrLastRow((boolean)LogCommon.isTop, (JTable)this.table, (JScrollPane)this.jScrollPane1);
                continue;
            }
            if (date.indexOf(currentWeekTitle) >= 0) {
                if (boardMeetingdDate.compareTo(this.currentWeek) != 0 && (!boardMeetingdDate.after(this.currentWeek) || !boardMeetingdDate.before(this.nextWeek))) continue;
                ++LogsKSE.boardMsgCount2;
                display = new MessageDisplay(this, message, this.table, this.type, this.rows, null);
                if (LogCommon.isTop) {
                    this.rows.add(0, display);
                } else {
                    this.rows.add(this.rows.size(), display);
                }
                if (message.isDateBlink || message.isBlink) {
                    this.timerMap.put(message.id.value, this.Blink(message.id.value, true));
                    message.isDateBlink = false;
                    message.isBlink = false;
                }
                Util.ScrollToFirstOrLastRow((boolean)LogCommon.isTop, (JTable)this.table, (JScrollPane)this.jScrollPane1);
                continue;
            }
            if (date.indexOf(nextWeekTitle) >= 0) {
                if (boardMeetingdDate.compareTo(this.nextWeek) != 0 && (!boardMeetingdDate.after(this.nextWeek) || !boardMeetingdDate.before(this.later))) continue;
                ++LogsKSE.boardMsgCount2;
                display = new MessageDisplay(this, message, this.table, this.type, this.rows, null);
                if (LogCommon.isTop) {
                    this.rows.add(0, display);
                } else {
                    this.rows.add(this.rows.size(), display);
                }
                if (message.isDateBlink || message.isBlink) {
                    this.timerMap.put(message.id.value, this.Blink(message.id.value, true));
                    message.isDateBlink = false;
                    message.isBlink = false;
                }
                Util.ScrollToFirstOrLastRow((boolean)LogCommon.isTop, (JTable)this.table, (JScrollPane)this.jScrollPane1);
                continue;
            }
            if (date.indexOf(laterTitle) >= 0) {
                if (boardMeetingdDate.compareTo(this.lastWeek) == 0 || boardMeetingdDate.after(this.lastWeek) && boardMeetingdDate.before(this.currentWeek) || boardMeetingdDate.compareTo(this.currentWeek) == 0 || boardMeetingdDate.after(this.currentWeek) && boardMeetingdDate.before(this.nextWeek) || boardMeetingdDate.compareTo(this.nextWeek) == 0 || boardMeetingdDate.after(this.nextWeek) && boardMeetingdDate.before(this.later) || boardMeetingdDate.compareTo(this.lastWeek) < 0) continue;
                ++LogsKSE.boardMsgCount2;
                display = new MessageDisplay(this, message, this.table, this.type, this.rows, null);
                if (LogCommon.isTop) {
                    this.rows.add(0, display);
                } else {
                    this.rows.add(this.rows.size(), display);
                }
                if (message.isDateBlink || message.isBlink) {
                    this.timerMap.put(message.id.value, this.Blink(message.id.value, true));
                    message.isDateBlink = false;
                    message.isBlink = false;
                }
                Util.ScrollToFirstOrLastRow((boolean)LogCommon.isTop, (JTable)this.table, (JScrollPane)this.jScrollPane1);
                continue;
            }
            if (!message.dateTime.value.equalsIgnoreCase(date)) continue;
            ++LogsKSE.boardMsgCount2;
            display = new MessageDisplay(this, message, this.table, this.type, this.rows, null);
            if (LogCommon.isTop) {
                this.rows.add(0, display);
            } else {
                this.rows.add(this.rows.size(), display);
            }
            if (message.isDateBlink || message.isBlink) {
                this.timerMap.put(message.id.value, this.Blink(message.id.value, true));
                message.isDateBlink = false;
                message.isBlink = false;
            }
            Util.ScrollToFirstOrLastRow((boolean)LogCommon.isTop, (JTable)this.table, (JScrollPane)this.jScrollPane1);
        }
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
        this.updateAllData();
    }

    public synchronized Timer Blink(final String idNO, boolean isStart) {
        final Timer BlinkTimmer = new Timer(0, null){

            @Override
            public void stop() {
                int rowNo = BoardMeetingTab.this.getRowNo(idNO);
                if (rowNo >= 0) {
                    MessageDisplay md = BoardMeetingTab.this.rows.get(rowNo);
                    md.setColor(false);
                    BoardMeetingTab.this.tableDataChange();
                    super.stop();
                }
            }
        };
        ActionListener ac = new ActionListener(){
            int i = 0;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.i >= AppConfig.BlinkInterval) {
                    int rowNo = BoardMeetingTab.this.getRowNo(idNO);
                    if (rowNo >= 0) {
                        MessageDisplay md = BoardMeetingTab.this.rows.get(rowNo);
                        md.setColor(true);
                        BlinkTimmer.stop();
                        BoardMeetingTab.this.tableDataChange();
                    }
                } else {
                    int rowNo = BoardMeetingTab.this.getRowNo(idNO);
                    if (rowNo >= 0) {
                        MessageDisplay md = BoardMeetingTab.this.rows.get(rowNo);
                        if (this.i % 2 == 0) {
                            md.setColor(false);
                        } else {
                            md.setColor(true);
                        }
                        BoardMeetingTab.this.tableDataChange();
                        ++this.i;
                    }
                }
            }
        };
        BlinkTimmer.addActionListener(ac);
        BlinkTimmer.setDelay(500);
        BlinkTimmer.setRepeats(true);
        if (isStart) {
            BlinkTimmer.start();
        }
        return BlinkTimmer;
    }

    public void stopBlink(String id) {
        if (this.timerMap.containsKey(id)) {
            this.timerMap.get(id).stop();
        }
    }

    private int getRowNo(String msgID) {
        int rowNo = -1;
        for (int i = 0; i < this.rows.size(); ++i) {
            Message object = this.rows.elementAt((int)i).message;
            if (!object.id.value.equalsIgnoreCase(msgID)) continue;
            return i;
        }
        return rowNo;
    }

    public Message parse(String[] columnVal) {
        Message m = new Message();
        boolean isBlink = false;
        boolean isRead = false;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        try {
            Date date = df.parse(columnVal[1]);
            m.dateTime.value = LogsTC.boardMeetingDateFormat.format(date);
        }
        catch (ParseException ex) {
            m.dateTime.value = columnVal[1];
            ex.printStackTrace();
        }
        m.description.value = columnVal[5];
        m.detail.value = columnVal[4];
        m.id.value = columnVal[0];
        m.subject.value = columnVal[3];
        m.type.value = columnVal[2];
        try {
            isBlink = columnVal[6].equalsIgnoreCase("1") ? true : Boolean.parseBoolean(columnVal[6]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        m.isBlink = isBlink;
        try {
            isRead = columnVal[7].equalsIgnoreCase("1") ? true : Boolean.parseBoolean(columnVal[7]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        m.isRead = isRead;
        return m;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.sortMenu = new JPopupMenu();
        this.menuDate = new JCheckBoxMenuItem();
        this.menuScrip = new JCheckBoxMenuItem();
        this.menuCompanyName = new JCheckBoxMenuItem();
        this.menuDetails = new JCheckBoxMenuItem();
        this.toolBar = new JToolBar();
        this.btnExpand = new JButton();
        this.btnSearch = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.btnAsen = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.btnDecn = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.collapsiblePane = new JXCollapsiblePane();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.Add_CollapsiblePane = new JXCollapsiblePane();
        this.buttonGroup1.add(this.menuDate);
        this.menuDate.setSelected(true);
        this.menuDate.setText("Date");
        this.menuDate.setIcon(new ImageIcon(this.getClass().getResource("/Images/date16.png")));
        this.menuDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BoardMeetingTab.this.menuDateActionPerformed(evt);
            }
        });
        this.sortMenu.add(this.menuDate);
        this.buttonGroup1.add(this.menuScrip);
        this.menuScrip.setText("Scrip");
        this.menuScrip.setIcon(new ImageIcon(this.getClass().getResource("/Images/subject16.png")));
        this.menuScrip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BoardMeetingTab.this.menuScripActionPerformed(evt);
            }
        });
        this.sortMenu.add(this.menuScrip);
        this.buttonGroup1.add(this.menuCompanyName);
        this.menuCompanyName.setText("Company Name");
        this.menuCompanyName.setIcon(new ImageIcon(this.getClass().getResource("/Images/description16.png")));
        this.menuCompanyName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BoardMeetingTab.this.menuCompanyNameActionPerformed(evt);
            }
        });
        this.sortMenu.add(this.menuCompanyName);
        this.buttonGroup1.add(this.menuDetails);
        this.menuDetails.setText("Details");
        this.menuDetails.setIcon(new ImageIcon(this.getClass().getResource("/Images/detail16.png")));
        this.menuDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BoardMeetingTab.this.menuDetailsActionPerformed(evt);
            }
        });
        this.sortMenu.add(this.menuDetails);
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.toolBar.setMaximumSize(new Dimension(116, 21));
        this.toolBar.setMinimumSize(new Dimension(116, 21));
        this.toolBar.setPreferredSize(new Dimension(100, 18));
        this.btnExpand.setIcon(new ImageIcon(this.getClass().getResource("/Images/RightArrow.png")));
        this.btnExpand.setFocusable(false);
        this.btnExpand.setHorizontalTextPosition(0);
        this.btnExpand.setVerticalTextPosition(3);
        this.btnExpand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BoardMeetingTab.this.btnExpandActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnExpand);
        this.btnSearch.setIcon(new ImageIcon(this.getClass().getResource("/Images/search12.png")));
        this.btnSearch.setText("Search");
        this.btnSearch.setToolTipText("Search");
        this.btnSearch.setFocusable(false);
        this.btnSearch.setHorizontalTextPosition(4);
        this.btnSearch.setMaximumSize(new Dimension(18, 18));
        this.btnSearch.setMinimumSize(new Dimension(18, 18));
        this.btnSearch.setPreferredSize(new Dimension(61, 21));
        this.btnSearch.setVerticalTextPosition(3);
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BoardMeetingTab.this.btnSearchActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnSearch);
        this.toolBar.add(this.jSeparator3);
        this.btnAsen.setIcon(new ImageIcon(this.getClass().getResource("/Images/ascending12.png")));
        this.btnAsen.setToolTipText("Sort Ascending");
        this.btnAsen.setFocusable(false);
        this.btnAsen.setHorizontalTextPosition(0);
        this.btnAsen.setMaximumSize(new Dimension(35, 18));
        this.btnAsen.setMinimumSize(new Dimension(35, 18));
        this.btnAsen.setPreferredSize(new Dimension(38, 18));
        this.btnAsen.setVerticalTextPosition(3);
        this.btnAsen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BoardMeetingTab.this.btnAsenActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnAsen);
        this.toolBar.add(this.jSeparator2);
        this.btnDecn.setIcon(new ImageIcon(this.getClass().getResource("/Images/descending12.png")));
        this.btnDecn.setToolTipText("Sort Descending");
        this.btnDecn.setFocusable(false);
        this.btnDecn.setHorizontalTextPosition(0);
        this.btnDecn.setMaximumSize(new Dimension(35, 18));
        this.btnDecn.setMinimumSize(new Dimension(35, 18));
        this.btnDecn.setPreferredSize(new Dimension(35, 18));
        this.btnDecn.setVerticalTextPosition(3);
        this.btnDecn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BoardMeetingTab.this.btnDecnActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnDecn);
        this.toolBar.add(this.jSeparator1);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 313, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 16, Short.MAX_VALUE));
        this.toolBar.add(this.jPanel2);
        this.jPanel1.setPreferredSize(new Dimension(461, 400));
        this.collapsiblePane.setOpaque(false);
        this.jScrollPane1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                BoardMeetingTab.this.jScrollPane1MouseClicked(evt);
            }
        });
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}}, new String[]{"Title", "Published Date", "Description", "Details"}));
        this.table.setRowSelectionAllowed(false);
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                BoardMeetingTab.this.tableMouseMoved(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.table);
        this.Add_CollapsiblePane.setBackground(new Color(255, 255, 255));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.collapsiblePane, -1, 492, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGap(0, 0, 0).addComponent((Component)this.Add_CollapsiblePane, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jScrollPane1, -1, 492, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent((Component)this.collapsiblePane, -2, -1, -2).addGap(0, 0, 0).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.Add_CollapsiblePane, -1, 51, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 51, Short.MAX_VALUE)).addGap(0, 0, 0)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 492, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, 492, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toolBar, -1, 492, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 71, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.jPanel1, -1, 51, Short.MAX_VALUE))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.toolBar, -2, -1, -2).addGap(0, 0, 0))));
    }

    private void tableMouseMoved(MouseEvent evt) {
        try {
            int rowindex = this.table.rowAtPoint(evt.getPoint());
            this.table.editCellAt(rowindex, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jScrollPane1MouseClicked(MouseEvent evt) {
    }

    private void btnSearchActionPerformed(ActionEvent evt) {
        this.searchPanel = new SearchPanelScrip(null, this, this.type);
        this.searchPanel.setScrip();
        this.collapsiblePane.removeAll();
        this.collapsiblePane.add((Component)this.searchPanel);
        this.collapsiblePane.setCollapsed(!this.collapsiblePane.isCollapsed());
    }

    private void btnAsenActionPerformed(ActionEvent evt) {
        if (this.menuDate.isSelected()) {
            this.callSort(1, true);
        } else if (this.menuScrip.isSelected()) {
            this.callSort(3, true);
        } else if (this.menuCompanyName.isSelected()) {
            this.callSort(5, true);
        } else if (this.menuDetails.isSelected()) {
            this.callSort(4, true);
        }
    }

    private void btnDecnActionPerformed(ActionEvent evt) {
        if (this.menuDate.isSelected()) {
            this.callSort(1, false);
        } else if (this.menuScrip.isSelected()) {
            this.callSort(3, false);
        } else if (this.menuCompanyName.isSelected()) {
            this.callSort(5, false);
        } else if (this.menuDetails.isSelected()) {
            this.callSort(4, false);
        }
    }

    private void btnExpandActionPerformed(ActionEvent evt) {
        boolean state = this.Add_CollapsiblePane.isCollapsed();
        if (state) {
            this.Add_CollapsiblePane.setCollapsed(false);
            this.btnExpand.setIcon(new ImageIcon(this.getClass().getResource("/Images/LeftArrow.png")));
        } else {
            this.Add_CollapsiblePane.setCollapsed(true);
            this.btnExpand.setIcon(new ImageIcon(this.getClass().getResource("/Images/RightArrow.png")));
        }
    }

    private void menuScripActionPerformed(ActionEvent evt) {
        this.callSort(3, this.isAsec);
    }

    private void menuCompanyNameActionPerformed(ActionEvent evt) {
        this.callSort(5, this.isAsec);
    }

    private void menuDetailsActionPerformed(ActionEvent evt) {
        this.callSort(4, this.isAsec);
    }

    private void menuDateActionPerformed(ActionEvent evt) {
        this.callSort(1, this.isAsec);
    }

    public void getAllMessages(String msgType, String msgID, int i) {
        GetBoardMeetingSingle m = new GetBoardMeetingSingle(msgID, i);
        Thread t = new Thread(m);
        t.setName("Borad Meeting getAllMessages Single");
        t.start();
    }

    private synchronized void updateAllData() {
        MessageDisplay messageDisplay;
        int i;
        HashMap<String, MessageDisplay> tem = new HashMap<String, MessageDisplay>();
        for (i = 0; i < this.rows.size(); ++i) {
            messageDisplay = this.rows.elementAt(i);
            tem.put(messageDisplay.message.id.value, messageDisplay);
        }
        this.rows.clear();
        this.rows.addAll(tem.values());
        for (i = 0; i < this.rows.size(); ++i) {
            messageDisplay = this.rows.elementAt(i);
            messageDisplay.message.msgNo = i + 1;
            LogsKSE.boardMsgCount2 = this.rows.size();
            messageDisplay.setBoardMeetingText(false);
        }
        this.tableDataChange();
    }

    private void callSort(int index, boolean ascSec) {
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
        Collections.sort(this.rows, new BoardMeetingComparator(index, ascSec));
        this.table.tableChanged(new TableModelEvent(this.model));
        this.tableDataChange();
    }

    public void callSort(Vector<MessageDisplay> rows_, int index, boolean ascSec) {
        Collections.sort(rows_, new BoardMeetingComparator(index, ascSec));
    }

    private void setDates() {
        this.cal.setTime(this.today);
        this.cal.set(11, 0);
        this.cal.set(12, 0);
        this.cal.set(13, 0);
        this.cal.set(14, 0);
        this.today = this.cal.getTime();
        this.cal.set(7, 2);
        this.cal.add(5, -7);
        this.lastWeek = new Date(this.cal.getTimeInMillis());
        this.cal.add(5, 7);
        this.currentWeek = new Date(this.cal.getTimeInMillis());
        this.cal.add(5, 7);
        this.nextWeek = new Date(this.cal.getTimeInMillis());
        this.cal.add(5, 7);
        this.later = new Date(this.cal.getTimeInMillis());
    }

    public void deleteRow(String id) {
        for (int i = 0; i < this.allData.size(); ++i) {
            if (!this.allData.get((int)i).id.value.equalsIgnoreCase(id)) continue;
            Date boardMeetingdDate = null;
            try {
                boardMeetingdDate = LogsTC.boardMeetingDateFormat.parse(this.allData.get((int)i).dateTime.value);
            }
            catch (ParseException ex) {
                ex.printStackTrace();
            }
            if (boardMeetingdDate.compareTo(this.lastWeek) == 0 || boardMeetingdDate.after(this.lastWeek) && boardMeetingdDate.before(this.currentWeek)) {
                --lastWeekCount;
            } else if (boardMeetingdDate.compareTo(this.currentWeek) == 0 || boardMeetingdDate.after(this.currentWeek) && boardMeetingdDate.before(this.nextWeek)) {
                --currentWeekCount;
            } else if (boardMeetingdDate.compareTo(this.nextWeek) == 0 || boardMeetingdDate.after(this.nextWeek) && boardMeetingdDate.before(this.later)) {
                --nextWeekCount;
            } else {
                if (boardMeetingdDate.compareTo(this.lastWeek) < 0) continue;
                --laterCount;
            }
            this.allData.remove(i);
            if (this.boardMeetingHolder.tree.getLastSelectedPathComponent() != null) {
                String url = this.boardMeetingHolder.tree.getLastSelectedPathComponent().toString();
                if (url.equalsIgnoreCase("Today")) {
                    url = LogsTC.boardMeetingDateFormat.format(new Date(System.currentTimeMillis()));
                }
                this.addFilterRow(url);
                break;
            }
            this.rows.clear();
            this.tableDataChange();
            break;
        }
        this.nodeSet.clear();
        for (int k = 0; k < this.allData.size(); ++k) {
            Message msgN = this.allData.get(k);
            if (this.nodeSet.contains(msgN.dateTime.value)) continue;
            this.nodeSet.add(msgN.dateTime.value);
        }
        this.addNode(this.nodeSet);
        this.tableDataChange();
    }

    public void setReadunRead(Message message) {
        int i;
        for (i = 0; i < this.allData.size(); ++i) {
            Message message1 = this.allData.get(i);
            if (!message1.id.value.equalsIgnoreCase(message.id.value)) continue;
            message1.isRead = message.isRead;
            break;
        }
        for (i = 0; i < this.rows.size(); ++i) {
            MessageDisplay messageDisplay = this.rows.elementAt(i);
            if (!messageDisplay.message.id.value.equalsIgnoreCase(message.id.value)) continue;
            messageDisplay.setBoardMeetingText(false);
            break;
        }
    }

    static {
        boardMsgCount = 0;
        totalMessage = 0;
        currentWeekCount = 0;
        lastWeekCount = 0;
        nextWeekCount = 0;
        laterCount = 0;
        currentWeekUnreadCount = 0;
        lastWeekUnreadCount = 0;
        nextWeekUnreadCount = 0;
        laterUnreadCount = 0;
    }

    private class GetBoardMeetingSingle
    implements Runnable {
        private String msgID;
        private final int i;

        public GetBoardMeetingSingle(String msgID, int i) {
            this.msgID = msgID;
            this.i = i;
            BoardMeetingTab.this.setName("GetBoardMeetingSingle");
        }

        @Override
        public void run() {
            try {
                String result = this.msgID.replaceAll("\\==", "|");
                if (result != null) {
                    BoardMeetingTab.this.addAllDataSafe(result, true);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

