/*
 * Decompiled with CFR 0.152.
 */
package MessageWindow;

import MessageWindow.UserMessage;
import MyDocking.TradeCast;
import common.gui.component.NxGDialogBox;
import common.gui.component.NxGTable;
import common.gui.util.MessageType;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import kse.gui.bean.MarginCallBean;
import kse.gui.comparator.MarginCallComparator;
import kse.gui.model.MarginCallListModel;
import kse.gui.render.MarginCallListHighLighterRender;
import org.jdesktop.swingx.JXSearchField;

public class MarginCallList
extends NxGDialogBox
implements ActionListener {
    private final UserMessage userMessage;
    private MarginCallBean margin;
    Vector<String> columns = new Vector();
    Vector<MarginCallBean> rows = new Vector();
    Vector<MarginCallBean> allRows = new Vector();
    private ButtonGroup buttonGroup = new ButtonGroup();
    private int searchingColumn = 0;
    MarginCallListModel model = null;
    MarginCallListHighLighterRender render = null;
    private Icon Cancel_ICON = null;
    private Icon Search_ICON = null;
    private Color Background = new Color(255, 102, 102);
    private static MarginCallList instance = null;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lblMessage;
    private JLabel lblName;
    private JPopupMenu popupMenu;
    private NxGTable table;
    private JXSearchField txtSearchField;

    public static MarginCallList getInstance(UserMessage userMessage, MarginCallBean margin) {
        if (instance == null) {
            instance = new MarginCallList(userMessage, margin);
        }
        return instance;
    }

    private MarginCallList(UserMessage userMessage, MarginCallBean margin) {
        super((Frame)TradeCast.getInstance().frame, false);
        this.initComponents();
        this.userMessage = userMessage;
        this.margin = margin;
        this.initTable();
        this.setTxtSearchFieldIcon();
        this.setupSearchField();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.setAllData();
    }

    private void setTxtSearchFieldIcon() {
        try {
            this.Cancel_ICON = new ImageIcon(this.getClass().getResource("/common/gui/images/cross.png"));
            this.txtSearchField.getCancelButton().setIcon(this.Cancel_ICON);
            this.txtSearchField.getCancelButton().setRolloverIcon(this.Cancel_ICON);
            this.txtSearchField.getCancelButton().setPressedIcon(this.Cancel_ICON);
            this.txtSearchField.updateUI();
            this.Search_ICON = new ImageIcon(this.getClass().getResource("/common/gui/images/search26x20.png"));
            this.txtSearchField.getFindButton().setIcon(this.Search_ICON);
            this.txtSearchField.getFindButton().setRolloverIcon(this.Search_ICON);
            this.txtSearchField.updateUI();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setupSearchField() {
        this.txtSearchField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MarginCallList.this.txtSearchField.getText().trim().length() == 0) {
                    MarginCallList.this.rowsFillter("");
                }
            }
        });
        this.txtSearchField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                super.keyPressed(e);
                if (e.getKeyCode() == 10) {
                    MarginCallList.this.rowsFillter(MarginCallList.this.txtSearchField.getText().trim());
                }
            }
        });
        this.txtSearchField.setFindPopupMenu(this.popupMenu);
        for (int i = 0; i < this.columns.size(); ++i) {
            JRadioButtonMenuItem rb = new JRadioButtonMenuItem(this.columns.get(i));
            rb.setActionCommand(i + "");
            rb.addActionListener(this);
            this.buttonGroup.add(rb);
            this.popupMenu.add(rb);
            if (!this.columns.get(i).equalsIgnoreCase("Account")) continue;
            rb.setSelected(true);
            this.lblName.setText("Account");
        }
        this.popupMenu.addSeparator();
        JRadioButtonMenuItem rb = new JRadioButtonMenuItem("Search");
        rb.setActionCommand("-123");
        rb.setSelected(false);
        rb.addActionListener(this);
        this.buttonGroup.add(rb);
        this.popupMenu.add(rb);
    }

    private void rowsFillter(String str) {
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
        this.render.setSearchText(str);
        this.render.setSearchingColumn(this.searchingColumn);
        this.rows.clear();
        this.txtSearchField.setBackground(Color.WHITE);
        this.tableDataChange(false);
        if (str.length() == 0) {
            for (int i = 0; i < this.allRows.size(); ++i) {
                MarginCallBean bean = this.allRows.get(i);
                this.rows.add(bean);
                this.txtSearchField.setBackground(Color.WHITE);
            }
        } else {
            for (int i = 0; i < this.allRows.size(); ++i) {
                MarginCallBean bean = this.allRows.get(i);
                if (this.searchingColumn == -123) {
                    if (bean.toString().toUpperCase().indexOf(str.toUpperCase()) < 0) continue;
                    this.rows.add(bean);
                    continue;
                }
                if (this.searchingColumn == 0) {
                    if (!bean.account.toUpperCase().equalsIgnoreCase(str.toUpperCase())) continue;
                    this.rows.add(bean);
                    continue;
                }
                if (this.searchingColumn == 2) {
                    if (bean.call.toUpperCase().indexOf(str.toUpperCase()) < 0) continue;
                    this.rows.add(bean);
                    continue;
                }
                if (this.searchingColumn == 1) {
                    if (bean.name.toUpperCase().indexOf(str.toUpperCase()) < 0) continue;
                    this.rows.add(bean);
                    continue;
                }
                if (this.searchingColumn == 3) {
                    if (bean.shortfall.toUpperCase().indexOf(str.toUpperCase()) < 0) continue;
                    this.rows.add(bean);
                    continue;
                }
                if (this.searchingColumn == 4) {
                    if (bean.shortfallPer.toUpperCase().indexOf(str.toUpperCase()) < 0) continue;
                    this.rows.add(bean);
                    continue;
                }
                if (this.searchingColumn != 5 || bean.dateTime.toUpperCase().indexOf(str.toUpperCase()) < 0) continue;
                this.rows.add(bean);
            }
        }
        this.tableDataChange(true);
        if (this.rows.size() <= 0) {
            this.txtSearchField.setBackground(this.Background);
        }
        if (this.rows.size() == 1) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)(Util.format0digit((String)(this.rows.size() + "")) + " record found out of " + Util.format0digit((String)(this.allRows.size() + ""))));
        } else if (this.rows.size() > 1) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)(Util.format0digit((String)(this.rows.size() + "")) + " records found out of " + Util.format0digit((String)(this.allRows.size() + ""))));
        }
    }

    private void initTable() {
        this.columns.add("Account");
        this.columns.add("Name");
        this.columns.add("Call");
        this.columns.add("Short Fall");
        this.columns.add("Short Fall %");
        this.columns.add("Time");
        this.model = new MarginCallListModel(this.rows, this.columns);
        this.table.setModel((TableModel)this.model);
        this.render = new MarginCallListHighLighterRender((JTable)this.table);
        for (int k = 0; k < this.model.getColumnCount(); ++k) {
            this.table.getColumn((Object)this.model.getColumnName(k)).setCellRenderer((TableCellRenderer)this.render);
        }
        this.table.setSelectionMode(0);
        this.tableDataChange(false);
        this.setSorter();
    }

    private void tableDataChange(final boolean isPackAll) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.table.addNotify();
            this.model.fireTableDataChanged();
            if (isPackAll) {
                this.table.packAll();
            }
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MarginCallList.this.table.addNotify();
                    MarginCallList.this.model.fireTableDataChanged();
                    if (isPackAll) {
                        MarginCallList.this.table.packAll();
                    }
                    MarginCallList.this.table.repaint();
                }
            });
        }
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.jScrollPane1 = new JScrollPane();
        this.table = new NxGTable();
        this.txtSearchField = new JXSearchField();
        this.lblName = new JLabel();
        this.lblMessage = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setTitle("Margin Call List");
        this.table.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4", "Title 5", "Title 6", "Title 7", "Title 8", "Title 9", "Title 10"}));
        this.table.setSortable(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView((Component)this.table);
        this.txtSearchField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MarginCallList.this.txtSearchFieldFocusGained(evt);
            }
        });
        this.lblName.setFont(new Font("Tahoma", 1, 11));
        this.lblName.setText("Company");
        this.lblName.setHorizontalTextPosition(2);
        this.lblMessage.setText(" ");
        this.lblMessage.setVerticalAlignment(3);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblName, -2, 83, -2).addGap(4, 4, 4).addComponent((Component)this.txtSearchField, -2, 140, -2)).addComponent(this.jScrollPane1, -1, 580, Short.MAX_VALUE).addComponent(this.lblMessage, -1, -1, Short.MAX_VALUE)).addGap(10, 10, 10)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.lblName, -2, 20, -2)).addComponent((Component)this.txtSearchField, -2, -1, -2)).addGap(11, 11, 11).addComponent(this.jScrollPane1, -1, 223, Short.MAX_VALUE).addGap(8, 8, 8).addComponent(this.jSeparator1, -2, 3, -2).addGap(0, 0, 0).addComponent(this.lblMessage, -2, 20, -2).addGap(7, 7, 7)));
        this.pack();
    }

    private void txtSearchFieldFocusGained(FocusEvent evt) {
        this.txtSearchField.selectAll();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof JRadioButtonMenuItem) {
            JRadioButtonMenuItem rb = (JRadioButtonMenuItem)obj;
            try {
                this.searchingColumn = Integer.parseInt(rb.getActionCommand());
                if (this.searchingColumn == -123) {
                    this.lblName.setText("Search");
                } else {
                    this.lblName.setText(this.columns.get(this.searchingColumn));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.rowsFillter(this.txtSearchField.getText());
        }
    }

    public void dispose() {
        super.dispose();
        instance = null;
    }

    private void setAllData() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    MarginCallList.this.allRows.addAll(MarginCallList.this.userMessage.getAllMarginCall());
                    Thread.sleep(300L);
                    if (MarginCallList.this.margin != null) {
                        MarginCallList.this.txtSearchField.setText(((MarginCallList)MarginCallList.this).margin.account);
                        MarginCallList.this.txtSearchField.selectAll();
                        MarginCallList.this.rowsFillter(((MarginCallList)MarginCallList.this).margin.account);
                    } else {
                        MarginCallList.this.rowsFillter("");
                    }
                    MarginCallList.this.tableDataChange(true);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }, "Margin Call List : set All Data").start();
    }

    private void setSorter() {
        JTableHeader tableHeader = this.table.getTableHeader();
        tableHeader.addMouseListener(new ColumnListner(this.table));
        tableHeader.setReorderingAllowed(false);
    }

    private class ColumnListner
    extends MouseAdapter {
        private final NxGTable table;
        protected int sortCol = 0;
        protected boolean isSortAsc = true;
        private TableColumnModel colModel;

        public ColumnListner(NxGTable table) {
            this.table = table;
            this.colModel = table.getColumnModel();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            final MouseEvent evt2 = e;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (MarginCallList.this.rows.size() > 1) {
                        ColumnListner.this.sortTable(evt2);
                    }
                }
            }, "margin Call List sortTable").start();
        }

        private void sortTable(MouseEvent e) {
            String oldMessage = MarginCallList.this.lblMessage.getText();
            Util.setMessage((JLabel)MarginCallList.this.lblMessage, (MessageType)MessageType.Loading, (String)"Please wait while sorting...");
            int columnModelIndex = this.colModel.getColumnIndexAtX(e.getX());
            int modelIndex = this.colModel.getColumn(columnModelIndex).getModelIndex();
            if (modelIndex < 0) {
                return;
            }
            if (this.sortCol == modelIndex) {
                this.isSortAsc = !this.isSortAsc;
            } else {
                this.sortCol = modelIndex;
            }
            Collections.sort(MarginCallList.this.rows, new MarginCallComparator(this.sortCol, this.isSortAsc));
            this.table.tableChanged(new TableModelEvent((TableModel)MarginCallList.this.model));
            MarginCallList.this.tableDataChange(true);
            Util.setMessage((JLabel)MarginCallList.this.lblMessage, (MessageType)MessageType.Normal, (String)oldMessage);
        }
    }
}

