/*
 * Decompiled with CFR 0.152.
 */
package MessageWindow;

import MessageWindow.DisplayModel;
import MessageWindow.MessageDisplay;
import MessageWindow.MessageRender;
import MessageWindow.SearchPanelMarginCall;
import MyDocking.Mediator;
import Utilities.CompressManager;
import Utilities.Voice;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.LoginMode;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import kse.gui.bean.MarginCallBean;
import kse.util.LogsKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;
import org.jdesktop.swingx.JXCollapsiblePane;

public class MarginCallTab
extends JPanel {
    String[] columnNames = new String[]{""};
    HashMap<String, Timer> timerMap = new HashMap();
    HashMap<String, String> lastMessageTypeMap = new HashMap();
    public static HashMap<String, Boolean> readUnReadMap = new HashMap();
    Vector<MessageDisplay> rows = new Vector();
    Vector columns = new Vector();
    public Set<String> nameSet = new TreeSet<String>();
    public Set<String> accountSet = new TreeSet<String>();
    DisplayModel model = new DisplayModel(this.rows, true);
    MessageRender messageRender = new MessageRender();
    int id = 0;
    final int accountIndex = 0;
    final int nameIndex = 1;
    final int callIndex = 2;
    final int shortfallIndex = 3;
    final int shortfallPerIndex = 4;
    final int dateTimeIndex = 5;
    String type = "";
    private JButton dropDownDec;
    private JButton dropDownAsc;
    private JLabel lblCount = new JLabel(" ");
    private boolean isAsec = true;
    public static final int dateTimeIndexSort = 0;
    public static final int callIndexSort = 1;
    public static final int nameIndexSort = 2;
    public static final int accountIndexSort = 3;
    private Mediator mediator;
    private boolean isFirst = true;
    public static int TotalMessage;
    private String lastCallAcc = "";
    private int newCall = 0;
    private LanguageCentre languageCentre = new LanguageCentre();
    Thread getMessages = new Thread(){

        @Override
        public void run() {
            try {
                String result = CompressManager.unzipStringFromBytes(WebService.getInstance().getPort().getMarginCallByTrader(LogCommon.UserID));
                if (result != null) {
                    MarginCallTab.this.addAllData(result);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    };
    Thread getTCSetting = new Thread(){

        @Override
        public void run() {
            try {
                String val = CompressManager.unzipStringFromBytes(WebService.getInstance().getPort().getTCSetting("MagrinCallText"));
                if (val != null && !val.trim().equalsIgnoreCase("")) {
                    LogsKSE.MarginCallText = val;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    };
    private JButton btnAsen;
    private JButton btnDecn;
    private JButton btnSearch;
    private ButtonGroup buttonGroup1;
    private JXCollapsiblePane collapsiblePane;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator7;
    private JToolBar.Separator jSeparator8;
    private JToolBar.Separator jSeparator9;
    private JCheckBoxMenuItem menuAccount;
    private JCheckBoxMenuItem menuCall;
    private JCheckBoxMenuItem menuDate;
    private JCheckBoxMenuItem menuName;
    private JPopupMenu sortMenu;
    public JTable table;
    private JToolBar toolBar;

    public MarginCallTab(String type, Mediator mediator) {
        try {
            this.type = type;
            this.mediator = mediator;
            this.initComponents();
            if (Util.isWindow7()) {
                this.menuAccount.setIcon(null);
                this.menuCall.setIcon(null);
                this.menuDate.setIcon(null);
                this.menuName.setIcon(null);
            }
            this.btnDecn.setLayout(new BorderLayout());
            this.btnDecn.setMargin(new Insets(-5, -5, -5, -5));
            this.dropDownDec = new BasicArrowButton(5);
            this.dropDownDec.setIcon(new ImageIcon(this.getClass().getResource("/Images/ascending12.png")));
            this.dropDownDec.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    MarginCallTab.this.isAsec = false;
                    MarginCallTab.this.sortMenu.show(MarginCallTab.this.btnDecn, evt.getX() + 2, evt.getY() + 7);
                }
            });
            this.btnDecn.add((Component)this.dropDownDec, "East");
            this.btnAsen.setLayout(new BorderLayout());
            this.btnAsen.setMargin(new Insets(-5, -5, -5, -5));
            this.dropDownAsc = new BasicArrowButton(5);
            this.dropDownAsc.setIcon(new ImageIcon(this.getClass().getResource("/Images/ascending12.png")));
            this.dropDownAsc.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    MarginCallTab.this.isAsec = true;
                    MarginCallTab.this.sortMenu.show(MarginCallTab.this.btnAsen, evt.getX() + 2, evt.getY() + 7);
                }
            });
            this.btnAsen.add((Component)this.dropDownAsc, "East");
            this.toolBar.add(Box.createHorizontalGlue());
            this.lblCount.setHorizontalAlignment(4);
            this.lblCount.setVerticalAlignment(3);
            this.toolBar.add(this.lblCount);
            for (int i = 0; i < this.columnNames.length; ++i) {
                this.columns.addElement(this.columnNames[i]);
            }
            this.model.setDataVector(this.rows, this.columns);
            this.table.setModel(this.model);
            this.model.setDataVector(this.rows, this.columns);
            this.table.setModel(this.model);
            this.table.setDefaultRenderer(Object.class, this.messageRender);
            TableColumn com = this.table.getColumnModel().getColumn(0);
            com.setCellEditor(this.messageRender);
            this.table.setTableHeader(null);
            this.table.setRowHeight(95);
            this.table.setSelectionMode(0);
            this.collapsiblePane.setCollapsed(true);
            if (AppConfig.loginMode != LoginMode.PMEX) {
                this.getTCSetting.start();
            }
            mediator.msgCenter.setMarginCallTab(this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addAllData(String msg) {
        String lastAccount = "";
        this.newCall = 0;
        this.rows.clear();
        this.tableDataChange();
        this.mediator.userMessage.removeAllMarginCall();
        if (msg.indexOf("|") >= 0) {
            String[] rowsVal = msg.split("\\|", -1);
            TotalMessage = rowsVal.length - 1;
            ArrayList<MarginCallBean> list = new ArrayList<MarginCallBean>();
            for (int i = 0; i < rowsVal.length; ++i) {
                if (rowsVal[i].indexOf(";") < 0) continue;
                String[] columnVal = rowsVal[i].split("\\;", -1);
                MarginCallBean margin = null;
                try {
                    margin = this.parse(columnVal);
                    margin.msgID = i + 1;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    ex.printStackTrace();
                }
                if (margin == null) {
                    --TotalMessage;
                    continue;
                }
                this.nameSet.add(margin.name);
                this.accountSet.add(margin.account);
                MessageDisplay display = new MessageDisplay(this, margin, this.table, this.type, this.rows);
                list.add(margin);
                if (LogCommon.isTop) {
                    this.rows.add(0, display);
                } else {
                    this.rows.add(this.rows.size(), display);
                }
                if (this.lastMessageTypeMap.containsKey(margin.account)) {
                    String call = this.lastMessageTypeMap.get(margin.account);
                    lastAccount = margin.account;
                    if (!call.equalsIgnoreCase(margin.call)) {
                        ++this.newCall;
                        if (this.timerMap.containsKey(margin.account)) {
                            this.timerMap.get(margin.account).stop();
                        }
                        this.timerMap.put(margin.account, this.Blink(margin.account, true));
                        this.lastMessageTypeMap.put(margin.account, margin.call);
                    }
                } else {
                    this.lastMessageTypeMap.put(margin.account, margin.call);
                }
                this.tableDataChange();
                Util.ScrollToFirstOrLastRow((boolean)LogCommon.isTop, (JTable)this.table, (JScrollPane)this.jScrollPane1);
            }
            this.mediator.userMessage.addMarginCall(list);
            if (!this.isFirst) {
                if (LogCommon.DesktopAlert_MarginCall) {
                    if (this.mediator.toasterManager != null && this.newCall > 1) {
                        this.mediator.toasterManager.showToaster(this.mediator.toasterManager, this.languageCentre.getValue(LanguageConstant.MarginCall), this.newCall + " New Margin Call", LanguageConstant.MarginCall);
                    } else if (this.mediator.toasterManager != null && this.newCall == 1) {
                        this.mediator.toasterManager.showToaster(this.mediator.toasterManager, this.languageCentre.getValue(LanguageConstant.MarginCall), "New Margin Call for Account " + lastAccount, LanguageConstant.MarginCall);
                    }
                }
                if (LogCommon.VoiceAlert_MarginCall && this.newCall > 1) {
                    Voice.getInstance().Speak(this.newCall + " New Margin Call");
                } else if (LogCommon.VoiceAlert_MarginCall && this.newCall == 1) {
                    Voice.getInstance().Speak("New Margin Call for account " + Util.MakeSingleCharacterVoice((String)lastAccount));
                }
                if (this.mediator.msgwin != null && this.newCall > 0) {
                    this.mediator.msgwin.blinkMarginCallTab();
                }
            }
        }
        this.isFirst = false;
        this.lblCount.setText(Util.format0digit((String)(this.rows.size() + "")) + " Record(s)  ");
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.table.addNotify();
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MarginCallTab.this.table.addNotify();
                    MarginCallTab.this.table.repaint();
                }
            });
        }
    }

    public MarginCallBean parse(String[] columnVal) throws ArrayIndexOutOfBoundsException {
        MarginCallBean margin = new MarginCallBean();
        margin.account = columnVal[0];
        margin.name = columnVal[1];
        margin.call = columnVal[2];
        margin.shortfall = Util.format2digit((String)columnVal[3]);
        margin.shortfallPer = Util.format2digit((String)columnVal[4]);
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
            Date date = df.parse(columnVal[5]);
            margin.dateTime = LogsKSE.sdfMessage.format(date);
        }
        catch (ParseException ex) {
            margin.dateTime = columnVal[5];
            ex.printStackTrace();
        }
        if (margin.call.equalsIgnoreCase("FIRST_MARGIN_CALL")) {
            margin.call = "First Margin Call";
        } else if (margin.call.equalsIgnoreCase("SECOND_MARGIN_CALL")) {
            margin.call = "Second Margin Call";
        } else if (margin.call.equalsIgnoreCase("THIRD_MARGIN_CALL")) {
            margin.call = "Final Margin Call";
        }
        margin.isRead = readUnReadMap.containsKey(margin.account + "|=|" + margin.call) ? readUnReadMap.get(margin.account + "|=|" + margin.call).booleanValue() : false;
        return margin;
    }

    public synchronized Timer Blink(final String idNO, boolean isStart) {
        final Timer BlinkTimmer = new Timer(0, null){

            @Override
            public void stop() {
                int rowNo = MarginCallTab.this.getRowNo(idNO);
                if (rowNo >= 0) {
                    MessageDisplay md = MarginCallTab.this.rows.get(rowNo);
                    md.setMarginCallText(true);
                    MarginCallTab.this.tableDataChange();
                    super.stop();
                }
            }
        };
        ActionListener ac = new ActionListener(){
            int i = 0;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.i >= AppConfig.BlinkInterval) {
                    int rowNo = MarginCallTab.this.getRowNo(idNO);
                    if (rowNo >= 0) {
                        MessageDisplay md = MarginCallTab.this.rows.get(rowNo);
                        md.setMarginCallText(true);
                        BlinkTimmer.stop();
                        MarginCallTab.this.tableDataChange();
                    }
                } else {
                    int rowNo = MarginCallTab.this.getRowNo(idNO);
                    if (rowNo >= 0) {
                        MessageDisplay md = MarginCallTab.this.rows.get(rowNo);
                        if (this.i % 2 == 0) {
                            md.setMarginCallText(false);
                        } else {
                            md.setMarginCallText(true);
                        }
                        MarginCallTab.this.tableDataChange();
                        ++this.i;
                    }
                }
            }
        };
        BlinkTimmer.addActionListener(ac);
        BlinkTimmer.setDelay(500);
        BlinkTimmer.setRepeats(true);
        if (isStart) {
            BlinkTimmer.start();
        }
        return BlinkTimmer;
    }

    public void stopBlink(int rowNo) {
        MarginCallBean mm = this.rows.get((int)rowNo).margin;
        if (this.timerMap.containsKey(mm.account)) {
            this.timerMap.get(mm.account).stop();
        }
        this.rows.get(rowNo).setMarginCallText(false);
    }

    public int getRowNo(String msgID) {
        int rowNo = -1;
        for (int i = 0; i < this.rows.size(); ++i) {
            MarginCallBean object = this.rows.elementAt((int)i).margin;
            if (!object.account.equalsIgnoreCase(msgID)) continue;
            return i;
        }
        return rowNo;
    }

    public void getAllMessages() {
        if (AppConfig.loginMode == LoginMode.KSE || AppConfig.loginMode == LoginMode.KSEPMEX) {
            new Thread((Runnable)this.getMessages, "Margin Call getAllMessages").start();
        }
    }

    public void messageAckReceived(String acc) {
        if (this.lastCallAcc.equalsIgnoreCase(acc)) {
            return;
        }
        this.lastCallAcc = acc;
        this.getAllMessages();
    }

    private void initComponents() {
        this.sortMenu = new JPopupMenu();
        this.menuDate = new JCheckBoxMenuItem();
        this.menuCall = new JCheckBoxMenuItem();
        this.menuName = new JCheckBoxMenuItem();
        this.menuAccount = new JCheckBoxMenuItem();
        this.buttonGroup1 = new ButtonGroup();
        this.toolBar = new JToolBar();
        this.btnSearch = new JButton();
        this.jSeparator7 = new JToolBar.Separator();
        this.btnAsen = new JButton();
        this.jSeparator8 = new JToolBar.Separator();
        this.btnDecn = new JButton();
        this.jSeparator9 = new JToolBar.Separator();
        this.jPanel3 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.collapsiblePane = new JXCollapsiblePane();
        this.buttonGroup1.add(this.menuDate);
        this.menuDate.setSelected(true);
        this.menuDate.setText("Date");
        this.menuDate.setIcon(new ImageIcon(this.getClass().getResource("/Images/date16.png")));
        this.menuDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MarginCallTab.this.menuDateActionPerformed(evt);
            }
        });
        this.sortMenu.add(this.menuDate);
        this.buttonGroup1.add(this.menuCall);
        this.menuCall.setText("Call");
        this.menuCall.setIcon(new ImageIcon(this.getClass().getResource("/Images/subject16.png")));
        this.menuCall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MarginCallTab.this.menuCallActionPerformed(evt);
            }
        });
        this.sortMenu.add(this.menuCall);
        this.buttonGroup1.add(this.menuName);
        this.menuName.setText("Name");
        this.menuName.setIcon(new ImageIcon(this.getClass().getResource("/Images/description16.png")));
        this.menuName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MarginCallTab.this.menuNameActionPerformed(evt);
            }
        });
        this.sortMenu.add(this.menuName);
        this.buttonGroup1.add(this.menuAccount);
        this.menuAccount.setText("Account");
        this.menuAccount.setIcon(new ImageIcon(this.getClass().getResource("/Images/description16.png")));
        this.menuAccount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MarginCallTab.this.menuAccountActionPerformed(evt);
            }
        });
        this.sortMenu.add(this.menuAccount);
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.toolBar.setMaximumSize(new Dimension(116, 21));
        this.toolBar.setMinimumSize(new Dimension(116, 21));
        this.toolBar.setPreferredSize(new Dimension(100, 18));
        this.btnSearch.setIcon(new ImageIcon(this.getClass().getResource("/Images/search12.png")));
        this.btnSearch.setText("Search");
        this.btnSearch.setToolTipText("Search");
        this.btnSearch.setFocusable(false);
        this.btnSearch.setHorizontalTextPosition(4);
        this.btnSearch.setMaximumSize(new Dimension(61, 21));
        this.btnSearch.setMinimumSize(new Dimension(61, 21));
        this.btnSearch.setPreferredSize(new Dimension(61, 21));
        this.btnSearch.setVerticalTextPosition(3);
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MarginCallTab.this.btnSearchActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnSearch);
        this.toolBar.add(this.jSeparator7);
        this.btnAsen.setIcon(new ImageIcon(this.getClass().getResource("/Images/ascending12.png")));
        this.btnAsen.setToolTipText("Sort Ascending");
        this.btnAsen.setFocusable(false);
        this.btnAsen.setHorizontalTextPosition(0);
        this.btnAsen.setMaximumSize(new Dimension(35, 18));
        this.btnAsen.setMinimumSize(new Dimension(35, 18));
        this.btnAsen.setPreferredSize(new Dimension(38, 18));
        this.btnAsen.setVerticalTextPosition(3);
        this.btnAsen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MarginCallTab.this.btnAsenActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnAsen);
        this.toolBar.add(this.jSeparator8);
        this.btnDecn.setIcon(new ImageIcon(this.getClass().getResource("/Images/descending12.png")));
        this.btnDecn.setToolTipText("Sort Desecnding");
        this.btnDecn.setFocusable(false);
        this.btnDecn.setHorizontalTextPosition(0);
        this.btnDecn.setMaximumSize(new Dimension(35, 18));
        this.btnDecn.setMinimumSize(new Dimension(35, 18));
        this.btnDecn.setPreferredSize(new Dimension(35, 18));
        this.btnDecn.setVerticalTextPosition(3);
        this.btnDecn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MarginCallTab.this.btnDecnActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnDecn);
        this.toolBar.add(this.jSeparator9);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 213, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 16, Short.MAX_VALUE));
        this.toolBar.add(this.jPanel3);
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MarginCallTab.this.tableMousePressed(evt);
            }
        });
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                MarginCallTab.this.tableMouseMoved(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.table);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.collapsiblePane, GroupLayout.Alignment.TRAILING, -1, 373, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 373, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toolBar, -1, 373, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addComponent((Component)this.collapsiblePane, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jScrollPane1, -1, 78, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.toolBar, -2, -1, -2).addGap(0, 0, 0))));
    }

    private void btnSearchActionPerformed(ActionEvent evt) {
        this.collapsiblePane.removeAll();
        this.collapsiblePane.add((Component)new SearchPanelMarginCall(this));
        boolean state = this.collapsiblePane.isCollapsed();
        this.collapsiblePane.setCollapsed(!state);
    }

    private void btnAsenActionPerformed(ActionEvent evt) {
        if (this.menuDate.isSelected()) {
            this.callSort(0, true);
        } else if (this.menuCall.isSelected()) {
            this.callSort(1, true);
        } else if (this.menuName.isSelected()) {
            this.callSort(2, true);
        } else if (this.menuAccount.isSelected()) {
            this.callSort(3, true);
        }
    }

    private void btnDecnActionPerformed(ActionEvent evt) {
        if (this.menuDate.isSelected()) {
            this.callSort(0, false);
        } else if (this.menuCall.isSelected()) {
            this.callSort(1, false);
        } else if (this.menuName.isSelected()) {
            this.callSort(2, false);
        } else if (this.menuAccount.isSelected()) {
            this.callSort(3, false);
        }
    }

    private void menuDateActionPerformed(ActionEvent evt) {
        this.callSort(0, this.isAsec);
    }

    private void menuCallActionPerformed(ActionEvent evt) {
        this.callSort(1, this.isAsec);
    }

    private void menuNameActionPerformed(ActionEvent evt) {
        this.callSort(2, this.isAsec);
    }

    private void menuAccountActionPerformed(ActionEvent evt) {
        this.callSort(3, this.isAsec);
    }

    private void tableMouseMoved(MouseEvent evt) {
        try {
            int rowindex = this.table.rowAtPoint(evt.getPoint());
            this.table.editCellAt(rowindex, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void tableMousePressed(MouseEvent evt) {
        this.stopBlink(this.table.getSelectedRow());
    }

    public void callSort(int index, boolean ascSec) {
        Collections.sort(this.rows, new MarginCallComparator(index, ascSec));
        this.table.tableChanged(new TableModelEvent(this.model));
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
        this.tableDataChange();
    }

    class MarginCallComparator
    implements Comparator {
        protected int m_sortCol;
        protected boolean m_sortAsc;
        private HashMap<String, String> ht = null;

        public MarginCallComparator(int sortCol, boolean sortAsc) {
            this.m_sortCol = sortCol;
            this.m_sortAsc = sortAsc;
            this.ht = new HashMap();
            this.ht.put("First Margin Call", "a");
            this.ht.put("Second Margin Call", "b");
            this.ht.put("Final Margin Call", "c");
        }

        public int compare(Object o1, Object o2) {
            int result = 0;
            try {
                MessageDisplay s1 = null;
                MessageDisplay s2 = null;
                if (o1 instanceof MessageDisplay && o2 instanceof MessageDisplay) {
                    s1 = (MessageDisplay)o1;
                    s2 = (MessageDisplay)o2;
                }
                switch (this.m_sortCol) {
                    case 0: {
                        Date d1 = LogsKSE.sdfMessage.parse(s1.margin.dateTime);
                        Date d2 = LogsKSE.sdfMessage.parse(s2.margin.dateTime);
                        result = d1.compareTo(d2);
                        break;
                    }
                    case 1: {
                        result = this.ht.get(s1.margin.call).compareTo(this.ht.get(s2.margin.call));
                        break;
                    }
                    case 2: {
                        result = s1.margin.name.compareTo(s2.margin.name);
                        break;
                    }
                    case 3: {
                        result = s1.margin.account.compareTo(s2.margin.account);
                    }
                }
                if (!this.m_sortAsc) {
                    result = -result;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return result;
        }
    }
}

