/*
 * Decompiled with CFR 0.152.
 */
package MessageWindow;

import CustomComponent.DnDTabbedPane;
import CustomComponent.MyOptionPane;
import CustomComponent.MyTime;
import MessageWindow.AnnouncementLiveTab;
import MessageWindow.AnnouncementTab;
import MessageWindow.BoardMeetingTab;
import MessageWindow.MarginCallTab;
import MessageWindow.MyTab;
import MessageWindow.PMEX_MyTab;
import MessageWindow.PriceAlertTab;
import MessageWindow.RSSTab;
import MyDocking.Mediator;
import MyDocking.MessageWindowCenter;
import MyDocking.TradeCast;
import RendersNModels.MsgColoredTableCellRenderer;
import RendersNModels.MsgDataModel;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.ImageUtil;
import common.gui.util.LogCommon;
import common.gui.util.LoginMode;
import common.gui.util.MessageType;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableColumn;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class MsgWin
extends JPanel {
    public static final String BoardMeetingTag = "BOARD_MEETING";
    protected JTable m_table;
    public MsgDataModel m_data;
    private JPanel topPanel;
    private JScrollPane scrollPane;
    protected JTable Ord_table;
    protected MsgDataModel Ord_data;
    private JPanel OrdtopPanel;
    private JScrollPane OrdscrollPane;
    private JPopupMenu popupMenuActivty;
    protected JTable Exc_table;
    protected MsgDataModel Exc_data;
    Mediator mediator = Mediator.getInstance();
    MessageWindowCenter msgCenter = MessageWindowCenter.getInstance();
    private JCheckBoxMenuItem checkBoxMenuShowCapAlert;
    private JCheckBoxMenuItem checkBoxMenuShowSpotAlert;
    private JCheckBoxMenuItem AlertsMenu;
    private JMenuItem fontMenu;
    private JMenuItem saveFileMenu;
    private static boolean isHelpShow = false;
    MyTab newsTab = null;
    PMEX_MyTab newsTabPMEX = null;
    MyTab houseTab = null;
    AnnouncementTab announcementTab = null;
    AnnouncementLiveTab announcementLiveTab = null;
    RSSTab rssTab = null;
    BoardMeetingTab boardMeetingTab = null;
    public PriceAlertTab priceAlertTab = null;
    MarginCallTab marginCallTab = null;
    JTabbedPane tabbedPane = new DnDTabbedPane();
    Hashtable<Integer, String> TabInfo = new Hashtable();
    int MessageCount = 0;
    final ImageIcon RSSIcon = new ImageIcon(this.getClass().getResource("/Images/RSS.png"));
    final ImageIcon AnnouncementIcon = new ImageIcon(this.getClass().getResource("/Images/Annoucements16x16.png"));
    final ImageIcon AnnouncementLiveIcon = new ImageIcon(this.getClass().getResource("/Images/annoucementsLive.png"));
    ImageIcon allMsgIcon = new ImageIcon(this.getClass().getResource("/Images/AllMessages2.png"));
    ImageIcon pricaAlertIcon = new ImageIcon(this.getClass().getResource("/Images/PriceAlert12.png"));
    ImageIcon newsIcon = new ImageIcon(this.getClass().getResource("/Images/News16.png"));
    final ImageIcon news16Icon = new ImageIcon(this.getClass().getResource("/Images/News16.png"));
    ImageIcon exchangeIcon = new ImageIcon(this.getClass().getResource("/Images/Exchange12.png"));
    ImageIcon orderIcon = new ImageIcon(this.getClass().getResource("/Images/Order12x12.png"));
    final ImageIcon Order16x16 = new ImageIcon(this.getClass().getResource("/Images/Order16x16.png"));
    final ImageIcon boardMeetingIcon = new ImageIcon(this.getClass().getResource("/Images/Meeting16x16.png"));
    ImageIcon marginIcon = new ImageIcon(this.getClass().getResource("/Images/MarginCall16x16.png"));
    final ImageIcon PriceAlertIcon = new ImageIcon(this.getClass().getResource("/Images/PriceAlert16x16.png"));
    ImageIcon houseIcon = null;
    HashMap<String, Timer> timmerMap = new HashMap();
    MsgColoredTableCellRenderer render = new MsgColoredTableCellRenderer();
    MsgColoredTableCellRenderer renderOrder = new MsgColoredTableCellRenderer();
    JFileChooser chooser = new JFileChooser();
    private LanguageCentre languageCentre = new LanguageCentre();
    int count = 0;

    public MsgWin() {
        this.mediator.setMsgWin(this);
        this.msgCenter.setMsgWin(this);
        this.setObject();
        this.init("");
        this.chooser.setAcceptAllFileFilterUsed(false);
        this.chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".txt") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Text File(*.txt)";
            }
        });
    }

    public void init(String HouseName_) {
        TableColumn column;
        int k;
        this.tabbedPane.setOpaque(true);
        this.popupMenuActivty = new JPopupMenu();
        this.checkBoxMenuShowCapAlert = new JCheckBoxMenuItem();
        this.checkBoxMenuShowCapAlert.setText("Show Cap Alerts   ");
        this.checkBoxMenuShowCapAlert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogCommon.isShowCapMessageAlert = MsgWin.this.checkBoxMenuShowCapAlert.isSelected();
            }
        });
        this.checkBoxMenuShowSpotAlert = new JCheckBoxMenuItem();
        this.checkBoxMenuShowSpotAlert.setText("Show Spot Alerts   ");
        this.checkBoxMenuShowSpotAlert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogCommon.isShowSpotMessageAlert = MsgWin.this.checkBoxMenuShowSpotAlert.isSelected();
            }
        });
        this.AlertsMenu = new JCheckBoxMenuItem(this.languageCentre.getValue("Alerts"));
        this.fontMenu = new JMenuItem("Font Setting          ");
        this.fontMenu.setIcon(new ImageIcon(this.getClass().getResource("/Images/font.png")));
        this.fontMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TradeCast.getInstance().ShowDynamicForm(FormName.Prefernces, LanguageConstant.Fonts);
                if (MsgWin.this.mediator.prefrences != null) {
                    MsgWin.this.mediator.prefrences.selectFontTab("Others");
                }
            }
        });
        this.saveFileMenu = new JMenuItem("Save Messages");
        this.saveFileMenu.setIcon(new ImageIcon(this.getClass().getResource("/Images/save.png")));
        this.saveFileMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                block12: {
                    File f = new File(System.getProperty("user.home") + "/" + MsgWin.this.tabbedPane.getTitleAt(MsgWin.this.tabbedPane.getSelectedIndex()) + "-" + MyTime.getInstance().getDate());
                    MsgWin.this.chooser.setSelectedFile(f);
                    int returnVal = MsgWin.this.chooser.showSaveDialog(TradeCast.getInstance().frame);
                    if (returnVal == 0) {
                        File file = MsgWin.this.chooser.getSelectedFile();
                        String fileName = file.getName();
                        if (fileName.indexOf(".txt") < 0) {
                            fileName = fileName + ".txt";
                        }
                        String parent = file.getParent();
                        String path = parent + Util.FileSeparator + fileName;
                        String tabName = MsgWin.this.tabbedPane.getTitleAt(MsgWin.this.tabbedPane.getSelectedIndex());
                        if (tabName.equalsIgnoreCase(MsgWin.this.languageCentre.getValue(LanguageConstant.Activity))) {
                            try {
                                if (Util.WriteTableIntoFile((JTable)MsgWin.this.m_table, (String)path)) {
                                    MyOptionPane.showMessage(MessageType.Sussess, MsgWin.this.languageCentre.getValue(LanguageConstant.Activity) + " messages saved successfully", true);
                                    break block12;
                                }
                                MyOptionPane.showMessage(MessageType.Error, "Error in saving file", false);
                            }
                            catch (IOException ex) {
                                MyOptionPane.showMessage(MessageType.Error, "Error in saving file", false);
                                MsgWin.this.mediator.PrintLog(ex, "");
                            }
                        } else if (tabName.equalsIgnoreCase(MsgWin.this.languageCentre.getValue(LanguageConstant.Orders))) {
                            try {
                                if (Util.WriteTableIntoFile((JTable)MsgWin.this.Ord_table, (String)path)) {
                                    MyOptionPane.showMessage(MessageType.Sussess, MsgWin.this.languageCentre.getValue(LanguageConstant.Orders) + " messages saved successfully", false);
                                } else {
                                    MyOptionPane.showMessage(MessageType.Error, "Error in saving file", false);
                                }
                            }
                            catch (Exception ex) {
                                MyOptionPane.showMessage(MessageType.Error, "Error in saving file", false);
                                MsgWin.this.mediator.PrintLog(ex, "");
                            }
                        }
                    }
                }
            }
        });
        if (AppConfig.loginMode != LoginMode.PMEX) {
            this.popupMenuActivty.add(this.checkBoxMenuShowCapAlert);
            this.popupMenuActivty.add(this.checkBoxMenuShowSpotAlert);
            this.popupMenuActivty.addSeparator();
            this.popupMenuActivty.add(this.fontMenu);
            this.popupMenuActivty.addSeparator();
            this.popupMenuActivty.add(this.saveFileMenu);
        } else {
            this.popupMenuActivty.add(this.fontMenu);
            this.popupMenuActivty.addSeparator();
            this.popupMenuActivty.add(this.saveFileMenu);
        }
        this.m_data = new MsgDataModel();
        this.m_table = new JTable();
        this.m_table.setTableHeader(null);
        this.m_table.setAutoCreateColumnsFromModel(false);
        this.m_table.setModel(this.m_data);
        this.m_table.setSelectionMode(0);
        for (k = 0; k < MsgDataModel.m_columns.length; ++k) {
            this.render.setHorizontalAlignment(2);
            column = new TableColumn(k, 200, this.render, null);
            this.m_table.addColumn(column);
        }
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane();
        this.scrollPane.getViewport().add(this.m_table);
        this.topPanel.add((Component)this.scrollPane, "Center");
        this.AddNewMessage("<>" + MyTime.getInstance().getTime() + " - Please wait while connecting to Trade Server...", Util.convertToColor((String)"#ffff00", (Color)Color.black), Util.convertToColor((String)"#015199", (Color)Color.black));
        this.Exc_data = new MsgDataModel();
        this.Exc_table = new JTable();
        this.Exc_table.setTableHeader(null);
        this.Exc_table.setAutoCreateColumnsFromModel(false);
        this.Exc_table.setModel(this.Exc_data);
        this.Exc_table.setSelectionMode(0);
        for (k = 0; k < MsgDataModel.m_columns.length; ++k) {
            MsgColoredTableCellRenderer renderExec = new MsgColoredTableCellRenderer();
            renderExec.setHorizontalAlignment(2);
            TableColumn column2 = new TableColumn(k, 200, renderExec, null);
            this.Exc_table.addColumn(column2);
        }
        this.Ord_data = new MsgDataModel();
        this.Ord_table = new JTable();
        this.Ord_table.setTableHeader(null);
        this.Ord_table.setAutoCreateColumnsFromModel(false);
        this.Ord_table.setModel(this.Ord_data);
        this.Ord_table.setSelectionMode(0);
        for (k = 0; k < MsgDataModel.m_columns.length; ++k) {
            this.renderOrder.setHorizontalAlignment(2);
            column = new TableColumn(k, 200, this.renderOrder, null);
            this.Ord_table.addColumn(column);
        }
        this.OrdtopPanel = new JPanel();
        this.OrdtopPanel.setLayout(new BorderLayout());
        this.OrdscrollPane = new JScrollPane();
        this.OrdscrollPane.getViewport().add(this.Ord_table);
        this.OrdtopPanel.add((Component)this.OrdscrollPane, "Center");
        this.m_table.setFont(LogCommon.MessageWindowFont);
        this.Ord_table.setFont(LogCommon.MessageWindowFont);
        this.Exc_table.setFont(LogCommon.MessageWindowFont);
        FontMetrics metrics = this.getFontMetrics(LogCommon.MessageWindowFont);
        int fontHeight = metrics.getHeight();
        this.m_table.setRowHeight(fontHeight);
        this.Ord_table.setRowHeight(fontHeight);
        this.Exc_table.setRowHeight(fontHeight);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPane, -1, 20, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPane, -1, 20, Short.MAX_VALUE));
        Toolkit tk = new JFrame().getToolkit();
        Dimension d = tk.getScreenSize();
        this.tabbedPane.setPreferredSize(new Dimension(d.width - 30, 180));
        this.m_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MsgWin.this.showPopupMenu(e, MsgWin.this.m_table);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MsgWin.this.render.setRowNo(-1);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                if (!isHelpShow) {
                    TradeCast.getInstance().setTrayMessage("Message Window: ", "Right click Messages to view Spot & Cap messages.", TrayIcon.MessageType.INFO);
                    isHelpShow = true;
                }
            }
        });
        this.m_table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                int row = MsgWin.this.m_table.rowAtPoint(evt.getPoint());
                if (row != MsgWin.this.render.getRowNo()) {
                    MsgWin.this.render.setRowNo(row);
                    MsgWin.this.repaint();
                }
            }
        });
        this.Exc_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MsgWin.this.showPopupMenu(e, MsgWin.this.Exc_table);
            }
        });
        this.Ord_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MsgWin.this.showPopupMenu(e, MsgWin.this.Ord_table);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MsgWin.this.renderOrder.setRowNo(-1);
            }
        });
        this.Ord_table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                int row = MsgWin.this.Ord_table.rowAtPoint(evt.getPoint());
                if (row != MsgWin.this.renderOrder.getRowNo()) {
                    MsgWin.this.renderOrder.setRowNo(row);
                    MsgWin.this.repaint();
                }
            }
        });
        this.scrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MsgWin.this.showPopupMenu(e, MsgWin.this.scrollPane);
            }
        });
        this.OrdscrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MsgWin.this.showPopupMenu(e, MsgWin.this.OrdscrollPane);
            }
        });
        this.setMinimumSize(new Dimension(20, 20));
        this.Exc_table.setMinimumSize(new Dimension(20, 20));
        this.Ord_table.setMinimumSize(new Dimension(20, 20));
        this.OrdscrollPane.setMinimumSize(new Dimension(20, 20));
        this.OrdtopPanel.setMinimumSize(new Dimension(20, 20));
        this.m_table.setMinimumSize(new Dimension(20, 20));
        this.scrollPane.setMinimumSize(new Dimension(20, 20));
        this.topPanel.setMinimumSize(new Dimension(20, 20));
        this.tabbedPane.setMinimumSize(new Dimension(20, 20));
        try {
            if (AppConfig.houseIcon == null) {
                AppConfig.houseIcon = ImageUtil.downloadImage((String)(AppConfig.TradeCastURL + "/HouseImages/small.png"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (AppConfig.houseIcon != null) {
            this.houseIcon = new ImageIcon(AppConfig.houseIcon);
        }
        this.tabbedPane.addChangeListener(new ChangeListener(){
            int lastSelectedIndex = -1;

            @Override
            public void stateChanged(ChangeEvent e) {
                int sIdx;
                int i;
                if (MsgWin.this.tabbedPane.getSelectedIndex() == -1) {
                    return;
                }
                String tabName = MsgWin.this.tabbedPane.getTitleAt(MsgWin.this.tabbedPane.getSelectedIndex());
                if (tabName.equalsIgnoreCase(MsgWin.this.languageCentre.getValue(LanguageConstant.Announcement))) {
                    if (MsgWin.this.timmerMap.containsKey(LanguageConstant.Announcement)) {
                        MsgWin.this.timmerMap.get(LanguageConstant.Announcement).stop();
                    }
                } else if (tabName.equalsIgnoreCase(MsgWin.this.languageCentre.getValue(LanguageConstant.AnnouncementLive))) {
                    if (MsgWin.this.timmerMap.containsKey(LanguageConstant.AnnouncementLive)) {
                        MsgWin.this.timmerMap.get(LanguageConstant.AnnouncementLive).stop();
                    }
                } else if (tabName.equalsIgnoreCase(MsgWin.this.languageCentre.getValue(LanguageConstant.News))) {
                    if (MsgWin.this.timmerMap.containsKey(LanguageConstant.News)) {
                        MsgWin.this.timmerMap.get(LanguageConstant.News).stop();
                    }
                } else if (tabName.equalsIgnoreCase("Commodity News")) {
                    if (MsgWin.this.timmerMap.containsKey("Commodity News")) {
                        MsgWin.this.timmerMap.get("Commodity News").stop();
                    }
                } else if (tabName.equalsIgnoreCase(AppConfig.houseName)) {
                    if (MsgWin.this.timmerMap.containsKey("HOUSE_MESSAGE")) {
                        MsgWin.this.timmerMap.get("HOUSE_MESSAGE").stop();
                    }
                } else if (tabName.equalsIgnoreCase(MsgWin.this.languageCentre.getValue(LanguageConstant.BoardMeeting))) {
                    if (MsgWin.this.timmerMap.containsKey(LanguageConstant.BoardMeeting)) {
                        MsgWin.this.timmerMap.get(LanguageConstant.BoardMeeting).stop();
                    }
                } else if (tabName.equalsIgnoreCase(MsgWin.this.languageCentre.getValue("Alerts"))) {
                    if (MsgWin.this.timmerMap.containsKey("Alerts")) {
                        MsgWin.this.timmerMap.get("Alerts").stop();
                    }
                } else if (tabName.equalsIgnoreCase(MsgWin.this.languageCentre.getValue(LanguageConstant.MarginCall)) && MsgWin.this.timmerMap.containsKey(LanguageConstant.MarginCall)) {
                    MsgWin.this.timmerMap.get(LanguageConstant.MarginCall).stop();
                }
                if (MsgWin.this.tabbedPane.getTitleAt(i = MsgWin.this.tabbedPane.getSelectedIndex()).equalsIgnoreCase(LanguageConstant.RSS) && MsgWin.this.rssTab != null) {
                    MsgWin.this.rssTab.TabChange();
                }
                int lastSelectedIndex = MsgWin.this.tabbedPane.getSelectedIndex();
                JTabbedPane tab = (JTabbedPane)e.getSource();
                if (lastSelectedIndex != -1) {
                    tab.setForegroundAt(lastSelectedIndex, tab.getForeground());
                    tab.setBackgroundAt(lastSelectedIndex, tab.getBackground());
                }
                lastSelectedIndex = sIdx = tab.getSelectedIndex();
            }
        });
        this.AddAllTab();
        this.ShowAllTab();
        for (int t = 0; t < this.tabbedPane.getTabCount(); ++t) {
            String TabName = this.tabbedPane.getTitleAt(t);
            if (this.TabInfo.contains(TabName)) continue;
            this.TabInfo.put(t, TabName);
        }
        final JPopupMenu tabMenu = new JPopupMenu();
        JCheckBoxMenuItem ActivitMenu = new JCheckBoxMenuItem(this.languageCentre.getValue(LanguageConstant.Activity));
        if (!Util.isWindow7()) {
            ActivitMenu.setIcon(new ImageIcon(this.getClass().getResource("/Images/AllMessages2.png")));
        }
        ActivitMenu.setSelected(true);
        ActivitMenu.setEnabled(false);
        final JCheckBoxMenuItem OrderMenu = new JCheckBoxMenuItem(this.languageCentre.getValue(LanguageConstant.Orders));
        if (!Util.isWindow7()) {
            OrderMenu.setIcon(this.Order16x16);
        }
        OrderMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MsgWin.this.ShowHideTab(OrderMenu, MsgWin.this.languageCentre.getValue(LanguageConstant.Orders), MsgWin.this.OrdtopPanel, MsgWin.this.Order16x16);
            }
        });
        final JCheckBoxMenuItem AnnouncementsMenu = new JCheckBoxMenuItem(this.languageCentre.getValue(LanguageConstant.Announcement));
        if (!Util.isWindow7()) {
            AnnouncementsMenu.setIcon(this.AnnouncementIcon);
        }
        AnnouncementsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MsgWin.this.ShowHideTab(AnnouncementsMenu, MsgWin.this.languageCentre.getValue(LanguageConstant.Announcement), MsgWin.this.announcementTab, MsgWin.this.AnnouncementIcon);
            }
        });
        final JCheckBoxMenuItem AnnouncementsLiveMenu = new JCheckBoxMenuItem(this.languageCentre.getValue(LanguageConstant.AnnouncementLive));
        if (!Util.isWindow7()) {
            AnnouncementsLiveMenu.setIcon(this.AnnouncementLiveIcon);
        }
        AnnouncementsLiveMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MsgWin.this.ShowHideTab(AnnouncementsLiveMenu, MsgWin.this.languageCentre.getValue(LanguageConstant.AnnouncementLive), MsgWin.this.announcementLiveTab, MsgWin.this.AnnouncementLiveIcon);
            }
        });
        final JCheckBoxMenuItem NewsMenu = new JCheckBoxMenuItem(this.languageCentre.getValue(LanguageConstant.News));
        if (!Util.isWindow7()) {
            NewsMenu.setIcon(this.news16Icon);
        }
        NewsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MsgWin.this.ShowHideTab(NewsMenu, MsgWin.this.languageCentre.getValue(LanguageConstant.News), MsgWin.this.newsTab, MsgWin.this.news16Icon);
            }
        });
        final JCheckBoxMenuItem NewsPMEXMenu = new JCheckBoxMenuItem("Commodity News");
        if (!Util.isWindow7()) {
            NewsPMEXMenu.setIcon(this.news16Icon);
        }
        NewsPMEXMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MsgWin.this.ShowHideTab(NewsPMEXMenu, "Commodity News", MsgWin.this.newsTabPMEX, MsgWin.this.news16Icon);
            }
        });
        JCheckBoxMenuItem houseNameMenu = new JCheckBoxMenuItem(AppConfig.houseName);
        if (!Util.isWindow7()) {
            houseNameMenu.setIcon(this.houseIcon);
        }
        houseNameMenu.setSelected(true);
        houseNameMenu.setEnabled(false);
        final JCheckBoxMenuItem BoradMeetingMenu = new JCheckBoxMenuItem(this.languageCentre.getValue(LanguageConstant.BoardMeeting));
        if (!Util.isWindow7()) {
            BoradMeetingMenu.setIcon(this.boardMeetingIcon);
        }
        BoradMeetingMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MsgWin.this.ShowHideTab(BoradMeetingMenu, MsgWin.this.languageCentre.getValue(LanguageConstant.BoardMeeting), MsgWin.this.boardMeetingTab, MsgWin.this.boardMeetingIcon);
            }
        });
        if (!Util.isWindow7()) {
            this.AlertsMenu.setIcon(this.PriceAlertIcon);
        }
        this.AlertsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MsgWin.this.ShowHideTab(MsgWin.this.AlertsMenu, MsgWin.this.languageCentre.getValue("Alerts"), MsgWin.this.priceAlertTab, MsgWin.this.PriceAlertIcon);
            }
        });
        JCheckBoxMenuItem MarginCallsMenu = new JCheckBoxMenuItem(this.languageCentre.getValue(LanguageConstant.MarginCall));
        if (!Util.isWindow7()) {
            MarginCallsMenu.setIcon(this.marginIcon);
        }
        MarginCallsMenu.setSelected(true);
        MarginCallsMenu.setEnabled(false);
        final JCheckBoxMenuItem RSSMenu = new JCheckBoxMenuItem(LanguageConstant.RSS);
        if (!Util.isWindow7()) {
            RSSMenu.setIcon(this.RSSIcon);
        }
        RSSMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MsgWin.this.ShowHideTab(RSSMenu, LanguageConstant.RSS, MsgWin.this.rssTab, MsgWin.this.RSSIcon);
            }
        });
        JMenuItem showAll = new JMenuItem("Show All");
        showAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MsgWin.this.tabbedPane.removeAll();
                MsgWin.this.ShowAllTab();
                for (int i = 0; i < MsgWin.this.tabbedPane.getTabCount(); ++i) {
                    if (MsgWin.this.tabbedPane.getTitleAt(i).equalsIgnoreCase(MsgWin.this.languageCentre.getValue(LanguageConstant.Orders))) {
                        OrderMenu.setSelected(true);
                        continue;
                    }
                    if (MsgWin.this.tabbedPane.getTitleAt(i).equalsIgnoreCase(MsgWin.this.languageCentre.getValue(LanguageConstant.Announcement))) {
                        AnnouncementsMenu.setSelected(true);
                        continue;
                    }
                    if (MsgWin.this.tabbedPane.getTitleAt(i).equalsIgnoreCase(MsgWin.this.languageCentre.getValue(LanguageConstant.AnnouncementLive))) {
                        AnnouncementsLiveMenu.setSelected(true);
                        continue;
                    }
                    if (MsgWin.this.tabbedPane.getTitleAt(i).equalsIgnoreCase(MsgWin.this.languageCentre.getValue(LanguageConstant.News))) {
                        NewsMenu.setSelected(true);
                        continue;
                    }
                    if (MsgWin.this.tabbedPane.getTitleAt(i).equalsIgnoreCase(MsgWin.this.languageCentre.getValue(LanguageConstant.BoardMeeting))) {
                        BoradMeetingMenu.setSelected(true);
                        continue;
                    }
                    if (MsgWin.this.tabbedPane.getTitleAt(i).equalsIgnoreCase(MsgWin.this.languageCentre.getValue("Alerts"))) {
                        MsgWin.this.AlertsMenu.setSelected(true);
                        continue;
                    }
                    if (!MsgWin.this.tabbedPane.getTitleAt(i).equalsIgnoreCase(LanguageConstant.RSS)) continue;
                    RSSMenu.setSelected(true);
                }
            }
        });
        if (AppConfig.loginMode == LoginMode.KSE) {
            tabMenu.add(ActivitMenu);
            tabMenu.add(OrderMenu);
            tabMenu.add(AnnouncementsMenu);
            tabMenu.add(AnnouncementsLiveMenu);
            tabMenu.add(NewsMenu);
            tabMenu.add(houseNameMenu);
            tabMenu.add(BoradMeetingMenu);
            tabMenu.add(this.AlertsMenu);
            tabMenu.add(MarginCallsMenu);
            tabMenu.add(RSSMenu);
            tabMenu.add(new JSeparator());
            tabMenu.add(showAll);
        } else if (AppConfig.loginMode == LoginMode.KSEPMEX) {
            tabMenu.add(ActivitMenu);
            tabMenu.add(OrderMenu);
            tabMenu.add(AnnouncementsMenu);
            tabMenu.add(AnnouncementsLiveMenu);
            tabMenu.add(NewsMenu);
            tabMenu.add(NewsPMEXMenu);
            tabMenu.add(houseNameMenu);
            tabMenu.add(BoradMeetingMenu);
            tabMenu.add(this.AlertsMenu);
            tabMenu.add(MarginCallsMenu);
            tabMenu.add(RSSMenu);
            tabMenu.add(new JSeparator());
            tabMenu.add(showAll);
        }
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            if (this.tabbedPane.getTitleAt(i).equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Orders))) {
                OrderMenu.setSelected(true);
                continue;
            }
            if (this.tabbedPane.getTitleAt(i).equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Announcement))) {
                AnnouncementsMenu.setSelected(true);
                continue;
            }
            if (this.tabbedPane.getTitleAt(i).equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.AnnouncementLive))) {
                AnnouncementsLiveMenu.setSelected(true);
                continue;
            }
            if (this.tabbedPane.getTitleAt(i).equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.News))) {
                NewsMenu.setSelected(true);
                continue;
            }
            if (this.tabbedPane.getTitleAt(i).equalsIgnoreCase("Commodity News")) {
                NewsPMEXMenu.setSelected(true);
                continue;
            }
            if (this.tabbedPane.getTitleAt(i).equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.BoardMeeting))) {
                BoradMeetingMenu.setSelected(true);
                continue;
            }
            if (this.tabbedPane.getTitleAt(i).equalsIgnoreCase(this.languageCentre.getValue("Alerts"))) {
                this.AlertsMenu.setSelected(true);
                continue;
            }
            if (!this.tabbedPane.getTitleAt(i).equalsIgnoreCase(LanguageConstant.RSS)) continue;
            RSSMenu.setSelected(true);
        }
        this.tabbedPane.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (AppConfig.loginMode != LoginMode.PMEX && SwingUtilities.isRightMouseButton(e)) {
                    tabMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
            }
        });
        this.msgCenter.setNewsTab(this.newsTab);
        this.msgCenter.setNewsTabPMEX(this.newsTabPMEX);
        this.msgCenter.setHouseTab(this.houseTab);
        this.msgCenter.setBoardMeetingTab(this.boardMeetingTab);
        this.msgCenter.setAnnouncementTab(this.announcementTab);
        this.msgCenter.setAnnouncementLiveTab(this.announcementLiveTab);
        this.msgCenter.setRSSTab(this.rssTab);
    }

    public void AddAllTab() {
        block12: {
            String[] tabValues;
            block13: {
                if (LogCommon.msgwinTabInfo.equalsIgnoreCase("")) break block12;
                tabValues = LogCommon.msgwinTabInfo.split("\\|");
                if (AppConfig.loginMode != LoginMode.KSE && AppConfig.loginMode != LoginMode.KSEPMEX) break block13;
                this.tabbedPane.removeAll();
                for (int i = 0; i < tabValues.length; ++i) {
                    if (tabValues[i].equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Activity))) {
                        this.tabbedPane.addTab(this.languageCentre.getValue(LanguageConstant.Activity), this.allMsgIcon, this.scrollPane, "View Activity");
                        continue;
                    }
                    if (tabValues[i].equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Orders))) {
                        this.tabbedPane.addTab(this.languageCentre.getValue(LanguageConstant.Orders), this.orderIcon, this.OrdtopPanel, "View Order Messages");
                        continue;
                    }
                    if (tabValues[i].equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Announcement))) {
                        this.tabbedPane.addTab(this.languageCentre.getValue(LanguageConstant.Announcement), this.AnnouncementIcon, this.announcementTab, "View Announcements");
                        continue;
                    }
                    if (tabValues[i].equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.AnnouncementLive))) {
                        this.tabbedPane.addTab(this.languageCentre.getValue(LanguageConstant.AnnouncementLive), this.AnnouncementLiveIcon, this.announcementLiveTab, "View Live Announcements");
                        continue;
                    }
                    if (tabValues[i].equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.News))) {
                        this.tabbedPane.addTab(this.languageCentre.getValue(LanguageConstant.News), this.newsIcon, this.newsTab, "View News");
                        continue;
                    }
                    if (tabValues[i].equalsIgnoreCase("Commodity News")) {
                        this.tabbedPane.addTab("Commodity News", TradeCast.getInstance().PMEX_ICON, this.newsTabPMEX, "View Comodity News");
                        continue;
                    }
                    if (tabValues[i].equalsIgnoreCase(AppConfig.houseName)) {
                        this.tabbedPane.addTab(AppConfig.houseName, this.houseIcon, this.houseTab, "View Messages From " + AppConfig.companyName);
                        continue;
                    }
                    if (tabValues[i].equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.BoardMeeting))) {
                        this.tabbedPane.addTab(this.languageCentre.getValue(LanguageConstant.BoardMeeting), this.boardMeetingIcon, this.boardMeetingTab, "View Board Meetings");
                        continue;
                    }
                    if (tabValues[i].equalsIgnoreCase(this.languageCentre.getValue("Alerts"))) continue;
                    if (tabValues[i].equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.MarginCall))) {
                        this.tabbedPane.addTab(this.languageCentre.getValue(LanguageConstant.MarginCall), this.marginIcon, this.marginCallTab, "View All Margin Calls");
                        continue;
                    }
                    if (!tabValues[i].equalsIgnoreCase(LanguageConstant.RSS)) continue;
                    this.tabbedPane.addTab(LanguageConstant.RSS, this.RSSIcon, this.rssTab, "View All RSS Messages");
                }
                break block12;
            }
            if (AppConfig.loginMode != LoginMode.PMEX) break block12;
            for (int i = 0; i < tabValues.length; ++i) {
                if (tabValues[i].equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Orders))) {
                    this.tabbedPane.addTab(this.languageCentre.getValue(LanguageConstant.Activity), this.allMsgIcon, this.scrollPane, "View Activity");
                    continue;
                }
                if (!tabValues[i].equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Orders))) continue;
                this.tabbedPane.addTab(this.languageCentre.getValue(LanguageConstant.Orders), this.orderIcon, this.OrdtopPanel, "View Order Messages");
            }
        }
    }

    public void ShowAllTab() {
        this.tabbedPane.removeAll();
        if (AppConfig.loginMode == LoginMode.KSE) {
            this.tabbedPane.addTab(this.languageCentre.getValue(LanguageConstant.Activity), this.allMsgIcon, this.scrollPane, "View Activity");
            this.tabbedPane.addTab(this.languageCentre.getValue(LanguageConstant.Orders), this.orderIcon, this.OrdtopPanel, "View Order Messages");
            this.tabbedPane.addTab(this.languageCentre.getValue(LanguageConstant.Announcement), this.AnnouncementIcon, this.announcementTab, "View Announcements");
            this.tabbedPane.addTab(this.languageCentre.getValue(LanguageConstant.AnnouncementLive), this.AnnouncementLiveIcon, this.announcementLiveTab, "View Live Announcements");
            this.tabbedPane.addTab(this.languageCentre.getValue(LanguageConstant.News), this.newsIcon, this.newsTab, "View News");
            this.tabbedPane.addTab(AppConfig.houseName, this.houseIcon, this.houseTab, "View Messages From " + AppConfig.companyName);
            this.tabbedPane.addTab(this.languageCentre.getValue(LanguageConstant.BoardMeeting), this.boardMeetingIcon, this.boardMeetingTab, "View Board Meetings");
            this.tabbedPane.addTab(this.languageCentre.getValue("Alerts"), this.pricaAlertIcon, this.priceAlertTab, "View Price Alerts");
            this.tabbedPane.addTab(this.languageCentre.getValue(LanguageConstant.MarginCall), this.marginIcon, this.marginCallTab, "View Margin Calls");
            this.tabbedPane.addTab(LanguageConstant.RSS, this.RSSIcon, this.rssTab, "View All RSS Messages");
        } else if (AppConfig.loginMode == LoginMode.KSEPMEX) {
            this.tabbedPane.addTab(this.languageCentre.getValue(LanguageConstant.Activity), this.allMsgIcon, this.scrollPane, "View Activity");
            this.tabbedPane.addTab(this.languageCentre.getValue(LanguageConstant.Orders), this.orderIcon, this.OrdtopPanel, "View Order Messages");
            this.tabbedPane.addTab(this.languageCentre.getValue(LanguageConstant.Announcement), this.AnnouncementIcon, this.announcementTab, "View Announcements");
            this.tabbedPane.addTab(this.languageCentre.getValue(LanguageConstant.AnnouncementLive), this.AnnouncementLiveIcon, this.announcementLiveTab, "View Live Announcements");
            this.tabbedPane.addTab(this.languageCentre.getValue(LanguageConstant.News), this.newsIcon, this.newsTab, "View News");
            this.tabbedPane.addTab("Commodity News", TradeCast.getInstance().PMEX_ICON, this.newsTabPMEX, "View Comodity News");
            this.tabbedPane.addTab(AppConfig.houseName, this.houseIcon, this.houseTab, "View Messages From " + AppConfig.companyName);
            this.tabbedPane.addTab(this.languageCentre.getValue(LanguageConstant.BoardMeeting), this.boardMeetingIcon, this.boardMeetingTab, "View Board Meetings");
            this.tabbedPane.addTab(this.languageCentre.getValue("Alerts"), this.pricaAlertIcon, this.priceAlertTab, "View Price Alerts");
            this.tabbedPane.addTab(this.languageCentre.getValue(LanguageConstant.MarginCall), this.marginIcon, this.marginCallTab, "View Margin Calls");
            this.tabbedPane.addTab(LanguageConstant.RSS, this.RSSIcon, this.rssTab, "View All RSS Messages");
        } else if (AppConfig.loginMode == LoginMode.PMEX) {
            this.tabbedPane.addTab(this.languageCentre.getValue(LanguageConstant.Activity), this.allMsgIcon, this.scrollPane, "View Activity");
            this.tabbedPane.addTab(this.languageCentre.getValue(LanguageConstant.Orders), this.orderIcon, this.OrdtopPanel, "View Order Messages");
            this.tabbedPane.addTab("Commodity News", TradeCast.getInstance().PMEX_ICON, this.newsTabPMEX, "View Comodity News");
        }
    }

    public void getTabInfo() {
        int i;
        LogCommon.msgwinTabInfo = "";
        if (this.tabbedPane.getTabCount() >= 2) {
            for (i = 0; i <= this.tabbedPane.getTabCount() - 1; ++i) {
                LogCommon.msgwinTabInfo = LogCommon.msgwinTabInfo + this.tabbedPane.getTitleAt(i);
                if (i > this.tabbedPane.getTabCount()) continue;
                LogCommon.msgwinTabInfo = LogCommon.msgwinTabInfo + "|";
            }
        }
        try {
            i = this.tabbedPane.getSelectedIndex();
            if (this.tabbedPane.getTitleAt(i).equalsIgnoreCase("RSS") && this.rssTab != null) {
                this.rssTab.TabChange();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void ShowHideTab(JCheckBoxMenuItem tab, String title, JPanel panel, ImageIcon icon) {
        if (tab.getState()) {
            if (!this.getTabIndexingName(tab.getActionCommand()).equalsIgnoreCase("")) {
                String[] name = this.getTabIndexingName(tab.getActionCommand()).split("\\|");
                int tabNum = Integer.parseInt(name[1]);
                this.tabbedPane.add(panel, title, tabNum);
                this.tabbedPane.setIconAt(tabNum, icon);
            } else {
                this.tabbedPane.addTab(title, icon, panel, "View Order Messages");
            }
        } else if (this.getTabIndex(tab.getActionCommand()) >= 0) {
            int TabIndex = this.getTabIndex(tab.getActionCommand());
            this.TabValueUpdate(tab.getActionCommand(), TabIndex);
            this.tabbedPane.remove(TabIndex);
        }
    }

    public void TabValueUpdate(String name, int index) {
        int key2 = 0;
        try {
            Set<Integer> set = this.TabInfo.keySet();
            for (int key2 : set) {
                if (!this.TabInfo.get(key2).equalsIgnoreCase(name)) continue;
                this.TabInfo.remove(key2);
                this.TabInfo.put(index, name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getTabIndexingName(String name) {
        String tabIndex = "";
        int key2 = 0;
        Set<Integer> set = this.TabInfo.keySet();
        for (int key2 : set) {
            if (!this.TabInfo.get(key2).equalsIgnoreCase(name)) continue;
            tabIndex = this.TabInfo.get(key2) + "|" + key2;
        }
        return tabIndex;
    }

    private int getTabIndex(String id) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            String title = this.tabbedPane.getTitleAt(i);
            if (!title.equalsIgnoreCase(id)) continue;
            return i;
        }
        return -1;
    }

    public void ChangeTab(String TabName) {
        int index = this.getTabIndex(TabName);
        if (index >= 0) {
            this.tabbedPane.setSelectedIndex(index);
        }
    }

    private void showPopupMenu(MouseEvent e, JScrollPane sp) {
        if (SwingUtilities.isRightMouseButton(e)) {
            this.checkBoxMenuShowCapAlert.setSelected(LogCommon.isShowCapMessageAlert);
            this.checkBoxMenuShowSpotAlert.setSelected(LogCommon.isShowSpotMessageAlert);
            this.popupMenuActivty.show(sp, e.getX(), e.getY());
        }
    }

    private void showPopupMenu(MouseEvent e, JTable tb) {
        if (SwingUtilities.isRightMouseButton(e)) {
            this.checkBoxMenuShowCapAlert.setSelected(LogCommon.isShowCapMessageAlert);
            this.checkBoxMenuShowSpotAlert.setSelected(LogCommon.isShowSpotMessageAlert);
            this.popupMenuActivty.show(tb, e.getX(), e.getY());
        }
    }

    public void AddNewMessageToMsgWindow(final String Message2, final Color ForC, final Color BakC) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.AddNewMessage(Message2, ForC, BakC);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MsgWin.this.AddNewMessage(Message2, ForC, BakC);
                }
            });
        }
    }

    private void tableDataChange(final JTable table) {
        if (SwingUtilities.isEventDispatchThread()) {
            table.addNotify();
            table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    table.addNotify();
                    table.repaint();
                }
            });
        }
    }

    private void PaintComponenet(final Component com) {
        if (SwingUtilities.isEventDispatchThread()) {
            com.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    com.repaint();
                }
            });
        }
    }

    private synchronized void AddNewMessage(String Message2, Color ForC, Color BakC) {
        String MsgType2 = "";
        String Msg = "";
        MsgType2 = Message2.split("<>")[0];
        for (int i = 1; i < Message2.split("<>").length; ++i) {
            Msg = Msg + Message2.split("<>")[i];
        }
        if (!Msg.equals("")) {
            this.m_data.RemoveLastElement();
            this.m_data.addRow(Msg, ForC, BakC);
            this.m_data.addRow("", Color.white, Color.white);
            Util.ScrollToFirstOrLastRow((boolean)false, (JTable)this.m_table, (JScrollPane)this.scrollPane);
            this.tableDataChange(this.m_table);
        }
        if (MsgType2.equalsIgnoreCase("Exc")) {
            this.Exc_data.RemoveLastElement();
            this.Exc_data.addRow(Msg, ForC, BakC);
            DefaultListSelectionModel lsm = (DefaultListSelectionModel)this.Exc_table.getSelectionModel();
            lsm.setLeadSelectionIndex(this.Exc_data.getRowCount() - 1);
            this.Exc_data.addRow("", Color.white, Color.white);
            lsm = (DefaultListSelectionModel)this.Exc_table.getSelectionModel();
            lsm.setLeadSelectionIndex(this.Exc_data.getRowCount() - 1);
        } else if (MsgType2.equalsIgnoreCase("Order")) {
            this.Ord_data.RemoveLastElement();
            this.Ord_data.addRow(Msg, ForC, BakC);
            this.Ord_data.addRow("", Color.white, Color.white);
            this.tableDataChange(this.m_table);
            Util.ScrollToFirstOrLastRow((boolean)false, (JTable)this.Ord_table, (JScrollPane)this.OrdscrollPane);
            this.tableDataChange(this.m_table);
            Mediator.getInstance().WriteMessageInFile(Message2);
        }
    }

    public void messageAckReceived(String msgID, String msgType, String acc) {
        int selectedIndex = this.tabbedPane.getSelectedIndex();
        if (msgType.equalsIgnoreCase(LanguageConstant.News)) {
            int index;
            if (this.newsTab != null) {
                this.newsTab.getAllMessages(msgType, msgID, -1);
            }
            if ((index = this.getTabIndex(this.languageCentre.getValue(LanguageConstant.News))) != selectedIndex && index >= 0) {
                ++this.count;
                if (this.timmerMap.containsKey(LanguageConstant.News)) {
                    this.timmerMap.get(LanguageConstant.News).stop();
                }
                this.timmerMap.put(LanguageConstant.News, this.Blink(index, true));
            }
        } else if (msgType.equalsIgnoreCase("Commodity News")) {
            int index;
            if (this.newsTabPMEX != null) {
                this.newsTabPMEX.getAllMessages(msgType, msgID, -1);
            }
            if ((index = this.getTabIndex("Commodity News")) != selectedIndex && index >= 0) {
                ++this.count;
                if (this.timmerMap.containsKey("Commodity News")) {
                    this.timmerMap.get("Commodity News").stop();
                }
                this.timmerMap.put("Commodity News", this.Blink(index, true));
            }
        } else if (msgType.equalsIgnoreCase("HOUSE_MESSAGE")) {
            int index;
            if (this.houseTab != null) {
                this.houseTab.getAllMessages(msgType, msgID, -1);
            }
            if ((index = this.getTabIndex(AppConfig.houseName)) != selectedIndex) {
                if (this.timmerMap.containsKey("HOUSE_MESSAGE")) {
                    this.timmerMap.get("HOUSE_MESSAGE").stop();
                }
                this.timmerMap.put("HOUSE_MESSAGE", this.Blink(index, true));
            }
        } else if (msgType.equalsIgnoreCase(BoardMeetingTag)) {
            int index;
            if (this.boardMeetingTab != null && !msgID.equalsIgnoreCase("ALL") && AppConfig.loginMode != LoginMode.PMEX) {
                this.boardMeetingTab.getAllMessages(msgType, msgID, -1);
            }
            if ((index = this.getTabIndex(this.languageCentre.getValue(LanguageConstant.BoardMeeting))) != selectedIndex) {
                if (this.timmerMap.containsKey(BoardMeetingTag)) {
                    this.timmerMap.get(BoardMeetingTag).stop();
                }
                this.timmerMap.put(BoardMeetingTag, this.Blink(index, true));
            }
        } else if (msgType.equalsIgnoreCase("ANNOUNCEMENT")) {
            int index;
            if (this.announcementTab != null) {
                if (msgID.equalsIgnoreCase("ALL")) {
                    this.announcementTab.getAllMessages();
                } else {
                    this.announcementTab.setSingleAnnouncement(msgID);
                }
            }
            if ((index = this.getTabIndex(this.languageCentre.getValue(LanguageConstant.Announcement))) != selectedIndex) {
                if (this.timmerMap.containsKey(LanguageConstant.Announcement)) {
                    this.timmerMap.get(LanguageConstant.Announcement).stop();
                }
                this.timmerMap.put(LanguageConstant.Announcement, this.Blink(index, true));
            }
        } else if (msgType.equalsIgnoreCase("PUCARS_ANNOUNCEMENT")) {
            int index;
            if (this.announcementLiveTab != null) {
                if (msgID.equalsIgnoreCase("ALL")) {
                    this.announcementLiveTab.getAllMessages();
                } else {
                    this.announcementLiveTab.setSingleAnnouncement(msgID);
                }
            }
            if ((index = this.getTabIndex(this.languageCentre.getValue(LanguageConstant.AnnouncementLive))) != selectedIndex) {
                if (this.timmerMap.containsKey(LanguageConstant.AnnouncementLive)) {
                    this.timmerMap.get(LanguageConstant.AnnouncementLive).stop();
                }
                this.timmerMap.put(LanguageConstant.AnnouncementLive, this.Blink(index, true));
            }
        } else if (msgType.equalsIgnoreCase(LanguageConstant.MarginCall) && this.marginCallTab != null) {
            this.marginCallTab.messageAckReceived(acc);
        }
    }

    public void blinkMarginCallTab() {
        int selectedIndex = this.tabbedPane.getSelectedIndex();
        int index = this.getTabIndex(this.languageCentre.getValue(LanguageConstant.MarginCall));
        if (index != selectedIndex) {
            if (this.timmerMap.containsKey(LanguageConstant.MarginCall)) {
                this.timmerMap.get(LanguageConstant.MarginCall).stop();
            }
            this.timmerMap.put(LanguageConstant.MarginCall, this.Blink(index, true));
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.scrollPane.revalidate();
        this.PaintComponenet(this.scrollPane);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    public Font GetMsgWindowFont() {
        return this.m_table.getFont();
    }

    public void Refresh() {
        FontMetrics metrics = this.getFontMetrics(LogCommon.MessageWindowFont);
        int fontHeight = metrics.getHeight();
        this.m_table.setRowHeight(fontHeight);
        this.Ord_table.setRowHeight(fontHeight);
        this.Exc_table.setRowHeight(fontHeight);
    }

    public Timer Blink(final int index, boolean isStart) {
        ActionListener ac = new ActionListener(){
            int i = 0;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (index != -1) {
                    if (this.i >= AppConfig.BlinkInterval) {
                        MsgWin.this.tabbedPane.setForegroundAt(index, MyColors.tabPaneselectedForeground);
                        MsgWin.this.PaintComponenet(MsgWin.this.tabbedPane);
                    } else {
                        if (this.i % 2 == 0) {
                            MsgWin.this.tabbedPane.setForegroundAt(index, MyColors.tabPaneselectedForeground);
                        } else {
                            MsgWin.this.tabbedPane.setForegroundAt(index, Color.BLACK);
                        }
                        MsgWin.this.PaintComponenet(MsgWin.this.tabbedPane);
                        ++this.i;
                    }
                }
            }
        };
        Timer BlinkTimmer = new Timer(0, ac){

            @Override
            public void stop() {
                if (index != -1) {
                    MsgWin.this.tabbedPane.setForegroundAt(index, MyColors.tabPaneselectedForeground);
                    MsgWin.this.PaintComponenet(MsgWin.this.tabbedPane);
                    super.stop();
                }
                super.stop();
            }
        };
        BlinkTimmer.setDelay(500);
        BlinkTimmer.setRepeats(true);
        if (isStart) {
            BlinkTimmer.start();
        }
        return BlinkTimmer;
    }

    public void messageDeleteAckReceived(String id, String type, String other) {
        if (type.equalsIgnoreCase("Message")) {
            if (this.msgCenter.newsTab != null) {
                this.msgCenter.newsTab.deleteRow(id);
            }
            if (this.msgCenter.boardMeetingTab != null) {
                this.msgCenter.boardMeetingTab.deleteRow(id);
            }
            if (this.msgCenter.houseTab != null) {
                this.msgCenter.houseTab.deleteRow(id);
            }
        } else if (type.equalsIgnoreCase("Announcement")) {
            if (this.msgCenter.announcementTab != null) {
                this.msgCenter.announcementTab.deleteRow(id);
            }
            if (this.msgCenter.announcementLiveTab != null) {
                this.msgCenter.announcementLiveTab.deleteRow(id);
            }
        }
    }

    public void initForPriceAlert(String scrip, String market) {
        int index = this.getTabIndex(this.languageCentre.getValue("Alerts"));
        if (index >= 0) {
            this.tabbedPane.setSelectedIndex(index);
        } else {
            this.tabbedPane.addTab(this.languageCentre.getValue("Alerts"), this.PriceAlertIcon, this.priceAlertTab, "");
            index = this.getTabIndex(this.languageCentre.getValue("Alerts"));
            this.tabbedPane.setSelectedIndex(index);
            this.AlertsMenu.setSelected(true);
        }
        this.priceAlertTab.initForPriceAlert(scrip, market);
    }

    public void scrollTopOrBorttom(boolean b) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int index = MsgWin.this.getTabIndex(MsgWin.this.languageCentre.getValue(LanguageConstant.Activity));
                if (index >= 0) {
                    MsgWin.this.tabbedPane.setSelectedIndex(index);
                }
                JScrollBar verticalScrollBar = MsgWin.this.scrollPane.getVerticalScrollBar();
                MsgWin.this.scrollPane.getViewport().scrollRectToVisible(MsgWin.this.m_table.getCellRect(MsgWin.this.m_data.getRowCount() - 1, 0, true));
                verticalScrollBar.setValue(verticalScrollBar.getMaximum());
                MsgWin.this.scrollPane.revalidate();
                MsgWin.this.PaintComponenet(MsgWin.this.scrollPane);
            }
        });
    }

    private void setObject() {
        this.announcementTab = new AnnouncementTab();
        this.announcementLiveTab = new AnnouncementLiveTab();
        this.rssTab = new RSSTab();
        this.marginCallTab = new MarginCallTab("Margin Call", this.mediator);
        this.priceAlertTab = new PriceAlertTab("Price Alerts");
        this.houseTab = new MyTab("HOUSE_MESSAGE", new String[]{""});
        this.boardMeetingTab = new BoardMeetingTab("Board_Meetings");
        this.newsTab = new MyTab(LanguageConstant.News, new String[]{""});
        this.newsTabPMEX = new PMEX_MyTab("Commodity News", new String[]{""});
    }
}

