/*
 * Decompiled with CFR 0.152.
 */
package MessageWindow;

import MessageWindow.DisplayModel;
import MessageWindow.Message;
import MessageWindow.MessageDisplay;
import MessageWindow.MessageRender;
import MessageWindow.SearchPanel;
import MessageWindow.ShowHouseMessagePopup;
import MyDocking.Mediator;
import Utilities.CompressManager;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.LoginMode;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import kse.util.LogsKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;
import login.LoginServer;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.VerticalLayout;

public class MyTab
extends JPanel {
    String[] columnNames = new String[]{""};
    Hashtable<String, Timer> timerMap = new Hashtable();
    Vector<MessageDisplay> rows = new Vector();
    Vector columns = new Vector();
    DisplayModel model = new DisplayModel(this.rows, true);
    int id = 0;
    public static final int idIndex = 0;
    public static final int dateTimeIndex = 1;
    public static final int typeIndex = 2;
    public static final int subjectIndex = 3;
    public static final int detailIndex = 4;
    public static final int descriptionIndex = 5;
    public static final int isBlinkIndex = 6;
    public static final int isReadIndex = 7;
    private String type = "";
    MessageRender messageRender = new MessageRender();
    Mediator mediator = Mediator.getInstance();
    private JButton dropDownDec;
    private JButton dropDownAsc;
    private JLabel lblCount = new JLabel(" ");
    private boolean isAsec = true;
    public SearchPanel searchPanel = null;
    private boolean isUpdate = false;
    private LanguageCentre languageCentre = new LanguageCentre();
    private JButton btnAsen;
    private JButton btnDecn;
    private JButton btnSearch;
    private ButtonGroup buttonGroup1;
    private JXCollapsiblePane collapsiblePane;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JCheckBoxMenuItem menuDate;
    private JCheckBoxMenuItem menuDescription;
    private JCheckBoxMenuItem menuDetails;
    private JCheckBoxMenuItem menuSubject;
    private JPopupMenu sortMenu;
    private JTable table;
    private JToolBar toolBar;
    Thread getMessages = new Thread(){

        @Override
        public void run() {
            try {
                LoginServer port;
                String result;
                String temp = MyTab.this.type;
                if (MyTab.this.type.equalsIgnoreCase("Board Meetings")) {
                    temp = "BOARD_MEETING";
                }
                if ((result = CompressManager.unzipStringFromBytes((port = WebService.getInstance().getPort()).getUserMessages(temp, LogCommon.UserID, null, LogCommon.tabMessageDays))) != null) {
                    MyTab.this.addAllData(result, false);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    };

    public MyTab(String type, String[] columnNames) {
        try {
            this.type = type;
            this.columnNames = columnNames;
            if (type.equalsIgnoreCase("Board Meetings")) {
                this.type = "Board_Meeting";
            }
            this.initComponents();
            if (Util.isWindow7()) {
                this.menuDescription.setIcon(null);
                this.menuSubject.setIcon(null);
                this.menuDate.setIcon(null);
                this.menuDetails.setIcon(null);
            }
            this.searchPanel = new SearchPanel(this, type);
            this.btnDecn.setLayout(new BorderLayout());
            this.btnDecn.setMargin(new Insets(-5, -5, -5, -5));
            this.dropDownDec = new BasicArrowButton(5);
            this.dropDownDec.setIcon(new ImageIcon(this.getClass().getResource("/Images/ascending12.png")));
            this.dropDownDec.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    MyTab.this.isAsec = false;
                    MyTab.this.sortMenu.show(MyTab.this.btnDecn, evt.getX() + 2, evt.getY() + 7);
                }
            });
            this.btnDecn.add((Component)this.dropDownDec, "East");
            this.btnAsen.setLayout(new BorderLayout());
            this.btnAsen.setMargin(new Insets(-5, -5, -5, -5));
            this.dropDownAsc = new BasicArrowButton(5);
            this.dropDownAsc.setIcon(new ImageIcon(this.getClass().getResource("/Images/ascending12.png")));
            this.dropDownAsc.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    MyTab.this.isAsec = true;
                    MyTab.this.sortMenu.show(MyTab.this.btnAsen, evt.getX() + 2, evt.getY() + 7);
                }
            });
            this.btnAsen.add((Component)this.dropDownAsc, "East");
            this.toolBar.add(Box.createHorizontalGlue());
            this.lblCount.setHorizontalAlignment(4);
            this.toolBar.add(this.lblCount);
            for (int i = 0; i < columnNames.length; ++i) {
                this.columns.addElement(columnNames[i]);
            }
            this.model.setDataVector(this.rows, this.columns);
            this.table.setModel(this.model);
            this.table.setDefaultRenderer(Object.class, this.messageRender);
            TableColumn com = this.table.getColumnModel().getColumn(0);
            com.setCellEditor(this.messageRender);
            this.table.setTableHeader(null);
            this.table.setRowHeight(90);
            this.table.setSelectionMode(0);
            this.collapsiblePane.add((Component)this.searchPanel);
            this.collapsiblePane.setCollapsed(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.dropDownAsc.setName("MyTab -> " + type + " -> dropDownAsc");
        this.dropDownDec.setName("MyTab -> " + type + " -> dropDownDec");
        this.btnSearch.setName("MyTab -> " + type + " -> btnSearch");
        this.btnAsen.setName("MyTab -> " + type + " -> btnAsen");
        this.btnDecn.setName("MyTab -> " + type + " -> btnDecn");
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.table.addNotify();
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MyTab.this.table.addNotify();
                    MyTab.this.table.repaint();
                }
            });
        }
    }

    public void addAllData(String msg, boolean isBlink) {
        int unRead = 0;
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
        if (msg.indexOf("|") >= 0) {
            String[] rowsVal = msg.split("\\|", -1);
            if (this.type.equalsIgnoreCase(LanguageConstant.News)) {
                LogsKSE.newsMsgCount += rowsVal.length - 1;
            } else if (this.type.equalsIgnoreCase("Commodity News")) {
                LogsKSE.newsPMEXMsgCount += rowsVal.length - 1;
            } else if (this.type.equalsIgnoreCase("HOUSE_MESSAGE")) {
                LogsKSE.houseMsgCount += rowsVal.length - 1;
            }
            int MSG_count = 0;
            MessageDisplay singleMD = null;
            for (int i = 0; i < rowsVal.length; ++i) {
                MessageDisplay display;
                if (rowsVal[i].indexOf(";") < 0) continue;
                String[] columnVal = rowsVal[i].split("\\;", -1);
                Message m = null;
                try {
                    m = this.parse(columnVal);
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    ex.printStackTrace();
                }
                for (int j = 0; j < this.rows.size(); ++j) {
                    MessageDisplay messageDisplay = this.rows.elementAt(j);
                    if (messageDisplay.message.id.value.equalsIgnoreCase(m.id.value)) {
                        if (this.type.equalsIgnoreCase(LanguageConstant.News)) {
                            --LogsKSE.newsMsgCount;
                        } else if (this.type.equalsIgnoreCase("Commodity News")) {
                            --LogsKSE.newsPMEXMsgCount;
                        } else if (this.type.equalsIgnoreCase("HOUSE_MESSAGE")) {
                            --LogsKSE.houseMsgCount;
                        }
                        m.msgNo = messageDisplay.message.msgNo;
                        messageDisplay.message = m;
                        this.updateAllData();
                        this.isUpdate = true;
                        break;
                    }
                    this.isUpdate = false;
                }
                if (m == null) {
                    if (this.type.equalsIgnoreCase(LanguageConstant.News)) {
                        --LogsKSE.newsMsgCount;
                        continue;
                    }
                    if (this.type.equalsIgnoreCase("Commodity News")) {
                        --LogsKSE.newsPMEXMsgCount;
                        continue;
                    }
                    if (!this.type.equalsIgnoreCase("HOUSE_MESSAGE")) continue;
                    --LogsKSE.houseMsgCount;
                    continue;
                }
                if (this.isUpdate) continue;
                singleMD = display = new MessageDisplay(this, m, this.table, this.type, this.rows);
                if (LogCommon.isTop) {
                    this.rows.add(0, display);
                } else {
                    this.rows.add(this.rows.size(), display);
                }
                if (!m.isBlink) {
                    this.timerMap.put(m.id.value, this.Blink(m.id.value, isBlink));
                } else {
                    ++MSG_count;
                    this.timerMap.put(m.id.value, this.Blink(m.id.value, m.isBlink));
                    if (this.type.equalsIgnoreCase("HOUSE_MESSAGE") && AppConfig.isHouseMessagePopup) {
                        ShowHouseMessagePopup pop = new ShowHouseMessagePopup(this, m, this.type);
                        pop.setLocationRelativeTo(null);
                        pop.setVisible(true);
                    }
                }
                if (m.isRead) {
                    ++unRead;
                }
                this.tableDataChange();
                Util.ScrollToFirstOrLastRow((boolean)LogCommon.isTop, (JTable)this.table, (JScrollPane)this.jScrollPane1);
            }
            if (MSG_count == 1 && LogCommon.DesktopAlert_NewsHouseBoard) {
                if (this.mediator.toasterManager != null && this.type.equalsIgnoreCase(LanguageConstant.News)) {
                    this.mediator.toasterManager.showToaster(this.mediator.toasterManager, this.languageCentre.getValue(LanguageConstant.News), singleMD.message.subject.value, this.languageCentre.getValue(LanguageConstant.News));
                }
                if (this.mediator.toasterManager != null && this.type.equalsIgnoreCase("Commodity News")) {
                    this.mediator.toasterManager.showToaster(this.mediator.toasterManager, "Commodity News", singleMD.message.subject.value, "Commodity News");
                }
                if (this.mediator.toasterManager != null && this.type.equalsIgnoreCase("Board_Meeting")) {
                    this.mediator.toasterManager.showToaster(this.mediator.toasterManager, this.languageCentre.getValue(LanguageConstant.BoardMeeting), singleMD.message.subject.value, this.languageCentre.getValue(LanguageConstant.BoardMeeting));
                }
                if (this.mediator.toasterManager != null && this.type.equalsIgnoreCase("HOUSE_MESSAGE")) {
                    this.mediator.toasterManager.showToaster(this.mediator.toasterManager, "HOUSE_MESSAGE", singleMD.message.subject.value, "HOUSE_MESSAGE");
                }
            } else if (MSG_count > 1 && LogCommon.DesktopAlert_NewsHouseBoard) {
                if (this.mediator.toasterManager != null && this.type.equalsIgnoreCase(LanguageConstant.News)) {
                    this.mediator.toasterManager.showToaster(this.mediator.toasterManager, this.languageCentre.getValue(LanguageConstant.News), MSG_count + " New Messages!", this.languageCentre.getValue(LanguageConstant.News));
                }
                if (this.mediator.toasterManager != null && this.type.equalsIgnoreCase("Commodity News")) {
                    this.mediator.toasterManager.showToaster(this.mediator.toasterManager, "Commodity News", MSG_count + " New Messages!", "Commodity News");
                }
                if (this.mediator.toasterManager != null && this.type.equalsIgnoreCase("Board Meetings")) {
                    this.mediator.toasterManager.showToaster(this.mediator.toasterManager, this.languageCentre.getValue(LanguageConstant.BoardMeeting), MSG_count + " New Messages!", this.languageCentre.getValue(LanguageConstant.BoardMeeting));
                }
                if (this.mediator.toasterManager != null && this.type.equalsIgnoreCase("HOUSE_MESSAGE")) {
                    this.mediator.toasterManager.showToaster(this.mediator.toasterManager, "HOUSE_MESSAGE", MSG_count + " New Messages!", "HOUSE_MESSAGE");
                }
            }
        }
        this.lblCount.setText(Util.format0digit((String)(this.rows.size() + "")) + " Record(s)  ");
        this.updateAllData();
    }

    public Message parse(String[] columnVal) throws ArrayIndexOutOfBoundsException {
        Message m = new Message();
        boolean isBlink = false;
        boolean isRead = false;
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
            Date date = df.parse(columnVal[1]);
            m.dateTime.value = LogsKSE.sdfMessage.format(date);
        }
        catch (ParseException ex) {
            m.dateTime.value = columnVal[1];
            ex.printStackTrace();
        }
        m.description.value = columnVal[5];
        m.detail.value = columnVal[4];
        m.id.value = columnVal[0];
        m.subject.value = columnVal[3];
        m.type.value = columnVal[2];
        try {
            isBlink = columnVal[6].equalsIgnoreCase("1") ? true : Boolean.parseBoolean(columnVal[6]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        m.isBlink = isBlink;
        try {
            isRead = columnVal[7].equalsIgnoreCase("1") ? true : Boolean.parseBoolean(columnVal[7]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        m.isRead = isRead;
        return m;
    }

    public synchronized Timer Blink(final String idNO, boolean isStart) {
        final Timer BlinkTimmer = new Timer(0, null){

            @Override
            public void stop() {
                int rowNo = MyTab.this.getRowNo(idNO);
                if (rowNo >= 0) {
                    MessageDisplay md = MyTab.this.rows.get(rowNo);
                    md.setColor(false);
                    MyTab.this.tableDataChange();
                    super.stop();
                }
            }
        };
        ActionListener ac = new ActionListener(){
            int i = 0;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.i >= AppConfig.BlinkInterval) {
                    int rowNo = MyTab.this.getRowNo(idNO);
                    if (rowNo >= 0) {
                        MessageDisplay md = MyTab.this.rows.get(rowNo);
                        md.setColor(true);
                        BlinkTimmer.stop();
                        MyTab.this.tableDataChange();
                    }
                } else {
                    int rowNo = MyTab.this.getRowNo(idNO);
                    if (rowNo >= 0) {
                        MessageDisplay md = MyTab.this.rows.get(rowNo);
                        if (this.i % 2 == 0) {
                            md.setColor(false);
                        } else {
                            md.setColor(true);
                        }
                        MyTab.this.tableDataChange();
                        ++this.i;
                    }
                }
            }
        };
        BlinkTimmer.addActionListener(ac);
        BlinkTimmer.setDelay(500);
        BlinkTimmer.setRepeats(true);
        if (isStart) {
            BlinkTimmer.start();
        }
        return BlinkTimmer;
    }

    public void stopBlink(String id) {
        if (this.timerMap.containsKey(id)) {
            this.timerMap.get(id).stop();
        }
    }

    private int getRowNo(String msgID) {
        int rowNo = -1;
        for (int i = 0; i < this.rows.size(); ++i) {
            Message object = this.rows.elementAt((int)i).message;
            if (!object.id.value.equalsIgnoreCase(msgID)) continue;
            return i;
        }
        return rowNo;
    }

    public void getAllMessages() {
        if (AppConfig.loginMode != LoginMode.PMEX) {
            new Thread(this.getMessages).start();
        }
    }

    private void initComponents() {
        this.sortMenu = new JPopupMenu();
        this.menuDate = new JCheckBoxMenuItem();
        this.menuSubject = new JCheckBoxMenuItem();
        this.menuDescription = new JCheckBoxMenuItem();
        this.menuDetails = new JCheckBoxMenuItem();
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.toolBar = new JToolBar();
        this.btnSearch = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.btnAsen = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.btnDecn = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jPanel1 = new JPanel();
        this.collapsiblePane = new JXCollapsiblePane();
        this.buttonGroup1.add(this.menuDate);
        this.menuDate.setSelected(true);
        this.menuDate.setText("Date");
        this.menuDate.setIcon(new ImageIcon(this.getClass().getResource("/Images/date16.png")));
        this.menuDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTab.this.menuDateActionPerformed(evt);
            }
        });
        this.sortMenu.add(this.menuDate);
        this.buttonGroup1.add(this.menuSubject);
        this.menuSubject.setText("Subject");
        this.menuSubject.setIcon(new ImageIcon(this.getClass().getResource("/Images/subject16.png")));
        this.menuSubject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTab.this.menuSubjectActionPerformed(evt);
            }
        });
        this.sortMenu.add(this.menuSubject);
        this.buttonGroup1.add(this.menuDescription);
        this.menuDescription.setText("Description");
        this.menuDescription.setIcon(new ImageIcon(this.getClass().getResource("/Images/description16.png")));
        this.menuDescription.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTab.this.menuDescriptionActionPerformed(evt);
            }
        });
        this.sortMenu.add(this.menuDescription);
        this.buttonGroup1.add(this.menuDetails);
        this.menuDetails.setText("Details");
        this.menuDetails.setIcon(new ImageIcon(this.getClass().getResource("/Images/detail16.png")));
        this.menuDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTab.this.menuDetailsActionPerformed(evt);
            }
        });
        this.sortMenu.add(this.menuDetails);
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"Date Time", "Subject", "Detail"}));
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                MyTab.this.tableMouseMoved(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.table);
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.toolBar.setMaximumSize(new Dimension(116, 21));
        this.toolBar.setMinimumSize(new Dimension(116, 21));
        this.toolBar.setPreferredSize(new Dimension(100, 18));
        this.btnSearch.setIcon(new ImageIcon(this.getClass().getResource("/Images/search12.png")));
        this.btnSearch.setText("Search");
        this.btnSearch.setToolTipText("Search");
        this.btnSearch.setFocusable(false);
        this.btnSearch.setHorizontalTextPosition(4);
        this.btnSearch.setMaximumSize(new Dimension(18, 18));
        this.btnSearch.setMinimumSize(new Dimension(18, 18));
        this.btnSearch.setPreferredSize(new Dimension(61, 21));
        this.btnSearch.setVerticalTextPosition(3);
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTab.this.btnSearchActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnSearch);
        this.toolBar.add(this.jSeparator3);
        this.btnAsen.setIcon(new ImageIcon(this.getClass().getResource("/Images/ascending12.png")));
        this.btnAsen.setToolTipText("Sort Ascending");
        this.btnAsen.setFocusable(false);
        this.btnAsen.setHorizontalTextPosition(0);
        this.btnAsen.setMaximumSize(new Dimension(35, 18));
        this.btnAsen.setMinimumSize(new Dimension(35, 18));
        this.btnAsen.setPreferredSize(new Dimension(38, 18));
        this.btnAsen.setVerticalTextPosition(3);
        this.btnAsen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTab.this.btnAsenActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnAsen);
        this.toolBar.add(this.jSeparator2);
        this.btnDecn.setIcon(new ImageIcon(this.getClass().getResource("/Images/descending12.png")));
        this.btnDecn.setToolTipText("Sort Descending");
        this.btnDecn.setFocusable(false);
        this.btnDecn.setHorizontalTextPosition(0);
        this.btnDecn.setMaximumSize(new Dimension(35, 18));
        this.btnDecn.setMinimumSize(new Dimension(35, 18));
        this.btnDecn.setPreferredSize(new Dimension(35, 18));
        this.btnDecn.setVerticalTextPosition(3);
        this.btnDecn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyTab.this.btnDecnActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnDecn);
        this.toolBar.add(this.jSeparator1);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 251, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.toolBar.add(this.jPanel1);
        this.collapsiblePane.getContentPane().setLayout((LayoutManager)new VerticalLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toolBar, GroupLayout.Alignment.TRAILING, -1, 405, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 405, Short.MAX_VALUE).addComponent((Component)this.collapsiblePane, -1, 405, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.toolBar, -2, 21, -2).addGap(0, 0, 0).addComponent((Component)this.collapsiblePane, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jScrollPane1, -1, 27, Short.MAX_VALUE)));
    }

    private void tableMouseMoved(MouseEvent evt) {
        try {
            int rowindex = this.table.rowAtPoint(evt.getPoint());
            this.table.editCellAt(rowindex, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void btnSearchActionPerformed(ActionEvent evt) {
        boolean state = this.collapsiblePane.isCollapsed();
        this.collapsiblePane.setCollapsed(!state);
    }

    private void btnAsenActionPerformed(ActionEvent evt) {
        if (this.menuDate.isSelected()) {
            this.callSort(1, true);
        } else if (this.menuSubject.isSelected()) {
            this.callSort(3, true);
        } else if (this.menuDescription.isSelected()) {
            this.callSort(5, true);
        } else if (this.menuDetails.isSelected()) {
            this.callSort(4, true);
        }
    }

    private void btnDecnActionPerformed(ActionEvent evt) {
        if (this.menuDate.isSelected()) {
            this.callSort(1, false);
        } else if (this.menuSubject.isSelected()) {
            this.callSort(3, false);
        } else if (this.menuDescription.isSelected()) {
            this.callSort(5, false);
        } else if (this.menuDetails.isSelected()) {
            this.callSort(4, false);
        }
    }

    private void menuDateActionPerformed(ActionEvent evt) {
        this.callSort(1, this.isAsec);
    }

    private void menuSubjectActionPerformed(ActionEvent evt) {
        this.callSort(3, this.isAsec);
    }

    private void menuDescriptionActionPerformed(ActionEvent evt) {
        this.callSort(5, this.isAsec);
    }

    private void menuDetailsActionPerformed(ActionEvent evt) {
        this.callSort(4, this.isAsec);
    }

    private void callSort(int index, boolean ascSec) {
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
        Collections.sort(this.rows, new MyTabComparator(index, ascSec));
        this.table.tableChanged(new TableModelEvent(this.model));
        this.table.repaint();
    }

    public void callSort(Vector<MessageDisplay> rows_, int index, boolean ascSec) {
        Collections.sort(rows_, new MyTabComparator(index, ascSec));
    }

    private void updateAllData() {
        for (int i = 0; i < this.rows.size(); ++i) {
            MessageDisplay messageDisplay = this.rows.elementAt(i);
            messageDisplay.message.msgNo = this.rows.size() - i;
            messageDisplay.setTextUpdated();
        }
    }

    public void deleteRow(String id) {
        for (int i = 0; i < this.rows.size(); ++i) {
            if (!this.rows.elementAt((int)i).message.id.value.equalsIgnoreCase(id)) continue;
            this.rows.remove(i);
            if (this.type.equalsIgnoreCase(LanguageConstant.News)) {
                --LogsKSE.newsMsgCount;
            } else if (this.type.equalsIgnoreCase("Commodity News")) {
                --LogsKSE.newsPMEXMsgCount;
            } else if (this.type.equalsIgnoreCase("HOUSE_MESSAGE")) {
                --LogsKSE.houseMsgCount;
            }
            this.updateAllData();
            this.tableDataChange();
            break;
        }
    }

    public void setReadunRead(Message message) {
        for (int i = 0; i < this.rows.size(); ++i) {
            MessageDisplay messageDisplay = this.rows.elementAt(i);
            if (!messageDisplay.message.id.value.equalsIgnoreCase(message.id.value)) continue;
            messageDisplay.message.isRead = message.isRead;
            messageDisplay.setTextUpdated();
            break;
        }
    }

    public void getAllMessages(String msgType, final String msgID, int i) {
        new Thread(){

            @Override
            public void run() {
                try {
                    String result;
                    LoginServer port = WebService.getInstance().getPort();
                    if (!msgID.equalsIgnoreCase("ALL") && (result = msgID.replaceAll("\\==", "|")) != null) {
                        MyTab.this.addAllData(result, true);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }.start();
    }

    class MyTabComparator
    implements Comparator {
        protected int m_sortCol;
        protected boolean m_sortAsc;

        public MyTabComparator(int sortCol, boolean sortAsc) {
            this.m_sortCol = sortCol;
            this.m_sortAsc = sortAsc;
        }

        public int compare(Object o1, Object o2) {
            int result = 0;
            try {
                MessageDisplay s1 = null;
                MessageDisplay s2 = null;
                if (o1 instanceof MessageDisplay && o2 instanceof MessageDisplay) {
                    s1 = (MessageDisplay)o1;
                    s2 = (MessageDisplay)o2;
                }
                switch (this.m_sortCol) {
                    case 1: {
                        Date d1 = LogsKSE.sdfMessage.parse(s1.message.dateTime.value);
                        Date d2 = LogsKSE.sdfMessage.parse(s2.message.dateTime.value);
                        result = d1.compareTo(d2);
                        break;
                    }
                    case 3: {
                        result = s1.message.subject.value.compareTo(s2.message.subject.value);
                        break;
                    }
                    case 5: {
                        result = s1.message.description.value.compareTo(s2.message.description.value);
                        break;
                    }
                    case 4: {
                        result = s1.message.detail.value.compareTo(s2.message.detail.value);
                    }
                }
                if (!this.m_sortAsc) {
                    result = -result;
                }
            }
            catch (ParseException ex) {
                ex.printStackTrace();
            }
            return result;
        }
    }
}

